(*
 *  freshness.ml
 *
 *  Caml interface for the freshness library
 *
 *  (c) Copyright 2005, INRIA [Francesco Zappa Nardelli]
 * 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 *  3. The names of the authors may not be used to endorse or promote products
 *  derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 *  NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *)

type 'a name

exception Arity_mismatch
let _ = Callback.register_exception "arity_mismatch" Arity_mismatch

let name_tag = ref ()

external fresh_int : unit ref -> unit -> 'a name 
  = "fresh_new_atom"
external swap_int : unit ref -> 'a name -> 'a name -> 'b -> 'b 
  = "fresh_swap_atoms" 
external swap_multiple_int : unit ref -> 'a name list -> 'a name list -> 'b -> 'b 
  = "fresh_swap_multiple_atoms"


let fresh : unit -> 'a name 
  = fun () -> fresh_int name_tag ()  
let swap : 'a name -> 'a name -> 'b -> 'b 
  = fun m n e -> swap_int name_tag m n e
let swap_multiple : 'a name list -> 'a name list -> 'b -> 'b 
  = fun ml nl e -> swap_multiple_int name_tag ml nl e
