# Dwarf-assembly

Generates C code from the DWARF embedded in an ELF file. This code can then be
compiled into a .so, and used to unwind stack frames.

## Options

### Switch generation policy

The code can either generate one big `switch` statement for every PC in the
ELF, or one `switch` and a function per FDE, plus a lookup function.

One of the two options must be passed:

* `--switch-per-func`: one `switch` and function per FDE;
* `--global-switch`: a single big `switch` for the whole ELF.

### PC list

Instead of generating interval switches (eg `case 0x42 ... 0x100`), it is
possible to provide a binary file (generated by `../extract_pc.py`) containing
a list of all PCs in the ELF. The file contains one 8-bytes chunk per PC,
which is the PC in little endian.

`--pc-list PC_LIST_FILE_PATH`

### Dereferencing function

The lookup functions can also take an additional argument, a pointer to a
function of prototype

```C
  uintptr_t deref(uintptr_t address)
```

that will, in spirit, contain a `return *((uintptr_t*)address);`.

This argument can be used to work on remote address spaces instead of local
address spaces, eg. to work with `libunwind`.

To enable the presence of this argument, you must pass the option
`--enable-deref-arg`
