(**************************************************************************)
(*                                 Cmmtest                                *)
(*                                                                        *)
(*   Robin Morisset, ENS & INRIA Paris-Rocquencourt                       *)
(*   Pankaj Pawan, IIT Kanpur & INRIA Paris-Rocquencourt                  *)
(*   Francesco Zappa Nardelli, INRIA Paris-Rocquencourt                   *)
(*                                                                        *)
(*  The Cmmtest tool is copyright 2012, 2013 Institut National de         *)
(*  Recherche en Informatique et en Automatique (INRIA).                  *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(**************************************************************************)

(* to compile: ocamlopt str.cmxa varnames.ml -o varnames *)

(* input: the executable name and the trace name *)
(* action: it overwrites the trace with informations about variable names, whenever possible *) 

let object_file = ref ""

let trace_file = ref ""

let trace_file_mod = ref ""

let nm_file = ref ""

let _ =
  Arg.parse [("-exec", Arg.Set_string object_file,"specify the executable name");
             ("-trace", Arg.Set_string trace_file,"specify the trace file name")] 
    (fun s -> ()) 
    ("varnames -exec <executable> -trace <trace>")

let _ =
  if (String.compare !object_file "" == 0) || (String.compare !trace_file "" == 0)
  then failwith "must specify -exec and -trace options"
  else begin
    trace_file_mod := !trace_file ^ ".log";
    nm_file := !object_file ^ ".nm"
  end

let exec s = 
  if (Sys.command s) != 0
  then failwith ("error: "^s^" failed.")

let var_addresses = Hashtbl.create 15

(* build var_addresses *)
let _ = 
  exec ("nm " ^ !object_file ^ " > " ^ !nm_file);
  let f_nm = open_in !nm_file in
  try while (true) do
      let s = input_line f_nm in
      try
        Scanf.sscanf s "0000000%s %s %s" 
          (fun addr _ name -> 
            Hashtbl.add var_addresses ("0x"^addr) name)
      with _ -> ()
  done with End_of_file -> (close_in f_nm; Sys.remove !nm_file)


(* process trace *)
let _ =
  let f_log = open_in !trace_file in
  let f_log_out = open_out (!trace_file_mod) in
  try while (true) do
    let s = input_line f_log in
    if s.[0] = 'I' || s.[0] = '=' 
    then 
      output_string f_log_out (s^"\n")
    else begin
      let ls = Str.split (Str.regexp " : ") s in
      if List.length ls != 7
      then output_string f_log_out (s^"\n")
      else begin
        let addr = List.nth ls 3 in
        let name =
          try Hashtbl.find var_addresses addr 
          with Not_found -> "(null)" in
        output_string f_log_out 
          ( List.nth ls 0 ^ " : " 
            ^ List.nth ls 1 ^ " : " 
            ^ name ^ " : " 
            ^ List.nth ls 3 ^ " : " 
            ^ List.nth ls 4 ^ " : " 
            ^ List.nth ls 5 ^ " : " 
            ^ List.nth ls 6 ^ "\n" )
      end
    end
  done with End_of_file -> (close_in f_log; close_out f_log_out)
      
(* replace trace *)
let _ =
  exec ("mv "^ !trace_file_mod^" "^ !trace_file)

