(**************************************************************************)
(*                                 Cmmtest                                *)
(*                                                                        *)
(*   Robin Morisset, ENS & INRIA Paris-Rocquencourt                       *)
(*   Pankaj Pawan, IIT Kanpur & INRIA Paris-Rocquencourt                  *)
(*   Francesco Zappa Nardelli, INRIA Paris-Rocquencourt                   *)
(*                                                                        *)
(*  The Cmmtest tool is copyright 2012, 2013 Institut National de         *)
(*  Recherche en Informatique et en Automatique (INRIA).                  *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(**************************************************************************)

open String
open Types
open Util

(* TODO: symbol table for variable *)
(* TODO: flush *)
(* parsing - disgusting, someday I will learn how to write parsers *)

let parse_attribute s = 
  if String.compare s "seq_cst" = 0 then Seq_cst else
  if String.compare s "acquire" = 0 then Acquire else
  if String.compare s "release" = 0 then Release else
  if String.compare s "relaxed" = 0 then Relaxed else
  error ("cannot parse attribute : "^s)

(* let rec construct_pointer_table fd (st:symbol_table) upd_st: symbol_table = *)
(*   try *)
(*     let line = input_line fd in *)
(*     if line.[0] = '=' || line.[0] = '*' then construct_pointer_table fd st upd_st *)
(*     else if not (line.[0] = 'I') then construct_pointer_table fd st upd_st *)
(*     else begin *)
(*       let l = Str.split (Str.regexp ":") line in *)
(*       (\* TODO: factor the two let below into parse_var_ofs *\) *)
(*       let var_tmp = strip  *)
(* 	( try List.nth l 1 with  *)
(* 	  | Failure _ -> error ("error parsing \""^line^"\" at index 1") ) in *)
(*       let (var,ofs) = *)
(* 	let l = Str.split (Str.regexp "+") var_tmp in *)
(* 	match l with *)
(* 	  | [var;ofs] -> var,(Some (int_of_string ofs)) *)
(* 	  | [var] -> var,None *)
(* 	  | _ -> error ("error parsing location \""^var_tmp^"\" in line \""^line^"\"") in *)


(*       let var = strip  *)
(* 	(try List.nth l 1  *)
(* 	 with Failure _ -> error ("error parsing \""^line^"\" at index 1") ) in *)
(*       let address =  *)
(* 	try Int64.of_string ("0x"^(strip (List.nth l 2) ))  *)
(* 	with *)
(* 	  | Failure "int_of_string" ->  *)
(* 	    error ("unable to convert \""^line^"\" to number at index 2") *)
(* 	  | Failure _ ->  *)
(* 	    error ("error parsing \""^line^"\" at index 2")  *)
(*       in *)
(*       match (List.hd l).[0] with *)
(*       | 'I' -> let nst =  *)
(*           (if not (Hashtbl.mem pointer_table address) then *)
(*           Hashtbl.add pointer_table address var); *)
(*           if List.mem_assoc var (fst st) then st  *)
(*           else if upd_st then *)
(*             let (t,i) = st in *)
(*             (((var, i)::t), i+1) *)
(*           else  *)
(*             error ("var "^var^" not defined in the symbol table.")  *)
(*           in *)
(*           construct_pointer_table fd nst upd_st *)
(*       |  _  ->  *)
(* 	(\* maybe not required as pointer table is complete wen INIT *)
(* 	   section is finished *\) *)
(* 	construct_pointer_table fd st upd_st *)
(*     end *)
(*   with End_of_file -> st (\**\)  *)


(* Address to variable name mapping, build by parsing the init entries of the trace *)

let pointer_table = Hashtbl.create 15

let dump_pointer_table () =
  Hashtbl.iter 
    (fun x y -> print_endline ((Int64.to_string x) ^":"^y))
    pointer_table

let rec construct_pointer_table fd (st:symbol_table) upd_st: symbol_table= 
    let mline = 
      try Some (input_line fd) 
      with End_of_file -> (* dump_pointer_table (); *) None in
    match mline with
        | None -> st
        | Some line ->
            if line.[0] = '=' || line.[0] = '*' then construct_pointer_table fd st upd_st
            else if line.[0] = 'F' then construct_pointer_table fd st upd_st
            else begin
            let l = Str.split (Str.regexp ":") line in
            let var = strip 
                (try List.nth l 1 
                with Failure _ -> error ("error parsing \""^line^"\" at index 1") ) in
            let address = 
                try Int64.of_string ("0x"^(strip (List.nth l 2) )) 
                with
                | Failure "int_of_string" -> 
                    error ("unable to convert \""^line^"\" to number at index 2")
                | Failure _ -> 
                    error ("error parsing \""^line^"\" at index 2") 
            in
            match (List.hd l).[0] with
            | 'I' -> 
	      let nst = 
                (if not (Hashtbl.mem pointer_table address) then
                    Hashtbl.add pointer_table address var);
                if List.mem_assoc var (fst st) then st 
                else begin
		  if not upd_st 
		  then 
		    if var.[0] = 'g' || var.[0] = 'a' 
		    then warning ("var "^var^" not defined in the unopt symbol table: "^line);
                  let (t,i) = st in
                  (((var, i)::t), i+1)
		end
              in construct_pointer_table fd nst upd_st
            |  _  -> 
                (* maybe not required as pointer table is complete wen INIT
                section is finished *)
                construct_pointer_table fd st upd_st
            end

type parse_line_res =
  | Line of event * symbol_table
  | IReads of int list
  | LDList of (int*int list) list
  | Copts of string
  | End
  | ErrorTooBig

let rec parse_line fd st upd_st : parse_line_res =
  try
    let line = input_line fd in
    if line.[0] = '=' 
    then parse_line fd st upd_st 
    else if line.[0] = 'F' then 
      Line (Flush, st)
    else if line.[0] = '*' then begin
      match line.[1] with
	| 'I' ->
	  let l = Str.split (Str.regexp ":") line in
	  if List.length l = 1 then IReads [] 
	  else
	    let idxs = Str.split (Str.regexp " ") (List.nth l 1) in
	    if List.length idxs > 100000 
	    then 
	      ErrorTooBig
	    else 
	      let idx = List.map int_of_string idxs in
	      IReads idx 
	|  'L' ->
	  let l = String.sub line 8 ((String.length line)-8) in
	  let ls = Str.split (Str.regexp ";;") l in
	  let lss = List.map 
	    (fun s -> Str.split (Str.regexp ":") s)
	    ls in
	  let ldlist = 
	    opt_map (fun (x,y) ->
	      (int_of_string (strip x),
	       List.map (fun z -> int_of_string (strip z)) (Str.split (Str.regexp " ") y)))
	      (List.map list_to_pair lss) in
	(*	List.iter (fun (x,y) -> Printf.printf "%d, %s\n" x (String.concat "-" (List.map string_of_int y))) ldlist; *)
	  LDList ldlist
	| 'C' -> 
	  Copts (String.sub line 7 ((String.length line)-7))
	| _ -> 	
	  warning ("cannot parse line: "^line); 
	  parse_line fd st upd_st 
    end else begin  (* standard trace entries *)
      let l = Str.split (Str.regexp ":") line in
      let var_tmp = strip 
	( try List.nth l 1 with 
	  | Failure _ -> error ("error parsing \""^line^"\" at index 1") ) in
      let (var,ofs) = (* var_tmp, None in *)
	let l = Str.split (Str.regexp "+") var_tmp in
	match l with
	  | [var;ofs] -> var,(Some (int_of_string ofs))
	  | [var] -> var,None
	  | _ -> error ("error parsing location \""^var_tmp^"\" in line \""^line^"\"") in
      let (loc, nst) = 
        try (List.assoc var (fst st), st)
        with Not_found -> 
	  error ("internal: parse_line, var "^var^" not defined in the unopt symbol table: "^line) in
          (* let (t,i) = st in *)
          (* (i, (((var, i)::t), i+1)) in *)
      match (List.hd l).[0] with
      | 'I' | 'L' | 'S' | 'U' ->
          begin
            let address = try Int64.of_string ("0x"^(strip (List.nth l 2) )) with
             | Failure "int_of_string" -> error ("unable to convert \""^line^"\" to number at index 2")
             | Failure _ -> error ("error parsing "^line^" at index 2") 
            in
	    match List.length l with
	      | 5 | 6 ->
		let read_value = try Int64.of_string ("0x"^(strip (List.nth l 3) )) with
		  | Failure "int_of_string" -> 
		      if String.contains (List.nth l 3) '.' 
		      then begin
			warning ("unable to convert \""^line^"\" to number at index 3"); 
			Int64.of_string "0x0" (* FZ FIXME, HACK for ARM *)
		      end else error ("unable to convert \""^line^"\" to number at index 3")
		  | Failure _ -> error ("error parsing "^line^" at index 3") 
		in
		let value = 
		  (* print_endline ("read_value: "^(Int64.to_string read_value)); *)
		  if Hashtbl.mem pointer_table read_value then (
		    (* FIXME...  HERE WE SHOULD GUESS THE OFFSET *)
                    Pointer ((List.assoc (Hashtbl.find pointer_table read_value) (fst nst)), None))
		  else (
		    NonPointer read_value) in
		let size = try int_of_string (strip (List.nth l 4) ) with
		  | Failure "int_of_string" -> error ("unable to convert"^line^" to number at index 4")
		  | Failure _ -> error ("error parsing "^line^" at index 4") 
		in
		( match List.length l with
		  | 5 -> Line
		    (( match (List.hd l).[0] with
		      | 'I' -> Init ((loc,ofs),value,size)
		      | 'L' -> Load ((loc,ofs),value,size)
		      | 'S' -> Store ((loc,ofs),value,size)
		      | _ -> error ("malformed trace - internal [5]")) 
			, nst )
		  | 6 -> 
		    let attr = parse_attribute (strip (List.nth l 5)) in
		    Line (
		      (( match (List.hd l).[0] with
		      | 'L' -> ALoad (attr,(loc,ofs),value,size)
		      | 'S' -> AStore (attr,(loc,ofs),value,size)
		      | _ -> error ("malformed trace - internal [6]")) 
			, nst ) ))
	      | 3 -> Line
		(( match (List.hd l).[0] with
		  | 'L' -> Lock (loc,ofs)
		  | 'U' -> Unlock (loc,ofs) )
		    , nst) 	
          end    
      | _ ->  parse_line fd st upd_st
    end
  with End_of_file -> close_in fd; End
    
let rec parse_file fd t st irreads ldlist upd_st co =
  match parse_line fd st upd_st with 
    | Line (a,nst) -> parse_file fd (a::t) nst irreads ldlist upd_st co
    | IReads il -> parse_file fd t st (il@irreads) ldlist upd_st co
    | LDList ll -> parse_file fd t st irreads (ll@ldlist) upd_st co
    | Copts s -> parse_file fd t st irreads ldlist upd_st s
    | End -> Some (List.rev t, irreads, ldlist, st, co)
    | ErrorTooBig -> close_in fd; None

(* TODO: the only exported functions *)
let parse_log (filename: string) : (trace * int list * (int*int list) list * symbol_table * string) option =
  Hashtbl.clear pointer_table ;
  debug ("parse_log "^filename);
  let fd = 
    try open_in filename 
    with Sys_error _ -> error ("can't open " ^ filename) in
    (*construct the pointer and the symbol table.*)
    (*IMP: We need 2 passes to properly handle the pointers*)
  let st = construct_pointer_table fd empty_symbol_table true
  in
  seek_in fd 0;
  parse_file fd [] st [] [] true "" 
 (*since the symbol table is already constructed we should not be
  adding any more elements into it *)
 (*TODO : remove the redundant false option ?*)

let parse_log_st (filename: string) (st: symbol_table) : 
    (trace * int list * (int*int list) list * symbol_table * string) option =
  Hashtbl.clear pointer_table ;
  debug ("parse_log_st "^filename);
  let fd = 
    try open_in filename 
    with Sys_error _ -> error ("can't open " ^ filename) in
  let st = construct_pointer_table fd st false in
  (*IMP: so not contruct the symbol table again *)
  seek_in fd 0;
  match parse_file fd [] st [] [] false "" with
    | Some (t,irs,ldlist,st,co) -> Some (t, irs, ldlist, st, co)
    | None -> None
  

(* let parse_log (filename: string) : trace = *)
(*   let fd =  *)
(*     try open_in filename  *)
(*     with Sys_error _ -> error ("can't open " ^ filename) in *)
(*   let parse_attribute s =  *)
(*     if String.compare s "seq_cst" = 0 then Seq_cst else *)
(*     if String.compare s "acquire" = 0 then Acquire else *)
(*     if String.compare s "release" = 0 then Release else *)
(*     if String.compare s "relaxed" = 0 then Relaxed else *)
(*     error ("cannot parse attribute : "^s) in *)
(*   let rec parse_line fd = *)
(*     try *)
(*       let l = Str.split (Str.regexp ":") (input_line fd) in *)
(*       match (List.hd l).[0] with *)
(* 	| 'L' | 'S' -> *)
(* 	  begin *)
(* 	    if List.length l = 4  *)
(* 	    then (\* non atomic *\) *)
(* 	      match (List.hd l).[0] with *)
(* 		| 'L' -> Some (Load (List.nth l 1)) *)
(* 		| 'S' -> Some (Store (List.nth l 1)) *)
(* 		| _ -> error ("malformed trace "^filename) *)
(* 	    else (\* atomic *\) *)
(* 	      let a = parse_attribute (String.strip (List.nth l 4)) in *)
(* 	      match (List.hd l).[0] with *)
(* 		| 'L' -> Some (Aload ((List.nth l 1),a)) *)
(* 		| 'S' -> Some (Astore ((List.nth l 1), a)) *)
(* 		| _ -> error ("malformed trace "^filename) *)
(* 	  end *)
(* 	| _ ->  parse_line fd *)
(*     with _ -> None *)
(*   in *)
(*   let rec parse_file fd t = *)
(*     match parse_line fd with  *)
(*     | Some a -> parse_file fd (a::t) *)
(*     | None -> List.rev t in *)
(*   parse_file fd [] *)
