(**************************************************************************)
(*                                 Cmmtest                                *)
(*                                                                        *)
(*   Robin Morisset, ENS & INRIA Paris-Rocquencourt                       *)
(*   Pankaj Pawan, IIT Kanpur & INRIA Paris-Rocquencourt                  *)
(*   Francesco Zappa Nardelli, INRIA Paris-Rocquencourt                   *)
(*                                                                        *)
(*  The Cmmtest tool is copyright 2012, 2013 Institut National de         *)
(*  Recherche en Informatique et en Automatique (INRIA).                  *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(**************************************************************************)

(* options *)

let n_proc = ref 4

let command = ref "sleep"
let args = ref ["1"]

(* aux *)

let list_remove l e =
  let rec aux l b =
    match l with
      | [] -> None
      | x::y -> 
        if e = x then Some (List.append (List.rev b) y) 
	else aux y (x::b)
  in aux l []

(* process management *)

let spawn command args =
  let a_args = Array.of_list (command::args) in
  Unix.create_process command a_args Unix.stdin Unix.stdout Unix.stderr
  
let spawn_many n command args =
  let rec aux n pidlist =
    if n = 0 then pidlist
    else begin
      let pid = spawn command args in
      aux (n-1) (pid::pidlist)
    end in
  aux n []

let rec wait_many pidlist =
  if pidlist = [] then ()
  else begin
    let (pid,_) = Unix.wait () in
    print_endline ("waited: "^string_of_int pid);

    match list_remove pidlist pid with
      | None -> print_endline "spawn error: pid not in pidlist\n"; exit 1
      | Some pl -> wait_many pl
  end

(* main *)
  
let raw_ca = ref []

let opts = Arg.align 
  [("-no", 
    Arg.Int (fun x -> n_proc := x),
    "no of instances spawned");
   ("--",
    Arg.Rest (fun s -> raw_ca := s::!raw_ca),
    "the command to be spawned and its arguments")]

let _ =
  Arg.parse opts 
    (fun s -> ())
    "usage: spawn [options] -- <command> <arg1> .. <argn>";
  ( match (List.rev !raw_ca) with
    | [] -> print_endline "usage: spawn [options] -- <command> <arg1> .. <argn>";
    | c::a -> command:=c; args:=a );

  let pid_list = spawn_many !n_proc !command !args in
  print_endline ("spawned: "^ !command^" : "^(String.concat "," !args)); 
  wait_many pid_list;
  print_endline "done"
  

  
  
  
  
