(**************************************************************************)
(*                                 Cmmtest                                *)
(*                                                                        *)
(*   Robin Morisset, ENS & INRIA Paris-Rocquencourt                       *)
(*   Pankaj Pawan, IIT Kanpur & INRIA Paris-Rocquencourt                  *)
(*   Francesco Zappa Nardelli, INRIA Paris-Rocquencourt                   *)
(*                                                                        *)
(*  The Cmmtest tool is copyright 2012, 2013 Institut National de         *)
(*  Recherche en Informatique et en Automatique (INRIA).                  *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(**************************************************************************)

open Types
open Util
open Str
open Config

let get_load_attr index = match index with
  | 0 -> "seq_cst"
  | 1 -> "acquire"
  | 2 -> "relaxed"
  | _ -> error ("computed mod not in range")

let get_store_attr index = match index with
  | 0 -> "seq_cst"
  | 1 -> "release"
  | 2 -> "relaxed"
  | _ -> error ("computed mod not in range")

let modify_pinlog logfile symbol_table =
  let fd =
    try open_in logfile
    with Sys_error _ -> error ("can't open log file.") in
  let fd_out =
    try open_out (logfile^"_temp.log")
    with Sys_error _ -> error ("can't open log file.") in
  let rec parse () =
      let line = input_line fd in
      if line.[0] = '=' then begin
        output_string fd_out (line ^ "\n");
        parse ()
      end else if line.[0] = 'F' || line.[0] = '*' then begin
        output_string fd_out (line ^ "\n");
        parse ()
      end else begin
        let info_list = Str.split (Str.regexp ":") line in
        (*let address = (int_of_string ("0x"^(strip (List.nth info_list 1)))) in*)
        let address = try int_of_string ("0x"^(strip (List.nth info_list 1))) with
        | Failure "int_of_string" -> error ("unable to convert"^line^" to number at index 1")
        | Failure _ -> error ("error parsing "^line^" at index 1")
        in
        begin try
          let (var_name, var_size) = Hashtbl.find symbol_table address in
          let new_info_list = ((List.nth info_list 0) ^ ": " ^ var_name ^ " : " ^ (String.concat ":" (List.tl info_list))) in
          output_string fd_out new_info_list;
          if string_match (Str.regexp_string "a_") var_name 0 then begin
            let foo =
              try (int_of_string (String.sub var_name 2 (String.length var_name - 2)) mod 3)
              with Failure _ -> error ("unable to get var_number from "^ var_name)
            in
            match line.[0] with
            | 'L' -> output_string fd_out (":"^(get_load_attr foo)^"\n")
            | 'S' -> output_string fd_out (":"^(get_store_attr foo)^"\n")
            |  _  -> error "unknown character at the start of line"
          end else
            output_string fd_out "\n"
          (*let new_info_list = (List.nth info_list 0) ^ ": " ^ var_name ^ " : " ^ (String.concat ":" (List.tl info_list)) ^ "\n" in *)
          (*output_string fd_out new_info_list;*)
          (*parse ()*)
        with Not_found ->
          (*        output_string fd_out (line ^ "\n");*)
          (*TODO: check again for an array access to find the offset *)
(*           warning "check for misaligned access if arrays are disabled?";*)
          let found = ref true in
          Hashtbl.iter (fun var_addr (var_name, size) ->
            if !found then
              if address > var_addr &&  (address - var_addr) < size then
                let new_info_list = (List.nth info_list 0) ^ ": " ^ var_name ^ "+"^(string_of_int (address - var_addr))  ^" : " ^ (String.concat ":" (List.tl info_list)) ^ "\n" in
                output_string fd_out new_info_list;
                found := false
                ) symbol_table ;
        end;
        parse ()
      end
  in
    try parse ()
    with End_of_file ->
      close_in fd;
      close_out fd_out;
      Sys.rename (logfile^"_temp.log") logfile

let construct_var_address_table arch exc =
  let symbol_table = Hashtbl.create 15 in
  let fd =
    match arch with
      | X86 ->
        ( try Unix.open_process_in (find_config "readelf_x86_bin" ^ " -s " ^ exc ^ " 2> /dev/null | grep 'g_\\|csmith\\|a_'")
        with _ -> error ("modify_pintrace.ml , readelf_x86_bin executable failed") )
      | ARM ->
        try Unix.open_process_in (find_config "readelf_arm_bin" ^ " -s " ^ exc ^ " 2> /dev/null | grep 'g_\\|csmith\\|a_'")
        with _ -> error ("modify_pintrace.ml , readelf_arm_bin executable failed") in
  let rec parse () =
    try
      let line = input_line fd in
      let info_list = List.filter (fun x -> match x with "" -> false | _ -> true)
      (Str.split (Str.regexp " ") line) in
      let var_name = (List.nth info_list 7) in
      if var_name.[0] = 'g' || var_name.[0] = 'c' || var_name.[0] = 'a' then begin
        let var_addr = Int64.of_string ("0x" ^ strip_zeros (List.nth info_list 1)) in
        let var_size = int_of_string (List.nth info_list 2) in
        Hashtbl.add symbol_table var_addr (var_name,var_size)
      end;
      parse ()
    with End_of_file ->
      ignore (Unix.close_process_in fd)
  in
  parse ();
  (* print_endline ("*** VAT of "^exc); *)
  (* Hashtbl.iter (fun var_addr (var_name,var_size) -> Printf.printf "addr: %Lx ; name %s ; size %d\n" var_addr var_name var_size) symbol_table; *)
  symbol_table

(* let modify pin_log executable = *)
(*   let symbol_table = Hashtbl.create 15 in *)
(*   construct_symbol_table executable symbol_table; *)
(*   modify_pinlog pin_log symbol_table *)
