(**************************************************************************)
(*                                 Cmmtest                                *)
(*                                                                        *)
(*   Robin Morisset, ENS & INRIA Paris-Rocquencourt                       *)
(*   Pankaj Pawan, IIT Kanpur & INRIA Paris-Rocquencourt                  *)
(*   Francesco Zappa Nardelli, INRIA Paris-Rocquencourt                   *)
(*                                                                        *)
(*  The Cmmtest tool is copyright 2012, 2013 Institut National de         *)
(*  Recherche en Informatique et en Automatique (INRIA).                  *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(**************************************************************************)

let comp = ref "gcc"
let opt = ref "-O2"

let string_contains s1 s2 = 
  let re = Str.regexp_string s2 in
  try ignore (Str.search_forward re s1 0); true
  with Not_found -> false

let delete s =
  (* let p = String.sub s 0 ((String.length s)-6) in *)
  (* print_endline ("deleting: "^p^"*"); *)
  ignore (Sys.command ("rm -rf "^(String.sub s 0 ((String.length s)-2))^"*"));
  ignore (Sys.command ("rm -rf "^(String.sub s 0 ((String.length s)-6))^"_*"));
  ignore (Sys.command ("rm -rf "^(String.sub s 0 ((String.length s)-6))^".c"))

let inspect s =
  ignore (Sys.command ("cmmtest -trace x86 -compiler "^ !comp
                       ^" -opt " ^ !opt
                       ^" -analyse -timeout 120 -dump_traces " ^s));
  print_newline ();
  let rec user () =
    print_string " (s)how source; (d)elete; (k)eep; (h)alt > ";
    match read_line () with
      | "s" -> print_newline (); ignore (Sys.command ("cat "^s)); print_newline (); user ()
      | "d" -> delete s; print_endline "\n > deleted\n"
      | "k" -> print_endline "\n > kept\n"
      | "h" -> exit 0
      | _ -> user () in
  user ()

let args = 
  [ ("-comp", Arg.String (fun s -> comp := s), "specify the compiler");
    ("-opt", Arg.String (fun s -> opt := s), "specify the optimisations")  ]

let _ =
  Arg.parse args (fun s -> print_endline "usage: inspect <options>"; exit 1)
    "usage: inspect <options>";

  let min_files = ref [] in
  Array.iter 
    (fun s -> if string_contains s "min.c" then min_files := s::!min_files) 
    (Sys.readdir ".");
  List.iter
    (fun s -> 
      print_endline ("Inspecting: "^s);
      inspect s)
    (List.sort (String.compare) !min_files)

