#!/bin/bash

ulimit -t 60

#treats uninitialized warnings as errors, occurs frequently when reducing programs with arrays
# do not remove -O2 !!!
# gcc -Werror=uninitialized -g -I /home/yquem/moscova/zappa/repositories/cpp/compiler_testing/csmith-2.1.0/runtime/ \
# -I /home/riob/zappanar/compiler_testing/csmith-2.1.0/runtime/ -std=c++11 -O2 $1 &> /dev/null
# init_comp_result=$?
# if [ ! $init_comp_result -eq 0 ]; then
#   exit 1;
# fi

# set the C standard flag
std="c++11"
if [ ${1: -2} == ".c" ]; then
    std="c11"
fi

prelim_file_a=$1"_outA.txt"
prelim_file_b=$1"_outB.txt"
if ! (
  clang -pedantic -Wall -O0 -c -I/home/zappa/ct/csmith-2.1.0/runtime/ -std=$std $1 > $prelim_file_a 2>&1 &&\
  ! grep 'conversions than data arguments' $prelim_file_a &&\
  ! grep 'incompatible redeclaration' $prelim_file_a &&\
  ! grep 'ordered comparison between pointer' $prelim_file_a &&\
  ! grep 'eliding middle term' $prelim_file_a &&\
  ! grep 'end of non-void function' $prelim_file_a &&\
  ! grep 'invalid in C99' $prelim_file_a &&\
  ! grep 'specifies type' $prelim_file_a &&\
  ! grep 'should return a value' $prelim_file_a &&\
  ! grep 'uninitialized' $prelim_file_a &&\
  ! grep 'incompatible pointer to' $prelim_file_a &&\
  ! grep 'incompatible integer to' $prelim_file_a &&\
  ! grep 'type specifier missing' $prelim_file_a &&\
  gcc -Wall -Wextra -O2 -I/home/zappa/ct/csmith-2.1.0/runtime/ -std=$std $1 -o smallz > $prelim_file_b 2>&1 &&\
  ! grep uninitialized $prelim_file_b &&\
  ! grep 'without a cast' $prelim_file_b &&\
  ! grep 'control reaches end' $prelim_file_b &&\
  ! grep 'return type defaults' $prelim_file_b &&\
  ! grep 'cast from pointer to integer' $prelim_file_b &&\
  ! grep 'useless type name in empty declaration' $prelim_file_b &&\
  ! grep 'no semicolon at end' $prelim_file_b &&\
  ! grep 'type defaults to' $prelim_file_b &&\
  ! grep 'too few arguments for format' $prelim_file_b &&\
  ! grep 'incompatible pointer' $prelim_file_b &&\
  ! grep 'ordered comparison of pointer with integer' $prelim_file_b &&\
  ! grep 'declaration does not declare anything' $prelim_file_b &&\
  ! grep 'expects type' $prelim_file_b &&\
  ! grep 'pointer from integer' $prelim_file_b &&\
  ! grep 'incompatible implicit' $prelim_file_b &&\
  ! grep 'excess elements in struct initializer' $prelim_file_b &&\
  ! grep 'comparison between pointer and integer' $prelim_file_b )
then 
    exit 1;
fi


#run frama-c and look for warnings / errors; unfortunately frama-c does not like C++ preprocessed files
# if [ ${1: -2} == ".c" ]; then
#     framac_file="framac_"$1
#     cp $1 $framac_file
#     perl -pi.bak -e 's/int main \(int argc, char\* argv\[\]\)/int argc; char **argv; int main (void)/' $framac_file &&\
# frama-c -cpp-command "gcc -C -Dvolatile= -E -I. -I/home/zappa/ct/csmith-2.1.0/runtime/ " -val-signed-overflow-alarms -val -stop-at-first-alarm -no-val-show-progress -machdep x86_64 -obviously-terminates -precise-unions $framac_file > $1"_framac.txt" 2>&1 &&\
# ! egrep -i '(user error|assert)' $1"_framac.txt"
#     framac_comp_result=$?
#    if [ ! $framac_comp_result -eq 0 ]; then
# 	exit 1;
#     fi
# fi

#run cmmtest
filename=$1".cmmtest_result"
cmmtest -trace $TRACE -timeout $TIMEOUT $TIMEOUT_DELTA $RELAXED_SIZE $UNSOUND $IRREPLAY $ANALYSE $ANALYSE_COUNT_ONLY -compiler $COMPILER $COMPOPTS -tool $TOOL $BASELINE $DUMPTRACES $1 > $filename
grep -E "(false)|(timeout_delta)" $filename
cmmtest_result=$?
if [ ! $cmmtest_result -eq 0 ]; then
  exit 1
fi

exit 0
