(**************************************************************************)
(*                                 Cmmtest                                *)
(*                                                                        *)
(*   Robin Morisset, ENS & INRIA Paris-Rocquencourt                       *)
(*   Pankaj Pawan, IIT Kanpur & INRIA Paris-Rocquencourt                  *)
(*   Francesco Zappa Nardelli, INRIA Paris-Rocquencourt                   *)
(*                                                                        *)
(*  The Cmmtest tool is copyright 2012, 2013 Institut National de         *)
(*  Recherche en Informatique et en Automatique (INRIA).                  *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(**************************************************************************)

open Str
open Util

(* util *)

(* FZ: already defined in util.ml ? *)
(* let strip ?(chars=" \t\r\n") s = *)
(*   let p = ref 0 in *)
(*   let l = String.length s in *)
(*   while !p < l && String.contains chars s.[!p] do *)
(*     incr p; *)
(*   done; *)
(*   let p = !p in *)
(*   let l = ref (l - 1) in *)
(*   while !l >= p && String.contains chars s.[!l] do *)
(*     decr l; *)
(*   done; *)
(*   String.sub s p (!l - p + 1) *)

let may f opt_x = match opt_x with
  | Some x -> f x;
  | None -> ()

let print_config (k,ov) =
  may (fun ov -> print_endline ("key : " ^ k ^ " and v : " ^ ov)) ov

(* config *)

let load_config =
  let filename = "cmmtest.config" in
  let (conf_file, fd_in) =
    try (("./" ^ filename), open_in ("./" ^ filename)) with Sys_error _ ->
      try (("~/" ^ filename), open_in  ("~/" ^ filename)) with Sys_error _ ->
        try 
          let cf = (Str.string_before Sys.executable_name 
                      (String.length Sys.executable_name - 7) ^ filename) in 
          (cf, open_in cf)
	with Sys_error _ -> error ("could not locate the cmmtest.config file.")
  in
  let rec parse_line config =
    try
      let line = input_line fd_in in
      try
        if line.[0] = '#' || line.[0] = ' ' then parse_line config else
          let m =  split (regexp "=") line in
          let config = match m with
            | [key;value] -> (strip key,Some (strip value))::config;
            | [key] -> (strip key,None)::config;
            | _ -> config; in
          parse_line config
      with Invalid_argument _ -> parse_line config;
    with End_of_file -> close_in fd_in;config; in
  let config = parse_line [] in
  print_endline ("* using config: "^conf_file);
  conf_file, config

let verify_path config_file k cmd =
  if exec ("which "^cmd^" > /dev/null") != 0
  then error (cmd ^ " not found.\nCheck that the binary name set for\n  "
              ^k^"\nin the config file\n  "^config_file ^"\nis correct.")

let verify_all_path config_file config =
  List.iter 
    (fun (k,sv) -> 
      if (last_chars k 3 = "bin") then may (verify_path config_file k) sv 
      else ()) 
    config

(* FZ: side effects at module initialisation time is bad practice *)
let config =
  let cf, c = load_config in
  verify_all_path cf c;
  c

let find_config key =
  let config = config in
  try
    match (List.assoc key config) with
  | Some v -> v
  | None -> warning (key ^ " not set in config.");""
  with Not_found -> error (key ^ "not found in config.")
