//                                Cmmtest                             

//  Robin Morisset, ENS & INRIA Paris-Rocquencourt
//  Pankaj Pawan, IIT Kanpur & INRIA Paris-Rocquencourt  
//  Pankaj Prateek, IIT Kanpur & INRIA Paris-Rocquencourt  
//  Francesco Zappa Nardelli, INRIA Paris-Rocquencourt

// The Cmmtest tool is copyright 2012, 2013 Institut National de
// Recherche en Informatique et en Automatique (INRIA).

// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions 
// are met: 
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
// 3. The names of the authors may not be used to endorse or promote
// products derived from this software without specific prior written
// permission.

// THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS 
// OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
// ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY 
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
// GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
// IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Variable definition
extern FILE * trace;
vector<pair<INT64, pair<bool, set<int> > > > control_dependency_structure;

bool read_from_rflags(set<int>* read_set, set<int>* read_write_set) {
  bool read_flag = false;
  for(set<int>::iterator it = (*read_set).begin(); it != (*read_set).end(); it++) {
    if((*it)== 34)
      read_flag = true;
  }
  for(set<int>::iterator it = (*read_write_set).begin(); it != (*read_write_set).end(); it++) {
    if((*it)== 34)
      read_flag = true;
  }
  return read_flag;
}

VOID control_dependency_analysis(bool memory_read, bool memory_write, 
    bool memory_read_write, ADDRINT memory_address, set<int> *read_set, 
    set<int> *write_set, set<int>* read_write_set,
    bool is_read, bool is_write, ADDRINT instr_addr) {
  
  bool read_rflags = read_from_rflags(read_set, read_write_set);
  
  if (memory_read || memory_write || memory_read_write) {
    /* DO NOTHING */
  } else {
    memory_address = 0;
  }
  
  map<ADDRINT, vector<int> >::iterator im;
  set<int>::iterator is;
  vector<int>::iterator iv;

  bool stack_read=false, stack_write=false;
  
  if(is_read) {
    UINT64 result = (UINT64)memory_address & STACK_MASK;
    if (result) stack_read=true;
    result = ( (UINT64)memory_address >> 20 ) ^ 0x4;
    if (!result) stack_read=true;
  }

  if(is_write) {
    UINT64 result = (UINT64)memory_address & STACK_MASK;
    if (result) stack_write=true;
    result = ( (UINT64)memory_address >> 20 ) ^ 0x4;
    if (!result) stack_write=true;
  }

  if ( ( (memory_address & STACK_MASK) && !(((UINT64)memory_address >> 20) ^ 0x4) ) && (!stack_read && !stack_write) ) {
    stack_read = memory_read;
    stack_write = memory_write; 
    if (memory_read_write) {
      stack_read = true ;
      stack_write = true;
    }
  }


  set<int> dependant_loads;

  if (stack_read && access_table.count(memory_address)) {
    vector<int>temp = access_table[memory_address];
    for (iv = temp.begin(); iv != temp.end(); iv++) {
      dependant_loads.insert(*iv);
    }
  }
  for (is = (*read_set).begin();is != (*read_set).end() ; is++) {
    int reg = *is;
    //add all loads in dependency list to used_index
    if(access_table.count(reg) > 0){
      vector<int>temp = access_table[reg];
      for (iv = temp.begin(); iv != temp.end(); iv++) {
        dependant_loads.insert(*iv);
      }
    }
    else {
      if (debug)
        warning(REG_StringShort((REG)reg).append(" is being read but was not found in the access_tabl")); 
    }
  }
  for (is = (*read_write_set).begin();is != (*read_write_set).end() ; is++) {
    int reg = *is;
    //add all loads in dependency list to used_index
    if(access_table.count(reg) > 0){
      vector<int>temp = access_table[reg];
      for(iv = temp.begin(); iv != temp.end(); iv++){
        dependant_loads.insert(*iv);
      }
    }
    else{
      if (debug)
        warning(REG_StringShort((REG)reg).append(" is being read but was not found in the access_table")); 
      //maybe because it was considered used and removed before
    }
  }

  control_dependency_structure.push_back(pair<INT64, pair<bool, set<int> > > (indexCount, pair<bool, set<int> > (read_rflags, dependant_loads)));

}


VOID print_control_dependencies() {
  vector<int> control_dep_list(indexCount);
  for(int i=0;i<int(control_dep_list.size());i++)
    control_dep_list[i] = -1;
  for(int i=0;i<int(control_dependency_structure.size());i++) {
    INT64 tmp1 = control_dependency_structure[i].first;
    bool tmp2 = control_dependency_structure[i].second.first;
    set<int> tmp3 = control_dependency_structure[i].second.second;
    if(tmp2) {
      for(set<int>::iterator is = tmp3.begin(); is!=tmp3.end(); is++) {
	if(tmp1+1 < control_dep_list[*is] || control_dep_list[*is] == -1)
	  control_dep_list[*is] = tmp1+1;
      }
    }
  }

  fprintf(trace, "*CDeps: ");
  if(debug) cout<<endl<<"CDeps: ";
  for(int i=0;i<indexCount;i++) {
    if(control_dep_list[i] != -1) {
      if(debug) cout<<i<<" : ";
      fprintf(trace, "%d : ", i);
      if(debug) cout<<control_dep_list[i]<<" ;;";
      fprintf(trace, "%d ;;", control_dep_list[i]);
    }
  }
  if(debug) cout<<endl;
  fprintf(trace, "\n");
}
