#ifndef STATEMENT_SYSTEMCALL_H
#define STATEMENT_SYSTEMCALL_H

///////////////////////////////////////////////////////////////////////////////
#include <ostream>
#include "Statement.h"


class Expression;
class Block;
class CGContext;

class StatementLock : public Statement
{
public:
  static StatementLock *make_random(CGContext &cg_context);

  StatementLock(Block* parent, int mutex);
  StatementLock(const StatementLock &sc);
  virtual void Output(std::ostream &out, FactMgr* fm, int indent = 0) const;
  virtual void get_blocks(std::vector<const Block*>& /* blks */) const {};
  virtual void get_exprs(std::vector<const Expression*>& ) const {};
  int get_mutex() const {return mutex;}

private:
  int mutex;
};


class StatementUnlock : public Statement
{
public:
  static StatementUnlock *make_random(CGContext &cg_context);

  StatementUnlock(Block* parent, int mutex);
  StatementUnlock(const StatementUnlock &sc);
  virtual void Output(std::ostream &out, FactMgr* fm, int indent = 0) const;
  virtual void get_blocks(std::vector<const Block*>& /* blks */) const {};
  virtual void get_exprs(std::vector<const Expression*>& ) const {};
  int get_mutex() const {return mutex;}

private:
  int mutex; 
};

void OutputMutexVariables(std::ostream&);
void InitMutexVaraibles(void);

#endif


