#include "StatementSystemCall.h"
#include <iostream>
#include <assert.h>
#include "CGOptions.h"
#include "CGContext.h"
#include "Block.h"
#include "Type.h"
#include "Function.h"
#include "Expression.h"
#include "FactMgr.h"
#include "Bookkeeper.h"
#include "ArrayVariable.h"
#include "Error.h"
#include <vector>
#include <set>

using namespace std;

///////////////////////////////////////////////////////////////////////////////

vector<int>GlobalMutexList;

void OutputMutexVariables(std::ostream &out){
  output_comment_line(out, "--- MUTEX VARIABLES ---");
  int mutex_list_size = GlobalMutexList.size();
  for(int i = 0 ;i < mutex_list_size ;i++)
    out << "pthread_mutex_t g_mutex_"<< GlobalMutexList[i] << " = PTHREAD_MUTEX_INITIALIZER;" << endl;
  outputln(out);
}

void InitMutexVariables(void){
  //generate a random number of mutex variables
  int num_mutex = rnd_upto(7);
  // out << "/*" << num_mutex <<"  mutex variables initialized*/" << endl;
  for (int i = 0;i<num_mutex;i++)
    GlobalMutexList.push_back(i);
}

StatementLock *
StatementLock::make_random(CGContext &cg_context)
{
  //check in cg_context if it has already seen a lock then generated statement
  //should be a unlock else a lock
  bool found = false;
  set<int> locked = cg_context.locks_taken; 
  int mutex_size = GlobalMutexList.size();
  int count = mutex_size;
  int mutex = -1;
  
  while(!found && count--){
    int index = rnd_upto(mutex_size);
    if(locked.find(GlobalMutexList[index]) == locked.end()){ 
      //free mutex...lock can be taken
      found = true;
      mutex = GlobalMutexList[index];
      cg_context.locks_taken.insert(mutex);
    }
  }
  if( !found && count <= 0) return NULL;

  assert(mutex >= 0);

  StatementLock* sc = new StatementLock(cg_context.get_current_block(), mutex);
  return sc;
}


StatementLock::StatementLock(Block* parent, int mutex):
Statement(eLock, parent),mutex(mutex)
{

}

StatementLock::StatementLock(const StatementLock &sc)
: Statement(sc.get_type(), sc.parent),mutex(sc.get_mutex())
{
  // Nothing else to do.
}


void
StatementLock::Output(std::ostream &out, FactMgr* /*fm*/, int indent) const
{
  output_tab(out, indent);
  out << "pthread_mutex_lock ( & g_mutex_" << mutex << ");";
  outputln(out);
}



StatementUnlock *
StatementUnlock::make_random(CGContext &cg_context)
{
  //Block* b = cg_context.get_current_block();
  //check in cg_context if it has already seen a lock then generated statement
  //should be a unlock else a lock

  set<int> locked = cg_context.locks_taken; 
  int mutex_size = locked.size();
  
  if(mutex_size <= 0) return NULL;
  //int index = rnd_upto(mutex_size);
  //unlocks the first mutex which was locked
  int mutex = *(locked.begin()); 
  cg_context.locks_taken.erase(mutex);

  StatementUnlock* sc = new StatementUnlock(cg_context.get_current_block(), mutex);
  return sc;
}


StatementUnlock::StatementUnlock(Block* parent, int mutex)
:Statement(eUnlock, parent),mutex(mutex)
{

}

StatementUnlock::StatementUnlock(const StatementUnlock &sc)
: Statement(sc.get_type(), sc.parent),mutex(sc.get_mutex())
{
  // Nothing else to do.
}


void
StatementUnlock::Output(std::ostream &out, FactMgr* /*fm*/, int indent) const
{
  output_tab(out, indent);
  out << "pthread_mutex_unlock ( & g_mutex_" << mutex<<" );";
  outputln(out);
}



