(**************************************************************************)
(*                            arm-run & arm-tracer                        *)
(*                                                                        *)
(*   Pankaj More, IIT Kanpur & INRIA Paris-Rocquencourt                   *)
(*   Francesco Zappa Nardelli, INRIA Paris-Rocquencourt                   *)
(*                                                                        *)
(*  The arm-run and arm-tracer tools are copyright 2012, 2013 Institut    *)
(*  National de Recherche en Informatique et en Automatique (INRIA).      *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(*  *******************************************************************   *)
(*                                                                        *)
(*  *******************************************************************   *)
(*                                                                        *)
(*                               arm-run                                  *)
(*                                                                        *)
(*  The arm-run tool is copyright 2010 - 2013 Anthony Fox, Magnus Myreen  *)
(*  and Mike Gordon, Computer Laboratory, University of Cambridge.        *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(**************************************************************************)

structure stringML :> stringML =
struct
  nonfix string_ge string_gt string_le char_ge char_gt char_le char_lt
         PAD_RIGHT PAD_LEFT toUpper toLower isCntrl isAscii isPunct
         isGraph isSpace isPrint isAlphaNum isHexDigit isAlpha isDigit
         isUpper isLower isPREFIX APPEND char_size * / div mod + - ^ @
         <> > < >= <= := o before;

  open numML
  open listML
  open optionML

  type char = Char.char;
  type string = String.string;
  fun CHR n = Char.chr(valOf(Int.fromString(numML.toDecString n)));
  fun ORD c = numML.fromDecString(Int.toString(Char.ord c));
  fun STRING c s = String.^(Char.toString c,s);
  fun DEST_STRING s = if s = "" then NONE 
          else SOME(String.sub(s,0),String.extract(s,1,NONE));
  fun string_lt a b = String.compare(a,b) = LESS
  val IMPLODE = String.implode
  val EXPLODE = String.explode
  fun STRLEN s = LENGTH (EXPLODE s)
  fun char_size c = ZERO

  fun STRCAT s1 s2 = FOLDR STRING s2 (EXPLODE s1)

  fun isPREFIX s1 s2 =
        case (DEST_STRING s1,DEST_STRING s2)
         of (NONE,v1) => true
          | (SOME((c1,t1)),NONE) => false
          | (SOME((c1,t1)),SOME((c2,t2))) =>
               (c1 = c2) andalso isPREFIX t1 t2

  fun isLower c =
        <= (fromString "97") (ORD c) andalso
        <= (ORD c) (fromString "122")

  fun isUpper c =
        <= (fromString "65") (ORD c) andalso
        <= (ORD c) (fromString "90")

  fun isDigit c =
        <= (fromString "48") (ORD c) andalso
        <= (ORD c) (fromString "57")

  fun isAlpha c = isLower c orelse isUpper c

  fun isHexDigit c =
        <= (fromString "48") (ORD c) andalso
        <= (ORD c) (fromString "57") orelse
        (<= (fromString "97") (ORD c) andalso
         <= (ORD c) (fromString "102") orelse
         <= (fromString "65") (ORD c) andalso
         <= (ORD c) (fromString "70"))

  fun isAlphaNum c = isAlpha c orelse isDigit c

  fun isPrint c =
        <= (fromString "32") (ORD c) andalso
        < (ORD c) (fromString "127")

  fun isSpace c =
        (ORD c = (fromString "32")) orelse
        <= (fromString "9") (ORD c) andalso <= (ORD c) (fromString "13")

  fun isGraph c = isPrint c andalso not (isSpace c)

  fun isPunct c = isGraph c andalso not (isAlphaNum c)

  fun isAscii c = <= (ORD c) (fromString "127")

  fun isCntrl c =
        < (ORD c) (fromString "32") orelse <= (fromString "127") (ORD c)

  fun toLower c =
        if isUpper c then CHR (+ (ORD c) (fromString "32")) else c

  fun toUpper c =
        if isLower c then CHR (- (ORD c) (fromString "32")) else c

  fun PAD_LEFT c n s =
        STRCAT (IMPLODE (GENLIST (combinML.K c) (- n (STRLEN s)))) s

  fun PAD_RIGHT c n s =
        STRCAT s (IMPLODE (GENLIST (combinML.K c) (- n (STRLEN s))))

  fun char_lt a b = < (ORD a) (ORD b)

  fun char_le a b = <= (ORD a) (ORD b)

  fun char_gt a b = > (ORD a) (ORD b)

  fun char_ge a b = >= (ORD a) (ORD b)

  fun string_le s1 s2 = (s1 = s2) orelse string_lt s1 s2

  fun string_gt s1 s2 = string_lt s2 s1

  fun string_ge s1 s2 = string_le s2 s1

end
