(**************************************************************************)
(*                            arm-run & arm-tracer                        *)
(*                                                                        *)
(*   Pankaj More, IIT Kanpur & INRIA Paris-Rocquencourt                   *)
(*   Francesco Zappa Nardelli, INRIA Paris-Rocquencourt                   *)
(*                                                                        *)
(*  The arm-run and arm-tracer tools are copyright 2012, 2013 Institut    *)
(*  National de Recherche en Informatique et en Automatique (INRIA).      *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(*  *******************************************************************   *)
(*                                                                        *)
(*  *******************************************************************   *)
(*                                                                        *)
(*                               arm-run                                  *)
(*                                                                        *)
(*  The arm-run tool is copyright 2010 - 2013 Anthony Fox, Magnus Myreen  *)
(*  and Mike Gordon, Computer Laboratory, University of Cambridge.        *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(**************************************************************************)

structure rich_listML :> rich_listML =
struct
  nonfix UNZIP_SND UNZIP_FST SUFFIX SEG SCANR SCANL REPLICATE PREFIX
         SPLITP REPLACE_ELEMENT SPLITP_AUX OR_EL IS_SUBLIST isPREFIX
         TAKE ELL DROP AND_EL * / div mod + - ^ @ <> > < >= <= := o
         before;

  open pairML
  open numML
  open listML

  val AND_EL = EVERY combinML.I

  fun DROP n l =
        if n = ZERO then l
        else
          if l = [] then
          raise (Fail "DROP: List too short")
        else DROP (PRE n) (TL l)

  fun ELL n l = if n = ZERO then LAST l else ELL (PRE n) (FRONT l)

  fun TAKE n l =
        if n = ZERO then []
        else
          if l = [] then
          raise (Fail "TAKE: List too short")
        else HD l::TAKE (PRE n) (TL l)

  fun isPREFIX [] l = true
    | isPREFIX (x::l) [] = false
    | isPREFIX (x2::l2) (x1::l1) = (x1 = x2) andalso isPREFIX l2 l1

  fun IS_SUBLIST l [] = true
    | IS_SUBLIST [] (x::l) = false
    | IS_SUBLIST (x1::l1) (x2::l2) =
        (x1 = x2) andalso isPREFIX l2 l1 orelse IS_SUBLIST l1 (x2::l2)

  val OR_EL = EXISTS combinML.I

  fun SPLITP_AUX acc P [] = (acc,[])
    | SPLITP_AUX acc P (h::t) =
        (if P h then (acc,h::t) else SPLITP_AUX (APPEND acc [h]) P t)

  fun REPLACE_ELEMENT e n [] = []
    | REPLACE_ELEMENT e n (x::l) =
        (if n = ZERO then e::l else x::REPLACE_ELEMENT e (PRE n) l)

  fun SPLITP x' x = SPLITP_AUX [] x' x

  fun PREFIX P l = FST (SPLITP (combinML.o not P) l)

  fun REPLICATE n l = if n = ZERO then [] else l::REPLICATE (PRE n) l

  fun SCANL f e [] = [e]
    | SCANL f e (x::l) = e::SCANL f (f e x) l

  fun SCANR f e [] = [e]
    | SCANR f e (x::l) = f x (HD (SCANR f e l))::SCANR f e l

  fun SEG m k l =
        if m = ZERO then []
        else
          if l = [] then
          raise (Fail "SEG: List too short")
        else
          if k = ZERO then
          HD l::SEG (PRE m) ZERO (TL l)
        else SEG m (PRE k) (TL l)

  fun SUFFIX P l =
        FOLDL (fn l' => fn x => if P x then SNOC x l' else []) [] l

  fun UNZIP_FST l = FST (UNZIP l)

  fun UNZIP_SND l = SND (UNZIP l)

end
