(**************************************************************************)
(*                            arm-run & arm-tracer                        *)
(*                                                                        *)
(*   Pankaj More, IIT Kanpur & INRIA Paris-Rocquencourt                   *)
(*   Francesco Zappa Nardelli, INRIA Paris-Rocquencourt                   *)
(*                                                                        *)
(*  The arm-run and arm-tracer tools are copyright 2012, 2013 Institut    *)
(*  National de Recherche en Informatique et en Automatique (INRIA).      *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(*  *******************************************************************   *)
(*                                                                        *)
(*  *******************************************************************   *)
(*                                                                        *)
(*                               arm-run                                  *)
(*                                                                        *)
(*  The arm-run tool is copyright 2010 - 2013 Anthony Fox, Magnus Myreen  *)
(*  and Mike Gordon, Computer Laboratory, University of Cambridge.        *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(**************************************************************************)

structure listML :> listML =
struct
  nonfix PAD_RIGHT PAD_LEFT list_size REV LEN LENGTH EL ALL_DISTINCT
         FRONT LAST REVERSE UNZIP ZIP MAP2 EXISTS EVERY GENLIST SNOC
         FOLDL FOLDR FILTER MEM MAP FLAT APPEND TL HD NULL * / div mod +
         - ^ @ <> > < >= <= := o before;

  open numML

  fun NULL [] = true
    | NULL (x::l) = false

  fun HD [] = raise (Fail "HD: Empty list")
    | HD (x::l) = x

  fun TL [] = raise (Fail "TL: Empty list")
    | TL (x::l) = l

  fun APPEND [] l = l
    | APPEND (x::l1) l2 = x::APPEND l1 l2

  fun FLAT [] = []
    | FLAT (x::l) = APPEND x (FLAT l)

  fun MAP f [] = []
    | MAP f (x::l) = f x::MAP f l

  fun MEM x [] = false
    | MEM x (h::t) = (x = h) orelse MEM x t

  fun FILTER P [] = []
    | FILTER P (h::t) = (if P h then h::FILTER P t else FILTER P t)

  fun FOLDR f e [] = e
    | FOLDR f e (x::l) = f x (FOLDR f e l)

  fun FOLDL f e [] = e
    | FOLDL f e (x::l) = FOLDL f (f e x) l

  fun SNOC x [] = [x]
    | SNOC x (x'::l) = x'::SNOC x l

  fun GENLIST f n =
        if n = ZERO then [] else SNOC (f (PRE n)) (GENLIST f (PRE n))

  fun EVERY P [] = true
    | EVERY P (h::t) = P h andalso EVERY P t

  fun EXISTS P [] = false
    | EXISTS P (h::t) = P h orelse EXISTS P t

  fun MAP2 f [] [] = []
    | MAP2 f [] (h::t) = raise (Fail "MAP2: unequal length lists")
    | MAP2 f (h::t) [] = raise (Fail "MAP2: unequal length lists")
    | MAP2 f (x1::l1) (x2::l2) = f x1 x2::MAP2 f l1 l2

  fun ZIP ([],[]) = []
    | ZIP ([],h::t) = raise (Fail "ZIP: unequal length lists")
    | ZIP (h::t,[]) = raise (Fail "ZIP: unequal length lists")
    | ZIP (x1::l1,x2::l2) = (x1,x2)::ZIP (l1,l2)

  fun UNZIP [] = ([],[])
    | UNZIP ((x,y)::t) = let val (L1,L2) = UNZIP t in (x::L1,y::L2) end

  fun REVERSE [] = []
    | REVERSE (h::t) = APPEND (REVERSE t) [h]

  fun LAST [] = raise (Fail "LAST: empty list")
    | LAST [x] = x
    | LAST (x::y::z) = LAST (y::z)

  fun FRONT [] = raise (Fail "FRONT: empty list")
    | FRONT [x] = []
    | FRONT (x::y::z) = x::FRONT (y::z)

  fun ALL_DISTINCT [] = true
    | ALL_DISTINCT (h::t) = not (MEM h t) andalso ALL_DISTINCT t

  fun EL n l = if n = ZERO then HD l else EL (PRE n) (TL l)

  fun LENGTH [] = ZERO
    | LENGTH (x::l) = + (LENGTH l) ONE

  fun LEN [] n = n
    | LEN (h::t) n = LEN t (+ n ONE)

  fun REV [] acc = acc
    | REV (h::t) acc = REV t (h::acc)

  fun list_size f [] = ZERO
    | list_size f (a0::a1) = + ONE (+ (f a0) (list_size f a1))

  fun PAD_LEFT c n s =
        APPEND (GENLIST (combinML.K c) (- n (LENGTH s))) s

  fun PAD_RIGHT c n s =
        APPEND s (GENLIST (combinML.K c) (- n (LENGTH s)))

end
