(**************************************************************************)
(*                            arm-run & arm-tracer                        *)
(*                                                                        *)
(*   Pankaj More, IIT Kanpur & INRIA Paris-Rocquencourt                   *)
(*   Francesco Zappa Nardelli, INRIA Paris-Rocquencourt                   *)
(*                                                                        *)
(*  The arm-run and arm-tracer tools are copyright 2012, 2013 Institut    *)
(*  National de Recherche en Informatique et en Automatique (INRIA).      *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(*  *******************************************************************   *)
(*                                                                        *)
(*  *******************************************************************   *)
(*                                                                        *)
(*                               arm-run                                  *)
(*                                                                        *)
(*  The arm-run tool is copyright 2010 - 2013 Anthony Fox, Magnus Myreen  *)
(*  and Mike Gordon, Computer Laboratory, University of Cambridge.        *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(**************************************************************************)

signature bitML =
sig
  type num = numML.num
  val TIMES_2EXP : num -> num -> num
  val BITWISE : num -> (bool -> bool -> bool) -> num -> num -> num
  val LOG : num -> num -> num
  val LOWEST_SET_BIT : num -> num
  val l2n : num -> num list -> num
  val n2l : num -> num -> num list
  val s2n : num -> (char -> num) -> string -> num
  val n2s : num -> (num -> char) -> num -> string
  val HEX : num -> char
  val UNHEX : char -> num
  val num_from_bin_list : num list -> num
  val num_from_oct_list : num list -> num
  val num_from_dec_list : num list -> num
  val num_from_hex_list : num list -> num
  val num_to_bin_list : num -> num list
  val num_to_oct_list : num -> num list
  val num_to_dec_list : num -> num list
  val num_to_hex_list : num -> num list
  val num_from_bin_string : string -> num
  val num_from_oct_string : string -> num
  val num_from_dec_string : string -> num
  val num_from_hex_string : string -> num
  val num_to_bin_string : num -> string
  val num_to_oct_string : num -> string
  val num_to_dec_string : num -> string
  val num_to_hex_string : num -> string
  val BIT_MODF
     : num -> (num -> bool -> bool) -> num -> num -> num -> num -> num
  val BIT_MODIFY : num -> (num -> bool -> bool) -> num -> num
  val BIT_REV : num -> num -> num -> num
  val BIT_REVERSE : num -> num -> num
  val LOG2 : num -> num
  val DIVMOD_2EXP : num -> num -> num * num
  val SBIT : bool -> num -> num
  val BITS : num -> num -> num -> num
  val MOD_2EXP_EQ : num -> num -> num -> bool
  val BITV : num -> num -> num
  val BIT : num -> num -> bool
  val SLICE : num -> num -> num -> num
  val LSB : num -> bool
  val SIGN_EXTEND : num -> num -> num -> num
  val BOOLIFY : num -> num -> bool list -> bool list
end
