(**************************************************************************)
(*                            arm-run & arm-tracer                        *)
(*                                                                        *)
(*   Pankaj More, IIT Kanpur & INRIA Paris-Rocquencourt                   *)
(*   Francesco Zappa Nardelli, INRIA Paris-Rocquencourt                   *)
(*                                                                        *)
(*  The arm-run and arm-tracer tools are copyright 2012, 2013 Institut    *)
(*  National de Recherche en Informatique et en Automatique (INRIA).      *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(*  *******************************************************************   *)
(*                                                                        *)
(*  *******************************************************************   *)
(*                                                                        *)
(*                               arm-run                                  *)
(*                                                                        *)
(*  The arm-run tool is copyright 2010 - 2013 Anthony Fox, Magnus Myreen  *)
(*  and Mike Gordon, Computer Laboratory, University of Cambridge.        *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(**************************************************************************)

structure armML :> armML =
struct
  nonfix fetch_instruction actual_instr_set attempt fetch_thumb
         fetch_arm ptree_read_halfword ptree_read_word proc
         thumb2_decode thumb2_decode_aux9 thumb2_decode_aux8
         thumb2_decode_aux7 thumb2_decode_aux6 thumb2_decode_aux5
         thumb2_decode_aux4 thumb2_decode_aux3 thumb2_decode_aux2
         thumb2_decode_aux1 thumbee_decode thumb_decode arm_decode
         LastInITBlock InITBlock parallel_add_sub_thumb_decode
         parallel_add_sub_decode parallel_add_sub_thumb_op2
         parallel_add_sub_op2 parallel_add_sub_op1 hint_decode arm_instr
         coprocessor_instruction miscellaneous_instruction
         load_store_instruction status_access_instruction
         data_processing_instruction branch_instruction condition_passed
         debug_instr wait_for_interrupt_instr send_event_instr
         wait_for_event_instr yield_instr no_operation_instr
         arm_register_to_coprocessor_two_instr
         coprocessor_register_to_arm_two_instr
         arm_register_to_coprocessor_instr
         coprocessor_register_to_arm_instr coprocessor_store_instr
         coprocessor_load_instr coprocessor_data_processing_instr
         instruction_synchronization_barrier_instr
         data_synchronization_barrier_instr data_memory_barrier_instr
         breakpoint_instr secure_monitor_call_instr set_endianness_instr
         change_processor_state_instr register_to_status_instr
         immediate_to_status_instr status_to_register_instr
         return_from_exception_instr store_return_state_instr swap_instr
         clear_exclusive_instr store_exclusive_halfword_instr
         load_exclusive_halfword_instr store_exclusive_byte_instr
         load_exclusive_byte_instr store_exclusive_doubleword_instr
         load_exclusive_doubleword_instr store_exclusive_instr
         load_exclusive_instr store_dual_instr load_dual_instr
         store_multiple_instr load_multiple_instr store_halfword_instr
         load_halfword_instr store_instr load_instr
         preload_instruction_instr preload_data_instr
         bit_field_clear_insert_instr bit_field_extract_instr
         unsigned_sum_absolute_differences_instr
         byte_reverse_signed_halfword_instr reverse_bits_instr
         byte_reverse_packed_halfword_instr extend_halfword_instr
         byte_reverse_word_instr extend_byte_instr saturate_16_instr
         select_bytes_instr extend_byte_16_instr saturate_instr
         pack_halfword_instr divide_instr parallel_add_subtract_instr
         signed_most_significant_multiply_subtract_instr
         signed_most_significant_multiply_instr
         signed_multiply_long_dual_instr signed_multiply_dual_instr
         signed_16_multiply_64_accumulate_instr
         signed_16x32_multiply_32_result_instr
         signed_16x32_multiply_32_accumulate_instr
         signed_16_multiply_32_result_instr
         signed_16_multiply_32_accumulate_instr
         saturating_add_subtract_instr multiply_subtract_instr
         multiply_accumulate_accumulate_instr multiply_long_instr
         multiply_instr data_processing_instr add_sub_instr
         move_halfword_instr count_leading_zeroes_instr if_then_instr
         enterx_leavex_instr handler_branch_parameter_instr
         handler_branch_link_parameter_instr handler_branch_link_instr
         check_array_instr table_branch_byte_instr compare_branch_instr
         branch_link_exchange_reg_instr branch_link_exchange_imm_instr
         branch_exchange_instr branch_target_instr null_check_if_thumbEE
         integer_zero_divide_trapping_enabled
         take_prefetch_abort_exception take_smc_exception
         take_svc_exception take_undef_instr_exception exc_vector_base
         barrier_option parallel_add_sub unsigned_halving_add_sub_8
         unsigned_saturating_add_sub_8 unsigned_normal_add_sub_8
         unsigned_parallel_add_sub_8 unsigned_halving_add_sub_16
         unsigned_saturating_add_sub_16 unsigned_normal_add_sub_16
         unsigned_parallel_add_sub_16 signed_halving_add_sub_8
         signed_saturating_add_sub_8 signed_normal_add_sub_8
         signed_parallel_add_sub_8 signed_halving_add_sub_16
         signed_saturating_add_sub_16 signed_normal_add_sub_16
         signed_parallel_add_sub_16 address_mode5 address_mode3
         address_mode2 address_mode1 arm_expand_imm thumb_expand_imm_c
         arm_expand_imm_c shift shift_c decode_reg_shift
         decode_imm_shift alu_write_pc load_write_pc bx_write_pc
         branch_write_pc spsr_write_by_instr cpsr_write_by_instr
         IT_advance write_e write_ge read_ge set_q read_cflag
         write_flags read_flags read_reg_literal arch_version
         unaligned_support coproc_get_two_words coproc_send_two_words
         coproc_get_one_word coproc_send_one_word
         coproc_get_words_to_store coproc_send_loaded_words
         coproc_internal_operation coproc_accepted write_coprocessors
         read_coprocessors clear_exclusive_local exclusive_monitors_pass
         set_exclusive_monitors waiting_for_interrupt
         clear_wait_for_interrupt wait_for_interrupt wait_for_event
         send_event event_registered clear_event_register hint_debug
         hint_yield hint_preload_instr hint_preload_data
         hint_preload_data_for_write instruction_synchronization_barrier
         data_synchronization_barrier data_memory_barrier
         write_memU_unpriv read_memU_unpriv write_memU read_memU
         write_memA_unpriv read_memA_unpriv write_memA read_memA
         write_memU_with_priv read_memU_with_priv write_memA_with_priv
         read_memA_with_priv write_mem read_mem write_mem1 read_mem1
         write_monitor read_monitor translate_address big_endian
         increment_pc branch_to write_reg read_reg pc_store_value
         read_pc write_reg_mode read_reg_mode LookUpRName RfiqBankSelect
         RBankSelect select_instr_set current_instr_set read_mvbar
         read_vbar is_secure current_mode_is_user_or_system
         current_mode_is_priviledged write_spsr read_spsr bad_mode
         have_thumbEE have_jazelle have_security_ext write_isetstate
         read_isetstate write_cpsr read_cpsr read_sctlr read_teehbr
         read_nsacr write_scr read_scr write__psr read__psr write__reg
         read__reg read_extensions read_arch read_info writeT readT forT
         condT lockT parT seqT errorT constT seqC constC seqE constE
         is_mode3_immediate is_mode2_immediate is_mode1_immediate
         version_number encode_psr decode_psr ITAdvance RRX ROR ASR LSR
         LSL RRX_C ROR_C ASR_C LSR_C LSL_C bytes word64 word32 word16
         sign_extend32 zero_extend32 bit_count bit_count_upto SUM
         lowest_set_bit count_leading_zeroes aligned align ==>
         data_processing_thumb2_unpredictable unsigned_sat_q_itself
         signed_sat_q_itself unsigned_sat_itself signed_sat_itself
         i2bits_itself i2w Error ValueState arm_state_monitors_fupd
         arm_state_coprocessors_fupd arm_state_information_fupd
         arm_state_accesses_fupd arm_state_memory_fupd
         arm_state_interrupt_wait_fupd arm_state_event_register_fupd
         arm_state_psrs_fupd arm_state_registers_fupd arm_state_monitors
         arm_state_coprocessors arm_state_information arm_state_accesses
         arm_state_memory arm_state_interrupt_wait
         arm_state_event_register arm_state_psrs arm_state_registers
         arm_state Coprocessors_get_two_fupd Coprocessors_send_two_fupd
         Coprocessors_get_one_fupd Coprocessors_send_one_fupd
         Coprocessors_store_fupd Coprocessors_load_fupd
         Coprocessors_load_count_fupd Coprocessors_internal_op_fupd
         Coprocessors_accept_fupd Coprocessors_state_fupd
         Coprocessors_get_two Coprocessors_send_two Coprocessors_get_one
         Coprocessors_send_one Coprocessors_store Coprocessors_load
         Coprocessors_load_count Coprocessors_internal_op
         Coprocessors_accept Coprocessors_state Coprocessors
         ExclusiveMonitors_ClearExclusiveLocal_fupd
         ExclusiveMonitors_ClearExclusiveByAddress_fupd
         ExclusiveMonitors_IsExclusiveLocal_fupd
         ExclusiveMonitors_IsExclusiveGlobal_fupd
         ExclusiveMonitors_MarkExclusiveLocal_fupd
         ExclusiveMonitors_MarkExclusiveGlobal_fupd
         ExclusiveMonitors_state_fupd
         ExclusiveMonitors_ClearExclusiveLocal
         ExclusiveMonitors_ClearExclusiveByAddress
         ExclusiveMonitors_IsExclusiveLocal
         ExclusiveMonitors_IsExclusiveGlobal
         ExclusiveMonitors_MarkExclusiveLocal
         ExclusiveMonitors_MarkExclusiveGlobal ExclusiveMonitors_state
         ExclusiveMonitors Coprocessor Miscellaneous LoadStore
         StatusAccess DataProcessing Branch Undefined Unpredictable
         Coprocessor_Transfer_Two Coprocessor_Transfer
         Coprocessor_Data_Processing Coprocessor_Store Coprocessor_Load
         If_Then Clear_Exclusive Enterx_Leavex Secure_Monitor_Call
         Supervisor_Call Preload_Instruction Preload_Data Swap
         Instruction_Synchronization_Barrier
         Data_Synchronization_Barrier Data_Memory_Barrier Breakpoint
         Hint Return_From_Exception Store_Return_State
         Store_Exclusive_Byte Load_Exclusive_Byte
         Store_Exclusive_Halfword Load_Exclusive_Halfword
         Store_Exclusive_Doubleword Load_Exclusive_Doubleword
         Store_Exclusive Load_Exclusive Store_Multiple Load_Multiple
         Store_Dual Load_Dual Store_Halfword Load_Halfword Store Load
         Set_Endianness Change_Processor_State Immediate_to_Status
         Register_to_Status Status_to_Register Divide
         Parallel_Add_Subtract Unsigned_Sum_Absolute_Differences
         Select_Bytes Bit_Field_Extract Byte_Reverse_Signed_Halfword
         Byte_Reverse_Packed_Halfword Byte_Reverse_Word Reverse_Bits
         Count_Leading_Zeroes Bit_Field_Clear_Insert Extend_Halfword
         Extend_Byte_16 Extend_Byte Pack_Halfword
         Saturating_Add_Subtract Saturate_16 Saturate
         Multiply_Accumulate_Accumulate Multiply_Long
         Signed_Most_Significant_Multiply_Subtract
         Signed_Most_Significant_Multiply Signed_Multiply_Long_Dual
         Signed_Multiply_Dual Signed_Halfword_Multiply Multiply_Subtract
         Multiply Move_Halfword Add_Sub Data_Processing
         Handler_Branch_Parameter Handler_Branch_Link_Parameter
         Handler_Branch_Link Check_Array Table_Branch_Byte
         Compare_Branch Branch_Link_Exchange_Register
         Branch_Link_Exchange_Immediate Branch_Exchange Branch_Target
         Parallel_sub_8 Parallel_add_8 Parallel_sub_16
         Parallel_sub_add_exchange Parallel_add_sub_exchange
         Parallel_add_16 Parallel_halving Parallel_saturating
         Parallel_normal Hint_debug Hint_send_event
         Hint_wait_for_interrupt Hint_wait_for_event Hint_yield Hint_nop
         Mode3_register Mode3_immediate Mode2_register Mode2_immediate
         Mode1_register_shifted_register Mode1_register Mode1_immediate
         MBReqTypes_Writes MBReqTypes_All MBReqDomain_Nonshareable
         MBReqDomain_InnerShareable MBReqDomain_OuterShareable
         MBReqDomain_FullSystem AddressDescriptor_paddress_fupd
         AddressDescriptor_memattrs_fupd AddressDescriptor_paddress
         AddressDescriptor_memattrs AddressDescriptor
         MemoryAttributes_outershareable_fupd
         MemoryAttributes_shareable_fupd
         MemoryAttributes_outerattrs_fupd
         MemoryAttributes_innerattrs_fupd MemoryAttributes_type_fupd
         MemoryAttributes_outershareable MemoryAttributes_shareable
         MemoryAttributes_outerattrs MemoryAttributes_innerattrs
         MemoryAttributes_type MemoryAttributes MemType_StronglyOrdered
         MemType_Device MemType_Normal Encoding_ThumbEE Encoding_Thumb2
         Encoding_Thumb Encoding_ARM InstrSet_ThumbEE InstrSet_Jazelle
         InstrSet_Thumb InstrSet_ARM SRType_RRX SRType_ROR SRType_ASR
         SRType_LSR SRType_LSL ARMinfo_unaligned_support_fupd
         ARMinfo_extensions_fupd ARMinfo_arch_fupd
         ARMinfo_unaligned_support ARMinfo_extensions ARMinfo_arch
         ARMinfo ARMv7_R ARMv7_A ARMv6T2 ARMv6K ARMv6 ARMv5TE ARMv5T
         ARMv4T ARMv4 MEM_WRITE MEM_READ coproc_state_cp15_fupd
         coproc_state_cp14_fupd coproc_state_cp15 coproc_state_cp14
         coproc_state CP15reg_MVBAR_fupd CP15reg_VBAR_fupd
         CP15reg_NSACR_fupd CP15reg_SCR_fupd CP15reg_SCTLR_fupd
         CP15reg_MVBAR CP15reg_VBAR CP15reg_NSACR CP15reg_SCR
         CP15reg_SCTLR CP15reg CP15nsacr_cp_fupd CP15nsacr_NSD32DIS_fupd
         CP15nsacr_NSASEDIS_fupd CP15nsacr_RFR_fupd CP15nsacr_cp
         CP15nsacr_NSD32DIS CP15nsacr_NSASEDIS CP15nsacr_RFR CP15nsacr
         CP15scr_NS_fupd CP15scr_IRQ_fupd CP15scr_FIQ_fupd
         CP15scr_EA_fupd CP15scr_FW_fupd CP15scr_AW_fupd
         CP15scr_nET_fupd CP15scr_NS CP15scr_IRQ CP15scr_FIQ CP15scr_EA
         CP15scr_FW CP15scr_AW CP15scr_nET CP15scr CP15sctlr_M_fupd
         CP15sctlr_A_fupd CP15sctlr_C_fupd CP15sctlr_B_fupd
         CP15sctlr_SW_fupd CP15sctlr_Z_fupd CP15sctlr_I_fupd
         CP15sctlr_V_fupd CP15sctlr_RR_fupd CP15sctlr_HA_fupd
         CP15sctlr_DZ_fupd CP15sctlr_FI_fupd CP15sctlr_U_fupd
         CP15sctlr_VE_fupd CP15sctlr_EE_fupd CP15sctlr_NMFI_fupd
         CP15sctlr_TRE_fupd CP15sctlr_AFE_fupd CP15sctlr_TE_fupd
         CP15sctlr_IE_fupd CP15sctlr_M CP15sctlr_A CP15sctlr_C
         CP15sctlr_B CP15sctlr_SW CP15sctlr_Z CP15sctlr_I CP15sctlr_V
         CP15sctlr_RR CP15sctlr_HA CP15sctlr_DZ CP15sctlr_FI CP15sctlr_U
         CP15sctlr_VE CP15sctlr_EE CP15sctlr_NMFI CP15sctlr_TRE
         CP15sctlr_AFE CP15sctlr_TE CP15sctlr_IE CP15sctlr
         CP14reg_TEEHBR_fupd CP14reg_TEEHBR CP14reg ARMpsr_M_fupd
         ARMpsr_T_fupd ARMpsr_F_fupd ARMpsr_I_fupd ARMpsr_A_fupd
         ARMpsr_E_fupd ARMpsr_GE_fupd ARMpsr_Reserved_fupd ARMpsr_J_fupd
         ARMpsr_IT_fupd ARMpsr_Q_fupd ARMpsr_V_fupd ARMpsr_C_fupd
         ARMpsr_Z_fupd ARMpsr_N_fupd ARMpsr_M ARMpsr_T ARMpsr_F ARMpsr_I
         ARMpsr_A ARMpsr_E ARMpsr_GE ARMpsr_Reserved ARMpsr_J ARMpsr_IT
         ARMpsr_Q ARMpsr_V ARMpsr_C ARMpsr_Z ARMpsr_N ARMpsr SPSR_und
         SPSR_abt SPSR_mon SPSR_svc SPSR_irq SPSR_fiq CPSR RName_PC
         RName_LRmon RName_LRund RName_LRabt RName_LRsvc RName_LRirq
         RName_LRfiq RName_LRusr RName_SPmon RName_SPund RName_SPabt
         RName_SPsvc RName_SPirq RName_SPfiq RName_SPusr RName_12fiq
         RName_12usr RName_11fiq RName_11usr RName_10fiq RName_10usr
         RName_9fiq RName_9usr RName_8fiq RName_8usr RName_7usr
         RName_6usr RName_5usr RName_4usr RName_3usr RName_2usr
         RName_1usr RName_0usr iiid_proc_fupd iiid_proc iiid
         Extension_Multiprocessing Extension_Jazelle Extension_Security
         Extension_AdvanvedSIMD Extension_VFP Extension_ThumbEE * / div
         mod + - ^ @ <> > < >= <= := o before

  open numML
  open setML
  open stringML
  open fcpML
  open bitML
  open wordsML

  type int = intML.int
  type 'a ptree = 'a patriciaML.ptree
  datatype ARMextensions
       = Extension_ThumbEE
       | Extension_VFP
       | Extension_AdvanvedSIMD
       | Extension_Security
       | Extension_Jazelle
       | Extension_Multiprocessing
  type ARMextensions_set = ARMextensions set
  datatype iiid = iiid of num
  fun iiid_proc (iiid(v1)) = v1

  fun iiid_proc_fupd f (iiid(v1)) = iiid(f v1)

  datatype RName
       = RName_0usr
       | RName_1usr
       | RName_2usr
       | RName_3usr
       | RName_4usr
       | RName_5usr
       | RName_6usr
       | RName_7usr
       | RName_8usr
       | RName_8fiq
       | RName_9usr
       | RName_9fiq
       | RName_10usr
       | RName_10fiq
       | RName_11usr
       | RName_11fiq
       | RName_12usr
       | RName_12fiq
       | RName_SPusr
       | RName_SPfiq
       | RName_SPirq
       | RName_SPsvc
       | RName_SPabt
       | RName_SPund
       | RName_SPmon
       | RName_LRusr
       | RName_LRfiq
       | RName_LRirq
       | RName_LRsvc
       | RName_LRabt
       | RName_LRund
       | RName_LRmon
       | RName_PC
  datatype PSRName
       = CPSR
       | SPSR_fiq
       | SPSR_irq
       | SPSR_svc
       | SPSR_mon
       | SPSR_abt
       | SPSR_und
  datatype
  ARMpsr = ARMpsr of bool * bool * bool * bool * bool * word8 * bool *
                     word4 * word4 * bool * bool * bool * bool * bool *
                     word5
  fun ARMpsr_N
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v1

  fun ARMpsr_Z
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v2

  fun ARMpsr_C
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v3

  fun ARMpsr_V
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v4

  fun ARMpsr_Q
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v5

  fun ARMpsr_IT
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v6

  fun ARMpsr_J
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v7

  fun ARMpsr_Reserved
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v8

  fun ARMpsr_GE
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v9

  fun ARMpsr_E
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v10

  fun ARMpsr_A
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v11

  fun ARMpsr_I
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v12

  fun ARMpsr_F
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v13

  fun ARMpsr_T
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v14

  fun ARMpsr_M
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        v15

  fun ARMpsr_N_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(f v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)

  fun ARMpsr_Z_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,f v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)

  fun ARMpsr_C_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,v2,f v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)

  fun ARMpsr_V_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,v2,v3,f v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)

  fun ARMpsr_Q_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,v2,v3,v4,f v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)

  fun ARMpsr_IT_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,v2,v3,v4,v5,f v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)

  fun ARMpsr_J_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,v2,v3,v4,v5,v6,f v7,v8,v9,v10,v11,v12,v13,v14,v15)

  fun ARMpsr_Reserved_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,v2,v3,v4,v5,v6,v7,f v8,v9,v10,v11,v12,v13,v14,v15)

  fun ARMpsr_GE_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,f v9,v10,v11,v12,v13,v14,v15)

  fun ARMpsr_E_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,f v10,v11,v12,v13,v14,v15)

  fun ARMpsr_A_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,f v11,v12,v13,v14,v15)

  fun ARMpsr_I_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,f v12,v13,v14,v15)

  fun ARMpsr_F_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,f v13,v14,v15)

  fun ARMpsr_T_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,f v14,v15)

  fun ARMpsr_M_fupd f
        (ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15)) =
        ARMpsr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,f v15)

  datatype CP14reg = CP14reg of word32
  fun CP14reg_TEEHBR (CP14reg(v1)) = v1

  fun CP14reg_TEEHBR_fupd f (CP14reg(v1)) = CP14reg(f v1)

  datatype
  CP15sctlr = CP15sctlr of bool * bool * bool * bool * bool * bool *
                           bool * bool * bool * bool * bool * bool *
                           bool * bool * bool * bool * bool * bool *
                           bool * bool
  fun CP15sctlr_IE
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v1

  fun CP15sctlr_TE
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v2

  fun CP15sctlr_AFE
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v3

  fun CP15sctlr_TRE
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v4

  fun CP15sctlr_NMFI
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v5

  fun CP15sctlr_EE
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v6

  fun CP15sctlr_VE
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v7

  fun CP15sctlr_U
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v8

  fun CP15sctlr_FI
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v9

  fun CP15sctlr_DZ
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v10

  fun CP15sctlr_HA
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v11

  fun CP15sctlr_RR
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v12

  fun CP15sctlr_V
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v13

  fun CP15sctlr_I
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v14

  fun CP15sctlr_Z
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v15

  fun CP15sctlr_SW
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v16

  fun CP15sctlr_B
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v17

  fun CP15sctlr_C
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v18

  fun CP15sctlr_A
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v19

  fun CP15sctlr_M
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) = v20

  fun CP15sctlr_IE_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(f v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_TE_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,f v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_AFE_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,f v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_TRE_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,f v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_NMFI_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,f v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_EE_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,f v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_VE_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,f v7,v8,v9,v10,v11,v12,v13,v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_U_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,v7,f v8,v9,v10,v11,v12,v13,v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_FI_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,f v9,v10,v11,v12,v13,v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_DZ_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,f v10,v11,v12,v13,v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_HA_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,f v11,v12,v13,v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_RR_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,f v12,v13,v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_V_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,f v13,v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_I_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,f v14,v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_Z_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,f v15,
                  v16,v17,v18,v19,v20)

  fun CP15sctlr_SW_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                  f v16,v17,v18,v19,v20)

  fun CP15sctlr_B_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                  v16,f v17,v18,v19,v20)

  fun CP15sctlr_C_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                  v16,v17,f v18,v19,v20)

  fun CP15sctlr_A_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                  v16,v17,v18,f v19,v20)

  fun CP15sctlr_M_fupd f
        (CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                   v16,v17,v18,v19,v20)) =
        CP15sctlr(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15,
                  v16,v17,v18,v19,f v20)

  datatype
  CP15scr = CP15scr of bool * bool * bool * bool * bool * bool * bool
  fun CP15scr_nET (CP15scr(v1,v2,v3,v4,v5,v6,v7)) = v1

  fun CP15scr_AW (CP15scr(v1,v2,v3,v4,v5,v6,v7)) = v2

  fun CP15scr_FW (CP15scr(v1,v2,v3,v4,v5,v6,v7)) = v3

  fun CP15scr_EA (CP15scr(v1,v2,v3,v4,v5,v6,v7)) = v4

  fun CP15scr_FIQ (CP15scr(v1,v2,v3,v4,v5,v6,v7)) = v5

  fun CP15scr_IRQ (CP15scr(v1,v2,v3,v4,v5,v6,v7)) = v6

  fun CP15scr_NS (CP15scr(v1,v2,v3,v4,v5,v6,v7)) = v7

  fun CP15scr_nET_fupd f (CP15scr(v1,v2,v3,v4,v5,v6,v7)) =
        CP15scr(f v1,v2,v3,v4,v5,v6,v7)

  fun CP15scr_AW_fupd f (CP15scr(v1,v2,v3,v4,v5,v6,v7)) =
        CP15scr(v1,f v2,v3,v4,v5,v6,v7)

  fun CP15scr_FW_fupd f (CP15scr(v1,v2,v3,v4,v5,v6,v7)) =
        CP15scr(v1,v2,f v3,v4,v5,v6,v7)

  fun CP15scr_EA_fupd f (CP15scr(v1,v2,v3,v4,v5,v6,v7)) =
        CP15scr(v1,v2,v3,f v4,v5,v6,v7)

  fun CP15scr_FIQ_fupd f (CP15scr(v1,v2,v3,v4,v5,v6,v7)) =
        CP15scr(v1,v2,v3,v4,f v5,v6,v7)

  fun CP15scr_IRQ_fupd f (CP15scr(v1,v2,v3,v4,v5,v6,v7)) =
        CP15scr(v1,v2,v3,v4,v5,f v6,v7)

  fun CP15scr_NS_fupd f (CP15scr(v1,v2,v3,v4,v5,v6,v7)) =
        CP15scr(v1,v2,v3,v4,v5,v6,f v7)

  datatype
  CP15nsacr = CP15nsacr of bool * bool * bool * unit bit1 bit1 bit0 word
  fun CP15nsacr_RFR (CP15nsacr(v1,v2,v3,v4)) = v1

  fun CP15nsacr_NSASEDIS (CP15nsacr(v1,v2,v3,v4)) = v2

  fun CP15nsacr_NSD32DIS (CP15nsacr(v1,v2,v3,v4)) = v3

  fun CP15nsacr_cp (CP15nsacr(v1,v2,v3,v4)) = v4

  fun CP15nsacr_RFR_fupd f (CP15nsacr(v1,v2,v3,v4)) =
        CP15nsacr(f v1,v2,v3,v4)

  fun CP15nsacr_NSASEDIS_fupd f (CP15nsacr(v1,v2,v3,v4)) =
        CP15nsacr(v1,f v2,v3,v4)

  fun CP15nsacr_NSD32DIS_fupd f (CP15nsacr(v1,v2,v3,v4)) =
        CP15nsacr(v1,v2,f v3,v4)

  fun CP15nsacr_cp_fupd f (CP15nsacr(v1,v2,v3,v4)) =
        CP15nsacr(v1,v2,v3,f v4)

  datatype
  CP15reg = CP15reg of CP15sctlr * CP15scr * CP15nsacr * word32 * word32
  fun CP15reg_SCTLR (CP15reg(v1,v2,v3,v4,v5)) = v1

  fun CP15reg_SCR (CP15reg(v1,v2,v3,v4,v5)) = v2

  fun CP15reg_NSACR (CP15reg(v1,v2,v3,v4,v5)) = v3

  fun CP15reg_VBAR (CP15reg(v1,v2,v3,v4,v5)) = v4

  fun CP15reg_MVBAR (CP15reg(v1,v2,v3,v4,v5)) = v5

  fun CP15reg_SCTLR_fupd f (CP15reg(v1,v2,v3,v4,v5)) =
        CP15reg(f v1,v2,v3,v4,v5)

  fun CP15reg_SCR_fupd f (CP15reg(v1,v2,v3,v4,v5)) =
        CP15reg(v1,f v2,v3,v4,v5)

  fun CP15reg_NSACR_fupd f (CP15reg(v1,v2,v3,v4,v5)) =
        CP15reg(v1,v2,f v3,v4,v5)

  fun CP15reg_VBAR_fupd f (CP15reg(v1,v2,v3,v4,v5)) =
        CP15reg(v1,v2,v3,f v4,v5)

  fun CP15reg_MVBAR_fupd f (CP15reg(v1,v2,v3,v4,v5)) =
        CP15reg(v1,v2,v3,v4,f v5)

  datatype coproc_state = coproc_state of CP14reg * CP15reg
  fun coproc_state_cp14 (coproc_state(v1,v2)) = v1

  fun coproc_state_cp15 (coproc_state(v1,v2)) = v2

  fun coproc_state_cp14_fupd f (coproc_state(v1,v2)) =
        coproc_state(f v1,v2)

  fun coproc_state_cp15_fupd f (coproc_state(v1,v2)) =
        coproc_state(v1,f v2)

  datatype access
    = MEM_READ of word32 * (word8 list) * num | MEM_WRITE of word32 * (word8 list) * num
      | REG_READ of RName | REG_WRITE of RName
      | PSR_READ of PSRName | PSR_WRITE of PSRName
  datatype ir_access
    = IR_REG_READ of RName | IR_REG_WRITE of RName
      | LOCAL_READ of word32 | LOCAL_WRITE of word32
      | GLOBAL_READ of Int.int | GLOBAL_WRITE of Int.int
  datatype ARMarch
       = ARMv4
       | ARMv4T
       | ARMv5T
       | ARMv5TE
       | ARMv6
       | ARMv6K
       | ARMv6T2
       | ARMv7_A
       | ARMv7_R
  datatype ARMinfo = ARMinfo of ARMarch * (ARMextensions_set) * bool
  fun ARMinfo_arch (ARMinfo(v1,v2,v3)) = v1

  fun ARMinfo_extensions (ARMinfo(v1,v2,v3)) = v2

  fun ARMinfo_unaligned_support (ARMinfo(v1,v2,v3)) = v3

  fun ARMinfo_arch_fupd f (ARMinfo(v1,v2,v3)) = ARMinfo(f v1,v2,v3)

  fun ARMinfo_extensions_fupd f (ARMinfo(v1,v2,v3)) =
        ARMinfo(v1,f v2,v3)

  fun ARMinfo_unaligned_support_fupd f (ARMinfo(v1,v2,v3)) =
        ARMinfo(v1,v2,f v3)

  datatype SRType
       = SRType_LSL | SRType_LSR | SRType_ASR | SRType_ROR | SRType_RRX
  datatype InstrSet
       = InstrSet_ARM
       | InstrSet_Thumb
       | InstrSet_Jazelle
       | InstrSet_ThumbEE
  datatype Encoding
       = Encoding_ARM
       | Encoding_Thumb
       | Encoding_Thumb2
       | Encoding_ThumbEE
  datatype MemType
       = MemType_Normal | MemType_Device | MemType_StronglyOrdered
  datatype
  MemoryAttributes = MemoryAttributes of MemType * word2 * word2 *
                                         bool * bool
  fun MemoryAttributes_type (MemoryAttributes(v1,v2,v3,v4,v5)) = v1

  fun MemoryAttributes_innerattrs (MemoryAttributes(v1,v2,v3,v4,v5)) =
        v2

  fun MemoryAttributes_outerattrs (MemoryAttributes(v1,v2,v3,v4,v5)) =
        v3

  fun MemoryAttributes_shareable (MemoryAttributes(v1,v2,v3,v4,v5)) = v4

  fun MemoryAttributes_outershareable (MemoryAttributes(v1,v2,v3,v4,v5))
        = v5

  fun MemoryAttributes_type_fupd f (MemoryAttributes(v1,v2,v3,v4,v5)) =
        MemoryAttributes(f v1,v2,v3,v4,v5)

  fun MemoryAttributes_innerattrs_fupd f
        (MemoryAttributes(v1,v2,v3,v4,v5)) =
        MemoryAttributes(v1,f v2,v3,v4,v5)

  fun MemoryAttributes_outerattrs_fupd f
        (MemoryAttributes(v1,v2,v3,v4,v5)) =
        MemoryAttributes(v1,v2,f v3,v4,v5)

  fun MemoryAttributes_shareable_fupd f
        (MemoryAttributes(v1,v2,v3,v4,v5)) =
        MemoryAttributes(v1,v2,v3,f v4,v5)

  fun MemoryAttributes_outershareable_fupd f
        (MemoryAttributes(v1,v2,v3,v4,v5)) =
        MemoryAttributes(v1,v2,v3,v4,f v5)

  datatype
  AddressDescriptor = AddressDescriptor of MemoryAttributes * word32
  fun AddressDescriptor_memattrs (AddressDescriptor(v1,v2)) = v1

  fun AddressDescriptor_paddress (AddressDescriptor(v1,v2)) = v2

  fun AddressDescriptor_memattrs_fupd f (AddressDescriptor(v1,v2)) =
        AddressDescriptor(f v1,v2)

  fun AddressDescriptor_paddress_fupd f (AddressDescriptor(v1,v2)) =
        AddressDescriptor(v1,f v2)

  datatype MBReqDomain
       = MBReqDomain_FullSystem
       | MBReqDomain_OuterShareable
       | MBReqDomain_InnerShareable
       | MBReqDomain_Nonshareable
  datatype MBReqTypes = MBReqTypes_All | MBReqTypes_Writes
  datatype addressing_mode1
       = Mode1_immediate of word12
       | Mode1_register of word5 * word2 * word4
       | Mode1_register_shifted_register of word4 * word2 * word4
  datatype addressing_mode2
       = Mode2_immediate of word12
       | Mode2_register of word5 * word2 * word4
  datatype addressing_mode3
       = Mode3_immediate of word12 | Mode3_register of word2 * word4
  datatype hint
       = Hint_nop
       | Hint_yield
       | Hint_wait_for_event
       | Hint_wait_for_interrupt
       | Hint_send_event
       | Hint_debug of word4
  datatype parallel_add_sub_op1
       = Parallel_normal | Parallel_saturating | Parallel_halving
  datatype parallel_add_sub_op2
       = Parallel_add_16
       | Parallel_add_sub_exchange
       | Parallel_sub_add_exchange
       | Parallel_sub_16
       | Parallel_add_8
       | Parallel_sub_8
  datatype branch_instruction
       = Branch_Target of word24
       | Branch_Exchange of word4
       | Branch_Link_Exchange_Immediate of bool * bool * word24
       | Branch_Link_Exchange_Register of word4
       | Compare_Branch of bool * word6 * word3
       | Table_Branch_Byte of word4 * bool * word4
       | Check_Array of word4 * word4
       | Handler_Branch_Link of bool * word8
       | Handler_Branch_Link_Parameter of word5 * word5
       | Handler_Branch_Parameter of word3 * word5
  datatype data_processing_instruction
       = Data_Processing of word4 * bool * word4 * word4 *
                            addressing_mode1
       | Add_Sub of bool * word4 * word4 * word12
       | Move_Halfword of bool * word4 * word16
       | Multiply of bool * bool * word4 * word4 * word4 * word4
       | Multiply_Subtract of word4 * word4 * word4 * word4
       | Signed_Halfword_Multiply of word2 * bool * bool * word4 *
                                     word4 * word4 * word4
       | Signed_Multiply_Dual of word4 * word4 * word4 * bool * bool *
                                 word4
       | Signed_Multiply_Long_Dual of word4 * word4 * word4 * bool *
                                      bool * word4
       | Signed_Most_Significant_Multiply of word4 * word4 * word4 *
                                             bool * word4
       | Signed_Most_Significant_Multiply_Subtract of word4 * word4 *
                                                      word4 * bool *
                                                      word4
       | Multiply_Long of bool * bool * bool * word4 * word4 * word4 *
                          word4
       | Multiply_Accumulate_Accumulate of word4 * word4 * word4 * word4
       | Saturate of bool * word5 * word4 * word5 * bool * word4
       | Saturate_16 of bool * word4 * word4 * word4
       | Saturating_Add_Subtract of word2 * word4 * word4 * word4
       | Pack_Halfword of word4 * word4 * word5 * bool * word4
       | Extend_Byte of bool * word4 * word4 * word2 * word4
       | Extend_Byte_16 of bool * word4 * word4 * word2 * word4
       | Extend_Halfword of bool * word4 * word4 * word2 * word4
       | Bit_Field_Clear_Insert of word5 * word4 * word5 * word4
       | Count_Leading_Zeroes of word4 * word4
       | Reverse_Bits of word4 * word4
       | Byte_Reverse_Word of word4 * word4
       | Byte_Reverse_Packed_Halfword of word4 * word4
       | Byte_Reverse_Signed_Halfword of word4 * word4
       | Bit_Field_Extract of bool * word5 * word4 * word5 * word4
       | Select_Bytes of word4 * word4 * word4
       | Unsigned_Sum_Absolute_Differences of word4 * word4 * word4 *
                                              word4
       | Parallel_Add_Subtract of bool *
                                  (parallel_add_sub_op1 *
                                   parallel_add_sub_op2) * word4 *
                                  word4 * word4
       | Divide of bool * word4 * word4 * word4
  datatype status_access_instruction
       = Status_to_Register of bool * word4
       | Register_to_Status of bool * word4 * word4
       | Immediate_to_Status of bool * word4 * word12
       | Change_Processor_State of word2 * bool * bool * bool *
                                   word5 option
       | Set_Endianness of bool
  datatype load_store_instruction
       = Load of bool * bool * bool * bool * bool * word4 * word4 *
                 addressing_mode2
       | Store of bool * bool * bool * bool * bool * word4 * word4 *
                  addressing_mode2
       | Load_Halfword of bool * bool * bool * bool * bool * bool *
                          word4 * word4 * addressing_mode3
       | Store_Halfword of bool * bool * bool * bool * word4 * word4 *
                           addressing_mode3
       | Load_Dual of bool * bool * bool * word4 * word4 * word4 *
                      addressing_mode3
       | Store_Dual of bool * bool * bool * word4 * word4 * word4 *
                       addressing_mode3
       | Load_Multiple of bool * bool * bool * bool * word4 * word16
       | Store_Multiple of bool * bool * bool * bool * word4 * word16
       | Load_Exclusive of word4 * word4 * word8
       | Store_Exclusive of word4 * word4 * word4 * word8
       | Load_Exclusive_Doubleword of word4 * word4 * word4
       | Store_Exclusive_Doubleword of word4 * word4 * word4 * word4
       | Load_Exclusive_Halfword of word4 * word4
       | Store_Exclusive_Halfword of word4 * word4 * word4
       | Load_Exclusive_Byte of word4 * word4
       | Store_Exclusive_Byte of word4 * word4 * word4
       | Store_Return_State of bool * bool * bool * word5
       | Return_From_Exception of bool * bool * bool * word4
  datatype miscellaneous_instruction
       = Hint of hint
       | Breakpoint of word16
       | Data_Memory_Barrier of word4
       | Data_Synchronization_Barrier of word4
       | Instruction_Synchronization_Barrier of word4
       | Swap of bool * word4 * word4 * word4
       | Preload_Data of bool * bool * word4 * addressing_mode2
       | Preload_Instruction of bool * word4 * addressing_mode2
       | Supervisor_Call of word24
       | Secure_Monitor_Call of word4
       | Enterx_Leavex of bool
       | Clear_Exclusive
       | If_Then of word4 * word4
  datatype coprocessor_instruction
       = Coprocessor_Load of bool * bool * bool * bool * word4 * word4 *
                             word4 * word8
       | Coprocessor_Store of bool * bool * bool * bool * word4 *
                              word4 * word4 * word8
       | Coprocessor_Data_Processing of word4 * word4 * word4 * word4 *
                                        word3 * word4
       | Coprocessor_Transfer of word3 * bool * word4 * word4 * word4 *
                                 word3 * word4
       | Coprocessor_Transfer_Two of bool * word4 * word4 * word4 *
                                     word4 * word4
  datatype ARMinstruction
       = Unpredictable
       | Undefined
       | Branch of branch_instruction
       | DataProcessing of data_processing_instruction
       | StatusAccess of status_access_instruction
       | LoadStore of load_store_instruction
       | Miscellaneous of miscellaneous_instruction
       | Coprocessor of coprocessor_instruction
  type CPinstruction = word4 * (word4 * coprocessor_instruction)
  type exclusive_triple = word32 * (iiid * num)
  type exclusive_state = (num -> word32 set) * (word32 * num) set
  type 'a ExclusiveM = exclusive_state -> ('a * exclusive_state)
  type 'a CoprocessorM = coproc_state -> ('a * coproc_state)
  datatype
  ExclusiveMonitors = ExclusiveMonitors of (exclusive_state) *
                                           (exclusive_triple ->
                                            unit ExclusiveM) *
                                           (exclusive_triple ->
                                            unit ExclusiveM) *
                                           (exclusive_triple ->
                                            bool ExclusiveM) *
                                           (exclusive_triple ->
                                            bool ExclusiveM) *
                                           (exclusive_triple ->
                                            unit ExclusiveM) *
                                           (num -> unit ExclusiveM)
  fun ExclusiveMonitors_state (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7))
        = v1

  fun ExclusiveMonitors_MarkExclusiveGlobal
        (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7)) = v2

  fun ExclusiveMonitors_MarkExclusiveLocal
        (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7)) = v3

  fun ExclusiveMonitors_IsExclusiveGlobal
        (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7)) = v4

  fun ExclusiveMonitors_IsExclusiveLocal
        (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7)) = v5

  fun ExclusiveMonitors_ClearExclusiveByAddress
        (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7)) = v6

  fun ExclusiveMonitors_ClearExclusiveLocal
        (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7)) = v7

  fun ExclusiveMonitors_state_fupd f
        (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7)) =
        ExclusiveMonitors(f v1,v2,v3,v4,v5,v6,v7)

  fun ExclusiveMonitors_MarkExclusiveGlobal_fupd f
        (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7)) =
        ExclusiveMonitors(v1,f v2,v3,v4,v5,v6,v7)

  fun ExclusiveMonitors_MarkExclusiveLocal_fupd f
        (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7)) =
        ExclusiveMonitors(v1,v2,f v3,v4,v5,v6,v7)

  fun ExclusiveMonitors_IsExclusiveGlobal_fupd f
        (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7)) =
        ExclusiveMonitors(v1,v2,v3,f v4,v5,v6,v7)

  fun ExclusiveMonitors_IsExclusiveLocal_fupd f
        (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7)) =
        ExclusiveMonitors(v1,v2,v3,v4,f v5,v6,v7)

  fun ExclusiveMonitors_ClearExclusiveByAddress_fupd f
        (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7)) =
        ExclusiveMonitors(v1,v2,v3,v4,v5,f v6,v7)

  fun ExclusiveMonitors_ClearExclusiveLocal_fupd f
        (ExclusiveMonitors(v1,v2,v3,v4,v5,v6,v7)) =
        ExclusiveMonitors(v1,v2,v3,v4,v5,v6,f v7)

  datatype
  Coprocessors = Coprocessors of coproc_state *
                                 (CPinstruction -> bool CoprocessorM) *
                                 (CPinstruction -> unit CoprocessorM) *
                                 (CPinstruction -> num CoprocessorM) *
                                 (CPinstruction ->
                                  word32 list -> unit CoprocessorM) *
                                 (CPinstruction ->
                                  word32 list CoprocessorM) *
                                 (CPinstruction ->
                                  word32 -> unit CoprocessorM) *
                                 (CPinstruction ->
                                  word32 CoprocessorM) *
                                 (CPinstruction ->
                                  word32 * word32 ->
                                  unit CoprocessorM) *
                                 (CPinstruction ->
                                  (word32 * word32) CoprocessorM)
  fun Coprocessors_state (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10))
        = v1

  fun Coprocessors_accept (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10))
        = v2

  fun Coprocessors_internal_op
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) = v3

  fun Coprocessors_load_count
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) = v4

  fun Coprocessors_load (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) =
        v5

  fun Coprocessors_store (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10))
        = v6

  fun Coprocessors_send_one
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) = v7

  fun Coprocessors_get_one
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) = v8

  fun Coprocessors_send_two
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) = v9

  fun Coprocessors_get_two
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) = v10

  fun Coprocessors_state_fupd f
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) =
        Coprocessors(f v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)

  fun Coprocessors_accept_fupd f
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) =
        Coprocessors(v1,f v2,v3,v4,v5,v6,v7,v8,v9,v10)

  fun Coprocessors_internal_op_fupd f
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) =
        Coprocessors(v1,v2,f v3,v4,v5,v6,v7,v8,v9,v10)

  fun Coprocessors_load_count_fupd f
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) =
        Coprocessors(v1,v2,v3,f v4,v5,v6,v7,v8,v9,v10)

  fun Coprocessors_load_fupd f
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) =
        Coprocessors(v1,v2,v3,v4,f v5,v6,v7,v8,v9,v10)

  fun Coprocessors_store_fupd f
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) =
        Coprocessors(v1,v2,v3,v4,v5,f v6,v7,v8,v9,v10)

  fun Coprocessors_send_one_fupd f
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) =
        Coprocessors(v1,v2,v3,v4,v5,v6,f v7,v8,v9,v10)

  fun Coprocessors_get_one_fupd f
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) =
        Coprocessors(v1,v2,v3,v4,v5,v6,v7,f v8,v9,v10)

  fun Coprocessors_send_two_fupd f
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) =
        Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,f v9,v10)

  fun Coprocessors_get_two_fupd f
        (Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10)) =
        Coprocessors(v1,v2,v3,v4,v5,v6,v7,v8,v9,f v10)

  datatype
  arm_state = arm_state of (num * RName -> word32) *
                           (num * PSRName -> ARMpsr) * (num -> bool) *
                           (num -> bool) * (word32 -> word8) *
                           access list * ARMinfo * Coprocessors *
                           ExclusiveMonitors
  fun arm_state_registers (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) = v1

  fun arm_state_psrs (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) = v2

  fun arm_state_event_register (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) =
        v3

  fun arm_state_interrupt_wait (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) =
        v4

  fun arm_state_memory (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) = v5

  fun arm_state_accesses (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) = v6

  fun arm_state_information (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) = v7

  fun arm_state_coprocessors (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) =
        v8

  fun arm_state_monitors (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) = v9

  fun arm_state_registers_fupd f (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9))
        = arm_state(f v1,v2,v3,v4,v5,v6,v7,v8,v9)

  fun arm_state_psrs_fupd f (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) =
        arm_state(v1,f v2,v3,v4,v5,v6,v7,v8,v9)

  fun arm_state_event_register_fupd f
        (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) =
        arm_state(v1,v2,f v3,v4,v5,v6,v7,v8,v9)

  fun arm_state_interrupt_wait_fupd f
        (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) =
        arm_state(v1,v2,v3,f v4,v5,v6,v7,v8,v9)

  fun arm_state_memory_fupd f (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) =
        arm_state(v1,v2,v3,v4,f v5,v6,v7,v8,v9)

  fun arm_state_accesses_fupd f (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9))
        = arm_state(v1,v2,v3,v4,v5,f v6,v7,v8,v9)

  fun arm_state_information_fupd f
        (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) =
        arm_state(v1,v2,v3,v4,v5,v6,f v7,v8,v9)

  fun arm_state_coprocessors_fupd f
        (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9)) =
        arm_state(v1,v2,v3,v4,v5,v6,v7,f v8,v9)

  fun arm_state_monitors_fupd f (arm_state(v1,v2,v3,v4,v5,v6,v7,v8,v9))
        = arm_state(v1,v2,v3,v4,v5,v6,v7,v8,f v9)

  datatype ('a,'b)error_option = ValueState of 'a * 'b | Error of string
  type 'a M = arm_state -> ('a, arm_state) error_option
  fun i2w i =
        if intML.int_lt i (intML.fromString"0i") then
          n2w_itself
            (MOD
               (- (fromString "256")
                  (MOD (intML.Num (intML.int_neg i))
                     (fromString "256"))) (fromString "256"),
             (ITSELF (fromString "8")))
        else n2w_itself (intML.Num i,(ITSELF (fromString "8")))

  fun i2bits_itself (i,(N,a)) =
        n2w_itself
          (intML.Num (intML.int_mod i (intML.int_of_num (EXP TWO N))),a)

  fun signed_sat_itself (i,(N,a)) =
        if < (dimindex a) N then pairML.FST (raise Fail "ARB")
        else
          if
            intML.int_gt i
              (intML.int_sub (intML.int_of_num (EXP TWO (- N ONE)))
                 (intML.int_of_num ONE))
          then
          n2w_itself
            (intML.Num
               (intML.int_mod
                  (intML.int_sub (intML.int_of_num (EXP TWO (- N ONE)))
                     (intML.int_of_num ONE))
                  (intML.int_of_num (EXP TWO N))),a)
        else
          if
            intML.int_lt i
              (intML.int_neg (intML.int_of_num (EXP TWO (- N ONE))))
          then
          n2w_itself
            (intML.Num
               (intML.int_mod
                  (intML.int_neg (intML.int_of_num (EXP TWO (- N ONE))))
                  (intML.int_of_num (EXP TWO N))),a)
        else
          n2w_itself
            (intML.Num (intML.int_mod i (intML.int_of_num (EXP TWO N))),
             a)

  fun unsigned_sat_itself (i,(N,a)) =
        if < (dimindex a) N then pairML.FST (raise Fail "ARB")
        else
          if
            intML.int_gt i
              (intML.int_sub (intML.int_of_num (EXP TWO N))
                 (intML.int_of_num ONE))
          then
          n2w_itself (- (EXP TWO N) ONE,a)
        else
          if intML.int_lt i (intML.fromString"0i") then
          n2w_itself (ZERO,a)
        else n2w_itself (intML.Num i,a)

  fun signed_sat_q_itself (i,(N,a)) =
        if < (dimindex a) N then raise Fail "ARB"
        else
          if
            intML.int_gt i
              (intML.int_sub (intML.int_of_num (EXP TWO (- N ONE)))
                 (intML.int_of_num ONE))
          then
          (n2w_itself
             (intML.Num
                (intML.int_mod
                   (intML.int_sub (intML.int_of_num (EXP TWO (- N ONE)))
                      (intML.int_of_num ONE))
                   (intML.int_of_num (EXP TWO N))),a),true)
        else
          if
            intML.int_lt i
              (intML.int_neg (intML.int_of_num (EXP TWO (- N ONE))))
          then
          (n2w_itself
             (intML.Num
                (intML.int_mod
                   (intML.int_neg
                      (intML.int_of_num (EXP TWO (- N ONE))))
                   (intML.int_of_num (EXP TWO N))),a),true)
        else
          (n2w_itself
             (intML.Num
                (intML.int_mod i (intML.int_of_num (EXP TWO N))),a),
           false)

  fun unsigned_sat_q_itself (i,(N,a)) =
        if < (dimindex a) N then raise Fail "ARB"
        else
          if
            intML.int_gt i
              (intML.int_sub (intML.int_of_num (EXP TWO N))
                 (intML.int_of_num ONE))
          then
          (n2w_itself (- (EXP TWO N) ONE,a),true)
        else
          if intML.int_lt i (intML.fromString"0i") then
          (n2w_itself (ZERO,a),true)
        else (n2w_itself (intML.Num i,a),false)

  fun data_processing_thumb2_unpredictable
        (Data_Processing(opc,setflags,n,d,Mode1_immediate(imm12))) =
        (case word_eq opc (n2w_itself (ZERO,(ITSELF (fromString "4"))))
         of true =>
               word_eq d
                 (n2w_itself
                    ((fromString "13"),(ITSELF (fromString "4"))))
               orelse
               (word_eq d
                  (n2w_itself
                     ((fromString "15"),(ITSELF (fromString "4"))))
                andalso not setflags orelse
                (word_eq n
                   (n2w_itself
                      ((fromString "13"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq n
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))))
          | false =>
               (case
                  word_eq opc
                    (n2w_itself (ONE,(ITSELF (fromString "4"))))
                of true =>
                      word_eq d
                        (n2w_itself
                           ((fromString "13"),
                            (ITSELF (fromString "4")))) orelse
                      (word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) andalso
                       not setflags orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "13"),
                              (ITSELF (fromString "4")))) orelse
                        word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4"))))))
                 | false =>
                      (case
                         word_eq opc
                           (n2w_itself (TWO,(ITSELF (fromString "4"))))
                       of true =>
                             if
                               word_eq n
                                 (n2w_itself
                                    ((fromString "13"),
                                     (ITSELF (fromString "4"))))
                             then
                               word_eq d
                                 (n2w_itself
                                    ((fromString "15"),
                                     (ITSELF (fromString "4")))) andalso
                               not setflags
                             else
                               word_eq d
                                 (n2w_itself
                                    ((fromString "13"),
                                     (ITSELF (fromString "4")))) orelse
                               (word_eq d
                                  (n2w_itself
                                     ((fromString "15"),
                                      (ITSELF (fromString "4"))))
                                andalso not setflags orelse
                                word_eq n
                                  (n2w_itself
                                     ((fromString "15"),
                                      (ITSELF (fromString "4")))))
                        | false =>
                             (case
                                word_eq opc
                                  (n2w_itself
                                     ((fromString "4"),
                                      (ITSELF (fromString "4"))))
                              of true =>
                                    if
                                      word_eq n
                                        (n2w_itself
                                           ((fromString "13"),
                                            (ITSELF (fromString "4"))))
                                    then
                                      word_eq d
                                        (n2w_itself
                                           ((fromString "15"),
                                            (ITSELF (fromString "4"))))
                                      andalso not setflags
                                    else
                                      word_eq d
                                        (n2w_itself
                                           ((fromString "13"),
                                            (ITSELF (fromString "4"))))
                                      orelse
                                      (word_eq d
                                         (n2w_itself
                                            ((fromString "15"),
                                             (ITSELF (fromString "4"))))
                                       andalso not setflags orelse
                                       word_eq n
                                         (n2w_itself
                                            ((fromString "15"),
                                             (ITSELF
                                               (fromString "4")))))
                               | false =>
                                    (case
                                       word_eq opc
                                         (n2w_itself
                                            ((fromString "7"),
                                             (ITSELF (fromString "4"))))
                                     of true => true
                                      | false =>
                                           (case
                                              word_eq opc
                                                (n2w_itself
                                                   ((fromString "8"),
                                                    (ITSELF
                                                      (fromString
                                                      "4"))))
                                            of true =>
                                                  word_eq n
                                                    (n2w_itself
                                                       ((fromString
                                                        "13"),
                                                        (ITSELF
                                                          (fromString
                                                          "4")))) orelse
                                                  word_eq n
                                                    (n2w_itself
                                                       ((fromString
                                                        "15"),
                                                        (ITSELF
                                                          (fromString
                                                          "4"))))
                                             | false =>
                                                  (case
                                                     word_eq opc
                                                       (n2w_itself
                                                          ((fromString
                                                           "9"),
                                                           (ITSELF
                                                             (fromString
                                                             "4"))))
                                                   of true =>
                                                         word_eq n
                                                           (n2w_itself
                                                              ((fromString
                                                               "13"),
                                                               (ITSELF
                                                                 (fromString
                                                                 "4"))))
                                                         orelse
                                                         word_eq n
                                                           (n2w_itself
                                                              ((fromString
                                                               "15"),
                                                               (ITSELF
                                                                 (fromString
                                                                 "4"))))
                                                    | false =>
                                                         (case
                                                            word_eq opc
                                                              (n2w_itself
                                                                 ((fromString
                                                                  "10"),
                                                                  (ITSELF
                                                                    (fromString
                                                                    "4"))))
                                                          of true =>
                                                                word_eq
                                                                  n
                                                                  (n2w_itself
                                                                     ((fromString
                                                                      "15"),
                                                                      (ITSELF
                                                                        (fromString
                                                                        "4"))))
                                                           | false =>
                                                                (case
                                                                   word_eq
                                                                     opc
                                                                     (n2w_itself
                                                                        ((fromString
                                                                         "11"),
                                                                         (ITSELF
                                                                           (fromString
                                                                           "4"))))
                                                                 of true =>
                                                                       word_eq
                                                                         n
                                                                         (n2w_itself
                                                                            ((fromString
                                                                             "15"),
                                                                             (ITSELF
                                                                               (fromString
                                                                               "4"))))
                                                                  | false =>
                                                                       (case
                                                                          word_eq
                                                                            opc
                                                                            (n2w_itself
                                                                               ((fromString
                                                                                "13"),
                                                                                (ITSELF
                                                                                  (fromString
                                                                                  "4"))))
                                                                        of true =>
                                                                              word_eq
                                                                                d
                                                                                (n2w_itself
                                                                                   ((fromString
                                                                                    "13"),
                                                                                    (ITSELF
                                                                                      (fromString
                                                                                      "4"))))
                                                                              orelse
                                                                              word_eq
                                                                                d
                                                                                (n2w_itself
                                                                                   ((fromString
                                                                                    "15"),
                                                                                    (ITSELF
                                                                                      (fromString
                                                                                      "4"))))
                                                                         | false =>
                                                                              (case
                                                                                 word_eq
                                                                                   opc
                                                                                   (n2w_itself
                                                                                      ((fromString
                                                                                       "15"),
                                                                                       (ITSELF
                                                                                         (fromString
                                                                                         "4"))))
                                                                               of true =>
                                                                                     (word_eq
                                                                                        d
                                                                                        (n2w_itself
                                                                                           ((fromString
                                                                                            "13"),
                                                                                            (ITSELF
                                                                                              (fromString
                                                                                              "4"))))
                                                                                      orelse
                                                                                      word_eq
                                                                                        d
                                                                                        (n2w_itself
                                                                                           ((fromString
                                                                                            "15"),
                                                                                            (ITSELF
                                                                                              (fromString
                                                                                              "4")))))
                                                                                     orelse
                                                                                     word_eq
                                                                                       n
                                                                                       (n2w_itself
                                                                                          ((fromString
                                                                                           "13"),
                                                                                           (ITSELF
                                                                                             (fromString
                                                                                             "4"))))
                                                                                | false =>
                                                                                     (word_eq
                                                                                        d
                                                                                        (n2w_itself
                                                                                           ((fromString
                                                                                            "13"),
                                                                                            (ITSELF
                                                                                              (fromString
                                                                                              "4"))))
                                                                                      orelse
                                                                                      word_eq
                                                                                        d
                                                                                        (n2w_itself
                                                                                           ((fromString
                                                                                            "15"),
                                                                                            (ITSELF
                                                                                              (fromString
                                                                                              "4")))))
                                                                                     orelse
                                                                                     (word_eq
                                                                                        n
                                                                                        (n2w_itself
                                                                                           ((fromString
                                                                                            "13"),
                                                                                            (ITSELF
                                                                                              (fromString
                                                                                              "4"))))
                                                                                      orelse
                                                                                      word_eq
                                                                                        n
                                                                                        (n2w_itself
                                                                                           ((fromString
                                                                                            "15"),
                                                                                            (ITSELF
                                                                                              (fromString
                                                                                              "4"))))))))))))))))
    | data_processing_thumb2_unpredictable
        (Data_Processing(opc,setflags,n,d,Mode1_register(imm5,typ,m))) =
        (case word_eq opc (n2w_itself (ZERO,(ITSELF (fromString "4"))))
         of true =>
               word_eq d
                 (n2w_itself
                    ((fromString "13"),(ITSELF (fromString "4"))))
               orelse
               (word_eq d
                  (n2w_itself
                     ((fromString "15"),(ITSELF (fromString "4"))))
                andalso not setflags orelse
                (word_eq n
                   (n2w_itself
                      ((fromString "13"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq n
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))))
          | false =>
               (case
                  word_eq opc
                    (n2w_itself (ONE,(ITSELF (fromString "4"))))
                of true =>
                      word_eq d
                        (n2w_itself
                           ((fromString "13"),
                            (ITSELF (fromString "4")))) orelse
                      (word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) andalso
                       not setflags orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "13"),
                              (ITSELF (fromString "4")))) orelse
                        word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4"))))))
                 | false =>
                      (case
                         word_eq opc
                           (n2w_itself (TWO,(ITSELF (fromString "4"))))
                       of true =>
                             if
                               word_eq n
                                 (n2w_itself
                                    ((fromString "13"),
                                     (ITSELF (fromString "4"))))
                             then
                               word_eq d
                                 (n2w_itself
                                    ((fromString "13"),
                                     (ITSELF (fromString "4")))) andalso
                               (not
                                  (word_eq typ
                                     (n2w_itself (ZERO,(ITSELF TWO))))
                                orelse > (w2n imm5) (fromString "3"))
                               orelse
                               (word_eq d
                                  (n2w_itself
                                     ((fromString "15"),
                                      (ITSELF (fromString "4")))) orelse
                                (word_eq m
                                   (n2w_itself
                                      ((fromString "13"),
                                       (ITSELF (fromString "4"))))
                                 orelse
                                 word_eq m
                                   (n2w_itself
                                      ((fromString "15"),
                                       (ITSELF (fromString "4"))))))
                             else
                               word_eq d
                                 (n2w_itself
                                    ((fromString "13"),
                                     (ITSELF (fromString "4")))) orelse
                               (word_eq d
                                  (n2w_itself
                                     ((fromString "15"),
                                      (ITSELF (fromString "4"))))
                                andalso not setflags orelse
                                (word_eq n
                                   (n2w_itself
                                      ((fromString "15"),
                                       (ITSELF (fromString "4"))))
                                 orelse
                                 (word_eq m
                                    (n2w_itself
                                       ((fromString "13"),
                                        (ITSELF (fromString "4"))))
                                  orelse
                                  word_eq m
                                    (n2w_itself
                                       ((fromString "15"),
                                        (ITSELF (fromString "4")))))))
                        | false =>
                             (case
                                word_eq opc
                                  (n2w_itself
                                     ((fromString "4"),
                                      (ITSELF (fromString "4"))))
                              of true =>
                                    if
                                      word_eq n
                                        (n2w_itself
                                           ((fromString "13"),
                                            (ITSELF (fromString "4"))))
                                    then
                                      word_eq d
                                        (n2w_itself
                                           ((fromString "13"),
                                            (ITSELF (fromString "4"))))
                                      andalso
                                      (not
                                         (word_eq typ
                                            (n2w_itself
                                               (ZERO,(ITSELF TWO))))
                                       orelse
                                       > (w2n imm5) (fromString "3"))
                                      orelse
                                      (word_eq d
                                         (n2w_itself
                                            ((fromString "15"),
                                             (ITSELF (fromString "4"))))
                                       orelse
                                       (word_eq m
                                          (n2w_itself
                                             ((fromString "13"),
                                              (ITSELF
                                                (fromString "4"))))
                                        orelse
                                        word_eq m
                                          (n2w_itself
                                             ((fromString "15"),
                                              (ITSELF
                                                (fromString "4"))))))
                                    else
                                      word_eq d
                                        (n2w_itself
                                           ((fromString "13"),
                                            (ITSELF (fromString "4"))))
                                      orelse
                                      (word_eq d
                                         (n2w_itself
                                            ((fromString "15"),
                                             (ITSELF (fromString "4"))))
                                       andalso not setflags orelse
                                       (word_eq n
                                          (n2w_itself
                                             ((fromString "15"),
                                              (ITSELF
                                                (fromString "4"))))
                                        orelse
                                        (word_eq m
                                           (n2w_itself
                                              ((fromString "13"),
                                               (ITSELF
                                                 (fromString "4"))))
                                         orelse
                                         word_eq m
                                           (n2w_itself
                                              ((fromString "15"),
                                               (ITSELF
                                                 (fromString "4")))))))
                               | false =>
                                    (case
                                       word_eq opc
                                         (n2w_itself
                                            ((fromString "7"),
                                             (ITSELF (fromString "4"))))
                                     of true => true
                                      | false =>
                                           (case
                                              word_eq opc
                                                (n2w_itself
                                                   ((fromString "8"),
                                                    (ITSELF
                                                      (fromString
                                                      "4"))))
                                            of true =>
                                                  (word_eq n
                                                     (n2w_itself
                                                        ((fromString
                                                         "13"),
                                                         (ITSELF
                                                           (fromString
                                                           "4"))))
                                                   orelse
                                                   word_eq n
                                                     (n2w_itself
                                                        ((fromString
                                                         "15"),
                                                         (ITSELF
                                                           (fromString
                                                           "4")))))
                                                  orelse
                                                  (word_eq m
                                                     (n2w_itself
                                                        ((fromString
                                                         "13"),
                                                         (ITSELF
                                                           (fromString
                                                           "4"))))
                                                   orelse
                                                   word_eq m
                                                     (n2w_itself
                                                        ((fromString
                                                         "15"),
                                                         (ITSELF
                                                           (fromString
                                                           "4")))))
                                             | false =>
                                                  (case
                                                     word_eq opc
                                                       (n2w_itself
                                                          ((fromString
                                                           "9"),
                                                           (ITSELF
                                                             (fromString
                                                             "4"))))
                                                   of true =>
                                                         (word_eq n
                                                            (n2w_itself
                                                               ((fromString
                                                                "13"),
                                                                (ITSELF
                                                                  (fromString
                                                                  "4"))))
                                                          orelse
                                                          word_eq n
                                                            (n2w_itself
                                                               ((fromString
                                                                "15"),
                                                                (ITSELF
                                                                  (fromString
                                                                  "4")))))
                                                         orelse
                                                         (word_eq m
                                                            (n2w_itself
                                                               ((fromString
                                                                "13"),
                                                                (ITSELF
                                                                  (fromString
                                                                  "4"))))
                                                          orelse
                                                          word_eq m
                                                            (n2w_itself
                                                               ((fromString
                                                                "15"),
                                                                (ITSELF
                                                                  (fromString
                                                                  "4")))))
                                                    | false =>
                                                         (case
                                                            word_eq opc
                                                              (n2w_itself
                                                                 ((fromString
                                                                  "10"),
                                                                  (ITSELF
                                                                    (fromString
                                                                    "4"))))
                                                          of true =>
                                                                word_eq
                                                                  n
                                                                  (n2w_itself
                                                                     ((fromString
                                                                      "15"),
                                                                      (ITSELF
                                                                        (fromString
                                                                        "4"))))
                                                                orelse
                                                                (word_eq
                                                                   m
                                                                   (n2w_itself
                                                                      ((fromString
                                                                       "13"),
                                                                       (ITSELF
                                                                         (fromString
                                                                         "4"))))
                                                                 orelse
                                                                 word_eq
                                                                   m
                                                                   (n2w_itself
                                                                      ((fromString
                                                                       "15"),
                                                                       (ITSELF
                                                                         (fromString
                                                                         "4")))))
                                                           | false =>
                                                                (case
                                                                   word_eq
                                                                     opc
                                                                     (n2w_itself
                                                                        ((fromString
                                                                         "11"),
                                                                         (ITSELF
                                                                           (fromString
                                                                           "4"))))
                                                                 of true =>
                                                                       word_eq
                                                                         n
                                                                         (n2w_itself
                                                                            ((fromString
                                                                             "15"),
                                                                             (ITSELF
                                                                               (fromString
                                                                               "4"))))
                                                                       orelse
                                                                       (word_eq
                                                                          m
                                                                          (n2w_itself
                                                                             ((fromString
                                                                              "13"),
                                                                              (ITSELF
                                                                                (fromString
                                                                                "4"))))
                                                                        orelse
                                                                        word_eq
                                                                          m
                                                                          (n2w_itself
                                                                             ((fromString
                                                                              "15"),
                                                                              (ITSELF
                                                                                (fromString
                                                                                "4")))))
                                                                  | false =>
                                                                       (case
                                                                          word_eq
                                                                            opc
                                                                            (n2w_itself
                                                                               ((fromString
                                                                                "13"),
                                                                                (ITSELF
                                                                                  (fromString
                                                                                  "4"))))
                                                                        of true =>
                                                                              if
                                                                                setflags
                                                                              then
                                                                                (word_eq
                                                                                   d
                                                                                   (n2w_itself
                                                                                      ((fromString
                                                                                       "13"),
                                                                                       (ITSELF
                                                                                         (fromString
                                                                                         "4"))))
                                                                                 orelse
                                                                                 word_eq
                                                                                   d
                                                                                   (n2w_itself
                                                                                      ((fromString
                                                                                       "15"),
                                                                                       (ITSELF
                                                                                         (fromString
                                                                                         "4")))))
                                                                                orelse
                                                                                (word_eq
                                                                                   m
                                                                                   (n2w_itself
                                                                                      ((fromString
                                                                                       "13"),
                                                                                       (ITSELF
                                                                                         (fromString
                                                                                         "4"))))
                                                                                 orelse
                                                                                 word_eq
                                                                                   m
                                                                                   (n2w_itself
                                                                                      ((fromString
                                                                                       "15"),
                                                                                       (ITSELF
                                                                                         (fromString
                                                                                         "4")))))
                                                                              else
                                                                                word_eq
                                                                                  d
                                                                                  (n2w_itself
                                                                                     ((fromString
                                                                                      "15"),
                                                                                      (ITSELF
                                                                                        (fromString
                                                                                        "4"))))
                                                                                orelse
                                                                                (word_eq
                                                                                   m
                                                                                   (n2w_itself
                                                                                      ((fromString
                                                                                       "15"),
                                                                                       (ITSELF
                                                                                         (fromString
                                                                                         "4"))))
                                                                                 orelse
                                                                                 word_eq
                                                                                   d
                                                                                   (n2w_itself
                                                                                      ((fromString
                                                                                       "13"),
                                                                                       (ITSELF
                                                                                         (fromString
                                                                                         "4"))))
                                                                                 andalso
                                                                                 word_eq
                                                                                   m
                                                                                   (n2w_itself
                                                                                      ((fromString
                                                                                       "13"),
                                                                                       (ITSELF
                                                                                         (fromString
                                                                                         "4")))))
                                                                         | false =>
                                                                              (case
                                                                                 word_eq
                                                                                   opc
                                                                                   (n2w_itself
                                                                                      ((fromString
                                                                                       "15"),
                                                                                       (ITSELF
                                                                                         (fromString
                                                                                         "4"))))
                                                                               of true =>
                                                                                     (word_eq
                                                                                        d
                                                                                        (n2w_itself
                                                                                           ((fromString
                                                                                            "13"),
                                                                                            (ITSELF
                                                                                              (fromString
                                                                                              "4"))))
                                                                                      orelse
                                                                                      word_eq
                                                                                        d
                                                                                        (n2w_itself
                                                                                           ((fromString
                                                                                            "15"),
                                                                                            (ITSELF
                                                                                              (fromString
                                                                                              "4")))))
                                                                                     orelse
                                                                                     (word_eq
                                                                                        n
                                                                                        (n2w_itself
                                                                                           ((fromString
                                                                                            "13"),
                                                                                            (ITSELF
                                                                                              (fromString
                                                                                              "4"))))
                                                                                      orelse
                                                                                      (word_eq
                                                                                         m
                                                                                         (n2w_itself
                                                                                            ((fromString
                                                                                             "13"),
                                                                                             (ITSELF
                                                                                               (fromString
                                                                                               "4"))))
                                                                                       orelse
                                                                                       word_eq
                                                                                         m
                                                                                         (n2w_itself
                                                                                            ((fromString
                                                                                             "15"),
                                                                                             (ITSELF
                                                                                               (fromString
                                                                                               "4"))))))
                                                                                | false =>
                                                                                     (word_eq
                                                                                        d
                                                                                        (n2w_itself
                                                                                           ((fromString
                                                                                            "13"),
                                                                                            (ITSELF
                                                                                              (fromString
                                                                                              "4"))))
                                                                                      orelse
                                                                                      word_eq
                                                                                        d
                                                                                        (n2w_itself
                                                                                           ((fromString
                                                                                            "15"),
                                                                                            (ITSELF
                                                                                              (fromString
                                                                                              "4")))))
                                                                                     orelse
                                                                                     ((word_eq
                                                                                         n
                                                                                         (n2w_itself
                                                                                            ((fromString
                                                                                             "13"),
                                                                                             (ITSELF
                                                                                               (fromString
                                                                                               "4"))))
                                                                                       orelse
                                                                                       word_eq
                                                                                         n
                                                                                         (n2w_itself
                                                                                            ((fromString
                                                                                             "15"),
                                                                                             (ITSELF
                                                                                               (fromString
                                                                                               "4")))))
                                                                                      orelse
                                                                                      (word_eq
                                                                                         m
                                                                                         (n2w_itself
                                                                                            ((fromString
                                                                                             "13"),
                                                                                             (ITSELF
                                                                                               (fromString
                                                                                               "4"))))
                                                                                       orelse
                                                                                       word_eq
                                                                                         m
                                                                                         (n2w_itself
                                                                                            ((fromString
                                                                                             "15"),
                                                                                             (ITSELF
                                                                                               (fromString
                                                                                               "4")))))))))))))))))
    | data_processing_thumb2_unpredictable
        (Data_Processing(opc,setflags,n,d,
                         Mode1_register_shifted_register(s,typ,m))) =
        not
          (word_eq opc
             (n2w_itself ((fromString "13"),(ITSELF (fromString "4")))))
        orelse
        ((word_eq d
            (n2w_itself ((fromString "13"),(ITSELF (fromString "4"))))
          orelse
          word_eq d
            (n2w_itself ((fromString "15"),(ITSELF (fromString "4")))))
         orelse
         ((word_eq s
             (n2w_itself ((fromString "13"),(ITSELF (fromString "4"))))
           orelse
           word_eq s
             (n2w_itself ((fromString "15"),(ITSELF (fromString "4")))))
          orelse
          (word_eq m
             (n2w_itself ((fromString "13"),(ITSELF (fromString "4"))))
           orelse
           word_eq m
             (n2w_itself
                ((fromString "15"),(ITSELF (fromString "4")))))))

  fun ==> A B = not A orelse B

  fun align (n2w_itself (m,a),n) =
        n2w_itself ( *  n (DIV (w2n (n2w_itself (m,a))) n),a)

  fun aligned (w,n) = word_eq w (align (w,n))

  fun count_leading_zeroes (n2w_itself (m,a)) =
        if word_eq (n2w_itself (m,a)) (n2w_itself (ZERO,a)) then
          dimindex a
        else - (- (dimindex a) ONE) (LOG2 (w2n (n2w_itself (m,a))))

  fun lowest_set_bit (n2w_itself (m,a)) =
        if word_eq (n2w_itself (m,a)) (n2w_itself (ZERO,a)) then
          dimindex a else LOWEST_SET_BIT (w2n (n2w_itself (m,a)))

  fun SUM n f =
        if n = ZERO then ZERO else + (SUM (- n ONE) f) (f (- n ONE))

  fun bit_count_upto n w =
        SUM n (fn i => if word_index w i then ONE else ZERO)

  fun bit_count (n2w_itself (m,a)) =
        bit_count_upto (dimindex a) (n2w_itself (m,a))

  fun zero_extend32 [b] = w2w_itself (ITSELF (fromString "32")) b
    | zero_extend32 [b1,b2] =
        w2w_itself (ITSELF (fromString "32"))
          (word_concat_itself (ITSELF (fromString "16")) b2 b1)

  fun sign_extend32 [b] = sw2sw_itself (ITSELF (fromString "32")) b
    | sign_extend32 [b1,b2] =
        sw2sw_itself (ITSELF (fromString "32"))
          (word_concat_itself (ITSELF (fromString "16")) b2 b1)

  fun word16 [b1,b2] =
        word_concat_itself (ITSELF (fromString "16")) b2 b1

  fun word32 [b1,b2,b3,b4] =
        word_concat_itself (ITSELF (fromString "32")) b4
          (word_concat_itself (ITSELF (fromString "24")) b3
             (word_concat_itself (ITSELF (fromString "16")) b2 b1))

  fun word64 [b1,b2,b3,b4,b5,b6,b7,b8] =
        word_concat_itself (ITSELF (fromString "64"))
          (word32 [b5,b6,b7,b8]) (word32 [b1,b2,b3,b4])

  fun bytes (w,n) =
        if n = ONE then [w2w_itself (ITSELF (fromString "8")) w]
        else
          if n = TWO then
          [word_extract_itself (ITSELF (fromString "8"))
             (fromString "7") ZERO w,
           word_extract_itself (ITSELF (fromString "8"))
             (fromString "15") (fromString "8") w]
        else
          if n = (fromString "4") then
          [word_extract_itself (ITSELF (fromString "8"))
             (fromString "7") ZERO w,
           word_extract_itself (ITSELF (fromString "8"))
             (fromString "15") (fromString "8") w,
           word_extract_itself (ITSELF (fromString "8"))
             (fromString "23") (fromString "16") w,
           word_extract_itself (ITSELF (fromString "8"))
             (fromString "31") (fromString "24") w]
        else raise (Fail "bytes: n not 1, 2 or 4")

  fun LSL_C (n2w_itself (m,a),shift) =
        if shift = ZERO then raise Fail "ARB"
        else
          let val extended_x =
                   *  (w2n (n2w_itself (m,a))) (EXP TWO shift)
          in
             (word_lsl (n2w_itself (m,a)) shift,
              BIT (dimindex a) extended_x)
          end

  fun LSR_C (x,shift) =
        if shift = ZERO then raise Fail "ARB"
        else (word_lsr x shift,BIT (- shift ONE) (w2n x))

  fun ASR_C (n2w_itself (m,a),shift) =
        if shift = ZERO then raise Fail "ARB"
        else
          (word_asr (n2w_itself (m,a)) shift,
           word_index (n2w_itself (m,a))
             (MIN (- (dimindex a) ONE) (- shift ONE)))

  fun ROR_C (n2w_itself (m,a),shift) =
        if shift = ZERO then raise Fail "ARB"
        else
          let val result = word_ror (n2w_itself (m,a)) shift
          in
             (result,word_index result (- (dimindex a) ONE))
          end

  fun RRX_C (x,carry_in) =
        let val (carry_out,result) = word_rrx (carry_in,x)
        in
           (result,carry_out)
        end

  fun LSL (x,shift) = word_lsl x shift

  fun LSR (x,shift) = word_lsr x shift

  fun ASR (x,shift) = word_asr x shift

  fun ROR (x,shift) = word_ror x shift

  fun RRX (x,carry_in) = pairML.SND (word_rrx (carry_in,x))

  fun ITAdvance IT =
        if
          word_eq
            (word_extract_itself (ITSELF (fromString "3")) TWO ZERO IT)
            (n2w_itself (ZERO,(ITSELF (fromString "3"))))
        then n2w_itself (ZERO,(ITSELF (fromString "8")))
        else
          word_or (word_slice (fromString "7") (fromString "5") IT)
            (w2w_itself (ITSELF (fromString "8"))
               (word_lsl
                  (word_extract_itself (ITSELF (fromString "5"))
                     (fromString "4") ZERO IT) ONE))

  fun decode_psr psr =
        ARMpsr(word_index psr (fromString "31"),
               word_index psr (fromString "30"),
               word_index psr (fromString "29"),
               word_index psr (fromString "28"),
               word_index psr (fromString "27"),
               word_concat_itself (ITSELF (fromString "8"))
                 (word_extract_itself (ITSELF (fromString "6"))
                    (fromString "15") (fromString "10") psr)
                 (word_extract_itself (ITSELF TWO) (fromString "26")
                    (fromString "25") psr),
               word_index psr (fromString "24"),
               word_extract_itself (ITSELF (fromString "4"))
                 (fromString "23") (fromString "20") psr,
               word_extract_itself (ITSELF (fromString "4"))
                 (fromString "19") (fromString "16") psr,
               word_index psr (fromString "9"),
               word_index psr (fromString "8"),
               word_index psr (fromString "7"),
               word_index psr (fromString "6"),
               word_index psr (fromString "5"),
               word_extract_itself (ITSELF (fromString "5"))
                 (fromString "4") ZERO psr)

  fun encode_psr psr =
        word_modify (fn i => fn b => if < i (fromString "5") then
            word_index (ARMpsr_M psr) i
          else
            if i = (fromString "5") then
            ARMpsr_T psr
          else
            if i = (fromString "6") then
            ARMpsr_F psr
          else
            if i = (fromString "7") then
            ARMpsr_I psr
          else
            if i = (fromString "8") then
            ARMpsr_A psr
          else
            if i = (fromString "9") then
            ARMpsr_E psr
          else
            if < i (fromString "16") then
            word_index (ARMpsr_IT psr) (- i (fromString "8"))
          else
            if < i (fromString "20") then
            word_index (ARMpsr_GE psr) (- i (fromString "16"))
          else
            if < i (fromString "24") then
            word_index (ARMpsr_Reserved psr) (- i (fromString "20"))
          else
            if i = (fromString "24") then
            ARMpsr_J psr
          else
            if < i (fromString "27") then
            word_index (ARMpsr_IT psr) (- i (fromString "25"))
          else
            if i = (fromString "27") then
            ARMpsr_Q psr
          else
            if i = (fromString "28") then
            ARMpsr_V psr
          else
            if i = (fromString "29") then
            ARMpsr_C psr
          else
            if i = (fromString "30") then
            ARMpsr_Z psr
          else ARMpsr_N psr)
          (n2w_itself (ZERO,(ITSELF (fromString "32"))))

  fun version_number ARMv4 = (fromString "4")
    | version_number ARMv4T = (fromString "4")
    | version_number ARMv5T = (fromString "5")
    | version_number ARMv5TE = (fromString "5")
    | version_number ARMv6 = (fromString "6")
    | version_number ARMv6K = (fromString "6")
    | version_number ARMv6T2 = (fromString "6")
    | version_number ARMv7_A = (fromString "7")
    | version_number ARMv7_R = (fromString "7")

  fun is_mode1_immediate x =
        case x
         of Mode1_immediate(imm12) => true
          | Mode1_register(v8,v9,v10) => false
          | Mode1_register_shifted_register(v11,v12,v13) => false

  fun is_mode2_immediate x =
        case x
         of Mode2_immediate(imm12) => true
          | Mode2_register(v5,v6,v7) => false

  fun is_mode3_immediate x =
        case x
         of Mode3_immediate(imm8) => true
          | Mode3_register(v4,v5) => false

  fun constE x = fn y => (x,y)

  fun seqE s f = fn y => let val (v,x) = s y in f v x end

  fun constC x = fn y => (x,y)

  fun seqC s f = fn y => let val (v,x) = s y in f v x end

  fun constT x = fn y => ValueState(x,y)

  fun errorT e = combinML.K (Error(e))

  fun seqT s f =
        fn y =>
        case s y of ValueState(z,t) => f z t | Error(e) => Error(e)

  fun parT s t = seqT s (fn x => seqT t (fn y => constT (x,y)))

  fun lockT s = s

  val condT = fn b => fn s => if b then s else constT ()

  fun forT l h f =
        if <= l h then
          seqT (f l) (fn r =>
            seqT (forT (+ l ONE) h f) (fn l => constT (r::l)))
        else constT []

  fun readT f = fn y => ValueState(f y,y)

  fun writeT f = fn y => ValueState((),f y)

  fun read_info ii = readT arm_state_information

  fun read_arch ii =
        readT (combinML.o ARMinfo_arch arm_state_information)

  fun read_extensions ii =
        readT (combinML.o ARMinfo_extensions arm_state_information)

  fun read__reg ii rname =
        seqT
           (writeT (arm_state_accesses_fupd (fn l => REG_READ(rname)::l)))
           (fn u => readT (fn s => arm_state_registers s (iiid_proc ii,rname)))

  fun write__reg ii rname value =
        seqT
           (writeT (arm_state_accesses_fupd (fn l => REG_WRITE(rname)::l)))
           (fn u =>
              writeT
                (arm_state_registers_fupd
                   (combinML.UPDATE (iiid_proc ii,rname) value)))

  fun read__psr ii i =
        seqT
           (writeT (arm_state_accesses_fupd (fn l => PSR_READ(i)::l)))
           (fn u => readT (fn s => arm_state_psrs s (iiid_proc ii,i)))

  fun write__psr ii psrname value =
        seqT
           (writeT (arm_state_accesses_fupd (fn l => PSR_WRITE(psrname)::l)))
           (fn u =>
                writeT
                   (arm_state_psrs_fupd
                      (combinML.UPDATE (iiid_proc ii,psrname) value)))

  fun read_scr ii =
        readT (fn s =>
          CP15reg_SCR
            (coproc_state_cp15
               (Coprocessors_state (arm_state_coprocessors s))))

  fun write_scr ii value =
        writeT
          (arm_state_coprocessors_fupd
             (Coprocessors_state_fupd
                (coproc_state_cp15_fupd (fn cp15 =>
                   CP15reg_SCR_fupd (combinML.K value) cp15))))

  fun read_nsacr ii =
        readT (fn s =>
          CP15reg_NSACR
            (coproc_state_cp15
               (Coprocessors_state (arm_state_coprocessors s))))

  fun read_teehbr ii =
        readT (fn s =>
          CP14reg_TEEHBR
            (coproc_state_cp14
               (Coprocessors_state (arm_state_coprocessors s))))

  fun read_sctlr ii =
        readT (fn s =>
          CP15reg_SCTLR
            (coproc_state_cp15
               (Coprocessors_state (arm_state_coprocessors s))))

  fun read_cpsr ii = read__psr ii CPSR

  fun write_cpsr ii value = write__psr ii CPSR value

  fun read_isetstate ii =
        seqT (read_cpsr ii) (fn cpsr =>
          constT
            (word_modify (fn i => fn b =>
               (i = ONE) andalso ARMpsr_J cpsr orelse
               (i = ZERO) andalso ARMpsr_T cpsr)
               (n2w_itself (ZERO,(ITSELF TWO)))))

  fun write_isetstate ii isetstate =
        seqT (read_cpsr ii) (fn cpsr =>
          write_cpsr ii
            (ARMpsr_J_fupd (combinML.K (word_index isetstate ONE))
               (ARMpsr_T_fupd (combinML.K (word_index isetstate ZERO))
                  cpsr)))

  fun have_security_ext x x' =
        seqT (read_info x) (fn info =>
          constT
            (((ARMinfo_arch info = ARMv6K) orelse
              (ARMinfo_arch info = ARMv7_A)) andalso
             IN Extension_Security (ARMinfo_extensions info))) x'

  fun have_jazelle x x' =
        seqT (read_info x) (fn info =>
          constT
            (> (version_number (ARMinfo_arch info)) (fromString "6")
             orelse
             (ARMinfo_arch info = ARMv5TE) andalso
             IN Extension_Jazelle (ARMinfo_extensions info))) x'

  fun have_thumbEE x x' =
        seqT (read_info x) (fn info =>
          constT
            ((ARMinfo_arch info = ARMv7_A) orelse
             (ARMinfo_arch info = ARMv7_R) andalso
             IN Extension_ThumbEE (ARMinfo_extensions info))) x'

  fun bad_mode ii mode =
        if
          word_eq mode
            (n2w_itself ((fromString "22"),(ITSELF (fromString "5"))))
        then
          seqT (have_security_ext ii) (fn have_security_ext =>
            constT (not have_security_ext))
        else
          constT
            (not
               (IN mode
                  (INSERT
                     (n2w_itself
                        ((fromString "16"),(ITSELF (fromString "5"))),
                      INSERT
                        (n2w_itself
                           ((fromString "17"),
                            (ITSELF (fromString "5"))),
                         INSERT
                           (n2w_itself
                              ((fromString "18"),
                               (ITSELF (fromString "5"))),
                            INSERT
                              (n2w_itself
                                 ((fromString "19"),
                                  (ITSELF (fromString "5"))),
                               INSERT
                                 (n2w_itself
                                    ((fromString "23"),
                                     (ITSELF (fromString "5"))),
                                  INSERT
                                    (n2w_itself
                                       ((fromString "27"),
                                        (ITSELF (fromString "5"))),
                                     INSERT
                                       (n2w_itself
                                          ((fromString "31"),
                                           (ITSELF (fromString "5"))),
                                        EMPTY))))))))))

  fun read_spsr ii =
        seqT (read_cpsr ii) (fn cpsr =>
          seqT (bad_mode ii (ARMpsr_M cpsr)) (fn bad_mode =>
            if bad_mode then errorT "read_spsr: unpredictable"
            else
              case
                word_eq (ARMpsr_M cpsr)
                  (n2w_itself
                     ((fromString "17"),(ITSELF (fromString "5"))))
               of true => read__psr ii SPSR_fiq
                | false =>
                     (case
                        word_eq (ARMpsr_M cpsr)
                          (n2w_itself
                             ((fromString "18"),
                              (ITSELF (fromString "5"))))
                      of true => read__psr ii SPSR_irq
                       | false =>
                            (case
                               word_eq (ARMpsr_M cpsr)
                                 (n2w_itself
                                    ((fromString "19"),
                                     (ITSELF (fromString "5"))))
                             of true => read__psr ii SPSR_svc
                              | false =>
                                   (case
                                      word_eq (ARMpsr_M cpsr)
                                        (n2w_itself
                                           ((fromString "22"),
                                            (ITSELF (fromString "5"))))
                                    of true => read__psr ii SPSR_mon
                                     | false =>
                                          (case
                                             word_eq (ARMpsr_M cpsr)
                                               (n2w_itself
                                                  ((fromString "23"),
                                                   (ITSELF
                                                     (fromString "5"))))
                                           of true =>
                                                 read__psr ii SPSR_abt
                                            | false =>
                                                 (case
                                                    word_eq
                                                      (ARMpsr_M cpsr)
                                                      (n2w_itself
                                                         ((fromString
                                                          "27"),
                                                          (ITSELF
                                                            (fromString
                                                            "5"))))
                                                  of true =>
                                                        read__psr ii
                                                          SPSR_und
                                                   | false =>
                                                        errorT
                                                          "read_spsr: unpredictable")))))))

  fun write_spsr ii value =
        seqT (read_cpsr ii) (fn cpsr =>
          seqT (bad_mode ii (ARMpsr_M cpsr)) (fn bad_mode =>
            if bad_mode then errorT "write_spsr: unpredictable"
            else
              case
                word_eq (ARMpsr_M cpsr)
                  (n2w_itself
                     ((fromString "17"),(ITSELF (fromString "5"))))
               of true => write__psr ii SPSR_fiq value
                | false =>
                     (case
                        word_eq (ARMpsr_M cpsr)
                          (n2w_itself
                             ((fromString "18"),
                              (ITSELF (fromString "5"))))
                      of true => write__psr ii SPSR_irq value
                       | false =>
                            (case
                               word_eq (ARMpsr_M cpsr)
                                 (n2w_itself
                                    ((fromString "19"),
                                     (ITSELF (fromString "5"))))
                             of true => write__psr ii SPSR_svc value
                              | false =>
                                   (case
                                      word_eq (ARMpsr_M cpsr)
                                        (n2w_itself
                                           ((fromString "22"),
                                            (ITSELF (fromString "5"))))
                                    of true =>
                                          write__psr ii SPSR_mon value
                                     | false =>
                                          (case
                                             word_eq (ARMpsr_M cpsr)
                                               (n2w_itself
                                                  ((fromString "23"),
                                                   (ITSELF
                                                     (fromString "5"))))
                                           of true =>
                                                 write__psr ii SPSR_abt
                                                   value
                                            | false =>
                                                 (case
                                                    word_eq
                                                      (ARMpsr_M cpsr)
                                                      (n2w_itself
                                                         ((fromString
                                                          "27"),
                                                          (ITSELF
                                                            (fromString
                                                            "5"))))
                                                  of true =>
                                                        write__psr ii
                                                          SPSR_und value
                                                   | false =>
                                                        errorT
                                                          "write_spsr: unpredictable")))))))

  fun current_mode_is_priviledged ii =
        seqT (read_cpsr ii) (fn cpsr =>
          seqT (bad_mode ii (ARMpsr_M cpsr)) (fn bad_mode =>
            if bad_mode then
              errorT "current_mode_is_priviledged: unpredictable"
            else
              constT
                (not
                   (word_eq (ARMpsr_M cpsr)
                      (n2w_itself
                         ((fromString "16"),
                          (ITSELF (fromString "5"))))))))

  fun current_mode_is_user_or_system ii =
        seqT (read_cpsr ii) (fn cpsr =>
          seqT (bad_mode ii (ARMpsr_M cpsr)) (fn bad_mode =>
            if bad_mode then
              errorT "current_mode_is_user_or_system: unpredictable"
            else
              constT
                (IN (ARMpsr_M cpsr)
                   (INSERT
                      (n2w_itself
                         ((fromString "16"),(ITSELF (fromString "5"))),
                       INSERT
                         (n2w_itself
                            ((fromString "31"),
                             (ITSELF (fromString "5"))),EMPTY))))))

  fun is_secure ii =
        seqT
          (parT (have_security_ext ii)
             (parT (read_scr ii) (read_cpsr ii))) (fn
          (have_security_ext,(scr,cpsr)) =>
          constT
            (not have_security_ext orelse
             (not (CP15scr_NS scr) orelse
              word_eq (ARMpsr_M cpsr)
                (n2w_itself
                   ((fromString "22"),(ITSELF (fromString "5")))))))

  fun read_vbar ii =
        readT (fn s =>
          CP15reg_VBAR
            (coproc_state_cp15
               (Coprocessors_state (arm_state_coprocessors s))))

  fun read_mvbar ii =
        readT (fn s =>
          CP15reg_MVBAR
            (coproc_state_cp15
               (Coprocessors_state (arm_state_coprocessors s))))

  fun current_instr_set ii =
        seqT (read_isetstate ii) (fn isetstate =>
          constT
            (case word_eq isetstate (n2w_itself (ZERO,(ITSELF TWO)))
             of true => InstrSet_ARM
              | false =>
                   (case
                      word_eq isetstate (n2w_itself (ONE,(ITSELF TWO)))
                    of true => InstrSet_Thumb
                     | false =>
                          (case
                             word_eq isetstate
                               (n2w_itself (TWO,(ITSELF TWO)))
                           of true => InstrSet_Jazelle
                            | false =>
                                 (case
                                    word_eq isetstate
                                      (n2w_itself
                                         ((fromString "3"),
                                          (ITSELF TWO)))
                                  of true => InstrSet_ThumbEE
                                   | false => raise Fail "ARB")))))

  fun select_instr_set ii iset =
        case iset
         of InstrSet_ARM =>
               seqT (current_instr_set ii) (fn current_instr_set =>
                 if current_instr_set = InstrSet_ThumbEE then
                   errorT "select_instr_set: unpredictable"
                 else
                   write_isetstate ii (n2w_itself (ZERO,(ITSELF TWO))))
          | InstrSet_Thumb =>
               write_isetstate ii (n2w_itself (ONE,(ITSELF TWO)))
          | InstrSet_Jazelle =>
               write_isetstate ii (n2w_itself (TWO,(ITSELF TWO)))
          | InstrSet_ThumbEE =>
               write_isetstate ii
                 (n2w_itself ((fromString "3"),(ITSELF TWO)))

  fun RBankSelect ii (mode,(usr,(fiq,(irq,(svc,(abt,(und,mon))))))) =
        seqT (bad_mode ii mode) (fn bad_mode => if bad_mode then
            errorT "RBankSelect: unpredictable"
          else
            constT
              (case
                 word_eq mode
                   (n2w_itself
                      ((fromString "16"),(ITSELF (fromString "5"))))
               of true => usr
                | false =>
                     (case
                        word_eq mode
                          (n2w_itself
                             ((fromString "17"),
                              (ITSELF (fromString "5"))))
                      of true => fiq
                       | false =>
                            (case
                               word_eq mode
                                 (n2w_itself
                                    ((fromString "18"),
                                     (ITSELF (fromString "5"))))
                             of true => irq
                              | false =>
                                   (case
                                      word_eq mode
                                        (n2w_itself
                                           ((fromString "19"),
                                            (ITSELF (fromString "5"))))
                                    of true => svc
                                     | false =>
                                          (case
                                             word_eq mode
                                               (n2w_itself
                                                  ((fromString "22"),
                                                   (ITSELF
                                                     (fromString "5"))))
                                           of true => mon
                                            | false =>
                                                 (case
                                                    word_eq mode
                                                      (n2w_itself
                                                         ((fromString
                                                          "23"),
                                                          (ITSELF
                                                            (fromString
                                                            "5"))))
                                                  of true => abt
                                                   | false =>
                                                        (case
                                                           word_eq mode
                                                             (n2w_itself
                                                                ((fromString
                                                                 "27"),
                                                                 (ITSELF
                                                                   (fromString
                                                                   "5"))))
                                                         of true => und
                                                          | false =>
                                                               (case
                                                                  word_eq
                                                                    mode
                                                                    (n2w_itself
                                                                       ((fromString
                                                                        "31"),
                                                                        (ITSELF
                                                                          (fromString
                                                                          "5"))))
                                                                of true =>
                                                                      usr
                                                                 | false =>
                                                                      raise Fail "ARB")))))))))

  fun RfiqBankSelect ii (mode,(usr,fiq)) =
        RBankSelect ii (mode,(usr,(fiq,(usr,(usr,(usr,(usr,usr)))))))

  fun LookUpRName ii (n,mode) =
        case word_eq n (n2w_itself (ZERO,(ITSELF (fromString "4"))))
         of true => constT RName_0usr
          | false =>
               (case
                  word_eq n (n2w_itself (ONE,(ITSELF (fromString "4"))))
                of true => constT RName_1usr
                 | false =>
                      (case
                         word_eq n
                           (n2w_itself (TWO,(ITSELF (fromString "4"))))
                       of true => constT RName_2usr
                        | false =>
                             (case
                                word_eq n
                                  (n2w_itself
                                     ((fromString "3"),
                                      (ITSELF (fromString "4"))))
                              of true => constT RName_3usr
                               | false =>
                                    (case
                                       word_eq n
                                         (n2w_itself
                                            ((fromString "4"),
                                             (ITSELF (fromString "4"))))
                                     of true => constT RName_4usr
                                      | false =>
                                           (case
                                              word_eq n
                                                (n2w_itself
                                                   ((fromString "5"),
                                                    (ITSELF
                                                      (fromString
                                                      "4"))))
                                            of true => constT RName_5usr
                                             | false =>
                                                  (case
                                                     word_eq n
                                                       (n2w_itself
                                                          ((fromString
                                                           "6"),
                                                           (ITSELF
                                                             (fromString
                                                             "4"))))
                                                   of true =>
                                                         constT
                                                           RName_6usr
                                                    | false =>
                                                         (case
                                                            word_eq n
                                                              (n2w_itself
                                                                 ((fromString
                                                                  "7"),
                                                                  (ITSELF
                                                                    (fromString
                                                                    "4"))))
                                                          of true =>
                                                                constT
                                                                  RName_7usr
                                                           | false =>
                                                                (case
                                                                   word_eq
                                                                     n
                                                                     (n2w_itself
                                                                        ((fromString
                                                                         "8"),
                                                                         (ITSELF
                                                                           (fromString
                                                                           "4"))))
                                                                 of true =>
                                                                       RfiqBankSelect
                                                                         ii
                                                                         (mode,
                                                                          (RName_8usr,
                                                                           RName_8fiq))
                                                                  | false =>
                                                                       (case
                                                                          word_eq
                                                                            n
                                                                            (n2w_itself
                                                                               ((fromString
                                                                                "9"),
                                                                                (ITSELF
                                                                                  (fromString
                                                                                  "4"))))
                                                                        of true =>
                                                                              RfiqBankSelect
                                                                                ii
                                                                                (mode,
                                                                                 (RName_9usr,
                                                                                  RName_9fiq))
                                                                         | false =>
                                                                              (case
                                                                                 word_eq
                                                                                   n
                                                                                   (n2w_itself
                                                                                      ((fromString
                                                                                       "10"),
                                                                                       (ITSELF
                                                                                         (fromString
                                                                                         "4"))))
                                                                               of true =>
                                                                                     RfiqBankSelect
                                                                                       ii
                                                                                       (mode,
                                                                                        (RName_10usr,
                                                                                         RName_10fiq))
                                                                                | false =>
                                                                                     (case
                                                                                        word_eq
                                                                                          n
                                                                                          (n2w_itself
                                                                                             ((fromString
                                                                                              "11"),
                                                                                              (ITSELF
                                                                                                (fromString
                                                                                                "4"))))
                                                                                      of true =>
                                                                                            RfiqBankSelect
                                                                                              ii
                                                                                              (mode,
                                                                                               (RName_11usr,
                                                                                                RName_11fiq))
                                                                                       | false =>
                                                                                            (case
                                                                                               word_eq
                                                                                                 n
                                                                                                 (n2w_itself
                                                                                                    ((fromString
                                                                                                     "12"),
                                                                                                     (ITSELF
                                                                                                       (fromString
                                                                                                       "4"))))
                                                                                             of true =>
                                                                                                   RfiqBankSelect
                                                                                                     ii
                                                                                                     (mode,
                                                                                                      (RName_12usr,
                                                                                                       RName_12fiq))
                                                                                              | false =>
                                                                                                   (case
                                                                                                      word_eq
                                                                                                        n
                                                                                                        (n2w_itself
                                                                                                           ((fromString
                                                                                                            "13"),
                                                                                                            (ITSELF
                                                                                                              (fromString
                                                                                                              "4"))))
                                                                                                    of true =>
                                                                                                          RBankSelect
                                                                                                            ii
                                                                                                            (mode,
                                                                                                             (RName_SPusr,
                                                                                                              (RName_SPfiq,
                                                                                                               (RName_SPirq,
                                                                                                                (RName_SPsvc,
                                                                                                                 (RName_SPabt,
                                                                                                                  (RName_SPund,
                                                                                                                   RName_SPmon)))))))
                                                                                                     | false =>
                                                                                                          (case
                                                                                                             word_eq
                                                                                                               n
                                                                                                               (n2w_itself
                                                                                                                  ((fromString
                                                                                                                   "14"),
                                                                                                                   (ITSELF
                                                                                                                     (fromString
                                                                                                                     "4"))))
                                                                                                           of true =>
                                                                                                                 RBankSelect
                                                                                                                   ii
                                                                                                                   (mode,
                                                                                                                    (RName_LRusr,
                                                                                                                     (RName_LRfiq,
                                                                                                                      (RName_LRirq,
                                                                                                                       (RName_LRsvc,
                                                                                                                        (RName_LRabt,
                                                                                                                         (RName_LRund,
                                                                                                                          RName_LRmon)))))))
                                                                                                            | false =>
                                                                                                                 errorT
                                                                                                                   "LookUpRName: n = 15w"))))))))))))))

  fun read_reg_mode ii (n,mode) =
        seqT (parT (is_secure ii) (read_nsacr ii)) (fn (is_secure,nsacr)
          =>
          if
            word_eq n
              (n2w_itself ((fromString "15"),(ITSELF (fromString "4"))))
            orelse
            not is_secure andalso
            (word_eq mode
               (n2w_itself
                  ((fromString "22"),(ITSELF (fromString "5")))) orelse
             word_eq mode
               (n2w_itself
                  ((fromString "17"),(ITSELF (fromString "5")))) andalso
             CP15nsacr_RFR nsacr)
          then errorT "read_reg_mode: unpredictable"
          else
            seqT (LookUpRName ii (n,mode)) (fn rname =>
              read__reg ii rname))

  fun write_reg_mode ii (n,mode) value =
        seqT
          (parT (is_secure ii)
             (parT (read_nsacr ii) (current_instr_set ii))) (fn
          (is_secure,(nsacr,current_instr_set)) =>
          if
            word_eq n
              (n2w_itself ((fromString "15"),(ITSELF (fromString "4"))))
            orelse
            (not is_secure andalso
             (word_eq mode
                (n2w_itself
                   ((fromString "22"),(ITSELF (fromString "5")))) orelse
              word_eq mode
                (n2w_itself
                   ((fromString "17"),(ITSELF (fromString "5"))))
              andalso CP15nsacr_RFR nsacr) orelse
             word_eq n
               (n2w_itself
                  ((fromString "13"),(ITSELF (fromString "4")))) andalso
             (not (aligned (value,(fromString "4"))) andalso
              not (current_instr_set = InstrSet_ARM)))
          then errorT "write_reg_mode: unpredictable"
          else
            seqT (LookUpRName ii (n,mode)) (fn rname =>
              write__reg ii rname value))

  fun read_pc ii = read__reg ii RName_PC

  fun pc_store_value ii =
        seqT (read_pc ii) (fn pc =>
          constT
            (word_add pc
               (n2w_itself
                  ((fromString "8"),(ITSELF (fromString "32"))))))

  fun read_reg ii n =
        if
          word_eq n
            (n2w_itself ((fromString "15"),(ITSELF (fromString "4"))))
        then
          seqT (parT (read_pc ii) (current_instr_set ii)) (fn
            (pc,current_instr_set) =>
            constT
              (if current_instr_set = InstrSet_ARM then
                 word_add pc
                   (n2w_itself
                      ((fromString "8"),(ITSELF (fromString "32"))))
               else
                 word_add pc
                   (n2w_itself
                      ((fromString "4"),(ITSELF (fromString "32"))))))
        else
          seqT (read_cpsr ii) (fn cpsr =>
            read_reg_mode ii (n,ARMpsr_M cpsr))

  fun read_r0 ii =
        read_reg ii (n2w_itself(ZERO,ITSELF (fromString "4")))

  fun write_reg ii n value =
        if
          word_eq n
            (n2w_itself ((fromString "15"),(ITSELF (fromString "4"))))
        then errorT "write_reg: assert"
        else
          seqT (read_cpsr ii) (fn cpsr =>
            write_reg_mode ii (n,ARMpsr_M cpsr) value)

  fun write_0_r0 ii =
      write_reg ii (n2w_itself(ZERO,ITSELF (fromString "4")))
                (n2w_itself(ZERO,ITSELF (fromString "32")))

  fun branch_to ii address = write__reg ii RName_PC address

  fun increment_pc ii enc =
        seqT (read_pc ii) (fn pc =>
          branch_to ii
            (word_add pc
               (if
                  (enc = Encoding_Thumb) orelse (enc = Encoding_ThumbEE)
                then
                  n2w_itself (TWO,(ITSELF (fromString "32")))
                else
                  n2w_itself
                    ((fromString "4"),(ITSELF (fromString "32"))))))

  fun big_endian ii =
        seqT (read_cpsr ii) (fn cpsr => constT (ARMpsr_E cpsr))

  fun translate_address (address,(ispriv,iswrite)) =
        constT
          (AddressDescriptor(MemoryAttributes(MemType_Normal,
                                              n2w_itself
                                                (ZERO,(ITSELF TWO)),
                                              n2w_itself
                                                (ZERO,(ITSELF TWO)),
                                              true,true),address))

  fun read_monitor ii = readT arm_state_monitors

  fun write_monitor ii d =
        writeT (fn s => arm_state_monitors_fupd (combinML.K d) s)

(*  fun read_mem1 ii address =
        seqT
      	  (readT (fn s => arm_state_memory s address))
      	  (fn v => seqT
	    (writeT
              (arm_state_accesses_fupd (fn l => MEM_READ(address, [v])::l)))
	    (fn u => constT v)) *)

(*  fun write_mem1 ii address byte =
        seqT
          (writeT
             (arm_state_accesses_fupd (fn l =>
                MEM_WRITE(address,[byte])::l))) (fn u =>
          writeT (arm_state_memory_fupd (combinML.UPDATE address byte))) *)

(*  fun read_mem ii (memaddrdesc,size) =
        if
          not
            (IN size
               (INSERT
                  (ONE,
                   INSERT
                     (TWO,
                      INSERT
                        ((fromString "4"),
                         INSERT ((fromString "8"),EMPTY))))))
        then errorT "read_mem: size is not 1, 2, 4 or 8"
        else
          let val address = AddressDescriptor_paddress memaddrdesc
          in
             forT ZERO (- size ONE) (fn i =>
               read_mem1 ii
                 (word_add address
                    (n2w_itself (i,(ITSELF (fromString "32"))))))
          end *)

  fun read_mem ii (memaddrdesc,size) =
        if
          not
            (IN size
               (INSERT
                  (ONE,
                   INSERT
                     (TWO,
                      INSERT
                        ((fromString "4"),
                         INSERT ((fromString "8"),EMPTY))))))
        then errorT "read_mem: size is not 1, 2, 4 or 8"
        else
          let val address = AddressDescriptor_paddress memaddrdesc
          in
             seqT
               (forT ZERO (- size ONE) (fn i =>
                 let val waddr =
	           word_add address (n2w_itself (i,(ITSELF (fromString "32"))))
	         in
	           readT (fn s => arm_state_memory s waddr)
                 end))
	       (fn vl => seqT
          	 (writeT
                   (arm_state_accesses_fupd (fn l => MEM_READ(address, List.rev vl, size)::l)))
                 (fn u => constT vl))
          end

(*  fun write_mem ii (memaddrdesc,size) value =
        if
          not
            (IN size
               (INSERT
                  (ONE,
                   INSERT
                     (TWO,
                      INSERT
                        ((fromString "4"),
                         INSERT ((fromString "8"),EMPTY))))))
        then errorT "write_mem: size is not 1, 2, 4 or 8"
        else
          if not (listML.LENGTH value = size) then
          errorT "write_mem: value has wrong size"
        else
          let val address = AddressDescriptor_paddress memaddrdesc
          in
             seqT
               (forT ZERO (- size ONE) (fn i =>
                  write_mem1 ii
                    (word_add address
                       (n2w_itself (i,(ITSELF (fromString "32")))))
                    (listML.EL i value))) (fn l => constT ())
          end *)

  fun write_mem ii (memaddrdesc,size) value =
        if
          not
            (IN size
               (INSERT
                  (ONE,
                   INSERT
                     (TWO,
                      INSERT
                        ((fromString "4"),
                         INSERT ((fromString "8"),EMPTY))))))
        then errorT "write_mem: size is not 1, 2, 4 or 8"
        else
          if not (listML.LENGTH value = size) then
          errorT "write_mem: value has wrong size"
        else
          let val address = AddressDescriptor_paddress memaddrdesc
          in
             seqT
              (writeT
                (arm_state_accesses_fupd (fn l =>
                  MEM_WRITE(address, List.rev value, size)::l)))
               (fn u => seqT
                 (forT ZERO (- size ONE) (fn i =>
                   let
                   val waddr = word_add address
                            (n2w_itself (i,(ITSELF (fromString "32"))))
                   val byte = listML.EL i value
                   in
                     writeT (arm_state_memory_fupd (combinML.UPDATE waddr byte))
                   end))
                 (fn l => constT ()))
          end

  fun read_memA_with_priv ii (address,(size,privileged)) =
        seqT
          (if aligned (address,size) then
             constT address
           else
             seqT (read_sctlr ii) (fn sctlr =>
               if CP15sctlr_A sctlr orelse CP15sctlr_U sctlr then
                 errorT "read_memA_with_priv: DAbort_Alignment"
               else constT (align (address,size)))) (fn VA =>
          seqT (translate_address (VA,(privileged,false))) (fn
            memaddrdesc =>
            seqT (read_mem ii (memaddrdesc,size)) (fn value =>
              seqT (big_endian ii) (fn E =>
                constT (if E then listML.REVERSE value else value)))))

  fun write_memA_with_priv ii (address,(size,privileged)) value =
        seqT
          (if aligned (address,size) then
             constT address
           else
             seqT (read_sctlr ii) (fn sctlr =>
               if CP15sctlr_A sctlr orelse CP15sctlr_U sctlr then
                 errorT "write_memA_with_priv: DAbort_Alignment"
               else constT (align (address,size)))) (fn VA =>
          seqT (translate_address (VA,(privileged,true))) (fn
            memaddrdesc =>
            seqT
              (if
                 MemoryAttributes_shareable
                   (AddressDescriptor_memattrs memaddrdesc)
               then
                 seqT (read_monitor ii) (fn monitor =>
                   write_monitor ii
                     (ExclusiveMonitors_state_fupd
                        (combinML.K
                           (pairML.SND
                              (ExclusiveMonitors_ClearExclusiveByAddress
                                 monitor
                                 (AddressDescriptor_paddress
                                    memaddrdesc,(ii,size))
                                 (ExclusiveMonitors_state monitor))))
                        monitor))
               else constT ()) (fn u =>
              seqT
                (seqT (big_endian ii) (fn E =>
                   constT (if E then listML.REVERSE value else value)))
                (fn value => write_mem ii (memaddrdesc,size) value))))

  fun read_memU_with_priv ii (address,(size,privileged)) =
        seqT (read_sctlr ii) (fn sctlr =>
          seqT
            (if
               not (CP15sctlr_A sctlr) andalso not (CP15sctlr_U sctlr)
             then
               constT (align (address,size))
             else constT address) (fn address =>
            if aligned (address,size) then
              read_memA_with_priv ii (address,(size,privileged))
            else
              if CP15sctlr_A sctlr then
              errorT "read_memU_with_priv: DAbort_Alignment"
            else
              seqT
                (forT ZERO (- size ONE) (fn i =>
                   read_memA_with_priv ii
                     (word_add address
                        (n2w_itself (i,(ITSELF (fromString "32")))),
                      (ONE,privileged)))) (fn values =>
                let val value = listML.FLAT values
                in
                   seqT (big_endian ii) (fn E =>
                     constT (if E then listML.REVERSE value else value))
                end)))

  fun write_memU_with_priv ii (address,(size,privileged)) value =
        seqT (read_sctlr ii) (fn sctlr =>
          seqT
            (if
               not (CP15sctlr_A sctlr) andalso not (CP15sctlr_U sctlr)
             then
               constT (align (address,size))
             else constT address) (fn address =>
            if aligned (address,size) then
              write_memA_with_priv ii (address,(size,privileged)) value
            else
              if CP15sctlr_A sctlr then
              errorT "write_memU_with_priv: DAbort_Alignment"
            else
              seqT
                (seqT (big_endian ii) (fn E =>
                   constT (if E then listML.REVERSE value else value)))
                (fn value =>
                seqT
                  (forT ZERO (- size ONE) (fn i =>
                     write_memA_with_priv ii
                       (word_add address
                          (n2w_itself (i,(ITSELF (fromString "32")))),
                        (ONE,privileged)) [listML.EL i value])) (fn u =>
                  constT ()))))

  fun read_memA ii (address,size) =
        seqT (current_mode_is_priviledged ii) (fn priviledged =>
          read_memA_with_priv ii (address,(size,priviledged)))

  fun write_memA ii (address,size) value =
        seqT (current_mode_is_priviledged ii) (fn priviledged =>
          write_memA_with_priv ii (address,(size,priviledged)) value)

  fun read_memA_unpriv ii (address,size) =
        read_memA_with_priv ii (address,(size,false))

  fun write_memA_unpriv ii (address,size) value =
        write_memA_with_priv ii (address,(size,false)) value

  fun read_memU ii (address,size) =
        seqT (current_mode_is_priviledged ii) (fn priviledged =>
          read_memU_with_priv ii (address,(size,priviledged)))

  fun write_memU ii (address,size) value =
        seqT (current_mode_is_priviledged ii) (fn priviledged =>
          write_memU_with_priv ii (address,(size,priviledged)) value)

  fun read_memU_unpriv ii (address,size) =
        read_memU_with_priv ii (address,(size,false))

  fun write_memU_unpriv ii (address,size) value =
        write_memU_with_priv ii (address,(size,false)) value

  fun data_memory_barrier ii x = constT ()

  fun data_synchronization_barrier ii x = constT ()

  fun instruction_synchronization_barrier ii = constT ()

  fun hint_preload_data_for_write ii x = constT ()

  fun hint_preload_data ii x = constT ()

  fun hint_preload_instr ii x = constT ()

  fun hint_yield ii = constT ()

  fun hint_debug ii option = constT ()

  fun clear_event_register ii =
        writeT
          (arm_state_event_register_fupd
             (combinML.UPDATE (iiid_proc ii) false))

  fun event_registered ii =
        readT (fn s => arm_state_event_register s (iiid_proc ii))

  fun send_event ii =
        writeT (fn s =>
          arm_state_event_register_fupd (combinML.K (combinML.K true))
            s)

  fun wait_for_event ii = constT ()

  fun wait_for_interrupt ii =
        writeT
          (arm_state_interrupt_wait_fupd
             (combinML.UPDATE (iiid_proc ii) true))

  fun clear_wait_for_interrupt ii =
        writeT
          (arm_state_interrupt_wait_fupd
             (combinML.UPDATE (iiid_proc ii) false))

  fun waiting_for_interrupt ii =
        readT (fn s => arm_state_interrupt_wait s (iiid_proc ii))

  fun set_exclusive_monitors ii (address,size) =
        seqT (parT (read_cpsr ii) (read_monitor ii)) (fn (cpsr,monitor)
          =>
          seqT
            (translate_address
               (address,
                (not
                   (word_eq (ARMpsr_M cpsr)
                      (n2w_itself
                         ((fromString "16"),
                          (ITSELF (fromString "5"))))),false))) (fn
            memaddrdesc =>
            let val triple =
                    (AddressDescriptor_paddress memaddrdesc,(ii,size))
            in
               write_monitor ii
                 (ExclusiveMonitors_state_fupd
                    (combinML.K
                       (pairML.SND
                          (if
                             MemoryAttributes_shareable
                               (AddressDescriptor_memattrs memaddrdesc)
                           then
                             seqE
                               (ExclusiveMonitors_MarkExclusiveGlobal
                                  monitor triple) (fn u =>
                               ExclusiveMonitors_MarkExclusiveLocal
                                 monitor triple)
                               (ExclusiveMonitors_state monitor)
                           else
                             ExclusiveMonitors_MarkExclusiveLocal
                               monitor triple
                               (ExclusiveMonitors_state monitor))))
                    monitor)
            end))

  fun exclusive_monitors_pass ii (address,size) =
        seqT (parT (read_cpsr ii) (read_monitor ii)) (fn (cpsr,monitor)
          => if not (aligned (address,size)) then
            errorT "exclusive_monitors_pass: alignment fault"
          else
            seqT
              (translate_address
                 (address,
                  (not
                     (word_eq (ARMpsr_M cpsr)
                        (n2w_itself
                           ((fromString "16"),
                            (ITSELF (fromString "5"))))),false))) (fn
              memaddrdesc =>
              let val triple =
                      (AddressDescriptor_paddress memaddrdesc,(ii,size))
                  val (passed,state') =
                      seqE
                        (ExclusiveMonitors_IsExclusiveLocal monitor
                           triple) (fn local_passed =>
                        seqE
                          (if
                             MemoryAttributes_shareable
                               (AddressDescriptor_memattrs memaddrdesc)
                           then
                             seqE
                               (ExclusiveMonitors_IsExclusiveGlobal
                                  monitor triple) (fn global_passed =>
                               constE
                                 (local_passed andalso global_passed))
                           else constE local_passed) (fn passed =>
                          if passed then
                            seqE
                              (ExclusiveMonitors_ClearExclusiveLocal
                                 monitor (iiid_proc ii)) (fn u =>
                              constE true) else constE false))
                        (ExclusiveMonitors_state monitor)
              in
                 seqT
                   (write_monitor ii
                      (ExclusiveMonitors_state_fupd (combinML.K state')
                         monitor)) (fn u => constT passed)
              end))

  fun clear_exclusive_local ii =
        seqT (read_monitor ii) (fn monitor =>
          let val state' =
                  pairML.SND
                    (ExclusiveMonitors_ClearExclusiveLocal monitor
                       (iiid_proc ii) (ExclusiveMonitors_state monitor))
          in
             write_monitor ii
               (ExclusiveMonitors_state_fupd (combinML.K state')
                  monitor)
          end)

  fun read_coprocessors ii = readT arm_state_coprocessors

  fun write_coprocessors ii d =
        writeT (fn s => arm_state_coprocessors_fupd (combinML.K d) s)

  fun coproc_accepted ii inst =
        seqT (read_coprocessors ii) (fn coprocessors =>
          let val accept =
                  pairML.FST
                    (Coprocessors_accept coprocessors inst
                       (Coprocessors_state coprocessors))
          in
             constT accept
          end)

  fun coproc_internal_operation ii inst =
        seqT (read_coprocessors ii) (fn coprocessors =>
          let val cp_state =
                  pairML.SND
                    (Coprocessors_internal_op coprocessors inst
                       (Coprocessors_state coprocessors))
          in
             write_coprocessors ii
               (Coprocessors_state_fupd (combinML.K cp_state)
                  coprocessors)
          end)

  fun coproc_send_loaded_words ii (readm,inst) =
        seqT (read_coprocessors ii) (fn coprocessors =>
          let val count =
                  pairML.FST
                    (Coprocessors_load_count coprocessors inst
                       (Coprocessors_state coprocessors))
          in
             seqT (forT ZERO (- count ONE) readm) (fn data =>
               let val cp_state =
                       pairML.SND
                         (Coprocessors_load coprocessors inst data
                            (Coprocessors_state coprocessors))
               in
                  write_coprocessors ii
                    (Coprocessors_state_fupd (combinML.K cp_state)
                       coprocessors)
               end)
          end)

  fun coproc_get_words_to_store ii inst =
        seqT (read_coprocessors ii) (fn coprocessors =>
          let val data =
                  pairML.FST
                    (Coprocessors_store coprocessors inst
                       (Coprocessors_state coprocessors))
          in
             constT data
          end)

  fun coproc_send_one_word ii (data,inst) =
        seqT (read_coprocessors ii) (fn coprocessors =>
          let val cp_state =
                  pairML.SND
                    (Coprocessors_send_one coprocessors inst data
                       (Coprocessors_state coprocessors))
          in
             write_coprocessors ii
               (Coprocessors_state_fupd (combinML.K cp_state)
                  coprocessors)
          end)

  fun coproc_get_one_word ii inst =
        seqT (read_coprocessors ii) (fn coprocessors =>
          let val data =
                  pairML.FST
                    (Coprocessors_get_one coprocessors inst
                       (Coprocessors_state coprocessors))
          in
             constT data
          end)

  fun coproc_send_two_words ii (data,inst) =
        seqT (read_coprocessors ii) (fn coprocessors =>
          let val cp_state =
                  pairML.SND
                    (Coprocessors_send_two coprocessors inst data
                       (Coprocessors_state coprocessors))
          in
             write_coprocessors ii
               (Coprocessors_state_fupd (combinML.K cp_state)
                  coprocessors)
          end)

  fun coproc_get_two_words ii inst =
        seqT (read_coprocessors ii) (fn coprocessors =>
          let val data =
                  pairML.FST
                    (Coprocessors_get_two coprocessors inst
                       (Coprocessors_state coprocessors))
          in
             constT data
          end)

  fun unaligned_support ii =
        seqT (read_info ii) (fn info =>
          constT (ARMinfo_unaligned_support info))

  fun arch_version ii =
        seqT (read_arch ii) (combinML.o constT version_number)

  fun read_reg_literal ii n =
        if
          word_eq n
            (n2w_itself ((fromString "15"),(ITSELF (fromString "4"))))
        then
          seqT
            (read_reg ii
               (n2w_itself
                  ((fromString "15"),(ITSELF (fromString "4"))))) (fn pc
            => constT (align (pc,(fromString "4")))) else read_reg ii n

  fun read_flags ii =
        seqT (read_cpsr ii) (fn cpsr =>
          constT
            (ARMpsr_N cpsr,
             (ARMpsr_Z cpsr,(ARMpsr_C cpsr,ARMpsr_V cpsr))))

  fun write_flags ii (n,(z,(c,v))) =
        seqT (read_cpsr ii) (fn cpsr =>
          write_cpsr ii
            (ARMpsr_N_fupd (combinML.K n)
               (ARMpsr_Z_fupd (combinML.K z)
                  (ARMpsr_C_fupd (combinML.K c)
                     (ARMpsr_V_fupd (combinML.K v) cpsr)))))

  fun read_cflag ii =
        seqT (read_flags ii) (fn (n,(z,(c,v))) => constT c)

  fun set_q ii =
        seqT (read_cpsr ii) (fn cpsr =>
          write_cpsr ii (ARMpsr_Q_fupd (combinML.K true) cpsr))

  fun read_ge ii =
        seqT (read_cpsr ii) (fn cpsr => constT (ARMpsr_GE cpsr))

  fun write_ge ii ge =
        seqT (read_cpsr ii) (fn cpsr =>
          write_cpsr ii (ARMpsr_GE_fupd (combinML.K ge) cpsr))

  fun write_e ii e =
        seqT (read_cpsr ii) (fn cpsr =>
          write_cpsr ii (ARMpsr_E_fupd (combinML.K e) cpsr))

  fun IT_advance ii =
        seqT (read_arch ii) (fn arch =>
          condT
            ((arch = ARMv6T2) orelse
             >= (version_number arch) (fromString "7"))
            (seqT (read_cpsr ii) (fn cpsr =>
               if
                 word_eq (ARMpsr_IT cpsr)
                   (n2w_itself (ZERO,(ITSELF (fromString "8")))) orelse
                 ARMpsr_T cpsr
               then
                 write_cpsr ii
                   (ARMpsr_IT_fupd
                      (combinML.K (ITAdvance (ARMpsr_IT cpsr))) cpsr)
               else errorT "IT_advance: unpredictable")))

  fun cpsr_write_by_instr ii (value,(bytemask,affect_execstate)) =
        let val value_mode =
                word_extract_itself (ITSELF (fromString "5"))
                  (fromString "4") ZERO value
        in
           seqT
             (parT (current_mode_is_priviledged ii)
                (parT (is_secure ii)
                   (parT (read_nsacr ii) (bad_mode ii value_mode)))) (fn
             (priviledged,(is_secure,(nsacr,badmode))) =>
             if
               word_index bytemask ZERO andalso
               (priviledged andalso
                (badmode orelse
                 (not is_secure andalso
                  word_eq value_mode
                    (n2w_itself
                       ((fromString "22"),(ITSELF (fromString "5"))))
                  orelse
                  not is_secure andalso
                  (word_eq value_mode
                     (n2w_itself
                        ((fromString "17"),(ITSELF (fromString "5"))))
                   andalso CP15nsacr_RFR nsacr))))
             then errorT "cpsr_write_by_instr: unpredictable"
             else
               seqT
                 (parT (read_sctlr ii)
                    (parT (read_scr ii) (read_cpsr ii))) (fn
                 (sctlr,(scr,cpsr)) =>
                 let val cpsr =
                         word_modify (fn i => fn b =>
                           if
                             <= (fromString "27") i andalso
                             (<= i (fromString "31") andalso
                              word_index bytemask (fromString "3"))
                             orelse
                             (<= (fromString "24") i andalso
                              (<= i (fromString "26") andalso
                               (word_index bytemask (fromString "3")
                                andalso affect_execstate)) orelse
                              (<= (fromString "16") i andalso
                               (<= i (fromString "19") andalso
                                word_index bytemask TWO) orelse
                               (<= (fromString "10") i andalso
                                (<= i (fromString "15") andalso
                                 (word_index bytemask ONE andalso
                                  affect_execstate)) orelse
                                ((i = (fromString "9")) andalso
                                 word_index bytemask ONE orelse
                                 ((i = (fromString "8")) andalso
                                  (word_index bytemask ONE andalso
                                   (priviledged andalso
                                    (is_secure orelse CP15scr_AW scr)))
                                  orelse
                                  ((i = (fromString "7")) andalso
                                   (word_index bytemask ZERO andalso
                                    priviledged) orelse
                                   ((i = (fromString "6")) andalso
                                    (word_index bytemask ZERO andalso
                                     (priviledged andalso
                                      ((is_secure orelse CP15scr_FW scr)
                                       andalso
                                       (not (CP15sctlr_NMFI sctlr)
                                        orelse
                                        not
                                          (word_index value
                                             (fromString "6"))))))
                                    orelse
                                    ((i = (fromString "5")) andalso
                                     (word_index bytemask ZERO andalso
                                      affect_execstate) orelse
                                     < i (fromString "5") andalso
                                     (word_index bytemask ZERO andalso
                                      priviledged)))))))))
                           then word_index value i else b)
                           (encode_psr cpsr)
                 in
                    write_cpsr ii (decode_psr cpsr)
                 end))
        end

  fun spsr_write_by_instr ii (value,bytemask) =
        seqT
          (parT (current_mode_is_user_or_system ii)
             (bad_mode ii
                (word_extract_itself (ITSELF (fromString "5"))
                   (fromString "4") ZERO value))) (fn
          (user_or_system,badmode) =>
          if
            user_or_system orelse
            word_index bytemask ZERO andalso badmode
          then errorT "spsr_write_by_instr: unpredictable"
          else
            seqT (read_spsr ii) (fn spsr =>
              let val spsr =
                      word_modify (fn i => fn b =>
                        if
                          <= (fromString "24") i andalso
                          (<= i (fromString "31") andalso
                           word_index bytemask (fromString "3")) orelse
                          (<= (fromString "16") i andalso
                           (<= i (fromString "19") andalso
                            word_index bytemask TWO) orelse
                           (<= (fromString "8") i andalso
                            (<= i (fromString "15") andalso
                             word_index bytemask ONE) orelse
                            <= i (fromString "7") andalso
                            word_index bytemask ZERO))
                        then word_index value i else b)
                        (encode_psr spsr)
              in
                 write_spsr ii (decode_psr spsr)
              end))

  fun branch_write_pc ii address =
        seqT (current_instr_set ii) (fn iset =>
          if iset = InstrSet_ARM then
            seqT (arch_version ii) (fn version =>
              if
                < version (fromString "6") andalso
                not
                  (word_eq
                     (word_extract_itself (ITSELF TWO) ONE ZERO address)
                     (n2w_itself (ZERO,(ITSELF TWO))))
              then errorT "branch_write_pc: unpredictable"
              else
                branch_to ii (word_slice (fromString "31") TWO address))
          else branch_to ii (word_slice (fromString "31") ONE address))

  fun bx_write_pc ii address =
        seqT (current_instr_set ii) (fn iset =>
          if iset = InstrSet_ThumbEE then
            (if word_index address ZERO then
               branch_to ii (word_slice (fromString "31") ONE address)
             else errorT "bx_write_pc: unpredictable")
          else
            if word_index address ZERO then
            seqT (select_instr_set ii InstrSet_Thumb) (fn u =>
              branch_to ii (word_slice (fromString "31") ONE address))
          else
            if not (word_index address ONE) then
            seqT (select_instr_set ii InstrSet_ARM) (fn u =>
              branch_to ii address)
          else errorT "bx_write_pc: unpredictable")

  fun load_write_pc ii address =
        seqT (arch_version ii) (fn version =>
          if >= version (fromString "5") then bx_write_pc ii address
          else branch_write_pc ii address)

  fun restore_return_address_to_pc ii =
      seqT (read_reg ii (n2w_itself ((fromString "14"),(ITSELF (fromString "4")))))
           (fn r14 =>
               (load_write_pc ii r14))

  fun hex n s = StringCvt.padLeft #"0" n (wordsML.word_to_hex_string s)

  fun compare_ir_access (IR_REG_READ r1) (IR_REG_READ r2) = r1 = r2
    | compare_ir_access (IR_REG_READ r1) (IR_REG_WRITE r2) = r1 = r2
    | compare_ir_access (IR_REG_WRITE r1) (IR_REG_READ r2) = r1 = r2
    | compare_ir_access (IR_REG_WRITE r1) (IR_REG_WRITE r2) = r1 = r2
    | compare_ir_access (LOCAL_READ m1) (LOCAL_READ m2) = m1 = m2
    | compare_ir_access (LOCAL_READ m1) (LOCAL_WRITE m2) = m1 = m2
    | compare_ir_access (LOCAL_WRITE m1) (LOCAL_READ m2) = m1 = m2
    | compare_ir_access (LOCAL_WRITE m1) (LOCAL_WRITE m2) = m1 = m2
    | compare_ir_access (GLOBAL_READ m1) (GLOBAL_READ m2) = m1 = m2
    | compare_ir_access (GLOBAL_READ m1) (GLOBAL_WRITE m2) = m1 = m2
    | compare_ir_access (GLOBAL_WRITE m1) (GLOBAL_READ m2) = m1 = m2
    | compare_ir_access (GLOBAL_WRITE m1) (GLOBAL_WRITE m2) = m1 = m2
    | compare_ir_access _ _ = false

  datatype LockType
        = Lock
        | Unlock

  fun handle_locks ii lock_type=
      (if lock_type=Lock then print "LOCK : " else print "UNLOCK : ";
       seqT (read_r0 ii) (fn r0 =>
          (print (hex 8 r0);print "\n";
          seqT
            (write_0_r0 ii)
             (fn _ => restore_return_address_to_pc ii))))

  fun alu_write_pc ii address =
        seqT (parT (arch_version ii) (current_instr_set ii)) (fn
          (version,iset) =>
          if
            >= version (fromString "7") andalso (iset = InstrSet_ARM)
          then bx_write_pc ii address else branch_write_pc ii address)

  fun decode_imm_shift (type_,imm5) =
        case word_eq type_ (n2w_itself (ZERO,(ITSELF TWO)))
         of true => (SRType_LSL,w2n imm5)
          | false =>
               (case word_eq type_ (n2w_itself (ONE,(ITSELF TWO)))
                of true =>
                      (SRType_LSR,
                       if
                         word_eq imm5
                           (n2w_itself (ZERO,(ITSELF (fromString "5"))))
                       then (fromString "32") else w2n imm5)
                 | false =>
                      (case
                         word_eq type_ (n2w_itself (TWO,(ITSELF TWO)))
                       of true =>
                             (SRType_ASR,
                              if
                                word_eq imm5
                                  (n2w_itself
                                     (ZERO,(ITSELF (fromString "5"))))
                              then (fromString "32") else w2n imm5)
                        | false =>
                             (case
                                word_eq type_
                                  (n2w_itself
                                     ((fromString "3"),(ITSELF TWO)))
                              of true =>
                                    if
                                      word_eq imm5
                                        (n2w_itself
                                           (ZERO,
                                            (ITSELF (fromString "5"))))
                                    then
                                      (SRType_RRX,ONE)
                                    else (SRType_ROR,w2n imm5)
                               | false => raise Fail "ARB")))

  fun decode_reg_shift type_ =
        case word_eq type_ (n2w_itself (ZERO,(ITSELF TWO)))
         of true => SRType_LSL
          | false =>
               (case word_eq type_ (n2w_itself (ONE,(ITSELF TWO)))
                of true => SRType_LSR
                 | false =>
                      (case
                         word_eq type_ (n2w_itself (TWO,(ITSELF TWO)))
                       of true => SRType_ASR
                        | false =>
                             (case
                                word_eq type_
                                  (n2w_itself
                                     ((fromString "3"),(ITSELF TWO)))
                              of true => SRType_ROR
                               | false => raise Fail "ARB")))

  fun shift_c (value,(type_,(amount,carry_in))) =
        if (type_ = SRType_RRX) andalso not (amount = ONE) then
          errorT "shift_c: RRX amount not 1"
        else
          constT
            (if amount = ZERO then
               (value,carry_in)
             else
               case type_
                of SRType_LSL => LSL_C (value,amount)
                 | SRType_LSR => LSR_C (value,amount)
                 | SRType_ASR => ASR_C (value,amount)
                 | SRType_ROR => ROR_C (value,amount)
                 | SRType_RRX => RRX_C (value,carry_in))

  fun shift (value,(type_,(amount,carry_in))) =
        seqT (shift_c (value,(type_,(amount,carry_in)))) (fn r =>
          constT (pairML.FST r))

  fun arm_expand_imm_c (imm12,carry_in) =
        shift_c
          (word_extract_itself (ITSELF (fromString "32"))
             (fromString "7") ZERO imm12,
           (SRType_ROR,
            ( *  TWO
               (w2n
                  (word_bits (fromString "11") (fromString "8") imm12)),
             carry_in)))

  fun thumb_expand_imm_c (imm12,carry_in) =
        if
          word_eq (word_bits (fromString "11") (fromString "10") imm12)
            (n2w_itself (ZERO,(ITSELF (fromString "12"))))
        then
          let val imm8 =
                  word_extract_itself (ITSELF (fromString "8"))
                    (fromString "7") ZERO imm12
          in
             case
               word_eq
                 (word_extract_itself (ITSELF TWO) (fromString "9")
                    (fromString "8") imm12)
                 (n2w_itself (ZERO,(ITSELF TWO)))
              of true =>
                    constT
                      (w2w_itself (ITSELF (fromString "32")) imm8,
                       carry_in)
               | false =>
                    (case
                       word_eq
                         (word_extract_itself (ITSELF TWO)
                            (fromString "9") (fromString "8") imm12)
                         (n2w_itself (ONE,(ITSELF TWO)))
                     of true =>
                           if
                             word_eq imm8
                               (n2w_itself
                                  (ZERO,(ITSELF (fromString "8"))))
                           then
                             errorT "thumb_expand_imm_c: unpredictable"
                           else
                             constT
                               (word32
                                  [imm8,
                                   n2w_itself
                                     (ZERO,(ITSELF (fromString "8"))),
                                   imm8,
                                   n2w_itself
                                     (ZERO,(ITSELF (fromString "8")))],
                                carry_in)
                      | false =>
                           (case
                              word_eq
                                (word_extract_itself (ITSELF TWO)
                                   (fromString "9") (fromString "8")
                                   imm12)
                                (n2w_itself (TWO,(ITSELF TWO)))
                            of true =>
                                  if
                                    word_eq imm8
                                      (n2w_itself
                                         (ZERO,
                                          (ITSELF (fromString "8"))))
                                  then
                                    errorT
                                      "thumb_expand_imm_c: unpredictable"
                                  else
                                    constT
                                      (word32
                                         [n2w_itself
                                            (ZERO,
                                             (ITSELF (fromString "8"))),
                                          imm8,
                                          n2w_itself
                                            (ZERO,
                                             (ITSELF (fromString "8"))),
                                          imm8],carry_in)
                             | false =>
                                  (case
                                     word_eq
                                       (word_extract_itself (ITSELF TWO)
                                          (fromString "9")
                                          (fromString "8") imm12)
                                       (n2w_itself
                                          ((fromString "3"),
                                           (ITSELF TWO)))
                                   of true =>
                                         if
                                           word_eq imm8
                                             (n2w_itself
                                                (ZERO,
                                                 (ITSELF
                                                   (fromString "8"))))
                                         then
                                           errorT
                                             "thumb_expand_imm_c: unpredictable"
                                         else
                                           constT
                                             (word32
                                                [imm8,imm8,imm8,imm8],
                                              carry_in)
                                    | false => raise Fail "ARB")))
          end
        else
          let val unrotated_value =
                  word_modify (fn i => fn b =>
                    if i = (fromString "7") then true else b)
                    (word_extract_itself (ITSELF (fromString "32"))
                       (fromString "6") ZERO imm12)
          in
             constT
               (ROR_C
                  (unrotated_value,
                   w2n
                     (word_bits (fromString "11") (fromString "7")
                        imm12)))
          end

  fun arm_expand_imm ii imm12 =
        seqT (read_cflag ii) (fn c =>
          seqT (arm_expand_imm_c (imm12,c)) (fn (imm32,c) =>
            constT imm32))

  fun address_mode1 ii thumb2 (Mode1_immediate(imm12)) =
        seqT (read_cflag ii) (fn c => if thumb2 then
            thumb_expand_imm_c (imm12,c)
          else arm_expand_imm_c (imm12,c))
    | address_mode1 ii thumb2 (Mode1_register(imm5,type_,rm)) =
        seqT (parT (read_reg ii rm) (read_cflag ii)) (fn (rm,c) =>
          let val (shift_t,shift_n) = decode_imm_shift (type_,imm5)
          in
             shift_c (rm,(shift_t,(shift_n,c)))
          end)
    | address_mode1 ii thumb2
        (Mode1_register_shifted_register(rs,type_,rm)) =
        seqT
          (parT (read_reg ii rm)
             (parT (read_reg ii rs) (read_cflag ii))) (fn (rm,(rs,c)) =>
          let val shift_t = decode_reg_shift type_
              val shift_n = w2n (word_bits (fromString "7") ZERO rs)
          in
             shift_c (rm,(shift_t,(shift_n,c)))
          end)

  fun address_mode2 ii indx add rn (Mode2_immediate(imm12)) =
        let val imm32 = w2w_itself (ITSELF (fromString "32")) imm12
            val offset_addr =
                if add then word_add rn imm32 else word_sub rn imm32
        in
           constT (offset_addr,if indx then offset_addr else rn)
        end
    | address_mode2 ii indx add rn (Mode2_register(imm5,type_,rm)) =
        seqT (parT (read_reg ii rm) (read_cflag ii)) (fn (rm,c) =>
          let val (shift_t,shift_n) = decode_imm_shift (type_,imm5)
          in
             seqT (shift (rm,(shift_t,(shift_n,c)))) (fn imm32 =>
               let val offset_addr =
                       if add then
                         word_add rn imm32
                       else word_sub rn imm32
               in
                  constT (offset_addr,if indx then offset_addr else rn)
               end)
          end)

  fun address_mode3 ii indx add rn (Mode3_immediate(imm12)) =
        let val imm32 = w2w_itself (ITSELF (fromString "32")) imm12
            val offset_addr =
                if add then word_add rn imm32 else word_sub rn imm32
        in
           constT (offset_addr,if indx then offset_addr else rn)
        end
    | address_mode3 ii indx add rn (Mode3_register(imm2,rm)) =
        seqT (parT (read_reg ii rm) (read_cflag ii)) (fn (rm,c) =>
          seqT (shift (rm,(SRType_LSL,(w2n imm2,c)))) (fn imm32 =>
            let val offset_addr =
                    if add then word_add rn imm32 else word_sub rn imm32
            in
               constT (offset_addr,if indx then offset_addr else rn)
            end))

  fun address_mode5 indx add rn imm8 =
        let val imm32 =
                word_lsl (w2w_itself (ITSELF (fromString "32")) imm8)
                  TWO
            val offset_addr =
                if add then word_add rn imm32 else word_sub rn imm32
        in
           constT (offset_addr,if indx then offset_addr else rn)
        end

  fun signed_parallel_add_sub_16 op2 rn rm =
        let val bn =
                intML.w2i
                  (word_extract_itself (ITSELF (fromString "16"))
                     (fromString "15") ZERO rn)
            val bm =
                intML.w2i
                  (word_extract_itself (ITSELF (fromString "16"))
                     (fromString "15") ZERO rm)
            val tn =
                intML.w2i
                  (word_extract_itself (ITSELF (fromString "16"))
                     (fromString "31") (fromString "16") rn)
            val tm =
                intML.w2i
                  (word_extract_itself (ITSELF (fromString "16"))
                     (fromString "31") (fromString "16") rm)
        in
           case op2
            of Parallel_add_16 =>
                  (intML.int_add bn bm,intML.int_add tn tm)
             | Parallel_add_sub_exchange =>
                  (intML.int_sub bn tm,intML.int_add tn bm)
             | Parallel_sub_add_exchange =>
                  (intML.int_add bn tm,intML.int_sub tn bm)
             | Parallel_sub_16 =>
                  (intML.int_sub bn bm,intML.int_sub tn tm)
             | Parallel_add_8 => raise Fail "ARB"
             | Parallel_sub_8 => raise Fail "ARB"
        end

  fun signed_normal_add_sub_16 op2 rn rm =
        let val (r1,r2) = signed_parallel_add_sub_16 op2 rn rm
            val ge1 =
                if intML.int_ge r1 (intML.fromString"0i") then
                  n2w_itself ((fromString "3"),(ITSELF TWO))
                else n2w_itself (ZERO,(ITSELF TWO))
            val ge2 =
                if intML.int_ge r2 (intML.fromString"0i") then
                  n2w_itself ((fromString "3"),(ITSELF TWO))
                else n2w_itself (ZERO,(ITSELF TWO))
        in
           (word_concat_itself (ITSELF (fromString "32"))
              (intML.i2w_itself (r2,(ITSELF (fromString "16"))))
              (intML.i2w_itself (r1,(ITSELF (fromString "16")))),
            SOME(word_concat_itself (ITSELF (fromString "4")) ge2 ge1))
        end

  fun signed_saturating_add_sub_16 op2 rn rm =
        let val (r1,r2) = signed_parallel_add_sub_16 op2 rn rm
        in
           (word_concat_itself (ITSELF (fromString "32"))
              (signed_sat_itself
                 (r2,((fromString "16"),(ITSELF (fromString "16")))))
              (signed_sat_itself
                 (r1,((fromString "16"),(ITSELF (fromString "16"))))),
            optionML.NONE)
        end

  fun signed_halving_add_sub_16 op2 rn rm =
        let val (r1,r2) = signed_parallel_add_sub_16 op2 rn rm
        in
           (word_concat_itself (ITSELF (fromString "32"))
              (intML.i2w_itself
                 (intML.int_div r2 (intML.int_of_num TWO),
                  (ITSELF (fromString "16"))))
              (intML.i2w_itself
                 (intML.int_div r1 (intML.int_of_num TWO),
                  (ITSELF (fromString "16")))),optionML.NONE)
        end

  fun signed_parallel_add_sub_8 op2 rn rm =
        let val n = listML.MAP intML.w2i (bytes (rn,(fromString "4")))
            val m = listML.MAP intML.w2i (bytes (rm,(fromString "4")))
        in
           case op2
            of Parallel_add_16 => raise Fail "ARB"
             | Parallel_add_sub_exchange => raise Fail "ARB"
             | Parallel_sub_add_exchange => raise Fail "ARB"
             | Parallel_sub_16 => raise Fail "ARB"
             | Parallel_add_8 =>
                  listML.MAP (pairML.UNCURRY intML.int_add)
                    (listML.ZIP (n,m))
             | Parallel_sub_8 =>
                  listML.MAP (pairML.UNCURRY intML.int_sub)
                    (listML.ZIP (n,m))
        end

  fun signed_normal_add_sub_8 op2 rn rm =
        let val r = signed_parallel_add_sub_8 op2 rn rm
            val ge =
                word_modify (fn i => fn b =>
                  intML.int_ge (listML.EL i r) (intML.fromString"0i"))
                  (n2w_itself (ZERO,(ITSELF (fromString "4"))))
        in
           (word32 (listML.MAP i2w r),SOME(ge))
        end

  fun signed_saturating_add_sub_8 op2 rn rm =
        (word32
           (listML.MAP (fn i =>
              signed_sat_itself
                (i,((fromString "8"),(ITSELF (fromString "8")))))
              (signed_parallel_add_sub_8 op2 rn rm)),optionML.NONE)

  fun signed_halving_add_sub_8 op2 rn rm =
        (word32
           (listML.MAP (fn i =>
              intML.i2w_itself
                (intML.int_div i (intML.int_of_num TWO),
                 (ITSELF (fromString "8"))))
              (signed_parallel_add_sub_8 op2 rn rm)),optionML.NONE)

  fun unsigned_parallel_add_sub_16 op2 rn rm =
        let val bn =
                intML.int_of_num
                  (w2n
                     (word_extract_itself (ITSELF (fromString "16"))
                        (fromString "15") ZERO rn))
            val bm =
                intML.int_of_num
                  (w2n
                     (word_extract_itself (ITSELF (fromString "16"))
                        (fromString "15") ZERO rm))
            val tn =
                intML.int_of_num
                  (w2n
                     (word_extract_itself (ITSELF (fromString "16"))
                        (fromString "31") (fromString "16") rn))
            val tm =
                intML.int_of_num
                  (w2n
                     (word_extract_itself (ITSELF (fromString "16"))
                        (fromString "31") (fromString "16") rm))
        in
           case op2
            of Parallel_add_16 =>
                  (intML.int_add bn bm,intML.int_add tn tm)
             | Parallel_add_sub_exchange =>
                  (intML.int_sub bn tm,intML.int_add tn bm)
             | Parallel_sub_add_exchange =>
                  (intML.int_add bn tm,intML.int_sub tn bm)
             | Parallel_sub_16 =>
                  (intML.int_sub bn bm,intML.int_sub tn tm)
             | Parallel_add_8 => raise Fail "ARB"
             | Parallel_sub_8 => raise Fail "ARB"
        end

  fun unsigned_normal_add_sub_16 op2 rn rm =
        let val (r1,r2) = unsigned_parallel_add_sub_16 op2 rn rm
            val (ge1,ge2) =
                case op2
                 of Parallel_add_16 =>
                       (if
                          intML.int_ge r1
                            (intML.int_of_num (fromString "65536"))
                        then n2w_itself ((fromString "3"),(ITSELF TWO))
                        else n2w_itself (ZERO,(ITSELF TWO)),
                        if
                          intML.int_ge r2
                            (intML.int_of_num (fromString "65536"))
                        then n2w_itself ((fromString "3"),(ITSELF TWO))
                        else n2w_itself (ZERO,(ITSELF TWO)))
                  | Parallel_add_sub_exchange =>
                       (if intML.int_ge r1 (intML.fromString"0i") then
                          n2w_itself ((fromString "3"),(ITSELF TWO))
                        else n2w_itself (ZERO,(ITSELF TWO)),
                        if
                          intML.int_ge r2
                            (intML.int_of_num (fromString "65536"))
                        then n2w_itself ((fromString "3"),(ITSELF TWO))
                        else n2w_itself (ZERO,(ITSELF TWO)))
                  | Parallel_sub_add_exchange =>
                       (if
                          intML.int_ge r1
                            (intML.int_of_num (fromString "65536"))
                        then n2w_itself ((fromString "3"),(ITSELF TWO))
                        else n2w_itself (ZERO,(ITSELF TWO)),
                        if intML.int_ge r2 (intML.fromString"0i") then
                          n2w_itself ((fromString "3"),(ITSELF TWO))
                        else n2w_itself (ZERO,(ITSELF TWO)))
                  | Parallel_sub_16 =>
                       (if intML.int_ge r1 (intML.fromString"0i") then
                          n2w_itself ((fromString "3"),(ITSELF TWO))
                        else n2w_itself (ZERO,(ITSELF TWO)),
                        if intML.int_ge r2 (intML.fromString"0i") then
                          n2w_itself ((fromString "3"),(ITSELF TWO))
                        else n2w_itself (ZERO,(ITSELF TWO)))
                  | Parallel_add_8 => raise Fail "ARB"
                  | Parallel_sub_8 => raise Fail "ARB"
        in
           (word_concat_itself (ITSELF (fromString "32"))
              (intML.i2w_itself (r2,(ITSELF (fromString "16"))))
              (intML.i2w_itself (r1,(ITSELF (fromString "16")))),
            SOME(word_concat_itself (ITSELF (fromString "4")) ge2 ge1))
        end

  fun unsigned_saturating_add_sub_16 op2 rn rm =
        let val (r1,r2) = unsigned_parallel_add_sub_16 op2 rn rm
        in
           (word_concat_itself (ITSELF (fromString "32"))
              (unsigned_sat_itself
                 (r2,((fromString "16"),(ITSELF (fromString "16")))))
              (unsigned_sat_itself
                 (r1,((fromString "16"),(ITSELF (fromString "16"))))),
            optionML.NONE)
        end

  fun unsigned_halving_add_sub_16 op2 rn rm =
        let val (r1,r2) = unsigned_parallel_add_sub_16 op2 rn rm
        in
           (word_concat_itself (ITSELF (fromString "32"))
              (intML.i2w_itself
                 (intML.int_div r2 (intML.int_of_num TWO),
                  (ITSELF (fromString "16"))))
              (intML.i2w_itself
                 (intML.int_div r1 (intML.int_of_num TWO),
                  (ITSELF (fromString "16")))),optionML.NONE)
        end

  fun unsigned_parallel_add_sub_8 op2 rn rm =
        let val n =
                listML.MAP (fn w => intML.int_of_num (w2n w))
                  (bytes (rn,(fromString "4")))
            val m =
                listML.MAP (fn w => intML.int_of_num (w2n w))
                  (bytes (rm,(fromString "4")))
        in
           case op2
            of Parallel_add_16 => raise Fail "ARB"
             | Parallel_add_sub_exchange => raise Fail "ARB"
             | Parallel_sub_add_exchange => raise Fail "ARB"
             | Parallel_sub_16 => raise Fail "ARB"
             | Parallel_add_8 =>
                  listML.MAP (pairML.UNCURRY intML.int_add)
                    (listML.ZIP (n,m))
             | Parallel_sub_8 =>
                  listML.MAP (pairML.UNCURRY intML.int_sub)
                    (listML.ZIP (n,m))
        end

  fun unsigned_normal_add_sub_8 op2 rn rm =
        let val r = unsigned_parallel_add_sub_8 op2 rn rm
            val ge_lim =
                case op2
                 of Parallel_add_16 => raise Fail "ARB"
                  | Parallel_add_sub_exchange => raise Fail "ARB"
                  | Parallel_sub_add_exchange => raise Fail "ARB"
                  | Parallel_sub_16 => raise Fail "ARB"
                  | Parallel_add_8 =>
                       intML.int_of_num (fromString "256")
                  | Parallel_sub_8 => (intML.fromString"0i")
            val ge =
                word_modify (fn i => fn b =>
                  intML.int_ge (listML.EL i r) ge_lim)
                  (n2w_itself (ZERO,(ITSELF (fromString "4"))))
        in
           (word32 (listML.MAP i2w r),SOME(ge))
        end

  fun unsigned_saturating_add_sub_8 op2 rn rm =
        (word32
           (listML.MAP (fn i =>
              unsigned_sat_itself
                (i,((fromString "8"),(ITSELF (fromString "8")))))
              (unsigned_parallel_add_sub_8 op2 rn rm)),optionML.NONE)

  fun unsigned_halving_add_sub_8 op2 rn rm =
        (word32
           (listML.MAP (fn i =>
              intML.i2w_itself
                (intML.int_div i (intML.int_of_num TWO),
                 (ITSELF (fromString "8"))))
              (unsigned_parallel_add_sub_8 op2 rn rm)),optionML.NONE)

  fun parallel_add_sub u (op1,op2) rn rm =
        case (u,(op1,op2))
         of (true,(Parallel_normal,Parallel_add_16)) =>
               unsigned_normal_add_sub_16 op2 rn rm
          | (true,(Parallel_normal,Parallel_add_sub_exchange)) =>
               unsigned_normal_add_sub_16 op2 rn rm
          | (true,(Parallel_normal,Parallel_sub_add_exchange)) =>
               unsigned_normal_add_sub_16 op2 rn rm
          | (true,(Parallel_normal,Parallel_sub_16)) =>
               unsigned_normal_add_sub_16 op2 rn rm
          | (true,(Parallel_normal,Parallel_add_8)) =>
               unsigned_normal_add_sub_8 op2 rn rm
          | (true,(Parallel_normal,Parallel_sub_8)) =>
               unsigned_normal_add_sub_8 op2 rn rm
          | (true,(Parallel_saturating,Parallel_add_16)) =>
               unsigned_saturating_add_sub_16 op2 rn rm
          | (true,(Parallel_saturating,Parallel_add_sub_exchange)) =>
               unsigned_saturating_add_sub_16 op2 rn rm
          | (true,(Parallel_saturating,Parallel_sub_add_exchange)) =>
               unsigned_saturating_add_sub_16 op2 rn rm
          | (true,(Parallel_saturating,Parallel_sub_16)) =>
               unsigned_saturating_add_sub_16 op2 rn rm
          | (true,(Parallel_saturating,Parallel_add_8)) =>
               unsigned_saturating_add_sub_8 op2 rn rm
          | (true,(Parallel_saturating,Parallel_sub_8)) =>
               unsigned_saturating_add_sub_8 op2 rn rm
          | (true,(Parallel_halving,Parallel_add_16)) =>
               unsigned_halving_add_sub_16 op2 rn rm
          | (true,(Parallel_halving,Parallel_add_sub_exchange)) =>
               unsigned_halving_add_sub_16 op2 rn rm
          | (true,(Parallel_halving,Parallel_sub_add_exchange)) =>
               unsigned_halving_add_sub_16 op2 rn rm
          | (true,(Parallel_halving,Parallel_sub_16)) =>
               unsigned_halving_add_sub_16 op2 rn rm
          | (true,(Parallel_halving,Parallel_add_8)) =>
               unsigned_halving_add_sub_8 op2 rn rm
          | (true,(Parallel_halving,Parallel_sub_8)) =>
               unsigned_halving_add_sub_8 op2 rn rm
          | (false,(Parallel_normal,Parallel_add_16)) =>
               signed_normal_add_sub_16 op2 rn rm
          | (false,(Parallel_normal,Parallel_add_sub_exchange)) =>
               signed_normal_add_sub_16 op2 rn rm
          | (false,(Parallel_normal,Parallel_sub_add_exchange)) =>
               signed_normal_add_sub_16 op2 rn rm
          | (false,(Parallel_normal,Parallel_sub_16)) =>
               signed_normal_add_sub_16 op2 rn rm
          | (false,(Parallel_normal,Parallel_add_8)) =>
               signed_normal_add_sub_8 op2 rn rm
          | (false,(Parallel_normal,Parallel_sub_8)) =>
               signed_normal_add_sub_8 op2 rn rm
          | (false,(Parallel_saturating,Parallel_add_16)) =>
               signed_saturating_add_sub_16 op2 rn rm
          | (false,(Parallel_saturating,Parallel_add_sub_exchange)) =>
               signed_saturating_add_sub_16 op2 rn rm
          | (false,(Parallel_saturating,Parallel_sub_add_exchange)) =>
               signed_saturating_add_sub_16 op2 rn rm
          | (false,(Parallel_saturating,Parallel_sub_16)) =>
               signed_saturating_add_sub_16 op2 rn rm
          | (false,(Parallel_saturating,Parallel_add_8)) =>
               signed_saturating_add_sub_8 op2 rn rm
          | (false,(Parallel_saturating,Parallel_sub_8)) =>
               signed_saturating_add_sub_8 op2 rn rm
          | (false,(Parallel_halving,Parallel_add_16)) =>
               signed_halving_add_sub_16 op2 rn rm
          | (false,(Parallel_halving,Parallel_add_sub_exchange)) =>
               signed_halving_add_sub_16 op2 rn rm
          | (false,(Parallel_halving,Parallel_sub_add_exchange)) =>
               signed_halving_add_sub_16 op2 rn rm
          | (false,(Parallel_halving,Parallel_sub_16)) =>
               signed_halving_add_sub_16 op2 rn rm
          | (false,(Parallel_halving,Parallel_add_8)) =>
               signed_halving_add_sub_8 op2 rn rm
          | (false,(Parallel_halving,Parallel_sub_8)) =>
               signed_halving_add_sub_8 op2 rn rm

  fun barrier_option option =
        case word_eq option (n2w_itself (TWO,(ITSELF (fromString "4"))))
         of true => (MBReqDomain_OuterShareable,MBReqTypes_Writes)
          | false =>
               (case
                  word_eq option
                    (n2w_itself
                       ((fromString "3"),(ITSELF (fromString "4"))))
                of true => (MBReqDomain_OuterShareable,MBReqTypes_All)
                 | false =>
                      (case
                         word_eq option
                           (n2w_itself
                              ((fromString "6"),
                               (ITSELF (fromString "4"))))
                       of true =>
                             (MBReqDomain_Nonshareable,
                              MBReqTypes_Writes)
                        | false =>
                             (case
                                word_eq option
                                  (n2w_itself
                                     ((fromString "7"),
                                      (ITSELF (fromString "4"))))
                              of true =>
                                    (MBReqDomain_Nonshareable,
                                     MBReqTypes_All)
                               | false =>
                                    (case
                                       word_eq option
                                         (n2w_itself
                                            ((fromString "10"),
                                             (ITSELF (fromString "4"))))
                                     of true =>
                                           (MBReqDomain_InnerShareable,
                                            MBReqTypes_Writes)
                                      | false =>
                                           (case
                                              word_eq option
                                                (n2w_itself
                                                   ((fromString "11"),
                                                    (ITSELF
                                                      (fromString
                                                      "4"))))
                                            of true =>
                                                  (MBReqDomain_InnerShareable,
                                                   MBReqTypes_All)
                                             | false =>
                                                  (case
                                                     word_eq option
                                                       (n2w_itself
                                                          ((fromString
                                                           "14"),
                                                           (ITSELF
                                                             (fromString
                                                             "4"))))
                                                   of true =>
                                                         (MBReqDomain_FullSystem,
                                                          MBReqTypes_Writes)
                                                    | false =>
                                                         (MBReqDomain_FullSystem,
                                                          MBReqTypes_All)))))))

  fun exc_vector_base ii =
        seqT (read_sctlr ii) (fn sctlr => if CP15sctlr_V sctlr then
            constT
              (n2w_itself
                 ((fromString "4294901760"),(ITSELF (fromString "32"))))
          else
            seqT (have_security_ext ii) (fn have_security_ext =>
              if have_security_ext then read_vbar ii
              else
                constT (n2w_itself (ZERO,(ITSELF (fromString "32"))))))

  fun take_undef_instr_exception ii =
        seqT
          (parT
             (read_reg ii
                (n2w_itself
                   ((fromString "15"),(ITSELF (fromString "4")))))
             (parT (exc_vector_base ii)
                (parT (read_cpsr ii)
                   (parT (read_scr ii) (read_sctlr ii))))) (fn
          (pc,(ExcVectorBase,(cpsr,(scr,sctlr)))) =>
          seqT
            (parT
               (condT
                  (word_eq (ARMpsr_M cpsr)
                     (n2w_itself
                        ((fromString "22"),(ITSELF (fromString "5")))))
                  (write_scr ii
                     (CP15scr_NS_fupd (combinML.K false) scr)))
               (write_cpsr ii
                  (ARMpsr_M_fupd
                     (combinML.K
                        (n2w_itself
                           ((fromString "27"),
                            (ITSELF (fromString "5"))))) cpsr))) (fn
            (u1,u2) =>
            seqT
              (parT (write_spsr ii cpsr)
                 (parT
                    (write_reg ii
                       (n2w_itself
                          ((fromString "14"),(ITSELF (fromString "4"))))
                       (if ARMpsr_T cpsr then
                          word_sub pc
                            (n2w_itself
                               (TWO,(ITSELF (fromString "32"))))
                        else
                          word_sub pc
                            (n2w_itself
                               ((fromString "4"),
                                (ITSELF (fromString "32"))))))
                    (parT
                       (seqT (read_cpsr ii) (fn cpsr =>
                          write_cpsr ii
                            (ARMpsr_I_fupd (combinML.K true)
                               (ARMpsr_IT_fupd
                                  (combinML.K
                                     (n2w_itself
                                        (ZERO,
                                         (ITSELF (fromString "8")))))
                                  (ARMpsr_J_fupd (combinML.K false)
                                     (ARMpsr_T_fupd
                                        (combinML.K
                                           (CP15sctlr_TE sctlr))
                                        (ARMpsr_E_fupd
                                           (combinML.K
                                              (CP15sctlr_EE sctlr))
                                           cpsr)))))))
                       (branch_to ii
                          (word_add ExcVectorBase
                             (n2w_itself
                                ((fromString "4"),
                                 (ITSELF (fromString "32"))))))))) (fn
              (u1,(u2,(u3,u4))) => constT ())))

  fun take_svc_exception ii =
        seqT (IT_advance ii) (fn u =>
          seqT
            (parT
               (read_reg ii
                  (n2w_itself
                     ((fromString "15"),(ITSELF (fromString "4")))))
               (parT (exc_vector_base ii)
                  (parT (read_cpsr ii)
                     (parT (read_scr ii) (read_sctlr ii))))) (fn
            (pc,(ExcVectorBase,(cpsr,(scr,sctlr)))) =>
            seqT
              (parT
                 (condT
                    (word_eq (ARMpsr_M cpsr)
                       (n2w_itself
                          ((fromString "22"),
                           (ITSELF (fromString "5")))))
                    (write_scr ii
                       (CP15scr_NS_fupd (combinML.K false) scr)))
                 (write_cpsr ii
                    (ARMpsr_M_fupd
                       (combinML.K
                          (n2w_itself
                             ((fromString "19"),
                              (ITSELF (fromString "5"))))) cpsr))) (fn
              (u1,u2) =>
              seqT
                (parT (write_spsr ii cpsr)
                   (parT
                      (write_reg ii
                         (n2w_itself
                            ((fromString "14"),
                             (ITSELF (fromString "4"))))
                         (if ARMpsr_T cpsr then
                            word_sub pc
                              (n2w_itself
                                 (TWO,(ITSELF (fromString "32"))))
                          else
                            word_sub pc
                              (n2w_itself
                                 ((fromString "4"),
                                  (ITSELF (fromString "32"))))))
                      (parT
                         (seqT (read_cpsr ii) (fn cpsr =>
                            write_cpsr ii
                              (ARMpsr_I_fupd (combinML.K true)
                                 (ARMpsr_IT_fupd
                                    (combinML.K
                                       (n2w_itself
                                          (ZERO,
                                           (ITSELF (fromString "8")))))
                                    (ARMpsr_J_fupd (combinML.K false)
                                       (ARMpsr_T_fupd
                                          (combinML.K
                                             (CP15sctlr_TE sctlr))
                                          (ARMpsr_E_fupd
                                             (combinML.K
                                                (CP15sctlr_EE sctlr))
                                             cpsr)))))))
                         (branch_to ii
                            (word_add ExcVectorBase
                               (n2w_itself
                                  ((fromString "8"),
                                   (ITSELF (fromString "32"))))))))) (fn
                (u1,(u2,(u3,u4))) => constT ()))))

  fun take_smc_exception ii =
        seqT (IT_advance ii) (fn u =>
          seqT
            (parT
               (read_reg ii
                  (n2w_itself
                     ((fromString "15"),(ITSELF (fromString "4")))))
               (parT (read_mvbar ii)
                  (parT (read_cpsr ii)
                     (parT (read_scr ii) (read_sctlr ii))))) (fn
            (pc,(mvbar,(cpsr,(scr,sctlr)))) =>
            seqT
              (parT
                 (condT
                    (word_eq (ARMpsr_M cpsr)
                       (n2w_itself
                          ((fromString "22"),
                           (ITSELF (fromString "5")))))
                    (write_scr ii
                       (CP15scr_NS_fupd (combinML.K false) scr)))
                 (write_cpsr ii
                    (ARMpsr_M_fupd
                       (combinML.K
                          (n2w_itself
                             ((fromString "22"),
                              (ITSELF (fromString "5"))))) cpsr))) (fn
              (u1,u2) =>
              seqT
                (parT (write_spsr ii cpsr)
                   (parT
                      (write_reg ii
                         (n2w_itself
                            ((fromString "14"),
                             (ITSELF (fromString "4"))))
                         (if ARMpsr_T cpsr then
                            pc
                          else
                            word_sub pc
                              (n2w_itself
                                 ((fromString "4"),
                                  (ITSELF (fromString "32"))))))
                      (parT
                         (seqT (read_cpsr ii) (fn cpsr =>
                            write_cpsr ii
                              (ARMpsr_I_fupd (combinML.K true)
                                 (ARMpsr_F_fupd (combinML.K true)
                                    (ARMpsr_A_fupd (combinML.K true)
                                       (ARMpsr_IT_fupd
                                          (combinML.K
                                             (n2w_itself
                                                (ZERO,
                                                 (ITSELF
                                                   (fromString "8")))))
                                          (ARMpsr_J_fupd
                                             (combinML.K false)
                                             (ARMpsr_T_fupd
                                                (combinML.K
                                                   (CP15sctlr_TE sctlr))
                                                (ARMpsr_E_fupd
                                                   (combinML.K
                                                      (CP15sctlr_EE
                                                         sctlr))
                                                   cpsr)))))))))
                         (branch_to ii
                            (word_add mvbar
                               (n2w_itself
                                  ((fromString "8"),
                                   (ITSELF (fromString "32"))))))))) (fn
                (u1,(u2,(u3,u4))) => constT ()))))

  fun take_prefetch_abort_exception ii =
        seqT
          (parT
             (read_reg ii
                (n2w_itself
                   ((fromString "15"),(ITSELF (fromString "4")))))
             (parT (exc_vector_base ii)
                (parT (have_security_ext ii)
                   (parT (read_cpsr ii)
                      (parT (read_scr ii) (read_sctlr ii)))))) (fn
          (pc,(ExcVectorBase,(have_security_ext,(cpsr,(scr,sctlr))))) =>
          seqT
            (parT
               (condT
                  (word_eq (ARMpsr_M cpsr)
                     (n2w_itself
                        ((fromString "22"),(ITSELF (fromString "5")))))
                  (write_scr ii
                     (CP15scr_NS_fupd (combinML.K false) scr)))
               (write_cpsr ii
                  (ARMpsr_M_fupd
                     (combinML.K
                        (n2w_itself
                           ((fromString "23"),
                            (ITSELF (fromString "5"))))) cpsr))) (fn
            (u1,u2) =>
            seqT
              (parT (write_spsr ii cpsr)
                 (parT
                    (write_reg ii
                       (n2w_itself
                          ((fromString "14"),(ITSELF (fromString "4"))))
                       (if ARMpsr_T cpsr then
                          pc
                        else
                          word_sub pc
                            (n2w_itself
                               ((fromString "4"),
                                (ITSELF (fromString "32"))))))
                    (parT
                       (seqT (read_cpsr ii) (fn cpsr =>
                          write_cpsr ii
                            (ARMpsr_I_fupd (combinML.K true)
                               (ARMpsr_A_fupd
                                  (combinML.K
                                     ((not have_security_ext orelse
                                       (not (CP15scr_NS scr) orelse
                                        CP15scr_AW scr)) orelse
                                      ARMpsr_A cpsr))
                                  (ARMpsr_IT_fupd
                                     (combinML.K
                                        (n2w_itself
                                           (ZERO,
                                            (ITSELF (fromString "8")))))
                                     (ARMpsr_J_fupd (combinML.K false)
                                        (ARMpsr_T_fupd
                                           (combinML.K
                                              (CP15sctlr_TE sctlr))
                                           (ARMpsr_E_fupd
                                              (combinML.K
                                                 (CP15sctlr_EE sctlr))
                                              cpsr))))))))
                       (branch_to ii
                          (word_add ExcVectorBase
                             (n2w_itself
                                ((fromString "12"),
                                 (ITSELF (fromString "32"))))))))) (fn
              (u1,(u2,(u3,u4))) => constT ())))

  fun integer_zero_divide_trapping_enabled ii =
        seqT (read_sctlr ii) (fn sctlr => constT (CP15sctlr_DZ sctlr))

  fun null_check_if_thumbEE ii n f =
        seqT (current_instr_set ii) (fn iset =>
          if iset = InstrSet_ThumbEE then
            seqT (read_reg ii n) (fn rn =>
              if
                word_eq n
                  (n2w_itself
                     ((fromString "15"),(ITSELF (fromString "4"))))
              then
                (if
                   word_eq (align (rn,(fromString "4")))
                     (n2w_itself (ZERO,(ITSELF (fromString "32"))))
                 then
                   errorT "null_check_if_thumbEE PC: unpredictable"
                 else f)
              else
                if
                  word_eq n
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                then
                (if
                   word_eq rn
                     (n2w_itself (ZERO,(ITSELF (fromString "32"))))
                 then
                   errorT "null_check_if_thumbEE SP: unpredictable"
                 else f)
              else
                if
                  word_eq rn
                    (n2w_itself (ZERO,(ITSELF (fromString "32"))))
                then
                seqT
                  (parT
                     (read_reg ii
                        (n2w_itself
                           ((fromString "15"),
                            (ITSELF (fromString "4")))))
                     (parT (read_cpsr ii) (read_teehbr ii))) (fn
                  (pc,(cpsr,teehbr)) =>
                  seqT
                    (parT
                       (write_reg ii
                          (n2w_itself
                             ((fromString "14"),
                              (ITSELF (fromString "4"))))
                          (word_modify (fn i => fn b => if i = ZERO then
                               true else b) pc))
                       (write_cpsr ii
                          (ARMpsr_IT_fupd
                             (combinML.K
                                (n2w_itself
                                   (ZERO,(ITSELF (fromString "8")))))
                             cpsr))) (fn (u1,u2) =>
                    branch_write_pc ii
                      (word_sub teehbr
                         (n2w_itself
                            ((fromString "4"),
                             (ITSELF (fromString "32")))))))
              else f) else f)

  fun branch_target_instr ii enc (Branch_Target(imm24)) =
        seqT (read_info ii) (fn info =>
          seqT
            (read_reg ii
               (n2w_itself
                  ((fromString "15"),(ITSELF (fromString "4"))))) (fn pc
            =>
            let val imm32 =
                    word_lsl
                      (sw2sw_itself (ITSELF (fromString "32")) imm24)
                      (if enc = Encoding_ARM then TWO else ONE)
            in
               branch_write_pc ii (word_add pc imm32)
            end))

  fun branch_exchange_instr ii (Branch_Exchange(m)) =
        seqT (read_info ii) (fn info =>
          if ARMinfo_arch info = ARMv4 then
            take_undef_instr_exception ii
          else seqT (read_reg ii m) (fn rm => bx_write_pc ii rm))

  fun branch_link_exchange_imm_instr ii enc
        (Branch_Link_Exchange_Immediate(H,toARM,imm24)) =
        seqT (read_info ii) (fn info =>
          if
            ((enc = Encoding_Thumb2) andalso toARM orelse
             (enc = Encoding_ARM) andalso not toARM) andalso
            < (version_number (ARMinfo_arch info)) (fromString "5")
          then take_undef_instr_exception ii
          else
            seqT (current_instr_set ii) (fn CurrentInstrSet =>
              if toARM andalso (CurrentInstrSet = InstrSet_ThumbEE) then
                take_undef_instr_exception ii
              else
                let val targetInstrSet =
                        if toARM then
                          InstrSet_ARM
                        else
                          if enc = Encoding_ARM then
                          InstrSet_Thumb
                        else CurrentInstrSet
                    val imm32 =
                        word_lsl
                          (sw2sw_itself (ITSELF (fromString "32"))
                             imm24) TWO
                    val imm32 =
                        if toARM then
                          imm32
                        else
                          word_modify (fn i => fn b => if i = ONE then H
                            else b) imm32
                in
                   seqT
                     (read_reg ii
                        (n2w_itself
                           ((fromString "15"),
                            (ITSELF (fromString "4"))))) (fn pc =>
                     seqT
                       (if CurrentInstrSet = InstrSet_ARM then
                          write_reg ii
                            (n2w_itself
                               ((fromString "14"),
                                (ITSELF (fromString "4"))))
                            (word_sub pc
                               (n2w_itself
                                  ((fromString "4"),
                                   (ITSELF (fromString "32")))))
                        else
                          write_reg ii
                            (n2w_itself
                               ((fromString "14"),
                                (ITSELF (fromString "4"))))
                            (word_modify (fn i => fn b =>
                               if i = ZERO then true else b) pc)) (fn u
                       =>
                       let val targetAddress =
                               if targetInstrSet = InstrSet_ARM then
                                 word_add (align (pc,(fromString "4")))
                                   imm32
                               else word_add pc imm32
                       in
                          seqT (select_instr_set ii targetInstrSet) (fn
                            u => branch_write_pc ii targetAddress)
                       end))
                end))

  fun branch_link_exchange_reg_instr ii
        (Branch_Link_Exchange_Register(m)) =
        seqT (read_info ii) (fn info =>
          if
            < (version_number (ARMinfo_arch info)) (fromString "5")
          then take_undef_instr_exception ii
          else
            seqT
              (parT
                 (read_reg ii
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 (parT (read_reg ii m) (current_instr_set ii))) (fn
              (pc,(rm,iset)) =>
              let val next_instr_addr =
                      if iset = InstrSet_ARM then
                        word_sub pc
                          (n2w_itself
                             ((fromString "4"),
                              (ITSELF (fromString "32"))))
                      else
                        word_sub pc
                          (n2w_itself (TWO,(ITSELF (fromString "32"))))
              in
                 seqT
                   (if iset = InstrSet_ARM then
                      write_reg ii
                        (n2w_itself
                           ((fromString "14"),
                            (ITSELF (fromString "4")))) next_instr_addr
                    else
                      write_reg ii
                        (n2w_itself
                           ((fromString "14"),
                            (ITSELF (fromString "4"))))
                        (word_modify (fn i => fn b => if i = ZERO then
                             true else b) next_instr_addr)) (fn u =>
                   bx_write_pc ii rm)
              end))

  fun compare_branch_instr ii (Compare_Branch(nonzero,imm6,n)) =
        seqT (read_info ii) (fn info =>
          if
            not (ARMinfo_arch info = ARMv6T2) andalso
            < (version_number (ARMinfo_arch info)) (fromString "7")
          then take_undef_instr_exception ii
          else
            seqT (read_reg ii (w2w_itself (ITSELF (fromString "4")) n))
              (fn rn =>
              if
                not
                  (nonzero =
                   word_eq rn
                     (n2w_itself (ZERO,(ITSELF (fromString "32")))))
              then
                seqT
                  (read_reg ii
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  (fn pc =>
                  let val imm32 =
                          word_lsl
                            (w2w_itself (ITSELF (fromString "32")) imm6)
                            ONE
                  in
                     branch_write_pc ii (word_add pc imm32)
                  end) else increment_pc ii Encoding_Thumb))

  fun table_branch_byte_instr ii (Table_Branch_Byte(n,is_tbh,m)) =
        seqT (read_info ii) (fn info =>
          if
            not (ARMinfo_arch info = ARMv6T2) andalso
            < (version_number (ARMinfo_arch info)) (fromString "7")
          then take_undef_instr_exception ii
          else
            if
              word_eq n
                (n2w_itself
                   ((fromString "13"),(ITSELF (fromString "4")))) orelse
              (word_eq m
                 (n2w_itself
                    ((fromString "13"),(ITSELF (fromString "4"))))
               orelse
               word_eq m
                 (n2w_itself
                    ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "table_branch_byte: unpredictable"
          else
            null_check_if_thumbEE ii n
              (seqT
                 (parT
                    (read_reg ii
                       (n2w_itself
                          ((fromString "15"),
                           (ITSELF (fromString "4")))))
                    (parT (read_reg ii n) (read_reg ii m))) (fn
                 (pc,(rn,rm)) =>
                 seqT
                   (if is_tbh then
                      read_memU ii (word_add rn (LSL (rm,ONE)),TWO)
                    else read_memU ii (word_add rn rm,ONE)) (fn
                   halfwords =>
                   branch_write_pc ii
                     (word_add pc
                        (word_mul
                           (n2w_itself (TWO,(ITSELF (fromString "32"))))
                           (zero_extend32 halfwords)))))))

  fun check_array_instr ii (Check_Array(n,m)) =
        seqT (read_info ii) (fn info =>
          if
            not (ARMinfo_arch info = ARMv7_A) andalso
            (not (ARMinfo_arch info = ARMv7_R) orelse
             not (IN Extension_ThumbEE (ARMinfo_extensions info)))
          then take_undef_instr_exception ii
          else
            if
              word_eq n
                (n2w_itself
                   ((fromString "15"),(ITSELF (fromString "4")))) orelse
              (word_eq m
                 (n2w_itself
                    ((fromString "13"),(ITSELF (fromString "4"))))
               orelse
               word_eq m
                 (n2w_itself
                    ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "check_array: unpredictable"
          else
            seqT
              (parT
                 (read_reg ii
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 (parT (read_reg ii n)
                    (parT (read_reg ii m)
                       (parT (read_cpsr ii) (read_teehbr ii))))) (fn
              (pc,(rn,(rm,(cpsr,teehbr)))) => if word_ls rn rm then
                seqT
                  (parT
                     (write_reg ii
                        (n2w_itself
                           ((fromString "14"),
                            (ITSELF (fromString "4"))))
                        (word_modify (fn i => fn b => if i = ZERO then
                             true else b) pc))
                     (write_cpsr ii
                        (ARMpsr_IT_fupd
                           (combinML.K
                              (n2w_itself
                                 (ZERO,(ITSELF (fromString "8")))))
                           cpsr))) (fn (u1,u2) =>
                  branch_write_pc ii
                    (word_sub teehbr
                       (n2w_itself
                          ((fromString "8"),
                           (ITSELF (fromString "32"))))))
              else increment_pc ii Encoding_ThumbEE))

  fun handler_branch_link_instr ii
        (Handler_Branch_Link(generate_link,handler)) =
        seqT (read_info ii) (fn info =>
          if
            not (ARMinfo_arch info = ARMv7_A) andalso
            (not (ARMinfo_arch info = ARMv7_R) orelse
             not (IN Extension_ThumbEE (ARMinfo_extensions info)))
          then take_undef_instr_exception ii
          else
            seqT
              (parT
                 (read_reg ii
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 (read_teehbr ii)) (fn (pc,teehbr) =>
              let val handler_offset =
                      word_lsl
                        (w2w_itself (ITSELF (fromString "32")) handler)
                        (fromString "5")
              in
                 seqT
                   (if generate_link then
                      let val next_instr_addr =
                              word_sub pc
                                (n2w_itself
                                   (TWO,(ITSELF (fromString "32"))))
                      in
                         write_reg ii
                           (n2w_itself
                              ((fromString "14"),
                               (ITSELF (fromString "4"))))
                           (word_modify (fn i => fn b =>
                              if i = ZERO then true else b)
                              next_instr_addr)
                      end
                    else constT ()) (fn u =>
                   branch_write_pc ii (word_add teehbr handler_offset))
              end))

  fun handler_branch_link_parameter_instr ii
        (Handler_Branch_Link_Parameter(imm5,handler)) =
        seqT (read_info ii) (fn info =>
          if
            not (ARMinfo_arch info = ARMv7_A) andalso
            (not (ARMinfo_arch info = ARMv7_R) orelse
             not (IN Extension_ThumbEE (ARMinfo_extensions info)))
          then take_undef_instr_exception ii
          else
            seqT
              (parT
                 (read_reg ii
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 (read_teehbr ii)) (fn (pc,teehbr) =>
              let val next_instr_addr =
                      word_sub pc
                        (n2w_itself (TWO,(ITSELF (fromString "32"))))
                  val handler_offset =
                      word_lsl
                        (w2w_itself (ITSELF (fromString "32")) handler)
                        (fromString "5")
              in
                 seqT
                   (parT
                      (write_reg ii
                         (n2w_itself
                            ((fromString "8"),
                             (ITSELF (fromString "4"))))
                         (w2w_itself (ITSELF (fromString "32")) imm5))
                      (write_reg ii
                         (n2w_itself
                            ((fromString "14"),
                             (ITSELF (fromString "4"))))
                         (word_modify (fn i => fn b => if i = ZERO then
                              true else b) next_instr_addr))) (fn
                   (u1,u2) =>
                   branch_write_pc ii (word_add teehbr handler_offset))
              end))

  fun handler_branch_parameter_instr ii
        (Handler_Branch_Parameter(imm3,handler)) =
        seqT (read_info ii) (fn info =>
          if
            not (ARMinfo_arch info = ARMv7_A) andalso
            (not (ARMinfo_arch info = ARMv7_R) orelse
             not (IN Extension_ThumbEE (ARMinfo_extensions info)))
          then take_undef_instr_exception ii
          else
            seqT (read_teehbr ii) (fn teehbr =>
              let val handler_offset =
                      word_lsl
                        (w2w_itself (ITSELF (fromString "32")) handler)
                        (fromString "5")
              in
                 seqT
                   (write_reg ii
                      (n2w_itself
                         ((fromString "8"),(ITSELF (fromString "4"))))
                      (w2w_itself (ITSELF (fromString "32")) imm3)) (fn
                   u =>
                   branch_write_pc ii (word_add teehbr handler_offset))
              end))

  fun enterx_leavex_instr ii is_enterx =
        seqT (read_info ii) (fn info =>
          if
            not (ARMinfo_arch info = ARMv7_A) andalso
            (not (ARMinfo_arch info = ARMv7_R) orelse
             not (IN Extension_ThumbEE (ARMinfo_extensions info)))
          then take_undef_instr_exception ii
          else
            seqT
              (if is_enterx then
                 select_instr_set ii InstrSet_ThumbEE
               else select_instr_set ii InstrSet_Thumb) (fn u =>
              increment_pc ii Encoding_Thumb2))

  fun if_then_instr ii (If_Then(firstcond,mask)) =
        seqT (read_info ii) (fn info =>
          if
            not (ARMinfo_arch info = ARMv6T2) andalso
            < (version_number (ARMinfo_arch info)) (fromString "7")
          then take_undef_instr_exception ii
          else
            if
              word_eq mask (n2w_itself (ZERO,(ITSELF (fromString "4"))))
              orelse
              (word_eq firstcond
                 (n2w_itself
                    ((fromString "15"),(ITSELF (fromString "4"))))
               orelse
               word_eq firstcond
                 (n2w_itself
                    ((fromString "14"),(ITSELF (fromString "4"))))
               andalso not (bit_count mask = ONE))
            then
            errorT "if_then: unpredictable"
          else
            seqT (read_cpsr ii) (fn cpsr =>
              seqT
                (parT (increment_pc ii Encoding_Thumb)
                   (write_cpsr ii
                      (ARMpsr_IT_fupd
                         (combinML.K
                            (word_concat_itself
                               (ITSELF (fromString "8")) firstcond
                               mask)) cpsr))) (fn (u1,u2) =>
                constT ())))

  fun count_leading_zeroes_instr ii enc (Count_Leading_Zeroes(d,m)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "5"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 (word_eq m
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq m
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq m
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "count_leading_zeroes: unpredictable"
          else
            seqT (read_reg ii m) (fn rm =>
              seqT
                (parT (increment_pc ii enc)
                   (write_reg ii d
                      (n2w_itself
                         (count_leading_zeroes rm,
                          (ITSELF (fromString "32")))))) (fn (u1,u2) =>
                constT ())))

  fun move_halfword_instr ii enc (Move_Halfword(high,d,imm16)) =
        seqT (read_info ii) (fn info =>
          if
            not (ARMinfo_arch info = ARMv6T2) andalso
            < (version_number (ARMinfo_arch info)) (fromString "7")
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 word_eq d
                   (n2w_itself
                      ((fromString "13"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "move_halfword: unpredictable"
          else
            seqT
              (if high then
                 seqT (read_reg ii d) (fn rd =>
                   constT
                     (word_concat_itself (ITSELF (fromString "32"))
                        imm16
                        (word_extract_itself (ITSELF (fromString "16"))
                           (fromString "15") ZERO rd)))
               else
                 constT (w2w_itself (ITSELF (fromString "32")) imm16))
              (fn result =>
              seqT (parT (increment_pc ii enc) (write_reg ii d result))
                (fn (u1,u2) => constT ())))

  fun add_sub_instr ii enc (Add_Sub(add,n,d,imm12)) =
        seqT (read_info ii) (fn info =>
          if
            (enc = Encoding_Thumb2) andalso
            (not (ARMinfo_arch info = ARMv6T2) andalso
             < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              (enc = Encoding_Thumb2) andalso
              (if
                 word_eq n
                   (n2w_itself
                      ((fromString "13"),(ITSELF (fromString "4"))))
               then
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "13"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "add_sub: unpredictable"
          else
            seqT
              (parT (read_reg_literal ii n)
                 (if enc = Encoding_ARM then
                    arm_expand_imm ii imm12
                  else
                    constT
                      (w2w_itself (ITSELF (fromString "32")) imm12)))
              (fn (rn,imm32) =>
              let val result =
                      if add then
                        word_add rn imm32
                      else word_sub rn imm32
              in
                 if
                   word_eq d
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))
                 then
                alu_write_pc ii result
              else
                seqT
                  (parT (increment_pc ii enc) (write_reg ii d result))
                  (fn (u1,u2) => constT ())
              end))

  fun data_processing_instr ii enc
        (Data_Processing(opc,setflags,n,d,mode1)) =
        if
          word_eq opc (n2w_itself (ZERO,(ITSELF (fromString "4"))))
        then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     (ZERO,(ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val result = word_and rn shifted
                in
                   seqT
                     (parT
                        (if
                           word_eq d
                             (n2w_itself
                                ((fromString "15"),
                                 (ITSELF (fromString "4"))))
                         then
                           (if setflags then
                              seqT (read_spsr ii) (fn spsr =>
                                seqT
                                  (cpsr_write_by_instr ii
                                     (encode_psr spsr,
                                      (n2w_itself
                                         ((fromString "15"),
                                          (ITSELF (fromString "4"))),
                                       true))) (fn u =>
                                  branch_write_pc ii result))
                            else alu_write_pc ii result)
                         else
                           seqT
                             (parT (increment_pc ii enc)
                                (write_reg ii d result)) (fn (u1,u2) =>
                             constT ()))
                        (if
                           setflags andalso
                           not
                             (word_eq d
                                (n2w_itself
                                   ((fromString "15"),
                                    (ITSELF (fromString "4")))))
                         then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_shift,V)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc (n2w_itself (ONE,(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     (ONE,(ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val result = word_xor rn shifted
                in
                   seqT
                     (parT
                        (if
                           word_eq d
                             (n2w_itself
                                ((fromString "15"),
                                 (ITSELF (fromString "4"))))
                         then
                           (if setflags then
                              seqT (read_spsr ii) (fn spsr =>
                                seqT
                                  (cpsr_write_by_instr ii
                                     (encode_psr spsr,
                                      (n2w_itself
                                         ((fromString "15"),
                                          (ITSELF (fromString "4"))),
                                       true))) (fn u =>
                                  branch_write_pc ii result))
                            else alu_write_pc ii result)
                         else
                           seqT
                             (parT (increment_pc ii enc)
                                (write_reg ii d result)) (fn (u1,u2) =>
                             constT ()))
                        (if
                           setflags andalso
                           not
                             (word_eq d
                                (n2w_itself
                                   ((fromString "15"),
                                    (ITSELF (fromString "4")))))
                         then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_shift,V)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc (n2w_itself (TWO,(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     (TWO,(ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) =>
                       word_eq n
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) andalso
                       not setflags
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val (result,(C_alu,V_alu)) =
                        add_with_carry (rn,(word_1comp shifted,true))
                in
                   seqT
                     (parT
                        (if
                           word_eq d
                             (n2w_itself
                                ((fromString "15"),
                                 (ITSELF (fromString "4"))))
                         then
                           (if setflags then
                              seqT (read_spsr ii) (fn spsr =>
                                seqT
                                  (cpsr_write_by_instr ii
                                     (encode_psr spsr,
                                      (n2w_itself
                                         ((fromString "15"),
                                          (ITSELF (fromString "4"))),
                                       true))) (fn u =>
                                  branch_write_pc ii result))
                            else alu_write_pc ii result)
                         else
                           seqT
                             (parT (increment_pc ii enc)
                                (write_reg ii d result)) (fn (u1,u2) =>
                             constT ()))
                        (if
                           setflags andalso
                           not
                             (word_eq d
                                (n2w_itself
                                   ((fromString "15"),
                                    (ITSELF (fromString "4")))))
                         then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_alu,V_alu)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc
              (n2w_itself ((fromString "3"),(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     ((fromString "3"),
                                      (ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val (result,(C_alu,V_alu)) =
                        add_with_carry (word_1comp rn,(shifted,true))
                in
                   seqT
                     (parT
                        (if
                           word_eq d
                             (n2w_itself
                                ((fromString "15"),
                                 (ITSELF (fromString "4"))))
                         then
                           (if setflags then
                              seqT (read_spsr ii) (fn spsr =>
                                seqT
                                  (cpsr_write_by_instr ii
                                     (encode_psr spsr,
                                      (n2w_itself
                                         ((fromString "15"),
                                          (ITSELF (fromString "4"))),
                                       true))) (fn u =>
                                  branch_write_pc ii result))
                            else alu_write_pc ii result)
                         else
                           seqT
                             (parT (increment_pc ii enc)
                                (write_reg ii d result)) (fn (u1,u2) =>
                             constT ()))
                        (if
                           setflags andalso
                           not
                             (word_eq d
                                (n2w_itself
                                   ((fromString "15"),
                                    (ITSELF (fromString "4")))))
                         then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_alu,V_alu)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc
              (n2w_itself ((fromString "4"),(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     ((fromString "4"),
                                      (ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) =>
                       word_eq n
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) andalso
                       not setflags
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val (result,(C_alu,V_alu)) =
                        add_with_carry (rn,(shifted,false))
                in
                   seqT
                     (parT
                        (if
                           word_eq d
                             (n2w_itself
                                ((fromString "15"),
                                 (ITSELF (fromString "4"))))
                         then
                           (if setflags then
                              seqT (read_spsr ii) (fn spsr =>
                                seqT
                                  (cpsr_write_by_instr ii
                                     (encode_psr spsr,
                                      (n2w_itself
                                         ((fromString "15"),
                                          (ITSELF (fromString "4"))),
                                       true))) (fn u =>
                                  branch_write_pc ii result))
                            else alu_write_pc ii result)
                         else
                           seqT
                             (parT (increment_pc ii enc)
                                (write_reg ii d result)) (fn (u1,u2) =>
                             constT ()))
                        (if
                           setflags andalso
                           not
                             (word_eq d
                                (n2w_itself
                                   ((fromString "15"),
                                    (ITSELF (fromString "4")))))
                         then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_alu,V_alu)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc
              (n2w_itself ((fromString "5"),(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     ((fromString "5"),
                                      (ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val (result,(C_alu,V_alu)) =
                        add_with_carry (rn,(shifted,C))
                in
                   seqT
                     (parT
                        (if
                           word_eq d
                             (n2w_itself
                                ((fromString "15"),
                                 (ITSELF (fromString "4"))))
                         then
                           (if setflags then
                              seqT (read_spsr ii) (fn spsr =>
                                seqT
                                  (cpsr_write_by_instr ii
                                     (encode_psr spsr,
                                      (n2w_itself
                                         ((fromString "15"),
                                          (ITSELF (fromString "4"))),
                                       true))) (fn u =>
                                  branch_write_pc ii result))
                            else alu_write_pc ii result)
                         else
                           seqT
                             (parT (increment_pc ii enc)
                                (write_reg ii d result)) (fn (u1,u2) =>
                             constT ()))
                        (if
                           setflags andalso
                           not
                             (word_eq d
                                (n2w_itself
                                   ((fromString "15"),
                                    (ITSELF (fromString "4")))))
                         then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_alu,V_alu)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc
              (n2w_itself ((fromString "6"),(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     ((fromString "6"),
                                      (ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val (result,(C_alu,V_alu)) =
                        add_with_carry (rn,(word_1comp shifted,C))
                in
                   seqT
                     (parT
                        (if
                           word_eq d
                             (n2w_itself
                                ((fromString "15"),
                                 (ITSELF (fromString "4"))))
                         then
                           (if setflags then
                              seqT (read_spsr ii) (fn spsr =>
                                seqT
                                  (cpsr_write_by_instr ii
                                     (encode_psr spsr,
                                      (n2w_itself
                                         ((fromString "15"),
                                          (ITSELF (fromString "4"))),
                                       true))) (fn u =>
                                  branch_write_pc ii result))
                            else alu_write_pc ii result)
                         else
                           seqT
                             (parT (increment_pc ii enc)
                                (write_reg ii d result)) (fn (u1,u2) =>
                             constT ()))
                        (if
                           setflags andalso
                           not
                             (word_eq d
                                (n2w_itself
                                   ((fromString "15"),
                                    (ITSELF (fromString "4")))))
                         then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_alu,V_alu)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc
              (n2w_itself ((fromString "7"),(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     ((fromString "7"),
                                      (ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val (result,(C_alu,V_alu)) =
                        add_with_carry (word_1comp rn,(shifted,C))
                in
                   seqT
                     (parT
                        (if
                           word_eq d
                             (n2w_itself
                                ((fromString "15"),
                                 (ITSELF (fromString "4"))))
                         then
                           (if setflags then
                              seqT (read_spsr ii) (fn spsr =>
                                seqT
                                  (cpsr_write_by_instr ii
                                     (encode_psr spsr,
                                      (n2w_itself
                                         ((fromString "15"),
                                          (ITSELF (fromString "4"))),
                                       true))) (fn u =>
                                  branch_write_pc ii result))
                            else alu_write_pc ii result)
                         else
                           seqT
                             (parT (increment_pc ii enc)
                                (write_reg ii d result)) (fn (u1,u2) =>
                             constT ()))
                        (if
                           setflags andalso
                           not
                             (word_eq d
                                (n2w_itself
                                   ((fromString "15"),
                                    (ITSELF (fromString "4")))))
                         then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_alu,V_alu)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc
              (n2w_itself ((fromString "8"),(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     ((fromString "8"),
                                      (ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val result = word_and rn shifted
                in
                   seqT
                     (parT (increment_pc ii enc)
                        (if setflags then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_shift,V)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc
              (n2w_itself ((fromString "9"),(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     ((fromString "9"),
                                      (ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val result = word_xor rn shifted
                in
                   seqT
                     (parT (increment_pc ii enc)
                        (if setflags then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_shift,V)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc
              (n2w_itself ((fromString "10"),(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     ((fromString "10"),
                                      (ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val (result,(C_alu,V_alu)) =
                        add_with_carry (rn,(word_1comp shifted,true))
                in
                   seqT
                     (parT (increment_pc ii enc)
                        (if setflags then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_alu,V_alu)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc
              (n2w_itself ((fromString "11"),(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     ((fromString "11"),
                                      (ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val (result,(C_alu,V_alu)) =
                        add_with_carry (rn,(shifted,false))
                in
                   seqT
                     (parT (increment_pc ii enc)
                        (if setflags then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_alu,V_alu)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc
              (n2w_itself ((fromString "12"),(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     ((fromString "12"),
                                      (ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val result = word_or rn shifted
                in
                   seqT
                     (parT
                        (if
                           word_eq d
                             (n2w_itself
                                ((fromString "15"),
                                 (ITSELF (fromString "4"))))
                         then
                           (if setflags then
                              seqT (read_spsr ii) (fn spsr =>
                                seqT
                                  (cpsr_write_by_instr ii
                                     (encode_psr spsr,
                                      (n2w_itself
                                         ((fromString "15"),
                                          (ITSELF (fromString "4"))),
                                       true))) (fn u =>
                                  branch_write_pc ii result))
                            else alu_write_pc ii result)
                         else
                           seqT
                             (parT (increment_pc ii enc)
                                (write_reg ii d result)) (fn (u1,u2) =>
                             constT ()))
                        (if
                           setflags andalso
                           not
                             (word_eq d
                                (n2w_itself
                                   ((fromString "15"),
                                    (ITSELF (fromString "4")))))
                         then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_shift,V)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc
              (n2w_itself ((fromString "13"),(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     ((fromString "13"),
                                      (ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT
                   (constT
                      (n2w_itself (ZERO,(ITSELF (fromString "32")))))
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val result = shifted
                in
                   seqT
                     (parT
                        (if
                           word_eq d
                             (n2w_itself
                                ((fromString "15"),
                                 (ITSELF (fromString "4"))))
                         then
                           (if setflags then
                              seqT (read_spsr ii) (fn spsr =>
                                seqT
                                  (cpsr_write_by_instr ii
                                     (encode_psr spsr,
                                      (n2w_itself
                                         ((fromString "15"),
                                          (ITSELF (fromString "4"))),
                                       true))) (fn u =>
                                  branch_write_pc ii result))
                            else alu_write_pc ii result)
                         else
                           seqT
                             (parT (increment_pc ii enc)
                                (write_reg ii d result)) (fn (u1,u2) =>
                             constT ()))
                        (if
                           setflags andalso
                           not
                             (word_eq d
                                (n2w_itself
                                   ((fromString "15"),
                                    (ITSELF (fromString "4")))))
                         then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_shift,V)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc
              (n2w_itself ((fromString "14"),(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     ((fromString "14"),
                                      (ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT (read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val result = word_and rn (word_1comp shifted)
                in
                   seqT
                     (parT
                        (if
                           word_eq d
                             (n2w_itself
                                ((fromString "15"),
                                 (ITSELF (fromString "4"))))
                         then
                           (if setflags then
                              seqT (read_spsr ii) (fn spsr =>
                                seqT
                                  (cpsr_write_by_instr ii
                                     (encode_psr spsr,
                                      (n2w_itself
                                         ((fromString "15"),
                                          (ITSELF (fromString "4"))),
                                       true))) (fn u =>
                                  branch_write_pc ii result))
                            else alu_write_pc ii result)
                         else
                           seqT
                             (parT (increment_pc ii enc)
                                (write_reg ii d result)) (fn (u1,u2) =>
                             constT ()))
                        (if
                           setflags andalso
                           not
                             (word_eq d
                                (n2w_itself
                                   ((fromString "15"),
                                    (ITSELF (fromString "4")))))
                         then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_shift,V)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else
          if
            word_eq opc
              (n2w_itself ((fromString "15"),(ITSELF (fromString "4"))))
          then
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                (enc = Encoding_Thumb2) andalso
                data_processing_thumb2_unpredictable
                  (Data_Processing(n2w_itself
                                     ((fromString "15"),
                                      (ITSELF (fromString "4"))),
                                   setflags,n,d,mode1)) orelse
                (case mode1
                 of Mode1_immediate(imm12) => false
                  | Mode1_register(v8,v9,v10) => false
                  | Mode1_register_shifted_register(s,type_,m) =>
                       word_eq d
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       (word_eq n
                          (n2w_itself
                             ((fromString "15"),
                              (ITSELF (fromString "4")))) orelse
                        (word_eq m
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))) orelse
                         word_eq s
                           (n2w_itself
                              ((fromString "15"),
                               (ITSELF (fromString "4")))))))
              then
              errorT "data_processing: unpredictable"
            else
              seqT
                (parT
                   (if
                      not (enc = Encoding_Thumb2) orelse
                      word_eq n
                        (n2w_itself
                           ((fromString "15"),
                            (ITSELF (fromString "4"))))
                    then
                      constT
                        (n2w_itself (ZERO,(ITSELF (fromString "32"))))
                    else read_reg ii n)
                   (parT
                      (address_mode1 ii (enc = Encoding_Thumb2) mode1)
                      (read_flags ii))) (fn
                (rn,((shifted,C_shift),(N,(Z,(C,V))))) =>
                let val result = word_or rn (word_1comp shifted)
                in
                   seqT
                     (parT
                        (if
                           word_eq d
                             (n2w_itself
                                ((fromString "15"),
                                 (ITSELF (fromString "4"))))
                         then
                           (if setflags then
                              seqT (read_spsr ii) (fn spsr =>
                                seqT
                                  (cpsr_write_by_instr ii
                                     (encode_psr spsr,
                                      (n2w_itself
                                         ((fromString "15"),
                                          (ITSELF (fromString "4"))),
                                       true))) (fn u =>
                                  branch_write_pc ii result))
                            else alu_write_pc ii result)
                         else
                           seqT
                             (parT (increment_pc ii enc)
                                (write_reg ii d result)) (fn (u1,u2) =>
                             constT ()))
                        (if
                           setflags andalso
                           not
                             (word_eq d
                                (n2w_itself
                                   ((fromString "15"),
                                    (ITSELF (fromString "4")))))
                         then
                           write_flags ii
                             (word_msb result,
                              (word_eq result
                                 (n2w_itself
                                    (ZERO,(ITSELF (fromString "32")))),
                               (C_shift,V)))
                         else constT ())) (fn (u1,u2) => constT ())
                end))
        else raise Fail "ARB"

  fun multiply_instr ii enc (Multiply(acc,setflags,d,a,m,n)) =
        seqT (read_info ii) (fn info =>
          if
            (enc = Encoding_Thumb2) andalso
            (not (ARMinfo_arch info = ARMv6T2) andalso
             < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq n
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  ((word_eq m
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq m
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                   orelse
                   acc andalso
                   word_eq a
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  (word_eq m
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))
                   orelse
                   (acc andalso
                    word_eq a
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4"))))
                    orelse
                    < (version_number (ARMinfo_arch info))
                      (fromString "6") andalso word_eq d n))))
            then
            errorT "multiply: unpredictable"
          else
            seqT
              (parT (read_reg ii a)
                 (parT (read_reg ii m)
                    (parT (read_reg ii n) (arch_version ii)))) (fn
              (ra,(rm,(rn,version))) =>
              let val result =
                      word_add (word_mul rn rm)
                        (if acc then
                           ra
                         else
                           n2w_itself (ZERO,(ITSELF (fromString "32"))))
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (parT (write_reg ii d result)
                         (if setflags then
                            seqT (read_flags ii) (fn (N,(Z,(C,V))) =>
                              let val C_flag =
                                      if version = (fromString "4") then
                                        raise Fail "ARB"
                                      else C
                              in
                                 write_flags ii
                                   (word_msb result,
                                    (word_eq result
                                       (n2w_itself
                                          (ZERO,
                                           (ITSELF (fromString "32")))),
                                     (C_flag,V)))
                              end)
                          else constT ()))) (fn (u1,(u2,u3)) =>
                   constT ())
              end))

  fun multiply_long_instr ii enc
        (Multiply_Long(signed,acc,setflags,dhi,dlo,m,n)) =
        seqT (read_info ii) (fn info =>
          if
            (enc = Encoding_Thumb2) andalso
            (not (ARMinfo_arch info = ARMv6T2) andalso
             < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq dlo
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq dlo
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq dhi
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq dhi
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  ((word_eq n
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq n
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                   orelse
                   (word_eq m
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq m
                      (n2w_itself
                         ((fromString "15"),
                          (ITSELF (fromString "4")))))))
               else
                 word_eq dlo
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq dhi
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  (word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))
                   orelse
                   (word_eq m
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4"))))
                    orelse
                    < (version_number (ARMinfo_arch info))
                      (fromString "6") andalso
                    (word_eq dhi n orelse word_eq dlo n))))) orelse
              word_eq dhi dlo
            then
            errorT "multiply_long: unpredictable"
          else
            seqT
              (parT (read_reg ii dhi)
                 (parT (read_reg ii dlo)
                    (parT (read_reg ii m)
                       (parT (read_reg ii n) (arch_version ii))))) (fn
              (rdhi,(rdlo,(rm,(rn,version)))) =>
              let val result =
                      word_add
                        (if signed then
                           word_mul
                             (sw2sw_itself (ITSELF (fromString "64"))
                                rn)
                             (sw2sw_itself (ITSELF (fromString "64"))
                                rm)
                         else
                           word_mul
                             (w2w_itself (ITSELF (fromString "64")) rn)
                             (w2w_itself (ITSELF (fromString "64")) rm))
                        (if acc then
                           word_concat_itself (ITSELF (fromString "64"))
                             rdhi rdlo
                         else
                           n2w_itself (ZERO,(ITSELF (fromString "64"))))
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (parT
                         (write_reg ii dhi
                            (word_extract_itself
                               (ITSELF (fromString "32"))
                               (fromString "63") (fromString "32")
                               result))
                         (parT
                            (write_reg ii dlo
                               (word_extract_itself
                                  (ITSELF (fromString "32"))
                                  (fromString "31") ZERO result))
                            (if setflags then
                               seqT (read_flags ii) (fn (N,(Z,(C,V))) =>
                                 let val (C_flag,V_flag) =
                                         if
                                           version = (fromString "4")
                                         then
                                           (raise Fail "ARB",
                                            raise Fail "ARB")
                                         else (C,V)
                                 in
                                    write_flags ii
                                      (word_msb result,
                                       (word_eq result
                                          (n2w_itself
                                             (ZERO,
                                              (ITSELF
                                                (fromString "64")))),
                                        (C_flag,V_flag)))
                                 end)
                             else constT ())))) (fn (u1,(u2,(u3,u4))) =>
                   constT ())
              end))

  fun multiply_accumulate_accumulate_instr ii enc
        (Multiply_Accumulate_Accumulate(dhi,dlo,m,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq dlo
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq dlo
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq dhi
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq dhi
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  ((word_eq n
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq n
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                   orelse
                   (word_eq m
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq m
                      (n2w_itself
                         ((fromString "15"),
                          (ITSELF (fromString "4")))))))
               else
                 word_eq dlo
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq dhi
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  (word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq m
                     (n2w_itself
                        ((fromString "15"),
                         (ITSELF (fromString "4"))))))) orelse
              word_eq dhi dlo
            then
            errorT "multiply_accumulate_accumulate: unpredictable"
          else
            seqT
              (parT (read_reg ii dhi)
                 (parT (read_reg ii dlo)
                    (parT (read_reg ii m) (read_reg ii n)))) (fn
              (rdhi,(rdlo,(rm,rn))) =>
              let val result =
                      word_add
                        (word_add
                           (word_mul
                              (w2w_itself (ITSELF (fromString "64")) rn)
                              (w2w_itself (ITSELF (fromString "64"))
                                 rm))
                           (w2w_itself (ITSELF (fromString "64")) rdhi))
                        (w2w_itself (ITSELF (fromString "64")) rdlo)
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (parT
                         (write_reg ii dhi
                            (word_extract_itself
                               (ITSELF (fromString "32"))
                               (fromString "63") (fromString "32")
                               result))
                         (write_reg ii dlo
                            (word_extract_itself
                               (ITSELF (fromString "32"))
                               (fromString "31") ZERO result)))) (fn
                   (u1,(u2,u3)) => constT ())
              end))

  fun multiply_subtract_instr ii enc (Multiply_Subtract(d,a,m,n)) =
        seqT (read_info ii) (fn info =>
          if
            not (ARMinfo_arch info = ARMv6T2) andalso
            < (version_number (ARMinfo_arch info)) (fromString "7")
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq n
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  ((word_eq m
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq m
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                   orelse
                   (word_eq a
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq a
                      (n2w_itself
                         ((fromString "15"),
                          (ITSELF (fromString "4")))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  (word_eq m
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq a
                     (n2w_itself
                        ((fromString "15"),
                         (ITSELF (fromString "4")))))))
            then
            errorT "multiply_subtract: unpredictable"
          else
            seqT
              (parT (read_reg ii n)
                 (parT (read_reg ii m) (read_reg ii a))) (fn
              (rn,(rm,ra)) =>
              let val result = word_sub ra (word_mul rn rm)
              in
                 seqT
                   (parT (increment_pc ii enc) (write_reg ii d result))
                   (fn (u1,u2) => constT ())
              end))

  fun saturating_add_subtract_instr ii enc
        (Saturating_Add_Subtract(opc,n,d,m)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               (ARMinfo_arch info = ARMv4) orelse
               ((ARMinfo_arch info = ARMv4T) orelse
                (ARMinfo_arch info = ARMv5T)))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq n
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  (word_eq m
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq m
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq m
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))))
            then
            errorT "saturating_add_subtract: unpredictable"
          else
            seqT (parT (read_reg ii m) (read_reg ii n)) (fn (rm,rn) =>
              let val (result,sat) =
                      case word_eq opc (n2w_itself (ZERO,(ITSELF TWO)))
                       of true =>
                             signed_sat_q_itself
                               (intML.int_add (intML.w2i rm)
                                  (intML.w2i rn),
                                ((fromString "32"),
                                 (ITSELF (fromString "32"))))
                        | false =>
                             (case
                                word_eq opc
                                  (n2w_itself (ONE,(ITSELF TWO)))
                              of true =>
                                    signed_sat_q_itself
                                      (intML.int_sub (intML.w2i rm)
                                         (intML.w2i rn),
                                       ((fromString "32"),
                                        (ITSELF (fromString "32"))))
                               | false =>
                                    (case
                                       word_eq opc
                                         (n2w_itself (TWO,(ITSELF TWO)))
                                     of true =>
                                           let val (doubled,sat1) =
                                                   signed_sat_q_itself
                                                     (intML.int_mul
                                                        (intML.int_of_num
                                                           TWO)
                                                        (intML.w2i rn),
                                                      ((fromString
                                                       "32"),
                                                       (ITSELF
                                                         (fromString
                                                         "32"))))
                                               val (result,sat2) =
                                                   signed_sat_q_itself
                                                     (intML.int_add
                                                        (intML.w2i rm)
                                                        (intML.w2i
                                                           doubled),
                                                      ((fromString
                                                       "32"),
                                                       (ITSELF
                                                         (fromString
                                                         "32"))))
                                           in
                                              (result,sat1 orelse sat2)
                                           end
                                      | false =>
                                           (case
                                              word_eq opc
                                                (n2w_itself
                                                   ((fromString "3"),
                                                    (ITSELF TWO)))
                                            of true =>
                                                  let val (doubled,sat1)
                                                          =
                                                          signed_sat_q_itself
                                                            (intML.int_mul
                                                               (intML.int_of_num
                                                                  TWO)
                                                               (intML.w2i
                                                                  rn),
                                                             ((fromString
                                                              "32"),
                                                              (ITSELF
                                                                (fromString
                                                                "32"))))
                                                      val (result,sat2)
                                                          =
                                                          signed_sat_q_itself
                                                            (intML.int_sub
                                                               (intML.w2i
                                                                  rm)
                                                               (intML.w2i
                                                                  doubled),
                                                             ((fromString
                                                              "32"),
                                                              (ITSELF
                                                                (fromString
                                                                "32"))))
                                                  in
                                                     (result,
                                                      sat1 orelse sat2)
                                                  end
                                             | false =>
                                                  raise Fail "ARB")))
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (parT (write_reg ii d result)
                         (if sat then set_q ii else constT ()))) (fn
                   (u1,(u2,u3)) => constT ())
              end))

  fun signed_16_multiply_32_accumulate_instr ii enc
        (Signed_Halfword_Multiply(opc,m_high,n_high,d,a,m,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               (ARMinfo_arch info = ARMv4) orelse
               ((ARMinfo_arch info = ARMv4T) orelse
                (ARMinfo_arch info = ARMv5T)))
          then take_undef_instr_exception ii
          else
            if
              not (word_eq opc (n2w_itself (ZERO,(ITSELF TWO)))) orelse
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq n
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  ((word_eq m
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq m
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                   orelse
                   (word_eq a
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq a
                      (n2w_itself
                         ((fromString "15"),
                          (ITSELF (fromString "4")))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  (word_eq m
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq a
                     (n2w_itself
                        ((fromString "15"),
                         (ITSELF (fromString "4")))))))
            then
            errorT "signed_16_multiply_32_accumulate: unpredictable"
          else
            seqT
              (parT (read_reg ii m)
                 (parT (read_reg ii n) (read_reg ii a))) (fn
              (rm,(rn,ra)) =>
              let val operand1 =
                      if n_high then
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "31") (fromString "16") rn
                      else
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "15") ZERO rn
                  val operand2 =
                      if m_high then
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "31") (fromString "16") rm
                      else
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "15") ZERO rm
                  val result =
                      intML.int_add
                        (intML.int_mul (intML.w2i operand1)
                           (intML.w2i operand2)) (intML.w2i ra)
                  val result32 =
                      intML.i2w_itself
                        (result,(ITSELF (fromString "32")))
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (parT (write_reg ii d result32)
                         (if not (result = intML.w2i result32) then
                            set_q ii
                          else constT ()))) (fn (u1,(u2,u3)) =>
                   constT ())
              end))

  fun signed_16_multiply_32_result_instr ii enc
        (Signed_Halfword_Multiply(opc,m_high,n_high,d,sbz,m,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               (ARMinfo_arch info = ARMv4) orelse
               ((ARMinfo_arch info = ARMv4T) orelse
                (ARMinfo_arch info = ARMv5T)))
          then take_undef_instr_exception ii
          else
            if
              not
                (word_eq opc
                   (n2w_itself ((fromString "3"),(ITSELF TWO)))) orelse
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq n
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  (word_eq m
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq m
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq m
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))))
            then
            errorT "signed_16_multiply_32_result: unpredictable"
          else
            seqT (parT (read_reg ii m) (read_reg ii n)) (fn (rm,rn) =>
              let val operand1 =
                      if n_high then
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "31") (fromString "16") rn
                      else
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "15") ZERO rn
                  val operand2 =
                      if m_high then
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "31") (fromString "16") rm
                      else
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "15") ZERO rm
                  val result =
                      intML.int_mul (intML.w2i operand1)
                        (intML.w2i operand2)
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (write_reg ii d
                         (intML.i2w_itself
                            (result,(ITSELF (fromString "32")))))) (fn
                   (u1,u2) => constT ())
              end))

  fun signed_16x32_multiply_32_accumulate_instr ii enc
        (Signed_Halfword_Multiply(opc,m_high,n_high,d,a,m,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               (ARMinfo_arch info = ARMv4) orelse
               ((ARMinfo_arch info = ARMv4T) orelse
                (ARMinfo_arch info = ARMv5T)))
          then take_undef_instr_exception ii
          else
            if
              not (word_eq opc (n2w_itself (ONE,(ITSELF TWO)))) orelse
              (n_high orelse
               (if enc = Encoding_Thumb2 then
                  (word_eq d
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq d
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  ((word_eq n
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq n
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                   orelse
                   ((word_eq m
                       (n2w_itself
                          ((fromString "13"),(ITSELF (fromString "4"))))
                     orelse
                     word_eq m
                       (n2w_itself
                          ((fromString "15"),
                           (ITSELF (fromString "4"))))) orelse
                    (word_eq a
                       (n2w_itself
                          ((fromString "13"),(ITSELF (fromString "4"))))
                     orelse
                     word_eq a
                       (n2w_itself
                          ((fromString "15"),
                           (ITSELF (fromString "4")))))))
                else
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  (word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))
                   orelse
                   (word_eq m
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq a
                      (n2w_itself
                         ((fromString "15"),
                          (ITSELF (fromString "4"))))))))
            then
            errorT "signed_16x32_multiply_32_accumulate: unpredictable"
          else
            seqT
              (parT (read_reg ii m)
                 (parT (read_reg ii n) (read_reg ii a))) (fn
              (rm,(rn,ra)) =>
              let val operand2 =
                      if m_high then
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "31") (fromString "16") rm
                      else
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "15") ZERO rm
                  val sh16 =
                      intML.int_exp (intML.int_of_num TWO)
                        (fromString "16")
                  val result =
                      intML.int_div
                        (intML.int_add
                           (intML.int_mul (intML.w2i rn)
                              (intML.w2i operand2))
                           (intML.int_mul (intML.w2i ra) sh16)) sh16
                  val result32 =
                      intML.i2w_itself
                        (result,(ITSELF (fromString "32")))
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (parT (write_reg ii d result32)
                         (if not (result = intML.w2i result32) then
                            set_q ii
                          else constT ()))) (fn (u1,(u2,u3)) =>
                   constT ())
              end))

  fun signed_16x32_multiply_32_result_instr ii enc
        (Signed_Halfword_Multiply(opc,m_high,n_high,d,sbz,m,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               (ARMinfo_arch info = ARMv4) orelse
               ((ARMinfo_arch info = ARMv4T) orelse
                (ARMinfo_arch info = ARMv5T)))
          then take_undef_instr_exception ii
          else
            if
              not (word_eq opc (n2w_itself (ONE,(ITSELF TWO)))) orelse
              (not n_high orelse
               (if enc = Encoding_Thumb2 then
                  (word_eq d
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq d
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  ((word_eq n
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq n
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                   orelse
                   (word_eq m
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq m
                      (n2w_itself
                         ((fromString "15"),
                          (ITSELF (fromString "4"))))))
                else
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  (word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq m
                     (n2w_itself
                        ((fromString "15"),
                         (ITSELF (fromString "4")))))))
            then
            errorT "signed_16x32_multiply_32_result: unpredictable"
          else
            seqT (parT (read_reg ii m) (read_reg ii n)) (fn (rm,rn) =>
              let val operand2 =
                      if m_high then
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "31") (fromString "16") rm
                      else
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "15") ZERO rm
                  val result =
                      intML.int_div
                        (intML.int_mul (intML.w2i rn)
                           (intML.w2i operand2))
                        (intML.int_exp (intML.int_of_num TWO)
                           (fromString "16"))
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (write_reg ii d
                         (intML.i2w_itself
                            (result,(ITSELF (fromString "32")))))) (fn
                   (u1,u2) => constT ())
              end))

  fun signed_16_multiply_64_accumulate_instr ii enc
        (Signed_Halfword_Multiply(opc,m_high,n_high,dhi,dlo,m,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               (ARMinfo_arch info = ARMv4) orelse
               ((ARMinfo_arch info = ARMv4T) orelse
                (ARMinfo_arch info = ARMv5T)))
          then take_undef_instr_exception ii
          else
            if
              not (word_eq opc (n2w_itself (TWO,(ITSELF TWO)))) orelse
              ((if enc = Encoding_Thumb2 then
                  (word_eq dlo
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq dlo
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  ((word_eq dhi
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq dhi
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                   orelse
                   ((word_eq n
                       (n2w_itself
                          ((fromString "13"),(ITSELF (fromString "4"))))
                     orelse
                     word_eq n
                       (n2w_itself
                          ((fromString "15"),
                           (ITSELF (fromString "4"))))) orelse
                    (word_eq m
                       (n2w_itself
                          ((fromString "13"),(ITSELF (fromString "4"))))
                     orelse
                     word_eq m
                       (n2w_itself
                          ((fromString "15"),
                           (ITSELF (fromString "4")))))))
                else
                  word_eq dlo
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  (word_eq dhi
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))
                   orelse
                   (word_eq n
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq m
                      (n2w_itself
                         ((fromString "15"),
                          (ITSELF (fromString "4"))))))) orelse
               word_eq dhi dlo)
            then
            errorT "signed_16_multiply_64_accumulate: unpredictable"
          else
            seqT
              (parT (read_reg ii m)
                 (parT (read_reg ii n)
                    (parT (read_reg ii dhi) (read_reg ii dlo)))) (fn
              (rm,(rn,(rdhi,rdlo))) =>
              let val operand1 =
                      if n_high then
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "31") (fromString "16") rn
                      else
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "15") ZERO rn
                  val operand2 =
                      if m_high then
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "31") (fromString "16") rm
                      else
                        word_extract_itself (ITSELF (fromString "16"))
                          (fromString "15") ZERO rm
                  val result =
                      intML.int_add
                        (intML.int_mul (intML.w2i operand1)
                           (intML.w2i operand2))
                        (intML.w2i
                           (word_concat_itself
                              (ITSELF (fromString "64")) rdhi rdlo))
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (parT
                         (write_reg ii dlo
                            (intML.i2w_itself
                               (result,(ITSELF (fromString "32")))))
                         (write_reg ii dhi
                            (intML.i2w_itself
                               (intML.int_div result
                                  (intML.int_exp (intML.int_of_num TWO)
                                     (fromString "32")),
                                (ITSELF (fromString "32"))))))) (fn
                   (u1,(u2,u3)) => constT ())
              end))

  fun signed_multiply_dual_instr ii enc
        (Signed_Multiply_Dual(d,a,m,sub,m_swap,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq n
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  ((word_eq m
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq m
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                   orelse
                   word_eq a
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq m
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))))
            then
            errorT "signed_multiply_dual: unpredictable"
          else
            seqT
              (parT (read_reg ii m)
                 (parT (read_reg ii n)
                    (if
                       word_eq a
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4"))))
                     then
                       constT
                         (n2w_itself (ZERO,(ITSELF (fromString "32"))))
                     else read_reg ii a))) (fn (rm,(rn,ra)) =>
              let val operand2 =
                      if m_swap then ROR (rm,(fromString "16")) else rm
                  val product1 =
                      intML.int_mul
                        (intML.w2i
                           (word_extract_itself
                              (ITSELF (fromString "16"))
                              (fromString "15") ZERO rn))
                        (intML.w2i
                           (word_extract_itself
                              (ITSELF (fromString "16"))
                              (fromString "15") ZERO operand2))
                  val product2 =
                      intML.int_mul
                        (intML.w2i
                           (word_extract_itself
                              (ITSELF (fromString "16"))
                              (fromString "31") (fromString "16") rn))
                        (intML.w2i
                           (word_extract_itself
                              (ITSELF (fromString "16"))
                              (fromString "31") (fromString "16")
                              operand2))
                  val result =
                      if sub then
                        intML.int_add (intML.int_sub product1 product2)
                          (intML.w2i ra)
                      else
                        intML.int_add (intML.int_add product1 product2)
                          (intML.w2i ra)
                  val result32 =
                      intML.i2w_itself
                        (result,(ITSELF (fromString "32")))
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (parT (write_reg ii d result32)
                         (if not (result = intML.w2i result32) then
                            set_q ii
                          else constT ()))) (fn (u1,(u2,u3)) =>
                   constT ())
              end))

  fun signed_multiply_long_dual_instr ii enc
        (Signed_Multiply_Long_Dual(dhi,dlo,m,sub,m_swap,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq dlo
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq dlo
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq dhi
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq dhi
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  (word_eq n
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  andalso
                  (word_eq m
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq m
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))))
               else
                 word_eq dlo
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq dhi
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  (word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq m
                     (n2w_itself
                        ((fromString "15"),
                         (ITSELF (fromString "4"))))))) orelse
              word_eq dhi dlo
            then
            errorT "signed_multiply_long_dual: unpredictable"
          else
            seqT
              (parT (read_reg ii m)
                 (parT (read_reg ii n)
                    (parT (read_reg ii dhi) (read_reg ii dlo)))) (fn
              (rm,(rn,(rdhi,rdlo))) =>
              let val operand2 =
                      if m_swap then ROR (rm,(fromString "16")) else rm
                  val product1 =
                      intML.int_mul
                        (intML.w2i
                           (word_extract_itself
                              (ITSELF (fromString "16"))
                              (fromString "15") ZERO rn))
                        (intML.w2i
                           (word_extract_itself
                              (ITSELF (fromString "16"))
                              (fromString "15") ZERO operand2))
                  val product2 =
                      intML.int_mul
                        (intML.w2i
                           (word_extract_itself
                              (ITSELF (fromString "16"))
                              (fromString "31") (fromString "16") rn))
                        (intML.w2i
                           (word_extract_itself
                              (ITSELF (fromString "16"))
                              (fromString "31") (fromString "16")
                              operand2))
                  val rd =
                      word_concat_itself (ITSELF (fromString "64")) rdhi
                        rdlo
                  val result =
                      if sub then
                        intML.int_add (intML.int_sub product1 product2)
                          (intML.w2i rd)
                      else
                        intML.int_add (intML.int_add product1 product2)
                          (intML.w2i rd)
                  val result64 =
                      intML.i2w_itself
                        (result,(ITSELF (fromString "64")))
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (parT
                         (write_reg ii dhi
                            (word_extract_itself
                               (ITSELF (fromString "32"))
                               (fromString "63") (fromString "32")
                               result64))
                         (write_reg ii dlo
                            (word_extract_itself
                               (ITSELF (fromString "32"))
                               (fromString "31") ZERO result64)))) (fn
                   (u1,(u2,u3)) => constT ())
              end))

  fun signed_most_significant_multiply_instr ii enc
        (Signed_Most_Significant_Multiply(d,a,m,round,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq n
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  ((word_eq m
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq m
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                   orelse
                   word_eq a
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq m
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))))
            then
            errorT "signed_most_significant_multiply: unpredictable"
          else
            seqT
              (parT (read_reg ii m)
                 (parT (read_reg ii n)
                    (if
                       word_eq a
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4"))))
                     then
                       constT
                         (n2w_itself (ZERO,(ITSELF (fromString "32"))))
                     else read_reg ii a))) (fn (rm,(rn,ra)) =>
              let val result =
                      intML.int_add
                        (intML.w2i
                           (word_lsl
                              (w2w_itself (ITSELF (fromString "64")) ra)
                              (fromString "32")))
                        (intML.int_mul (intML.w2i rn) (intML.w2i rm))
                  val result =
                      intML.i2w_itself
                        (if round then
                           intML.int_add result
                             (intML.int_of_num
                                (fromString "2147483648")) else result,
                         (ITSELF (fromString "64")))
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (write_reg ii d
                         (word_extract_itself (ITSELF (fromString "32"))
                            (fromString "63") (fromString "32")
                            result))) (fn (u1,u2) => constT ())
              end))

  fun signed_most_significant_multiply_subtract_instr ii enc
        (Signed_Most_Significant_Multiply_Subtract(d,a,m,round,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq n
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  ((word_eq m
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq m
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                   orelse
                   (word_eq a
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq a
                      (n2w_itself
                         ((fromString "15"),
                          (ITSELF (fromString "4")))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  (word_eq m
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq a
                     (n2w_itself
                        ((fromString "15"),
                         (ITSELF (fromString "4")))))))
            then
            errorT
              "signed_most_significant_multiply_subtract: unpredictable"
          else
            seqT
              (parT (read_reg ii m)
                 (parT (read_reg ii n) (read_reg ii a))) (fn
              (rm,(rn,ra)) =>
              let val result =
                      intML.int_sub
                        (intML.w2i
                           (word_lsl
                              (w2w_itself (ITSELF (fromString "64")) ra)
                              (fromString "32")))
                        (intML.int_mul (intML.w2i rn) (intML.w2i rm))
                  val result =
                      intML.i2w_itself
                        (if round then
                           intML.int_add result
                             (intML.int_of_num
                                (fromString "2147483648")) else result,
                         (ITSELF (fromString "64")))
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (write_reg ii d
                         (word_extract_itself (ITSELF (fromString "32"))
                            (fromString "63") (fromString "32")
                            result))) (fn (u1,u2) => constT ())
              end))

  fun parallel_add_subtract_instr ii enc
        (Parallel_Add_Subtract(u,op_,n,d,m)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq n
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  (word_eq m
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq m
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq m
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))))
            then
            errorT "parallel_add_subtract: unpredictable"
          else
            seqT (parT (read_reg ii n) (read_reg ii m)) (fn (rn,rm) =>
              let val (result,ge) = parallel_add_sub u op_ rn rm
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (parT (write_reg ii d result)
                         (if optionML.IS_SOME ge then
                            write_ge ii (optionML.THE ge)
                          else constT ()))) (fn (u1,(u2,u3)) =>
                   constT ())
              end))

  fun divide_instr ii (Divide(unsigned,n,d,m)) =
        seqT (read_info ii) (fn info =>
          if not (ARMinfo_arch info = ARMv7_R) then
            take_undef_instr_exception ii
          else
            if
              (word_eq d
                 (n2w_itself
                    ((fromString "13"),(ITSELF (fromString "4"))))
               orelse
               word_eq d
                 (n2w_itself
                    ((fromString "15"),(ITSELF (fromString "4")))))
              orelse
              ((word_eq n
                  (n2w_itself
                     ((fromString "13"),(ITSELF (fromString "4"))))
                orelse
                word_eq n
                  (n2w_itself
                     ((fromString "15"),(ITSELF (fromString "4")))))
               orelse
               (word_eq m
                  (n2w_itself
                     ((fromString "13"),(ITSELF (fromString "4"))))
                orelse
                word_eq m
                  (n2w_itself
                     ((fromString "15"),(ITSELF (fromString "4"))))))
            then
            errorT "divide: unpredictable"
          else
            seqT (read_reg ii m) (fn rm =>
              if
                word_eq rm
                  (n2w_itself (ZERO,(ITSELF (fromString "32"))))
              then
                seqT (integer_zero_divide_trapping_enabled ii) (fn trap
                  => if trap then take_undef_instr_exception ii
                  else
                    seqT
                      (parT (increment_pc ii Encoding_Thumb2)
                         (write_reg ii d
                            (n2w_itself
                               (ZERO,(ITSELF (fromString "32")))))) (fn
                      (u1,u2) => constT ()))
              else
                seqT (read_reg ii n) (fn rn =>
                  seqT
                    (parT (increment_pc ii Encoding_Thumb2)
                       (write_reg ii d
                          (if unsigned then
                             word_div rn rm
                           else word_sdiv rn rm))) (fn (u1,u2) =>
                    constT ()))))

  fun pack_halfword_instr ii enc (Pack_Halfword(n,d,imm5,tbform,m)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq n
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  (word_eq m
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq m
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq m
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))))
            then
            errorT "pack_halfword: unpredictable"
          else
            seqT
              (parT (read_reg ii n)
                 (parT (read_reg ii m) (read_cflag ii))) (fn (rn,(rm,c))
              =>
              let val (shift_t,shift_n) =
                      decode_imm_shift
                        (word_modify (fn i => fn b => if i = ONE then
                             tbform else b)
                           (n2w_itself (ZERO,(ITSELF TWO))),imm5)
              in
                 seqT (shift (rm,(shift_t,(shift_n,c)))) (fn operand2 =>
                   let val r1 =
                           if tbform then
                             word_extract_itself
                               (ITSELF (fromString "16"))
                               (fromString "15") ZERO operand2
                           else
                             word_extract_itself
                               (ITSELF (fromString "16"))
                               (fromString "15") ZERO rn
                       val r2 =
                           if tbform then
                             word_extract_itself
                               (ITSELF (fromString "16"))
                               (fromString "31") (fromString "16") rn
                           else
                             word_extract_itself
                               (ITSELF (fromString "16"))
                               (fromString "31") (fromString "16")
                               operand2
                   in
                      seqT
                        (parT (increment_pc ii enc)
                           (write_reg ii d
                              (word_concat_itself
                                 (ITSELF (fromString "32")) r2 r1))) (fn
                        (u1,u2) => constT ())
                   end)
              end))

  fun saturate_instr ii enc (Saturate(unsigned,sat_imm,d,imm5,sh,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq n
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "saturate: unpredictable"
          else
            seqT (parT (read_reg ii n) (read_cflag ii)) (fn (rn,c) =>
              let val (shift_t,shift_n) =
                      decode_imm_shift
                        (word_modify (fn i => fn b => if i = ONE then sh
                           else b) (n2w_itself (ZERO,(ITSELF TWO))),
                         imm5)
              in
                 seqT (shift (rn,(shift_t,(shift_n,c)))) (fn operand =>
                   let val (result,sat) =
                           if unsigned then
                             unsigned_sat_q_itself
                               (intML.w2i operand,
                                (w2n sat_imm,
                                 (ITSELF (fromString "32"))))
                           else
                             let val saturate_to = + (w2n sat_imm) ONE
                             in
                                pairML.## (word_sign_extend saturate_to)
                                  combinML.I
                                  (signed_sat_q_itself
                                     (intML.w2i operand,
                                      (saturate_to,
                                       (ITSELF (fromString "32")))))
                             end
                   in
                      seqT
                        (parT (increment_pc ii enc)
                           (parT (write_reg ii d result)
                              (if sat then set_q ii else constT ())))
                        (fn (u1,(u2,u3)) => constT ())
                   end)
              end))

  fun extend_byte_16_instr ii enc
        (Extend_Byte_16(unsigned,n,d,rotate,m)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  (word_eq m
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq m
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq m
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "extend_byte_16: unpredictable"
          else
            seqT
              (parT
                 (if
                    word_eq n
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4"))))
                  then
                    constT
                      (n2w_itself (ZERO,(ITSELF (fromString "32"))))
                  else read_reg ii n) (read_reg ii m)) (fn (rn,rm) =>
              let val rotated =
                      ROR (rm, *  (w2n rotate) (fromString "8"))
                  val r1 =
                      word_add
                        (word_extract_itself (ITSELF (fromString "16"))
                           (fromString "15") ZERO rn)
                        (if unsigned then
                           w2w_itself (ITSELF (fromString "16"))
                             (word_extract_itself
                                (ITSELF (fromString "8"))
                                (fromString "7") ZERO rotated)
                         else
                           sw2sw_itself (ITSELF (fromString "16"))
                             (word_extract_itself
                                (ITSELF (fromString "8"))
                                (fromString "7") ZERO rotated))
                  val r2 =
                      word_add
                        (word_extract_itself (ITSELF (fromString "16"))
                           (fromString "31") (fromString "16") rn)
                        (if unsigned then
                           w2w_itself (ITSELF (fromString "16"))
                             (word_extract_itself
                                (ITSELF (fromString "8"))
                                (fromString "23") (fromString "16")
                                rotated)
                         else
                           sw2sw_itself (ITSELF (fromString "16"))
                             (word_extract_itself
                                (ITSELF (fromString "8"))
                                (fromString "23") (fromString "16")
                                rotated))
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (write_reg ii d
                         (word_concat_itself (ITSELF (fromString "32"))
                            r2 r1))) (fn (u1,u2) => constT ())
              end))

  fun select_bytes_instr ii enc (Select_Bytes(n,d,m)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq n
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  (word_eq m
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq m
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq m
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))))
            then
            errorT "select_bytes: unpredictable"
          else
            seqT
              (parT (read_reg ii n) (parT (read_reg ii m) (read_ge ii)))
              (fn (rn,(rm,ge)) =>
              let val r1 =
                      if word_index ge ZERO then
                        word_extract_itself (ITSELF (fromString "8"))
                          (fromString "7") ZERO rn
                      else
                        word_extract_itself (ITSELF (fromString "8"))
                          (fromString "7") ZERO rm
                  val r2 =
                      if word_index ge ONE then
                        word_extract_itself (ITSELF (fromString "8"))
                          (fromString "15") (fromString "8") rn
                      else
                        word_extract_itself (ITSELF (fromString "8"))
                          (fromString "15") (fromString "8") rm
                  val r3 =
                      if word_index ge TWO then
                        word_extract_itself (ITSELF (fromString "8"))
                          (fromString "23") (fromString "16") rn
                      else
                        word_extract_itself (ITSELF (fromString "8"))
                          (fromString "23") (fromString "16") rm
                  val r4 =
                      if word_index ge (fromString "3") then
                        word_extract_itself (ITSELF (fromString "8"))
                          (fromString "31") (fromString "24") rn
                      else
                        word_extract_itself (ITSELF (fromString "8"))
                          (fromString "31") (fromString "24") rm
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (write_reg ii d (word32 [r1,r2,r3,r4]))) (fn
                   (u1,u2) => constT ())
              end))

  fun saturate_16_instr ii enc (Saturate_16(unsigned,sat_imm,d,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq n
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "saturate_16: unpredictable"
          else
            seqT (read_reg ii n) (fn rn =>
              let val ((result1,sat1),(result2,sat2)) =
                      if unsigned then
                        let val saturate_to = w2n sat_imm
                        in
                           (unsigned_sat_q_itself
                              (intML.w2i
                                 (word_extract_itself
                                    (ITSELF (fromString "16"))
                                    (fromString "15") ZERO rn),
                               (saturate_to,
                                (ITSELF (fromString "16")))),
                            unsigned_sat_q_itself
                              (intML.w2i
                                 (word_extract_itself
                                    (ITSELF (fromString "16"))
                                    (fromString "31") (fromString "16")
                                    rn),
                               (saturate_to,
                                (ITSELF (fromString "16")))))
                        end
                      else
                        let val saturate_to = + (w2n sat_imm) ONE
                        in
                           (pairML.## (word_sign_extend saturate_to)
                              combinML.I
                              (signed_sat_q_itself
                                 (intML.w2i
                                    (word_extract_itself
                                       (ITSELF (fromString "16"))
                                       (fromString "15") ZERO rn),
                                  (saturate_to,
                                   (ITSELF (fromString "16"))))),
                            pairML.## (word_sign_extend saturate_to)
                              combinML.I
                              (signed_sat_q_itself
                                 (intML.w2i
                                    (word_extract_itself
                                       (ITSELF (fromString "16"))
                                       (fromString "31")
                                       (fromString "16") rn),
                                  (saturate_to,
                                   (ITSELF (fromString "16"))))))
                        end
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (parT
                         (write_reg ii d
                            (word_concat_itself
                               (ITSELF (fromString "32")) result2
                               result1))
                         (if sat1 orelse sat2 then
                            set_q ii
                          else constT ()))) (fn (u1,(u2,u3)) =>
                   constT ())
              end))

  fun extend_byte_instr ii enc (Extend_Byte(unsigned,n,d,rotate,m)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  (word_eq m
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq m
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq m
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "extend_byte: unpredictable"
          else
            seqT
              (parT
                 (if
                    word_eq n
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4"))))
                  then
                    constT
                      (n2w_itself (ZERO,(ITSELF (fromString "32"))))
                  else read_reg ii n) (read_reg ii m)) (fn (rn,rm) =>
              let val rotated =
                      ROR (rm, *  (w2n rotate) (fromString "8"))
                  val r =
                      word_add rn
                        (if unsigned then
                           w2w_itself (ITSELF (fromString "32"))
                             (word_extract_itself
                                (ITSELF (fromString "8"))
                                (fromString "7") ZERO rotated)
                         else
                           sw2sw_itself (ITSELF (fromString "32"))
                             (word_extract_itself
                                (ITSELF (fromString "8"))
                                (fromString "7") ZERO rotated))
              in
                 seqT (parT (increment_pc ii enc) (write_reg ii d r))
                   (fn (u1,u2) => constT ())
              end))

  fun byte_reverse_word_instr ii enc (Byte_Reverse_Word(d,m)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 (word_eq m
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq m
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq m
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "byte_reverse_word: unpredictable"
          else
            seqT (read_reg ii m) (fn rm =>
              seqT
                (parT (increment_pc ii enc)
                   (write_reg ii d
                      (word32
                         (listML.REVERSE
                            (bytes (rm,(fromString "4"))))))) (fn
                (u1,u2) => constT ())))

  fun extend_halfword_instr ii enc
        (Extend_Halfword(unsigned,n,d,rotate,m)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  (word_eq m
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq m
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq m
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "extend_halfword: unpredictable"
          else
            seqT
              (parT
                 (if
                    word_eq n
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4"))))
                  then
                    constT
                      (n2w_itself (ZERO,(ITSELF (fromString "32"))))
                  else read_reg ii n) (read_reg ii m)) (fn (rn,rm) =>
              let val rotated =
                      ROR (rm, *  (w2n rotate) (fromString "8"))
                  val r =
                      word_add rn
                        (if unsigned then
                           w2w_itself (ITSELF (fromString "32"))
                             (word_extract_itself
                                (ITSELF (fromString "16"))
                                (fromString "15") ZERO rotated)
                         else
                           sw2sw_itself (ITSELF (fromString "32"))
                             (word_extract_itself
                                (ITSELF (fromString "16"))
                                (fromString "15") ZERO rotated))
              in
                 seqT (parT (increment_pc ii enc) (write_reg ii d r))
                   (fn (u1,u2) => constT ())
              end))

  fun byte_reverse_packed_halfword_instr ii enc
        (Byte_Reverse_Packed_Halfword(d,m)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 (word_eq m
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq m
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq m
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "byte_reverse_packed_halfword: unpredictable"
          else
            seqT (read_reg ii m) (fn rm =>
              seqT
                (parT (increment_pc ii enc)
                   (write_reg ii d
                      (let val w = bytes (rm,(fromString "4"))
                       in
                          word32
                            [listML.EL ONE w,listML.HD w,
                             listML.EL (fromString "3") w,
                             listML.EL TWO w]
                       end))) (fn (u1,u2) => constT ())))

  fun reverse_bits_instr ii enc (Reverse_Bits(d,m)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 (word_eq m
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq m
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq m
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "reverse_bits: unpredictable"
          else
            seqT (read_reg ii m) (fn rm =>
              seqT
                (parT (increment_pc ii enc)
                   (write_reg ii d (word_reverse rm))) (fn (u1,u2) =>
                constT ())))

  fun byte_reverse_signed_halfword_instr ii enc
        (Byte_Reverse_Signed_Halfword(d,m)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 (word_eq m
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq m
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq m
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "byte_reverse_signed_halfword: unpredictable"
          else
            seqT (read_reg ii m) (fn rm =>
              let val r1 =
                      sw2sw_itself (ITSELF (fromString "24"))
                        (word_extract_itself (ITSELF (fromString "8"))
                           (fromString "7") ZERO rm)
                  val r2 =
                      word_extract_itself (ITSELF (fromString "8"))
                        (fromString "15") (fromString "8") rm
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (write_reg ii d
                         (word_concat_itself (ITSELF (fromString "32"))
                            r1 r2))) (fn (u1,u2) => constT ())
              end))

  fun unsigned_sum_absolute_differences_instr ii enc
        (Unsigned_Sum_Absolute_Differences(d,a,m,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq n
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  ((word_eq m
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq m
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                   orelse
                   word_eq a
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq n
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq m
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))))
            then
            errorT "unsigned_sum_absolute_differences: unpredictable"
          else
            seqT
              (parT (read_reg ii m)
                 (parT (read_reg ii n)
                    (if
                       word_eq a
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4"))))
                     then
                       constT
                         (n2w_itself (ZERO,(ITSELF (fromString "32"))))
                     else read_reg ii a))) (fn (rm,(rn,ra)) =>
              let val absdiff1 =
                      intML.ABS
                        (intML.int_sub
                           (intML.int_of_num
                              (w2n
                                 (word_bits (fromString "7") ZERO rn)))
                           (intML.int_of_num
                              (w2n
                                 (word_bits (fromString "7") ZERO rm))))
                  val absdiff2 =
                      intML.ABS
                        (intML.int_sub
                           (intML.int_of_num
                              (w2n
                                 (word_bits (fromString "15")
                                    (fromString "8") rn)))
                           (intML.int_of_num
                              (w2n
                                 (word_bits (fromString "15")
                                    (fromString "8") rm))))
                  val absdiff3 =
                      intML.ABS
                        (intML.int_sub
                           (intML.int_of_num
                              (w2n
                                 (word_bits (fromString "23")
                                    (fromString "16") rn)))
                           (intML.int_of_num
                              (w2n
                                 (word_bits (fromString "23")
                                    (fromString "16") rm))))
                  val absdiff4 =
                      intML.ABS
                        (intML.int_sub
                           (intML.int_of_num
                              (w2n
                                 (word_bits (fromString "31")
                                    (fromString "24") rn)))
                           (intML.int_of_num
                              (w2n
                                 (word_bits (fromString "31")
                                    (fromString "24") rm))))
                  val result =
                      intML.int_add
                        (intML.int_add
                           (intML.int_add
                              (intML.int_add (intML.int_of_num (w2n ra))
                                 absdiff1) absdiff2) absdiff3) absdiff4
              in
                 seqT
                   (parT (increment_pc ii enc)
                      (write_reg ii d
                         (intML.i2w_itself
                            (result,(ITSELF (fromString "32")))))) (fn
                   (u1,u2) => constT ())
              end))

  fun bit_field_extract_instr ii enc
        (Bit_Field_Extract(unsigned,widthm1,d,lsb,n)) =
        let val lsbit = w2n lsb
            val widthm1 = w2n widthm1
            val msbit = + lsbit widthm1
        in
           seqT (read_info ii) (fn info =>
             if
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             then take_undef_instr_exception ii
             else
               if
                 (if enc = Encoding_Thumb2 then
                    (word_eq d
                       (n2w_itself
                          ((fromString "13"),(ITSELF (fromString "4"))))
                     orelse
                     word_eq d
                       (n2w_itself
                          ((fromString "15"),
                           (ITSELF (fromString "4"))))) orelse
                    (word_eq n
                       (n2w_itself
                          ((fromString "13"),(ITSELF (fromString "4"))))
                     orelse
                     word_eq n
                       (n2w_itself
                          ((fromString "15"),
                           (ITSELF (fromString "4")))))
                  else
                    word_eq d
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4"))))
                    orelse
                    word_eq n
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse not (<= msbit (fromString "31"))
               then
               errorT "bit_field_extract: unpredictable"
             else
               seqT (read_reg ii n) (fn rn =>
                 let val result =
                         if unsigned then
                           word_bits msbit lsbit rn
                         else word_signed_bits msbit lsbit rn
                 in
                    seqT
                      (parT (increment_pc ii enc)
                         (write_reg ii d result)) (fn (u1,u2) =>
                      constT ())
                 end))
        end

  fun bit_field_clear_insert_instr ii enc
        (Bit_Field_Clear_Insert(msb,d,lsb,n)) =
        let val lsbit = w2n lsb
            val msbit = w2n msb
        in
           seqT (read_info ii) (fn info =>
             if
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             then take_undef_instr_exception ii
             else
               if
                 (if enc = Encoding_Thumb2 then
                    (word_eq d
                       (n2w_itself
                          ((fromString "13"),(ITSELF (fromString "4"))))
                     orelse
                     word_eq d
                       (n2w_itself
                          ((fromString "15"),
                           (ITSELF (fromString "4"))))) orelse
                    word_eq n
                      (n2w_itself
                         ((fromString "13"),(ITSELF (fromString "4"))))
                  else
                    word_eq d
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse < msbit lsbit
               then
               errorT "bit_field_clear_insert: unpredictable"
             else
               seqT
                 (parT (read_reg ii d)
                    (if
                       word_eq n
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4"))))
                     then
                       constT
                         (n2w_itself (ZERO,(ITSELF (fromString "32"))))
                     else read_reg ii n)) (fn (rd,rn) =>
                 seqT
                   (parT (increment_pc ii enc)
                      (write_reg ii d
                         (bit_field_insert msbit lsbit rn rd))) (fn
                   (u1,u2) => constT ())))
        end

  fun preload_data_instr ii enc (Preload_Data(add,is_pldw,n,mode2)) =
        seqT (read_info ii) (fn info =>
          if
            not
              (if enc = Encoding_Thumb2 then
                 (ARMinfo_arch info = ARMv6T2) orelse
                 >= (version_number (ARMinfo_arch info))
                   (fromString "7")
               else
                 not (ARMinfo_arch info = ARMv4) andalso
                 (not (ARMinfo_arch info = ARMv4T) andalso
                  not (ARMinfo_arch info = ARMv5T))) orelse
            is_pldw andalso
            (not
               (IN Extension_Multiprocessing (ARMinfo_extensions info))
             orelse
             < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              (case mode2
               of Mode2_immediate(imm12) => false
                | Mode2_register(imm5,type_,m) =>
                     if enc = Encoding_Thumb2 then
                       word_eq m
                         (n2w_itself
                            ((fromString "13"),
                             (ITSELF (fromString "4")))) orelse
                       word_eq m
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4"))))
                     else
                       word_eq m
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) orelse
                       word_eq n
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))) andalso
                       is_pldw)
            then
            errorT "preload_data: unpredictable"
          else
            seqT
              (if is_mode2_immediate mode2 then
                 read_reg_literal ii n
               else read_reg ii n) (fn base =>
              seqT (address_mode2 ii true add base mode2) (fn
                (offset_addr,address) =>
                seqT
                  (parT (increment_pc ii enc)
                     (if is_pldw then
                        hint_preload_data_for_write ii address
                      else hint_preload_data ii address)) (fn (u1,u2) =>
                  constT ()))))

  fun preload_instruction_instr ii enc
        (Preload_Instruction(add,n,mode2)) =
        seqT (read_info ii) (fn info =>
          if
            < (version_number (ARMinfo_arch info)) (fromString "7")
          then take_undef_instr_exception ii
          else
            if
              (case mode2
               of Mode2_immediate(imm12) => false
                | Mode2_register(imm5,type_,m) =>
                     if enc = Encoding_Thumb2 then
                       word_eq m
                         (n2w_itself
                            ((fromString "13"),
                             (ITSELF (fromString "4")))) orelse
                       word_eq m
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4"))))
                     else
                       word_eq m
                         (n2w_itself
                            ((fromString "15"),
                             (ITSELF (fromString "4")))))
            then
            errorT "preload_instruction: unpredictable"
          else
            seqT
              (if is_mode2_immediate mode2 then
                 read_reg_literal ii n
               else read_reg ii n) (fn base =>
              seqT (address_mode2 ii true add base mode2) (fn
                (offset_addr,address) =>
                seqT
                  (parT (increment_pc ii enc)
                     (hint_preload_instr ii address)) (fn (u1,u2) =>
                  constT ()))))

  fun load_instr ii enc (Load(indx,add,load_byte,w,unpriv,n,t,mode2)) =
        let val wback = not indx orelse w
        in
           seqT (read_info ii) (fn info =>
             if
               (enc = Encoding_Thumb2) andalso
               (not (ARMinfo_arch info = ARMv6T2) andalso
                < (version_number (ARMinfo_arch info)) (fromString "7"))
             then take_undef_instr_exception ii
             else
               if
                 unpriv andalso
                 (if enc = Encoding_Thumb2 then
                    not indx orelse (not add orelse w)
                  else indx orelse not w) orelse
                 ((load_byte orelse unpriv) andalso
                  (if enc = Encoding_Thumb2 then
                     word_eq t
                       (n2w_itself
                          ((fromString "13"),(ITSELF (fromString "4"))))
                     orelse
                     word_eq t
                       (n2w_itself
                          ((fromString "15"),(ITSELF (fromString "4"))))
                   else
                     word_eq t
                       (n2w_itself
                          ((fromString "15"),
                           (ITSELF (fromString "4"))))) orelse
                  (wback andalso
                   (word_eq n
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4"))))
                    orelse word_eq n t) orelse
                   (case mode2
                    of Mode2_immediate(imm12) => false
                     | Mode2_register(imm5,type_,m) =>
                          if enc = Encoding_Thumb2 then
                            word_eq m
                              (n2w_itself
                                 ((fromString "13"),
                                  (ITSELF (fromString "4")))) orelse
                            word_eq m
                              (n2w_itself
                                 ((fromString "15"),
                                  (ITSELF (fromString "4"))))
                          else
                            word_eq m
                              (n2w_itself
                                 ((fromString "15"),
                                  (ITSELF (fromString "4")))) orelse
                            wback andalso
                            (< (version_number (ARMinfo_arch info))
                               (fromString "6") andalso word_eq m n))))
               then
               errorT "load: unpredictable"
             else
               null_check_if_thumbEE ii n
                 (seqT
                    (if is_mode2_immediate mode2 then
                       read_reg_literal ii n
                     else read_reg ii n) (fn base =>
                    seqT (address_mode2 ii indx add base mode2) (fn
                      (offset_addr,address) =>
                      seqT
                        (parT
                           (if wback then
                              write_reg ii n offset_addr
                            else constT ())
                           (if load_byte then
                              seqT
                                (if unpriv then
                                   read_memU_unpriv ii (address,ONE)
                                 else read_memU ii (address,ONE)) (fn
                                data =>
                                seqT
                                  (parT (increment_pc ii enc)
                                     (write_reg ii t
                                        (zero_extend32 data))) (fn
                                  (u1,u2) => constT ()))
                            else
                              seqT
                                (if unpriv then
                                   read_memU_unpriv ii
                                     (address,(fromString "4"))
                                 else
                                   read_memU ii
                                     (address,(fromString "4"))) (fn
                                data =>
                                let val data = word32 data
                                in
                                   if
                                     word_eq t
                                       (n2w_itself
                                          ((fromString "15"),
                                           (ITSELF (fromString "4"))))
                                   then
                                  (if
                                     aligned (address,(fromString "4"))
                                   then
                                     load_write_pc ii data
                                   else errorT "load: unpredictable")
                                else
                                  seqT
                                    (parT (increment_pc ii enc)
                                       (seqT (unaligned_support ii) (fn
                                          has_unaligned_support =>
                                          if
                                            has_unaligned_support orelse
                                            aligned
                                              (address,(fromString "4"))
                                          then write_reg ii t data
                                          else
                                            write_reg ii t
                                              (ROR
                                                 (data,
                                                   *  (fromString "8")
                                                    (w2n
                                                       (word_bits ONE
                                                          ZERO
                                                          address)))))))
                                    (fn (u1,u2) => constT ())
                                end))) (fn (u1,u2) => constT ())))))
        end

  fun store_instr ii enc (Store(indx,add,store_byte,w,unpriv,n,t,mode2))
        =
        let val wback = not indx orelse w
        in
           seqT (read_info ii) (fn info =>
             if
               (enc = Encoding_Thumb2) andalso
               (not (ARMinfo_arch info = ARMv6T2) andalso
                < (version_number (ARMinfo_arch info)) (fromString "7"))
             then take_undef_instr_exception ii
             else
               if
                 unpriv andalso
                 (if enc = Encoding_Thumb2 then
                    not indx orelse (not add orelse w)
                  else indx orelse not w) orelse
                 ((if enc = Encoding_Thumb2 then
                     store_byte andalso
                     word_eq t
                       (n2w_itself
                          ((fromString "13"),(ITSELF (fromString "4"))))
                     orelse
                     word_eq t
                       (n2w_itself
                          ((fromString "15"),(ITSELF (fromString "4"))))
                   else
                     store_byte andalso
                     word_eq t
                       (n2w_itself
                          ((fromString "15"),
                           (ITSELF (fromString "4"))))) orelse
                  (wback andalso
                   (word_eq n
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4"))))
                    orelse word_eq n t) orelse
                   (case mode2
                    of Mode2_immediate(imm12) => false
                     | Mode2_register(imm5,type_,m) =>
                          if enc = Encoding_Thumb2 then
                            word_eq m
                              (n2w_itself
                                 ((fromString "13"),
                                  (ITSELF (fromString "4")))) orelse
                            word_eq m
                              (n2w_itself
                                 ((fromString "15"),
                                  (ITSELF (fromString "4"))))
                          else
                            word_eq m
                              (n2w_itself
                                 ((fromString "15"),
                                  (ITSELF (fromString "4")))) orelse
                            wback andalso
                            (< (version_number (ARMinfo_arch info))
                               (fromString "6") andalso word_eq m n))))
               then
               errorT "store: unpredictable"
             else
               null_check_if_thumbEE ii n
                 (seqT
                    (parT (read_reg ii n)
                       (if
                          word_eq t
                            (n2w_itself
                               ((fromString "15"),
                                (ITSELF (fromString "4"))))
                        then
                          pc_store_value ii
                        else read_reg ii t)) (fn (base,data) =>
                    seqT (address_mode2 ii indx add base mode2) (fn
                      (offset_addr,address) =>
                      seqT
                        (parT
                           (if store_byte then
                              (if unpriv then
                                 write_memU_unpriv ii (address,ONE)
                                   (bytes (data,ONE))
                               else
                                 write_memU ii (address,ONE)
                                   (bytes (data,ONE)))
                            else
                              seqT (unaligned_support ii) (fn
                                has_unaligned_support =>
                                let val data =
                                        if
                                          has_unaligned_support orelse
                                          aligned
                                            (address,(fromString "4"))
                                        then
                                          bytes (data,(fromString "4"))
                                        else
                                          [raise Fail "ARB",
                                           raise Fail "ARB",
                                           raise Fail "ARB",
                                           raise Fail "ARB"]
                                in
                                   if unpriv then
                                  write_memU_unpriv ii
                                    (address,(fromString "4")) data
                                else
                                  write_memU ii
                                    (address,(fromString "4")) data
                                end))
                           (parT (increment_pc ii enc)
                              (if wback then
                                 write_reg ii n offset_addr
                               else constT ()))) (fn (u1,(u2,u3)) =>
                        constT ())))))
        end

  fun load_halfword_instr ii enc
        (Load_Halfword(indx,add,w,signed,half,unpriv,n,t,mode3)) =
        let val wback = not indx orelse w
        in
           seqT (read_info ii) (fn info =>
             if
               (enc = Encoding_Thumb2) andalso
               (not (ARMinfo_arch info = ARMv6T2) andalso
                < (version_number (ARMinfo_arch info)) (fromString "7"))
             then take_undef_instr_exception ii
             else
               if
                 unpriv andalso
                 (if enc = Encoding_Thumb2 then
                    not indx orelse (not add orelse w)
                  else indx orelse not w) orelse
                 (not signed andalso not half orelse
                  ((if enc = Encoding_Thumb2 then
                      word_eq t
                        (n2w_itself
                           ((fromString "13"),
                            (ITSELF (fromString "4")))) orelse
                      word_eq t
                        (n2w_itself
                           ((fromString "15"),
                            (ITSELF (fromString "4"))))
                    else
                      word_eq t
                        (n2w_itself
                           ((fromString "15"),
                            (ITSELF (fromString "4"))))) orelse
                   (wback andalso
                    (word_eq n
                       (n2w_itself
                          ((fromString "15"),(ITSELF (fromString "4"))))
                     orelse word_eq n t) orelse
                    (case mode3
                     of Mode3_immediate(imm12) => false
                      | Mode3_register(imm2,m) =>
                           if enc = Encoding_Thumb2 then
                             word_eq m
                               (n2w_itself
                                  ((fromString "13"),
                                   (ITSELF (fromString "4")))) orelse
                             word_eq m
                               (n2w_itself
                                  ((fromString "15"),
                                   (ITSELF (fromString "4"))))
                           else
                             word_eq m
                               (n2w_itself
                                  ((fromString "15"),
                                   (ITSELF (fromString "4")))) orelse
                             wback andalso
                             (< (version_number (ARMinfo_arch info))
                                (fromString "6") andalso
                              word_eq m n)))))
               then
               errorT "load_halfword: unpredictable"
             else
               null_check_if_thumbEE ii n
                 (seqT
                    (if is_mode3_immediate mode3 then
                       read_reg_literal ii n
                     else read_reg ii n) (fn base =>
                    seqT (address_mode3 ii indx add base mode3) (fn
                      (offset_addr,address) =>
                      seqT
                        (parT (increment_pc ii enc)
                           (parT
                              (if wback then
                                 write_reg ii n offset_addr
                               else constT ())
                              (if half then
                                 seqT
                                   (if unpriv then
                                      read_memU_unpriv ii (address,TWO)
                                    else read_memU ii (address,TWO)) (fn
                                   data =>
                                   seqT (unaligned_support ii) (fn
                                     has_unaligned_support =>
                                     if
                                       has_unaligned_support orelse
                                       aligned (address,TWO)
                                     then
                                       (if signed then
                                          write_reg ii t
                                            (sign_extend32 data)
                                        else
                                          write_reg ii t
                                            (zero_extend32 data))
                                     else
                                       write_reg ii t
                                         (raise Fail "ARB")))
                               else
                                 seqT
                                   (if unpriv then
                                      read_memU_unpriv ii (address,ONE)
                                    else read_memU ii (address,ONE)) (fn
                                   data =>
                                   write_reg ii t
                                     (sign_extend32 data))))) (fn
                        (u1,(u2,u3)) => constT ())))))
        end

  fun store_halfword_instr ii enc
        (Store_Halfword(indx,add,w,unpriv,n,t,mode3)) =
        let val wback = not indx orelse w
        in
           seqT (read_info ii) (fn info =>
             if
               (enc = Encoding_Thumb2) andalso
               (not (ARMinfo_arch info = ARMv6T2) andalso
                < (version_number (ARMinfo_arch info)) (fromString "7"))
             then take_undef_instr_exception ii
             else
               if
                 unpriv andalso
                 (if enc = Encoding_Thumb2 then
                    not indx orelse (not add orelse w)
                  else indx orelse not w) orelse
                 ((if enc = Encoding_Thumb2 then
                     word_eq t
                       (n2w_itself
                          ((fromString "13"),(ITSELF (fromString "4"))))
                     orelse
                     word_eq t
                       (n2w_itself
                          ((fromString "15"),(ITSELF (fromString "4"))))
                   else
                     word_eq t
                       (n2w_itself
                          ((fromString "15"),
                           (ITSELF (fromString "4"))))) orelse
                  (wback andalso
                   (word_eq n
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4"))))
                    orelse word_eq n t) orelse
                   (case mode3
                    of Mode3_immediate(imm12) => false
                     | Mode3_register(imm2,m) =>
                          if enc = Encoding_Thumb2 then
                            word_eq m
                              (n2w_itself
                                 ((fromString "13"),
                                  (ITSELF (fromString "4")))) orelse
                            word_eq m
                              (n2w_itself
                                 ((fromString "15"),
                                  (ITSELF (fromString "4"))))
                          else
                            word_eq m
                              (n2w_itself
                                 ((fromString "15"),
                                  (ITSELF (fromString "4")))) orelse
                            wback andalso
                            (< (version_number (ARMinfo_arch info))
                               (fromString "6") andalso word_eq m n))))
               then
               errorT "store_halfword: unpredictable"
             else
               null_check_if_thumbEE ii n
                 (seqT (parT (read_reg ii n) (read_reg ii t)) (fn
                    (base,rt) =>
                    seqT (address_mode3 ii indx add base mode3) (fn
                      (offset_addr,address) =>
                      seqT
                        (parT
                           (seqT (unaligned_support ii) (fn
                              has_unaligned_support =>
                              let val data =
                                      if
                                        has_unaligned_support orelse
                                        aligned (address,TWO)
                                      then
                                        bytes (rt,TWO)
                                      else
                                        [raise Fail "ARB",
                                         raise Fail "ARB"]
                              in
                                 if unpriv then
                                write_memU_unpriv ii (address,TWO) data
                              else write_memU ii (address,TWO) data
                              end))
                           (parT (increment_pc ii enc)
                              (if wback then
                                 write_reg ii n offset_addr
                               else constT ()))) (fn (u1,(u2,u3)) =>
                        constT ())))))
        end

  fun load_multiple_instr ii enc
        (Load_Multiple(indx,add,system,wback,n,registers)) =
        seqT (read_info ii) (fn info =>
          if
            (enc = Encoding_Thumb2) andalso
            (not (ARMinfo_arch info = ARMv6T2) andalso
             < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              word_eq n
                (n2w_itself
                   ((fromString "15"),(ITSELF (fromString "4")))) orelse
              (< (bit_count registers) ONE orelse
               ((enc = Encoding_Thumb2) andalso
                (system orelse
                 (< (bit_count registers) TWO orelse
                  (word_index registers (fromString "15") andalso
                   word_index registers (fromString "14") orelse
                   word_index registers (fromString "13")))) orelse
                (system andalso
                 (wback andalso
                  not (word_index registers (fromString "15"))) orelse
                 wback andalso
                 (word_index registers (w2n n) andalso
                  ((enc = Encoding_Thumb2) orelse
                   >= (version_number (ARMinfo_arch info))
                     (fromString "7"))))))
            then
            errorT "load_multiple: unpredictable"
          else
            null_check_if_thumbEE ii n
              (seqT (parT (read_reg ii n) (read_cpsr ii)) (fn
                 (base,cpsr) =>
                 let val mode =
                         if
                           system andalso
                           not (word_index registers (fromString "15"))
                         then
                           n2w_itself
                             ((fromString "16"),
                              (ITSELF (fromString "5")))
                         else ARMpsr_M cpsr
                     val length =
                         n2w_itself
                           ( *  (fromString "4") (bit_count registers),
                            (ITSELF (fromString "32")))
                     val base_address =
                         if add then base else word_sub base length
                     val start_address =
                         if indx = add then
                           word_add base_address
                             (n2w_itself
                                ((fromString "4"),
                                 (ITSELF (fromString "32"))))
                         else base_address
                     fun address i =
                         word_add start_address
                           (n2w_itself
                              ( *  (fromString "4")
                                 (- (bit_count_upto (+ i ONE) registers)
                                    ONE),(ITSELF (fromString "32"))))
                 in
                    seqT
                      (forT ZERO (fromString "14") (fn i =>
                         if word_index registers i then
                           seqT
                             (read_memA ii (address i,(fromString "4")))
                             (fn d =>
                             write_reg_mode ii
                               (n2w_itself
                                  (i,(ITSELF (fromString "4"))),mode)
                               (word32 d)) else constT ())) (fn
                      unit_list =>
                      seqT
                        (if wback then
                           (if not (word_index registers (w2n n)) then
                              (if add then
                                 write_reg ii n (word_add base length)
                               else
                                 write_reg ii n (word_sub base length))
                            else write_reg ii n (raise Fail "ARB"))
                         else constT ()) (fn u =>
                        if word_index registers (fromString "15") then
                          seqT
                            (read_memA ii
                               (address (fromString "15"),
                                (fromString "4"))) (fn d =>
                            if system then
                              seqT (current_mode_is_user_or_system ii)
                                (fn is_user_or_system =>
                                if is_user_or_system then
                                  errorT
                                    "load_multiple_instr: unpredictable"
                                else
                                  seqT (read_spsr ii) (fn spsr =>
                                    seqT
                                      (cpsr_write_by_instr ii
                                         (encode_psr spsr,
                                          (n2w_itself
                                             ((fromString "15"),
                                              (ITSELF
                                                (fromString "4"))),
                                           true))) (fn u =>
                                      branch_write_pc ii (word32 d))))
                            else load_write_pc ii (word32 d))
                        else increment_pc ii enc))
                 end)))

  fun store_multiple_instr ii enc
        (Store_Multiple(indx,add,system,wback,n,registers)) =
        seqT (read_info ii) (fn info =>
          if
            (enc = Encoding_Thumb2) andalso
            (not (ARMinfo_arch info = ARMv6T2) andalso
             < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              word_eq n
                (n2w_itself
                   ((fromString "15"),(ITSELF (fromString "4")))) orelse
              (< (bit_count registers) ONE orelse
               ((enc = Encoding_Thumb2) andalso
                (< (bit_count registers) TWO orelse
                 (word_index registers (fromString "15") orelse
                  (word_index registers (fromString "13") orelse
                   wback andalso word_index registers (w2n n)))) orelse
                system andalso wback))
            then
            errorT "store_multiple: unpredictable"
          else
            null_check_if_thumbEE ii n
              (seqT (current_mode_is_user_or_system ii) (fn
                 is_user_or_system =>
                 if system andalso is_user_or_system then
                   errorT "store_multiple_instr: unpredictable"
                 else
                   seqT (parT (read_reg ii n) (read_cpsr ii)) (fn
                     (base,cpsr) =>
                     let val mode =
                             if system then
                               n2w_itself
                                 ((fromString "16"),
                                  (ITSELF (fromString "5")))
                             else ARMpsr_M cpsr
                         val length =
                             n2w_itself
                               ( *  (fromString "4")
                                  (bit_count registers),
                                (ITSELF (fromString "32")))
                         val lowest = lowest_set_bit registers
                         val base_address =
                             if add then base else word_sub base length
                         val start_address =
                             if indx = add then
                               word_add base_address
                                 (n2w_itself
                                    ((fromString "4"),
                                     (ITSELF (fromString "32"))))
                             else base_address
                         fun address i =
                             word_add start_address
                               (n2w_itself
                                  ( *  (fromString "4")
                                     (-
                                        (bit_count_upto (+ i ONE)
                                           registers) ONE),
                                   (ITSELF (fromString "32"))))
                     in
                        seqT
                          (forT ZERO (fromString "14") (fn i =>
                             if word_index registers i then
                               (if
                                  (i = w2n n) andalso
                                  (wback andalso not (w2n n = lowest))
                                then
                                  write_memA ii
                                    (address (w2n n),(fromString "4"))
                                    [raise Fail "ARB",raise Fail "ARB",
                                     raise Fail "ARB",raise Fail "ARB"]
                                else
                                  seqT
                                    (read_reg_mode ii
                                       (n2w_itself
                                          (i,(ITSELF (fromString "4"))),
                                        mode)) (fn d =>
                                    write_memA ii
                                      (address i,(fromString "4"))
                                      (bytes (d,(fromString "4")))))
                             else constT ())) (fn unit_list =>
                          seqT
                            (parT
                               (if
                                  word_index registers (fromString "15")
                                then
                                  seqT (pc_store_value ii) (fn pc =>
                                    write_memA ii
                                      (address (fromString "15"),
                                       (fromString "4"))
                                      (bytes (pc,(fromString "4"))))
                                else constT ())
                               (parT (increment_pc ii enc)
                                  (if wback then
                                     (if add then
                                        write_reg ii n
                                          (word_add base length)
                                      else
                                        write_reg ii n
                                          (word_sub base length))
                                   else constT ()))) (fn (u1,(u2,u3)) =>
                            constT ()))
                     end))))

  fun load_dual_instr ii enc (Load_Dual(indx,add,w,n,t,t2,mode3)) =
        let val wback = not indx orelse w
        in
           seqT (read_info ii) (fn info =>
             if
               (if enc = Encoding_Thumb2 then
                  not (ARMinfo_arch info = ARMv6T2) andalso
                  < (version_number (ARMinfo_arch info))
                    (fromString "7")
                else
                  (ARMinfo_arch info = ARMv4) orelse
                  ((ARMinfo_arch info = ARMv4T) orelse
                   (ARMinfo_arch info = ARMv5T)))
             then take_undef_instr_exception ii
             else
               if
                 (if enc = Encoding_Thumb2 then
                    (word_eq t
                       (n2w_itself
                          ((fromString "13"),(ITSELF (fromString "4"))))
                     orelse
                     word_eq t
                       (n2w_itself
                          ((fromString "15"),
                           (ITSELF (fromString "4"))))) orelse
                    ((word_eq t2
                        (n2w_itself
                           ((fromString "13"),
                            (ITSELF (fromString "4")))) orelse
                      word_eq t2
                        (n2w_itself
                           ((fromString "15"),
                            (ITSELF (fromString "4"))))) orelse
                     word_eq t t2)
                  else
                    not indx andalso w orelse
                    (word_index t ZERO orelse
                     (not
                        (word_eq t2
                           (word_add t
                              (n2w_itself
                                 (ONE,(ITSELF (fromString "4"))))))
                      orelse
                      word_eq t2
                        (n2w_itself
                           ((fromString "15"),
                            (ITSELF (fromString "4"))))))) orelse
                 ((case mode3
                   of Mode3_immediate(imm12) => false
                    | Mode3_register(imm2,m) =>
                         not
                           (word_eq imm2
                              (n2w_itself (ZERO,(ITSELF TWO)))) orelse
                         (word_eq m
                            (n2w_itself
                               ((fromString "15"),
                                (ITSELF (fromString "4")))) orelse
                          (word_eq m t orelse
                           (word_eq m t2 orelse
                            < (version_number (ARMinfo_arch info))
                              (fromString "6") andalso
                            (wback andalso word_eq m n))))) orelse
                  wback andalso
                  (word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))
                   orelse (word_eq n t orelse word_eq n t2)))
               then
               errorT "load_dual: unpredictable"
             else
               null_check_if_thumbEE ii n
                 (seqT
                    (if is_mode3_immediate mode3 then
                       read_reg_literal ii n
                     else read_reg ii n) (fn base =>
                    seqT (address_mode3 ii indx add base mode3) (fn
                      (offset_addr,address) =>
                      seqT
                        (parT (increment_pc ii enc)
                           (parT
                              (if wback then
                                 write_reg ii n offset_addr
                               else constT ())
                              (parT
                                 (seqT
                                    (read_memA ii
                                       (address,(fromString "4"))) (fn
                                    data =>
                                    write_reg ii t (word32 data)))
                                 (seqT
                                    (read_memA ii
                                       (word_add address
                                          (n2w_itself
                                             ((fromString "4"),
                                              (ITSELF
                                                (fromString "32")))),
                                        (fromString "4"))) (fn data =>
                                    write_reg ii t2 (word32 data))))))
                        (fn (u1,(u2,(u3,u4))) => constT ())))))
        end

  fun store_dual_instr ii enc (Store_Dual(indx,add,w,n,t,t2,mode3)) =
        let val wback = not indx orelse w
        in
           seqT (read_info ii) (fn info =>
             if
               (if enc = Encoding_Thumb2 then
                  not (ARMinfo_arch info = ARMv6T2) andalso
                  < (version_number (ARMinfo_arch info))
                    (fromString "7")
                else
                  (ARMinfo_arch info = ARMv4) orelse
                  ((ARMinfo_arch info = ARMv4T) orelse
                   (ARMinfo_arch info = ARMv5T)))
             then take_undef_instr_exception ii
             else
               if
                 (if enc = Encoding_Thumb2 then
                    word_eq n
                      (n2w_itself
                         ((fromString "15"),(ITSELF (fromString "4"))))
                    orelse
                    ((word_eq t
                        (n2w_itself
                           ((fromString "13"),
                            (ITSELF (fromString "4")))) orelse
                      word_eq t
                        (n2w_itself
                           ((fromString "15"),
                            (ITSELF (fromString "4"))))) orelse
                     (word_eq t2
                        (n2w_itself
                           ((fromString "13"),
                            (ITSELF (fromString "4")))) orelse
                      word_eq t2
                        (n2w_itself
                           ((fromString "15"),
                            (ITSELF (fromString "4"))))))
                  else
                    not indx andalso w orelse
                    (word_index t ZERO orelse
                     (not
                        (word_eq t2
                           (word_add t
                              (n2w_itself
                                 (ONE,(ITSELF (fromString "4"))))))
                      orelse
                      word_eq t2
                        (n2w_itself
                           ((fromString "15"),
                            (ITSELF (fromString "4"))))))) orelse
                 ((case mode3
                   of Mode3_immediate(imm12) => false
                    | Mode3_register(imm2,m) =>
                         not
                           (word_eq imm2
                              (n2w_itself (ZERO,(ITSELF TWO)))) orelse
                         (word_eq m
                            (n2w_itself
                               ((fromString "15"),
                                (ITSELF (fromString "4")))) orelse
                          < (version_number (ARMinfo_arch info))
                            (fromString "6") andalso
                          (wback andalso word_eq m n))) orelse
                  wback andalso
                  (word_eq n
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))
                   orelse (word_eq n t orelse word_eq n t2)))
               then
               errorT "store_dual: unpredictable"
             else
               null_check_if_thumbEE ii n
                 (seqT
                    (parT (read_reg ii n)
                       (parT (read_reg ii t) (read_reg ii t2))) (fn
                    (base,(rt,rt2)) =>
                    seqT (address_mode3 ii indx add base mode3) (fn
                      (offset_addr,address) =>
                      seqT
                        (parT (increment_pc ii enc)
                           (parT
                              (if wback then
                                 write_reg ii n offset_addr
                               else constT ())
                              (parT
                                 (write_memA ii
                                    (address,(fromString "4"))
                                    (bytes (rt,(fromString "4"))))
                                 (write_memA ii
                                    (word_add address
                                       (n2w_itself
                                          ((fromString "4"),
                                           (ITSELF (fromString "32")))),
                                     (fromString "4"))
                                    (bytes (rt2,(fromString "4")))))))
                        (fn (u1,(u2,(u3,u4))) => constT ())))))
        end

  fun load_exclusive_instr ii enc (Load_Exclusive(n,t,imm8)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 word_eq t
                   (n2w_itself
                      ((fromString "13"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq t
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
               else
                 word_eq t
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
              orelse
              word_eq n
                (n2w_itself
                   ((fromString "15"),(ITSELF (fromString "4"))))
            then
            errorT "load_exclusive: unpredictable"
          else
            null_check_if_thumbEE ii n
              (seqT
                 (parT (increment_pc ii enc)
                    (seqT (read_reg ii n) (fn rn =>
                       let val address =
                               word_add rn
                                 (word_lsl
                                    (w2w_itself
                                       (ITSELF (fromString "32")) imm8)
                                    TWO)
                       in
                          seqT
                            (set_exclusive_monitors ii
                               (address,(fromString "4"))) (fn u =>
                            seqT
                              (read_memA ii (address,(fromString "4")))
                              (fn d => write_reg ii t (word32 d)))
                       end))) (fn (u1,u2) => constT ())))

  fun store_exclusive_instr ii enc (Store_Exclusive(n,d,t,imm8)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 (word_eq t
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq t
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq t
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4"))))
                  orelse
                  not
                    (word_eq imm8
                       (n2w_itself (ZERO,(ITSELF (fromString "8")))))))
              orelse
              (word_eq n
                 (n2w_itself
                    ((fromString "15"),(ITSELF (fromString "4"))))
               orelse (word_eq d n orelse word_eq d t))
            then
            errorT "store_exclusive: unpredictable"
          else
            null_check_if_thumbEE ii n
              (seqT
                 (parT (increment_pc ii enc)
                    (seqT (read_reg ii n) (fn rn =>
                       let val address =
                               word_add rn
                                 (word_lsl
                                    (w2w_itself
                                       (ITSELF (fromString "32")) imm8)
                                    TWO)
                       in
                          seqT
                            (exclusive_monitors_pass ii
                               (address,(fromString "4"))) (fn pass =>
                            if pass then
                              seqT (read_reg ii t) (fn rt =>
                                seqT
                                  (parT
                                     (write_memA ii
                                        (address,(fromString "4"))
                                        (bytes (rt,(fromString "4"))))
                                     (write_reg ii d
                                        (n2w_itself
                                           (ZERO,
                                            (ITSELF
                                              (fromString "32")))))) (fn
                                  (u1,u2) => constT ()))
                            else
                              write_reg ii d
                                (n2w_itself
                                   (ONE,(ITSELF (fromString "32")))))
                       end))) (fn (u1,u2) => constT ())))

  fun load_exclusive_doubleword_instr ii enc
        (Load_Exclusive_Doubleword(n,t,t2)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               not (ARMinfo_arch info = ARMv6K) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq t
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq t
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq t2
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq t2
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse word_eq t t2)
               else
                 word_index t ZERO orelse
                 word_eq t
                   (n2w_itself
                      ((fromString "14"),(ITSELF (fromString "4")))))
              orelse
              word_eq n
                (n2w_itself
                   ((fromString "15"),(ITSELF (fromString "4"))))
            then
            errorT "load_exclusive_doubleword: unpredictable"
          else
            null_check_if_thumbEE ii n
              (seqT
                 (parT (increment_pc ii enc)
                    (seqT (read_reg ii n) (fn address =>
                       seqT
                         (set_exclusive_monitors ii
                            (address,(fromString "8"))) (fn u =>
                         seqT
                           (parT
                              (read_memA ii (address,(fromString "8")))
                              (big_endian ii)) (fn (d,E) =>
                           let val value = word64 d
                           in
                              parT
                                (write_reg ii t
                                   (if E then
                                      word_extract_itself
                                        (ITSELF (fromString "32"))
                                        (fromString "63")
                                        (fromString "32") value
                                    else
                                      word_extract_itself
                                        (ITSELF (fromString "32"))
                                        (fromString "31") ZERO value))
                                (write_reg ii
                                   (word_add t
                                      (n2w_itself
                                         (ONE,
                                          (ITSELF (fromString "4")))))
                                   (if E then
                                      word_extract_itself
                                        (ITSELF (fromString "32"))
                                        (fromString "31") ZERO value
                                    else
                                      word_extract_itself
                                        (ITSELF (fromString "32"))
                                        (fromString "63")
                                        (fromString "32") value))
                           end))))) (fn (u1,u2) => constT ())))

  fun store_exclusive_doubleword_instr ii enc
        (Store_Exclusive_Doubleword(n,d,t,t2)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               not (ARMinfo_arch info = ARMv6K) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 ((word_eq t
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq t
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4")))))
                  orelse
                  (word_eq t2
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq t2
                     (n2w_itself
                        ((fromString "15"),(ITSELF (fromString "4"))))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_index t ZERO orelse
                  word_eq t
                    (n2w_itself
                       ((fromString "14"),(ITSELF (fromString "4"))))))
              orelse
              (word_eq n
                 (n2w_itself
                    ((fromString "15"),(ITSELF (fromString "4"))))
               orelse
               (word_eq d n orelse (word_eq d t orelse word_eq d t2)))
            then
            errorT "store_exclusive_doubleword: unpredictable"
          else
            null_check_if_thumbEE ii n
              (seqT
                 (parT (increment_pc ii enc)
                    (seqT (read_reg ii n) (fn address =>
                       seqT
                         (exclusive_monitors_pass ii
                            (address,(fromString "8"))) (fn pass =>
                         if pass then
                           seqT
                             (parT (read_reg ii t)
                                (parT (read_reg ii t2) (big_endian ii)))
                             (fn (rt,(rt2,E)) =>
                             let val value =
                                     if E then
                                       listML.APPEND
                                         (bytes (rt,(fromString "4")))
                                         (bytes (rt2,(fromString "4")))
                                     else
                                       listML.APPEND
                                         (bytes (rt2,(fromString "4")))
                                         (bytes (rt,(fromString "4")))
                             in
                                seqT
                                  (parT
                                     (write_memA ii
                                        (address,(fromString "8"))
                                        value)
                                     (write_reg ii d
                                        (n2w_itself
                                           (ZERO,
                                            (ITSELF
                                              (fromString "32")))))) (fn
                                  (u1,u2) => constT ())
                             end)
                         else
                           write_reg ii d
                             (n2w_itself
                                (ONE,(ITSELF (fromString "32"))))))))
                 (fn (u1,u2) => constT ())))

  fun load_exclusive_byte_instr ii enc (Load_Exclusive_Byte(n,t)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               not (ARMinfo_arch info = ARMv6K) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 word_eq t
                   (n2w_itself
                      ((fromString "13"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq t
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
               else
                 word_eq t
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
              orelse
              word_eq n
                (n2w_itself
                   ((fromString "15"),(ITSELF (fromString "4"))))
            then
            errorT "load_exclusive_byte: unpredictable"
          else
            null_check_if_thumbEE ii n
              (seqT
                 (parT (increment_pc ii enc)
                    (seqT (read_reg ii n) (fn address =>
                       seqT (set_exclusive_monitors ii (address,ONE))
                         (fn u =>
                         seqT (read_memA ii (address,ONE)) (fn d =>
                           write_reg ii t (zero_extend32 d)))))) (fn
                 (u1,u2) => constT ())))

  fun store_exclusive_byte_instr ii enc (Store_Exclusive_Byte(n,d,t)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               not (ARMinfo_arch info = ARMv6K) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 (word_eq t
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq t
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq t
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
              orelse
              (word_eq n
                 (n2w_itself
                    ((fromString "15"),(ITSELF (fromString "4"))))
               orelse (word_eq d n orelse word_eq d t))
            then
            errorT "store_exclusive_byte: unpredictable"
          else
            null_check_if_thumbEE ii n
              (seqT
                 (parT (increment_pc ii enc)
                    (seqT (read_reg ii n) (fn address =>
                       seqT (exclusive_monitors_pass ii (address,ONE))
                         (fn pass => if pass then
                           seqT (read_reg ii t) (fn rt =>
                             seqT
                               (parT
                                  (write_memA ii (address,ONE)
                                     (bytes (rt,ONE)))
                                  (write_reg ii d
                                     (n2w_itself
                                        (ZERO,
                                         (ITSELF (fromString "32"))))))
                               (fn (u1,u2) => constT ()))
                         else
                           write_reg ii d
                             (n2w_itself
                                (ONE,(ITSELF (fromString "32"))))))))
                 (fn (u1,u2) => constT ())))

  fun load_exclusive_halfword_instr ii enc
        (Load_Exclusive_Halfword(n,t)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               not (ARMinfo_arch info = ARMv6K) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 word_eq t
                   (n2w_itself
                      ((fromString "13"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq t
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
               else
                 word_eq t
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
              orelse
              word_eq n
                (n2w_itself
                   ((fromString "15"),(ITSELF (fromString "4"))))
            then
            errorT "load_exclusive_halfword: unpredictable"
          else
            null_check_if_thumbEE ii n
              (seqT
                 (parT (increment_pc ii enc)
                    (seqT (read_reg ii n) (fn address =>
                       seqT (set_exclusive_monitors ii (address,TWO))
                         (fn u =>
                         seqT (read_memA ii (address,TWO)) (fn d =>
                           write_reg ii t (zero_extend32 d)))))) (fn
                 (u1,u2) => constT ())))

  fun store_exclusive_halfword_instr ii enc
        (Store_Exclusive_Halfword(n,d,t)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               not (ARMinfo_arch info = ARMv6K) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 (word_eq d
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq d
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
                 orelse
                 (word_eq t
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq t
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq t
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
              orelse
              (word_eq n
                 (n2w_itself
                    ((fromString "15"),(ITSELF (fromString "4"))))
               orelse (word_eq d n orelse word_eq d t))
            then
            errorT "store_exclusive_halfword: unpredictable"
          else
            null_check_if_thumbEE ii n
              (seqT
                 (parT (increment_pc ii enc)
                    (seqT (read_reg ii n) (fn address =>
                       seqT (exclusive_monitors_pass ii (address,TWO))
                         (fn pass => if pass then
                           seqT (read_reg ii t) (fn rt =>
                             seqT
                               (parT
                                  (write_memA ii (address,TWO)
                                     (bytes (rt,TWO)))
                                  (write_reg ii d
                                     (n2w_itself
                                        (ZERO,
                                         (ITSELF (fromString "32"))))))
                               (fn (u1,u2) => constT ()))
                         else
                           write_reg ii d
                             (n2w_itself
                                (ONE,(ITSELF (fromString "32"))))))))
                 (fn (u1,u2) => constT ())))

  fun clear_exclusive_instr ii enc =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               not (ARMinfo_arch info = ARMv6K) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            seqT (parT (increment_pc ii enc) (clear_exclusive_local ii))
              (fn (u1,u2) => constT ()))

  fun swap_instr ii (Swap(swap_byte,n,t,t2)) =
        seqT (read_info ii) (fn info =>
          if
            word_eq t
              (n2w_itself ((fromString "15"),(ITSELF (fromString "4"))))
            orelse
            (word_eq t2
               (n2w_itself
                  ((fromString "15"),(ITSELF (fromString "4")))) orelse
             (word_eq n
                (n2w_itself
                   ((fromString "15"),(ITSELF (fromString "4")))) orelse
              (word_eq n t orelse word_eq n t2)))
          then errorT "swap: unpredictable"
          else
            lockT
              (seqT (parT (read_reg ii n) (read_reg ii t2)) (fn
                 (address,rt2) =>
                 seqT
                   (if swap_byte then
                      parT (read_memA ii (address,ONE))
                        (write_memA ii (address,ONE) (bytes (rt2,ONE)))
                    else
                      parT (read_memA ii (address,(fromString "4")))
                        (write_memA ii (address,(fromString "4"))
                           (bytes (rt2,(fromString "4"))))) (fn (d,u) =>
                   seqT
                     (parT (increment_pc ii Encoding_ARM)
                        (if swap_byte then
                           write_reg ii t (zero_extend32 d)
                         else
                           write_reg ii t
                             (ROR
                                (word32 d,
                                  *  (fromString "8")
                                   (w2n
                                      (word_bits ONE ZERO address))))))
                     (fn (u1,u2) => constT ())))))

  fun store_return_state_instr ii enc
        (Store_Return_State(P,inc,wback,mode)) =
        seqT (parT (is_secure ii) (read_nsacr ii)) (fn (is_secure,nsacr)
          =>
          seqT (read_info ii) (fn info =>
            if
              (if enc = Encoding_Thumb2 then
                 not (ARMinfo_arch info = ARMv6T2) andalso
                 < (version_number (ARMinfo_arch info)) (fromString "7")
               else
                 < (version_number (ARMinfo_arch info))
                   (fromString "6"))
            then take_undef_instr_exception ii
            else
              if
                not is_secure andalso
                (word_eq mode
                   (n2w_itself
                      ((fromString "22"),(ITSELF (fromString "5"))))
                 orelse
                 word_eq mode
                   (n2w_itself
                      ((fromString "17"),(ITSELF (fromString "5"))))
                 andalso CP15nsacr_RFR nsacr)
              then
              errorT "store_return_state: unpredictable"
            else
              seqT
                (parT (current_mode_is_user_or_system ii)
                   (current_instr_set ii)) (fn (is_user_or_system,iset)
                =>
                if
                  is_user_or_system orelse (iset = InstrSet_ThumbEE)
                then errorT "store_return_state_instr: unpredictable"
                else
                  seqT
                    (parT
                       (read_reg_mode ii
                          (n2w_itself
                             ((fromString "13"),
                              (ITSELF (fromString "4"))),mode))
                       (parT
                          (read_reg ii
                             (n2w_itself
                                ((fromString "14"),
                                 (ITSELF (fromString "4")))))
                          (read_spsr ii))) (fn (base,(lr,spsr)) =>
                    let val wordhigher = P = inc
                        val address =
                            if inc then
                              base
                            else
                              word_sub base
                                (n2w_itself
                                   ((fromString "8"),
                                    (ITSELF (fromString "32"))))
                        val address =
                            if wordhigher then
                              word_add address
                                (n2w_itself
                                   ((fromString "4"),
                                    (ITSELF (fromString "32"))))
                            else address
                    in
                       seqT
                         (parT (increment_pc ii enc)
                            (parT
                               (write_memA ii (address,(fromString "4"))
                                  (bytes (lr,(fromString "4"))))
                               (parT
                                  (write_memA ii
                                     (word_add address
                                        (n2w_itself
                                           ((fromString "4"),
                                            (ITSELF
                                              (fromString "32")))),
                                      (fromString "4"))
                                     (bytes
                                        (encode_psr spsr,
                                         (fromString "4"))))
                                  (if wback then
                                     write_reg_mode ii
                                       (n2w_itself
                                          ((fromString "13"),
                                           (ITSELF (fromString "4"))),
                                        mode)
                                       (if inc then
                                          word_add base
                                            (n2w_itself
                                               ((fromString "8"),
                                                (ITSELF
                                                  (fromString "32"))))
                                        else
                                          word_sub base
                                            (n2w_itself
                                               ((fromString "8"),
                                                (ITSELF
                                                  (fromString "32")))))
                                   else constT ())))) (fn
                         (u1,(u2,(u3,u4))) => constT ())
                    end))))

  fun return_from_exception_instr ii enc
        (Return_From_Exception(P,inc,wback,n)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            seqT
              (parT (current_mode_is_user_or_system ii)
                 (current_instr_set ii)) (fn (is_user_or_system,iset) =>
              if is_user_or_system orelse (iset = InstrSet_ThumbEE) then
                errorT "return_from_exception_instr: unpredictable"
              else
                seqT (read_reg ii n) (fn base =>
                  let val wordhigher = P = inc
                      val address =
                          if inc then
                            base
                          else
                            word_sub base
                              (n2w_itself
                                 ((fromString "8"),
                                  (ITSELF (fromString "32"))))
                      val address =
                          if wordhigher then
                            word_add address
                              (n2w_itself
                                 ((fromString "4"),
                                  (ITSELF (fromString "32"))))
                          else address
                  in
                     seqT
                       (parT
                          (read_memA ii
                             (word_add address
                                (n2w_itself
                                   ((fromString "4"),
                                    (ITSELF (fromString "32")))),
                              (fromString "4")))
                          (read_memA ii (address,(fromString "4")))) (fn
                       (d1,d2) =>
                       seqT
                         (parT
                            (cpsr_write_by_instr ii
                               (word32 d1,
                                (n2w_itself
                                   ((fromString "15"),
                                    (ITSELF (fromString "4"))),true)))
                            (parT (branch_write_pc ii (word32 d2))
                               (if wback then
                                  write_reg ii n
                                    (if inc then
                                       word_add base
                                         (n2w_itself
                                            ((fromString "8"),
                                             (ITSELF
                                               (fromString "32"))))
                                     else
                                       word_sub base
                                         (n2w_itself
                                            ((fromString "8"),
                                             (ITSELF
                                               (fromString "32")))))
                                else constT ()))) (fn (u1,(u2,u3)) =>
                         constT ()))
                  end)))

  fun status_to_register_instr ii enc (Status_to_Register(readspsr,d)) =
        seqT (read_info ii) (fn info =>
          if
            (enc = Encoding_Thumb2) andalso
            (not (ARMinfo_arch info = ARMv6T2) andalso
             < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              (if enc = Encoding_Thumb2 then
                 word_eq d
                   (n2w_itself
                      ((fromString "13"),(ITSELF (fromString "4"))))
                 orelse
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
               else
                 word_eq d
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4")))))
            then
            errorT "status_to_register: unpredictable"
          else
            seqT
              (parT (increment_pc ii enc)
                 (if readspsr then
                    seqT (current_mode_is_user_or_system ii) (fn
                      is_user_or_system_mode =>
                      if is_user_or_system_mode then
                        errorT "status_to_register_instr: unpredictable"
                      else
                        seqT (read_spsr ii) (fn spsr =>
                          write_reg ii d (encode_psr spsr)))
                  else
                    seqT (read_cpsr ii) (fn cpsr =>
                      write_reg ii d
                        (word_and (encode_psr cpsr)
                           (n2w_itself
                              ((fromString "4177462239"),
                               (ITSELF (fromString "32")))))))) (fn
              (u1,u2) => constT ()))

  fun immediate_to_status_instr ii
        (Immediate_to_Status(writespsr,mask,imm12)) =
        seqT (read_info ii) (fn info =>
          if
            word_eq mask (n2w_itself (ZERO,(ITSELF (fromString "4"))))
          then errorT "immidiate_to_status: unpredictable"
          else
            seqT (arm_expand_imm ii imm12) (fn imm32 =>
              seqT
                (parT (increment_pc ii Encoding_ARM)
                   (if writespsr then
                      spsr_write_by_instr ii (imm32,mask)
                    else cpsr_write_by_instr ii (imm32,(mask,false))))
                (fn (u1,u2) => constT ())))

  fun register_to_status_instr ii enc
        (Register_to_Status(writespsr,mask,n)) =
        seqT (read_info ii) (fn info =>
          if
            (enc = Encoding_Thumb2) andalso
            (not (ARMinfo_arch info = ARMv6T2) andalso
             < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            if
              word_eq mask (n2w_itself (ZERO,(ITSELF (fromString "4"))))
              orelse
              word_eq n
                (n2w_itself
                   ((fromString "15"),(ITSELF (fromString "4"))))
            then
            errorT "register_to_status: unpredictable"
          else
            seqT (read_reg ii n) (fn rn =>
              seqT
                (parT (increment_pc ii enc)
                   (if writespsr then
                      spsr_write_by_instr ii (rn,mask)
                    else cpsr_write_by_instr ii (rn,(mask,false)))) (fn
                (u1,u2) => constT ())))

  fun change_processor_state_instr ii enc
        (Change_Processor_State(imod,affectA,affectI,affectF,mode)) =
        seqT (read_info ii) (fn info =>
          if
            (if enc = Encoding_Thumb2 then
               not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7")
             else
               < (version_number (ARMinfo_arch info)) (fromString "6"))
          then take_undef_instr_exception ii
          else
            if
              word_eq imod (n2w_itself (ZERO,(ITSELF TWO))) andalso
              (mode = optionML.NONE) orelse
              ((word_index imod ONE =
                not affectA andalso (not affectI andalso not affectF))
               orelse word_eq imod (n2w_itself (ONE,(ITSELF TWO))))
            then
            errorT "change_processor_state: unpredictable"
          else
            seqT (current_mode_is_priviledged ii) (fn
              current_mode_is_priviledged =>
              if current_mode_is_priviledged then
                seqT (read_cpsr ii) (fn cpsr =>
                  let val enable =
                          word_eq imod (n2w_itself (TWO,(ITSELF TWO)))
                      val disable =
                          word_eq imod
                            (n2w_itself ((fromString "3"),(ITSELF TWO)))
                      val cpsr_val =
                          encode_psr
                            (ARMpsr_A_fupd
                               (combinML.K
                                  (if affectA then
                                     not enable andalso
                                     (disable orelse ARMpsr_A cpsr)
                                   else ARMpsr_A cpsr))
                               (ARMpsr_I_fupd
                                  (combinML.K
                                     (if affectI then
                                        not enable andalso
                                        (disable orelse ARMpsr_I cpsr)
                                      else ARMpsr_I cpsr))
                                  (ARMpsr_F_fupd
                                     (combinML.K
                                        (if affectF then
                                           not enable andalso
                                           (disable orelse
                                            ARMpsr_F cpsr)
                                         else ARMpsr_F cpsr))
                                     (ARMpsr_M_fupd
                                        (combinML.K
                                           (if
                                              optionML.IS_SOME mode
                                            then
                                              optionML.THE mode
                                            else ARMpsr_M cpsr))
                                        cpsr))))
                  in
                     seqT
                       (parT
                          (cpsr_write_by_instr ii
                             (cpsr_val,
                              (n2w_itself
                                 ((fromString "15"),
                                  (ITSELF (fromString "4"))),true)))
                          (increment_pc ii enc)) (fn (u1,u2) =>
                       constT ())
                  end) else increment_pc ii enc))

  fun set_endianness_instr ii enc (Set_Endianness(set_bigend)) =
        seqT (read_info ii) (fn info =>
          if
            < (version_number (ARMinfo_arch info)) (fromString "6")
          then take_undef_instr_exception ii
          else
            seqT (parT (write_e ii set_bigend) (increment_pc ii enc))
              (fn (u1,u2) => constT ()))

  fun secure_monitor_call_instr ii =
        seqT (read_info ii) (fn info =>
          if
            not (ARMinfo_arch info = ARMv6K) andalso
            not (ARMinfo_arch info = ARMv7_A) orelse
            not (IN Extension_Security (ARMinfo_extensions info))
          then take_undef_instr_exception ii
          else
            seqT (current_mode_is_priviledged ii) (fn
              current_mode_is_priviledged =>
              if current_mode_is_priviledged then take_smc_exception ii
              else take_undef_instr_exception ii))

  fun breakpoint_instr ii =
        seqT (read_info ii) (fn info =>
          if
            < (version_number (ARMinfo_arch info)) (fromString "5")
          then take_undef_instr_exception ii
          else take_prefetch_abort_exception ii)

  fun data_memory_barrier_instr ii enc (Data_Memory_Barrier(option)) =
        seqT (read_info ii) (fn info =>
          if
            < (version_number (ARMinfo_arch info)) (fromString "7")
          then take_undef_instr_exception ii
          else
            seqT
              (parT (increment_pc ii enc)
                 (data_memory_barrier ii (barrier_option option))) (fn
              (u1,u2) => constT ()))

  fun data_synchronization_barrier_instr ii enc
        (Data_Synchronization_Barrier(option)) =
        seqT (read_info ii) (fn info =>
          if
            < (version_number (ARMinfo_arch info)) (fromString "7")
          then take_undef_instr_exception ii
          else
            seqT
              (parT (increment_pc ii enc)
                 (data_synchronization_barrier ii
                    (barrier_option option))) (fn (u1,u2) => constT ()))

  fun instruction_synchronization_barrier_instr ii enc
        (Instruction_Synchronization_Barrier(option)) =
        seqT (read_info ii) (fn info =>
          if
            < (version_number (ARMinfo_arch info)) (fromString "7")
          then take_undef_instr_exception ii
          else
            seqT
              (parT (increment_pc ii enc)
                 (instruction_synchronization_barrier ii)) (fn (u1,u2)
              => constT ()))

  fun coprocessor_data_processing_instr ii enc cond
        (Coprocessor_Data_Processing(opc1,crn,crd,coproc,opc2,crm)) =
        seqT (read_info ii) (fn info =>
          if
            (enc = Encoding_Thumb2) andalso
            (not (ARMinfo_arch info = ARMv6T2) andalso
             < (version_number (ARMinfo_arch info)) (fromString "7"))
          then take_undef_instr_exception ii
          else
            let val ThisInstr =
                    (cond,
                     Coprocessor_Data_Processing(opc1,crn,crd,coproc,
                                                 opc2,crm))
            in
               seqT (coproc_accepted ii (coproc,ThisInstr)) (fn accepted
                 => if not accepted then take_undef_instr_exception ii
                 else
                   seqT
                     (parT (increment_pc ii enc)
                        (coproc_internal_operation ii
                           (coproc,ThisInstr))) (fn (u1,u2) =>
                     constT ()))
            end)

  fun coprocessor_load_instr ii enc cond
        (Coprocessor_Load(p,u,d,w,rn,crd,coproc,mode5)) =
        seqT (current_instr_set ii) (fn iset =>
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                word_eq rn
                  (n2w_itself
                     ((fromString "15"),(ITSELF (fromString "4"))))
                andalso
                (w orelse not p andalso not (iset = InstrSet_ARM))
              then
              errorT "coprocessor_load: unpredictable"
            else
              let val ThisInstr =
                      (cond,
                       Coprocessor_Load(p,u,d,w,rn,crd,coproc,mode5))
              in
                 seqT (coproc_accepted ii (coproc,ThisInstr)) (fn
                   accepted => if not accepted then
                     take_undef_instr_exception ii
                   else
                     seqT (read_reg_literal ii rn) (fn base =>
                       seqT (address_mode5 p u base mode5) (fn
                         (offset_addr,address) =>
                         let fun readm i =
                                 seqT
                                   (read_memA ii
                                      (word_add address
                                         (n2w_itself
                                            ( *  (fromString "4") i,
                                             (ITSELF
                                               (fromString "32")))),
                                       (fromString "4"))) (fn data =>
                                   constT (word32 data))
                         in
                            seqT
                              (parT
                                 (coproc_send_loaded_words ii
                                    (readm,(coproc,ThisInstr)))
                                 (parT (increment_pc ii enc)
                                    (if w then
                                       write_reg ii rn offset_addr
                                     else constT ()))) (fn (u1,(u2,u3))
                              => constT ())
                         end)))
              end))

  fun coprocessor_store_instr ii enc cond
        (Coprocessor_Store(p,u,d,w,rn,crd,coproc,mode5)) =
        seqT (current_instr_set ii) (fn iset =>
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                word_eq rn
                  (n2w_itself
                     ((fromString "15"),(ITSELF (fromString "4"))))
                andalso (w orelse not (iset = InstrSet_ARM))
              then
              errorT "coprocessor_store: unpredictable"
            else
              let val ThisInstr =
                      (cond,
                       Coprocessor_Store(p,u,d,w,rn,crd,coproc,mode5))
              in
                 seqT (coproc_accepted ii (coproc,ThisInstr)) (fn
                   accepted => if not accepted then
                     take_undef_instr_exception ii
                   else
                     seqT (read_reg ii rn) (fn base =>
                       seqT
                         (parT
                            (coproc_get_words_to_store ii
                               (coproc,ThisInstr))
                            (address_mode5 p u base mode5)) (fn
                         (data,(offset_addr,start_address)) =>
                         let fun address i =
                                 word_add start_address
                                   (n2w_itself
                                      ( *  (fromString "4") i,
                                       (ITSELF (fromString "32"))))
                         in
                            seqT
                              (parT
                                 (forT ZERO (- (listML.LENGTH data) ONE)
                                    (fn i =>
                                    write_memA ii
                                      (address i,(fromString "4"))
                                      (bytes
                                         (listML.EL i data,
                                          (fromString "4")))))
                                 (parT (increment_pc ii enc)
                                    (if w then
                                       write_reg ii rn offset_addr
                                     else constT ()))) (fn
                              (unit_list,(u2,u3)) => constT ())
                         end)))
              end))

  fun coprocessor_register_to_arm_instr ii enc cond
        (Coprocessor_Transfer(opc1,true,crn,rt,coproc,opc2,crm)) =
        seqT (current_instr_set ii) (fn iset =>
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                word_eq rt
                  (n2w_itself
                     ((fromString "13"),(ITSELF (fromString "4"))))
                andalso not (iset = InstrSet_ARM)
              then
              errorT "coprocessor_register_to_arm: unpredictable"
            else
              let val ThisInstr =
                      (cond,
                       Coprocessor_Transfer(opc1,true,crn,rt,coproc,
                                            opc2,crm))
              in
                 seqT (coproc_accepted ii (coproc,ThisInstr)) (fn
                   accepted => if not accepted then
                     take_undef_instr_exception ii
                   else
                     seqT (coproc_get_one_word ii (coproc,ThisInstr))
                       (fn value =>
                       seqT
                         (parT (increment_pc ii enc)
                            (if
                               not
                                 (word_eq rt
                                    (n2w_itself
                                       ((fromString "15"),
                                        (ITSELF (fromString "4")))))
                             then
                               write_reg ii rt value
                             else
                               write_flags ii
                                 (word_index value (fromString "31"),
                                  (word_index value (fromString "30"),
                                   (word_index value (fromString "29"),
                                    word_index value
                                      (fromString "28")))))) (fn (u1,u2)
                         => constT ())))
              end))

  fun arm_register_to_coprocessor_instr ii enc cond
        (Coprocessor_Transfer(opc1,false,crn,rt,coproc,opc2,crm)) =
        seqT (current_instr_set ii) (fn iset =>
          seqT (read_info ii) (fn info =>
            if
              (enc = Encoding_Thumb2) andalso
              (not (ARMinfo_arch info = ARMv6T2) andalso
               < (version_number (ARMinfo_arch info)) (fromString "7"))
            then take_undef_instr_exception ii
            else
              if
                word_eq rt
                  (n2w_itself
                     ((fromString "15"),(ITSELF (fromString "4"))))
                orelse
                word_eq rt
                  (n2w_itself
                     ((fromString "13"),(ITSELF (fromString "4"))))
                andalso not (iset = InstrSet_ARM)
              then
              errorT "arm_register_to_coprocessor: unpredictable"
            else
              let val ThisInstr =
                      (cond,
                       Coprocessor_Transfer(opc1,false,crn,rt,coproc,
                                            opc2,crm))
              in
                 seqT (coproc_accepted ii (coproc,ThisInstr)) (fn
                   accepted => if not accepted then
                     take_undef_instr_exception ii
                   else
                     seqT (read_reg ii rt) (fn value =>
                       seqT
                         (parT (increment_pc ii enc)
                            (coproc_send_one_word ii
                               (value,(coproc,ThisInstr)))) (fn (u1,u2)
                         => constT ())))
              end))

  fun coprocessor_register_to_arm_two_instr ii enc cond
        (Coprocessor_Transfer_Two(true,rt2,rt,coproc,opc1,crm)) =
        seqT (current_instr_set ii) (fn iset =>
          seqT (read_info ii) (fn info =>
            if
              not
                (if enc = Encoding_Thumb2 then
                   (ARMinfo_arch info = ARMv6T2) orelse
                   >= (version_number (ARMinfo_arch info))
                     (fromString "7")
                 else
                   if
                     word_eq cond
                       (n2w_itself
                          ((fromString "15"),(ITSELF (fromString "4"))))
                   then
                   >= (version_number (ARMinfo_arch info))
                     (fromString "6")
                 else
                   not (ARMinfo_arch info = ARMv4) andalso
                   (not (ARMinfo_arch info = ARMv4T) andalso
                    not (ARMinfo_arch info = ARMv5T)))
            then take_undef_instr_exception ii
            else
              if
                word_eq rt
                  (n2w_itself
                     ((fromString "15"),(ITSELF (fromString "4"))))
                orelse
                (word_eq rt2
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq rt rt2 orelse
                  (word_eq rt
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4"))))
                   orelse
                   word_eq rt2
                     (n2w_itself
                        ((fromString "13"),(ITSELF (fromString "4")))))
                  andalso not (iset = InstrSet_ARM)))
              then
              errorT "coprocessor_register_to_arm_two: unpredictable"
            else
              let val ThisInstr =
                      (cond,
                       Coprocessor_Transfer_Two(true,rt2,rt,coproc,opc1,
                                                crm))
              in
                 seqT (coproc_accepted ii (coproc,ThisInstr)) (fn
                   accepted => if not accepted then
                     take_undef_instr_exception ii
                   else
                     seqT (coproc_get_two_words ii (coproc,ThisInstr))
                       (fn (data1,data2) =>
                       seqT
                         (parT (increment_pc ii enc)
                            (parT (write_reg ii rt data1)
                               (write_reg ii rt2 data2))) (fn
                         (u1,(u2,u3)) => constT ())))
              end))

  fun arm_register_to_coprocessor_two_instr ii enc cond
        (Coprocessor_Transfer_Two(false,rt2,rt,coproc,opc1,crm)) =
        seqT (current_instr_set ii) (fn iset =>
          seqT (read_info ii) (fn info =>
            if
              not
                (if enc = Encoding_Thumb2 then
                   (ARMinfo_arch info = ARMv6T2) orelse
                   >= (version_number (ARMinfo_arch info))
                     (fromString "7")
                 else
                   if
                     word_eq cond
                       (n2w_itself
                          ((fromString "15"),(ITSELF (fromString "4"))))
                   then
                   >= (version_number (ARMinfo_arch info))
                     (fromString "6")
                 else
                   not (ARMinfo_arch info = ARMv4) andalso
                   (not (ARMinfo_arch info = ARMv4T) andalso
                    not (ARMinfo_arch info = ARMv5T)))
            then take_undef_instr_exception ii
            else
              if
                word_eq rt
                  (n2w_itself
                     ((fromString "15"),(ITSELF (fromString "4"))))
                orelse
                (word_eq rt2
                   (n2w_itself
                      ((fromString "15"),(ITSELF (fromString "4"))))
                 orelse
                 (word_eq rt
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4"))))
                  orelse
                  word_eq rt2
                    (n2w_itself
                       ((fromString "13"),(ITSELF (fromString "4")))))
                 andalso not (iset = InstrSet_ARM))
              then
              errorT "arm_register_to_coprocessor_two: unpredictable"
            else
              let val ThisInstr =
                      (cond,
                       Coprocessor_Transfer_Two(false,rt2,rt,coproc,
                                                opc1,crm))
              in
                 seqT (coproc_accepted ii (coproc,ThisInstr)) (fn
                   accepted => if not accepted then
                     take_undef_instr_exception ii
                   else
                     seqT (parT (read_reg ii rt) (read_reg ii rt2)) (fn
                       data =>
                       seqT
                         (parT (increment_pc ii enc)
                            (coproc_send_two_words ii
                               (data,(coproc,ThisInstr)))) (fn (u1,u2)
                         => constT ())))
              end))

  fun no_operation_instr ii enc =
        seqT (read_info ii) (fn info =>
          if
            (not (ARMinfo_arch info = ARMv6T2) andalso
             < (version_number (ARMinfo_arch info)) (fromString "7"))
            andalso
            (not (enc = Encoding_ARM) orelse
             not (ARMinfo_arch info = ARMv6K))
          then take_undef_instr_exception ii else increment_pc ii enc)

  fun yield_instr ii enc =
        seqT (read_arch ii) (fn arch => if arch = ARMv6T2 then
            no_operation_instr ii enc
          else
            seqT (read_info ii) (fn info =>
              if
                (if enc = Encoding_ARM then
                   not (ARMinfo_arch info = ARMv6K) andalso
                   < (version_number (ARMinfo_arch info))
                     (fromString "7")
                 else
                   < (version_number (ARMinfo_arch info))
                     (fromString "7"))
              then take_undef_instr_exception ii
              else
                seqT (parT (increment_pc ii enc) (hint_yield ii)) (fn
                  (u1,u2) => constT ())))

  fun wait_for_event_instr ii enc =
        seqT (read_arch ii) (fn arch => if arch = ARMv6T2 then
            no_operation_instr ii enc
          else
            seqT (read_info ii) (fn info =>
              if
                (if enc = Encoding_ARM then
                   not (ARMinfo_arch info = ARMv6K) andalso
                   < (version_number (ARMinfo_arch info))
                     (fromString "7")
                 else
                   < (version_number (ARMinfo_arch info))
                     (fromString "7"))
              then take_undef_instr_exception ii
              else
                seqT
                  (parT (increment_pc ii enc)
                     (seqT (event_registered ii) (fn registered =>
                        if registered then clear_event_register ii
                        else wait_for_event ii))) (fn (u1,u2) =>
                  constT ())))

  fun send_event_instr ii enc =
        seqT (read_arch ii) (fn arch => if arch = ARMv6T2 then
            no_operation_instr ii enc
          else
            seqT (read_info ii) (fn info =>
              if
                (if enc = Encoding_ARM then
                   not (ARMinfo_arch info = ARMv6K) andalso
                   < (version_number (ARMinfo_arch info))
                     (fromString "7")
                 else
                   < (version_number (ARMinfo_arch info))
                     (fromString "7"))
              then take_undef_instr_exception ii
              else
                seqT (parT (increment_pc ii enc) (send_event ii)) (fn
                  (u1,u2) => constT ())))

  fun wait_for_interrupt_instr ii enc =
        seqT (read_arch ii) (fn arch => if arch = ARMv6T2 then
            no_operation_instr ii enc
          else
            seqT (read_info ii) (fn info =>
              if
                (if enc = Encoding_ARM then
                   not (ARMinfo_arch info = ARMv6K) andalso
                   < (version_number (ARMinfo_arch info))
                     (fromString "7")
                 else
                   < (version_number (ARMinfo_arch info))
                     (fromString "7"))
              then take_undef_instr_exception ii
              else
                seqT
                  (parT (increment_pc ii enc) (wait_for_interrupt ii))
                  (fn (u1,u2) => constT ())))

  fun debug_instr ii enc option =
        seqT (read_arch ii) (fn arch =>
          if
            (arch = ARMv6T2) orelse
            (enc = Encoding_ARM) andalso (arch = ARMv6K)
          then no_operation_instr ii enc
          else
            seqT (read_info ii) (fn info =>
              if
                < (version_number (ARMinfo_arch info)) (fromString "7")
              then take_undef_instr_exception ii
              else
                seqT (parT (increment_pc ii enc) (hint_debug ii option))
                  (fn (u1,u2) => constT ())))

  fun condition_passed ii cond =
        seqT (read_flags ii) (fn (n,(z,(c,v))) =>
          let val result =
                  case
                    word_eq
                      (word_extract_itself (ITSELF (fromString "3"))
                         (fromString "3") ONE cond)
                      (n2w_itself (ZERO,(ITSELF (fromString "3"))))
                   of true => z
                    | false =>
                         (case
                            word_eq
                              (word_extract_itself
                                 (ITSELF (fromString "3"))
                                 (fromString "3") ONE cond)
                              (n2w_itself
                                 (ONE,(ITSELF (fromString "3"))))
                          of true => c
                           | false =>
                                (case
                                   word_eq
                                     (word_extract_itself
                                        (ITSELF (fromString "3"))
                                        (fromString "3") ONE cond)
                                     (n2w_itself
                                        (TWO,(ITSELF (fromString "3"))))
                                 of true => n
                                  | false =>
                                       (case
                                          word_eq
                                            (word_extract_itself
                                               (ITSELF (fromString "3"))
                                               (fromString "3") ONE
                                               cond)
                                            (n2w_itself
                                               ((fromString "3"),
                                                (ITSELF
                                                  (fromString "3"))))
                                        of true => v
                                         | false =>
                                              (case
                                                 word_eq
                                                   (word_extract_itself
                                                      (ITSELF
                                                        (fromString
                                                        "3"))
                                                      (fromString "3")
                                                      ONE cond)
                                                   (n2w_itself
                                                      ((fromString "4"),
                                                       (ITSELF
                                                         (fromString
                                                         "3"))))
                                               of true =>
                                                     c andalso not z
                                                | false =>
                                                     (case
                                                        word_eq
                                                          (word_extract_itself
                                                             (ITSELF
                                                               (fromString
                                                               "3"))
                                                             (fromString
                                                             "3") ONE
                                                             cond)
                                                          (n2w_itself
                                                             ((fromString
                                                              "5"),
                                                              (ITSELF
                                                                (fromString
                                                                "3"))))
                                                      of true => n = v
                                                       | false =>
                                                            (case
                                                               word_eq
                                                                 (word_extract_itself
                                                                    (ITSELF
                                                                      (fromString
                                                                      "3"))
                                                                    (fromString
                                                                    "3")
                                                                    ONE
                                                                    cond)
                                                                 (n2w_itself
                                                                    ((fromString
                                                                     "6"),
                                                                     (ITSELF
                                                                       (fromString
                                                                       "3"))))
                                                             of true =>
                                                                   (n =
                                                                    v)
                                                                   andalso
                                                                   not z
                                                              | false =>
                                                                   (case
                                                                      word_eq
                                                                        (word_extract_itself
                                                                           (ITSELF
                                                                             (fromString
                                                                             "3"))
                                                                           (fromString
                                                                           "3")
                                                                           ONE
                                                                           cond)
                                                                        (n2w_itself
                                                                           ((fromString
                                                                            "7"),
                                                                            (ITSELF
                                                                              (fromString
                                                                              "3"))))
                                                                    of true =>
                                                                          true
                                                                     | false =>
                                                                          raise Fail "ARB")))))))
          in
             if
               word_index cond ZERO andalso
               not
                 (word_eq cond
                    (n2w_itself
                       ((fromString "15"),(ITSELF (fromString "4")))))
             then
            constT (not result)
          else constT result
          end)

  fun branch_instruction ii (enc,inst) =
        case inst
         of Branch_Target(imm24) => branch_target_instr ii enc inst
          | Branch_Exchange(rm) => branch_exchange_instr ii inst
          | Branch_Link_Exchange_Immediate(H,toARM,imm24_1) =>
               branch_link_exchange_imm_instr ii enc inst
          | Branch_Link_Exchange_Register(rm_1) =>
               branch_link_exchange_reg_instr ii inst
          | Compare_Branch(nonzero,imm6,rn) =>
               compare_branch_instr ii inst
          | Table_Branch_Byte(rn_1,h,rm_2) =>
               table_branch_byte_instr ii inst
          | Check_Array(rn_2,rm_3) => check_array_instr ii inst
          | Handler_Branch_Link(l,handler) =>
               handler_branch_link_instr ii inst
          | Handler_Branch_Link_Parameter(imm5,handler_1) =>
               handler_branch_link_parameter_instr ii inst
          | Handler_Branch_Parameter(imm3,handler_2) =>
               handler_branch_parameter_instr ii inst

  fun data_processing_instruction ii (enc,inst) =
        case inst
         of Data_Processing(opc,s,rn,rd,mode1) =>
               data_processing_instr ii enc inst
          | Add_Sub(add,n,d,imm12) => add_sub_instr ii enc inst
          | Move_Halfword(high,rd_1,imm16) =>
               move_halfword_instr ii enc inst
          | Multiply(a,s_1,rd_2,ra,rm,rn_1) =>
               multiply_instr ii enc inst
          | Multiply_Subtract(rd_3,ra_1,rm_1,rn_2) =>
               multiply_subtract_instr ii enc inst
          | Signed_Halfword_Multiply(v22,m,n_1,rd_4,ra_2,rm_2,rn_3) =>
               (case word_eq v22 (n2w_itself (ZERO,(ITSELF TWO)))
                of true =>
                      signed_16_multiply_32_accumulate_instr ii enc inst
                 | false =>
                      (case word_eq v22 (n2w_itself (ONE,(ITSELF TWO)))
                       of true =>
                             (case n_1
                              of true =>
                                    signed_16x32_multiply_32_result_instr
                                      ii enc inst
                               | false =>
                                    signed_16x32_multiply_32_accumulate_instr
                                      ii enc inst)
                        | false =>
                             (case
                                word_eq v22
                                  (n2w_itself (TWO,(ITSELF TWO)))
                              of true =>
                                    signed_16_multiply_64_accumulate_instr
                                      ii enc inst
                               | false =>
                                    signed_16_multiply_32_result_instr
                                      ii enc inst)))
          | Signed_Multiply_Dual(rd_5,ra_3,rm_3,sub,m_swap,rn_4) =>
               signed_multiply_dual_instr ii enc inst
          | Signed_Multiply_Long_Dual(rdhi,rdlo,rm_4,sub_1,m_swap_1,
                                      rn_5) =>
               signed_multiply_long_dual_instr ii enc inst
          | Signed_Most_Significant_Multiply(rd_6,ra_4,rm_5,round,
                                             rn_6) =>
               signed_most_significant_multiply_instr ii enc inst
          | Signed_Most_Significant_Multiply_Subtract(rd_7,ra_5,rm_6,
                                                      round_1,rn_7) =>
               signed_most_significant_multiply_subtract_instr ii enc
                 inst
          | Multiply_Long(u,a_1,s_2,rdhi_1,rdlo_1,rm_7,rn_8) =>
               multiply_long_instr ii enc inst
          | Multiply_Accumulate_Accumulate(rdhi_2,rdlo_2,rm_8,rn_9) =>
               multiply_accumulate_accumulate_instr ii enc inst
          | Saturate(u_1,sat_imm5,rd_8,imm5,sh,rn_10) =>
               saturate_instr ii enc inst
          | Saturate_16(u_2,sat_imm4,rd_9,rn_11) =>
               saturate_16_instr ii enc inst
          | Saturating_Add_Subtract(opc_2,rn_12,rd_10,rm_9) =>
               saturating_add_subtract_instr ii enc inst
          | Pack_Halfword(rn_13,rd_11,imm5_1,tbform,rm_10) =>
               pack_halfword_instr ii enc inst
          | Extend_Byte(u_3,rn_14,rd_12,rotate,rm_11) =>
               extend_byte_instr ii enc inst
          | Extend_Byte_16(u_4,rn_15,rd_13,rotate_1,rm_12) =>
               extend_byte_16_instr ii enc inst
          | Extend_Halfword(u_5,rn_16,rd_14,rotate_2,rm_13) =>
               extend_halfword_instr ii enc inst
          | Bit_Field_Clear_Insert(msb,rd_15,lsb,rn_17) =>
               bit_field_clear_insert_instr ii enc inst
          | Count_Leading_Zeroes(rd_16,rm_14) =>
               count_leading_zeroes_instr ii enc inst
          | Reverse_Bits(rd_17,rm_15) => reverse_bits_instr ii enc inst
          | Byte_Reverse_Word(rd_18,rm_16) =>
               byte_reverse_word_instr ii enc inst
          | Byte_Reverse_Packed_Halfword(rd_19,rm_17) =>
               byte_reverse_packed_halfword_instr ii enc inst
          | Byte_Reverse_Signed_Halfword(rd_20,rm_18) =>
               byte_reverse_signed_halfword_instr ii enc inst
          | Bit_Field_Extract(u_6,widthm1,rd_21,lsb_1,rn_18) =>
               bit_field_extract_instr ii enc inst
          | Select_Bytes(rn_19,rd_22,rm_19) =>
               select_bytes_instr ii enc inst
          | Unsigned_Sum_Absolute_Differences(rd_23,ra_6,rm_20,rn_20) =>
               unsigned_sum_absolute_differences_instr ii enc inst
          | Parallel_Add_Subtract(u_7,op_,rn_21,rd_24,rm_21) =>
               parallel_add_subtract_instr ii enc inst
          | Divide(u_8,rn_22,rd_25,rm_22) => divide_instr ii inst

  fun status_access_instruction ii (enc,inst) =
        case inst
         of Status_to_Register(r,rd) =>
               status_to_register_instr ii enc inst
          | Register_to_Status(r_2,mask_1,rn) =>
               register_to_status_instr ii enc inst
          | Immediate_to_Status(r_1,mask,imm12) =>
               immediate_to_status_instr ii inst
          | Change_Processor_State(imod,affectA,affectI,affectF,mode) =>
               change_processor_state_instr ii enc inst
          | Set_Endianness(set_bigend) =>
               set_endianness_instr ii enc inst

  fun load_store_instruction ii (enc,inst) =
        case inst
         of Load(p,u,b,w,unpriv,rn,rt,mode2) => load_instr ii enc inst
          | Store(p_1,u_1,b_1,w_1,unpriv_1,rn_1,rt_1,mode2_1) =>
               store_instr ii enc inst
          | Load_Halfword(p_2,u_2,w_2,s,h,unpriv_2,rn_2,rt_2,mode3) =>
               load_halfword_instr ii enc inst
          | Store_Halfword(p_3,u_3,w_3,unpriv_3,rn_3,rt_3,mode3_1) =>
               store_halfword_instr ii enc inst
          | Load_Dual(p_4,u_4,w_4,rn_4,rt_4,rt2,mode3_2) =>
               load_dual_instr ii enc inst
          | Store_Dual(p_5,u_5,w_5,rn_5,rt_5,rt2_1,mode3_3) =>
               store_dual_instr ii enc inst
          | Load_Multiple(p_6,u_6,s_1,w_6,rn_6,registers) =>
               load_multiple_instr ii enc inst
          | Store_Multiple(p_7,u_7,s_2,w_7,rn_7,registers_1) =>
               store_multiple_instr ii enc inst
          | Load_Exclusive(rn_8,rt_6,imm8) =>
               load_exclusive_instr ii enc inst
          | Store_Exclusive(rn_9,rd,rt_7,imm8_1) =>
               store_exclusive_instr ii enc inst
          | Load_Exclusive_Doubleword(rn_10,rt_8,rt2_2) =>
               load_exclusive_doubleword_instr ii enc inst
          | Store_Exclusive_Doubleword(rn_11,rd_1,rt_9,rt2_3) =>
               store_exclusive_doubleword_instr ii enc inst
          | Load_Exclusive_Halfword(rn_12,rt_10) =>
               load_exclusive_halfword_instr ii enc inst
          | Store_Exclusive_Halfword(rn_13,rd_2,rt_11) =>
               store_exclusive_halfword_instr ii enc inst
          | Load_Exclusive_Byte(rn_14,rt_12) =>
               load_exclusive_byte_instr ii enc inst
          | Store_Exclusive_Byte(rn_15,rd_3,rt_13) =>
               store_exclusive_byte_instr ii enc inst
          | Store_Return_State(p_8,u_8,w_8,mode) =>
               store_return_state_instr ii enc inst
          | Return_From_Exception(p_9,u_9,w_9,rn_16) =>
               return_from_exception_instr ii enc inst

  fun miscellaneous_instruction ii (enc,inst) =
        case inst
         of Hint(Hint_nop) => no_operation_instr ii enc
          | Hint(Hint_yield) => yield_instr ii enc
          | Hint(Hint_wait_for_event) => wait_for_event_instr ii enc
          | Hint(Hint_wait_for_interrupt) =>
               wait_for_interrupt_instr ii enc
          | Hint(Hint_send_event) => send_event_instr ii enc
          | Hint(Hint_debug(option)) => debug_instr ii enc option
          | Breakpoint(imm16) => breakpoint_instr ii
          | Data_Memory_Barrier(option_1) =>
               data_memory_barrier_instr ii enc inst
          | Data_Synchronization_Barrier(option_2) =>
               data_synchronization_barrier_instr ii enc inst
          | Instruction_Synchronization_Barrier(option_3) =>
               instruction_synchronization_barrier_instr ii enc inst
          | Swap(b,rn,rt,rt2) => swap_instr ii inst
          | Preload_Data(u,r,rn_1,mode2) =>
               preload_data_instr ii enc inst
          | Preload_Instruction(u_1,rn_2,mode2_1) =>
               preload_instruction_instr ii enc inst
          | Supervisor_Call(imm24) => take_svc_exception ii
          | Secure_Monitor_Call(imm4) => secure_monitor_call_instr ii
          | Enterx_Leavex(is_enterx) => enterx_leavex_instr ii is_enterx
          | Clear_Exclusive => clear_exclusive_instr ii enc
          | If_Then(firstcond,mask) => if_then_instr ii inst

  fun coprocessor_instruction ii (enc,(cond,inst)) =
        case inst
         of Coprocessor_Load(p,u,d,w,rn,crd,coproc,mode5) =>
               coprocessor_load_instr ii enc cond inst
          | Coprocessor_Store(p_1,u_1,d_1,w_1,rn_1,crd_1,coproc_1,
                              mode5_1) =>
               coprocessor_store_instr ii enc cond inst
          | Coprocessor_Data_Processing(opc1,crn,crd_2,coproc_2,opc2,
                                        crm) =>
               coprocessor_data_processing_instr ii enc cond inst
          | Coprocessor_Transfer(opc1_1,true,crn_1,rt,coproc_3,opc2_1,
                                 crm_1) =>
               coprocessor_register_to_arm_instr ii enc cond inst
          | Coprocessor_Transfer(opc1_1,false,crn_1,rt,coproc_3,opc2_1,
                                 crm_1) =>
               arm_register_to_coprocessor_instr ii enc cond inst
          | Coprocessor_Transfer_Two(true,rt2,rt_1,coproc_4,opc1_2,
                                     crm_2) =>
               coprocessor_register_to_arm_two_instr ii enc cond inst
          | Coprocessor_Transfer_Two(false,rt2,rt_1,coproc_4,opc1_2,
                                     crm_2) =>
               arm_register_to_coprocessor_two_instr ii enc cond inst

  fun arm_instr ii (enc,(cond,inst)) =
        seqT
          (seqT (condition_passed ii cond) (fn pass => if pass then
               (case inst
                of Unpredictable => errorT "decode: unpredictable"
                 | Undefined => take_undef_instr_exception ii
                 | Branch(b) => branch_instruction ii (enc,b)
                 | DataProcessing(d) =>
                      data_processing_instruction ii (enc,d)
                 | StatusAccess(s) =>
                      status_access_instruction ii (enc,s)
                 | LoadStore(l) => load_store_instruction ii (enc,l)
                 | Miscellaneous(m) =>
                      miscellaneous_instruction ii (enc,m)
                 | Coprocessor(c) =>
                      coprocessor_instruction ii (enc,(cond,c)))
             else increment_pc ii enc)) (fn u =>
          condT
            (case inst
             of Unpredictable => true
              | Undefined => true
              | Branch(v6) => true
              | DataProcessing(v7) => true
              | StatusAccess(v8) => true
              | LoadStore(v9) => true
              | Miscellaneous(Hint(v33)) => true
              | Miscellaneous(Breakpoint(v34)) => true
              | Miscellaneous(Data_Memory_Barrier(v35)) => true
              | Miscellaneous(Data_Synchronization_Barrier(v36)) => true
              | Miscellaneous(Instruction_Synchronization_Barrier(v37)) =>
                   true
              | Miscellaneous(Swap(v38,v39,v40,v41)) => true
              | Miscellaneous(Preload_Data(v42,v43,v44,v45)) => true
              | Miscellaneous(Preload_Instruction(v46,v47,v48)) => true
              | Miscellaneous(Supervisor_Call(v49)) => true
              | Miscellaneous(Secure_Monitor_Call(v50)) => true
              | Miscellaneous(Enterx_Leavex(v51)) => true
              | Miscellaneous(Clear_Exclusive) => true
              | Miscellaneous(If_Then(v52,v53)) => false
              | Coprocessor(v11) => true) (IT_advance ii))

  fun hint_decode w =
        case word_eq w (n2w_itself (ZERO,(ITSELF (fromString "8"))))
         of true => Hint_nop
          | false =>
               (case
                  word_eq w (n2w_itself (ONE,(ITSELF (fromString "8"))))
                of true => Hint_yield
                 | false =>
                      (case
                         word_eq w
                           (n2w_itself (TWO,(ITSELF (fromString "8"))))
                       of true => Hint_wait_for_event
                        | false =>
                             (case
                                word_eq w
                                  (n2w_itself
                                     ((fromString "3"),
                                      (ITSELF (fromString "8"))))
                              of true => Hint_wait_for_interrupt
                               | false =>
                                    (case
                                       word_eq w
                                         (n2w_itself
                                            ((fromString "4"),
                                             (ITSELF (fromString "8"))))
                                     of true => Hint_send_event
                                      | false =>
                                           if
                                             word_eq
                                               (word_bits
                                                  (fromString "7")
                                                  (fromString "4") w)
                                               (n2w_itself
                                                  ((fromString "15"),
                                                   (ITSELF
                                                     (fromString "8"))))
                                           then
                                             Hint_debug(w2w_itself
                                                          (ITSELF
                                                            (fromString
                                                            "4")) w)
                                           else Hint_nop))))

  fun parallel_add_sub_op1 w =
        case word_eq w (n2w_itself (ONE,(ITSELF TWO)))
         of true => Parallel_normal
          | false =>
               (case word_eq w (n2w_itself (TWO,(ITSELF TWO)))
                of true => Parallel_saturating
                 | false =>
                      (case
                         word_eq w
                           (n2w_itself ((fromString "3"),(ITSELF TWO)))
                       of true => Parallel_halving
                        | false =>
                             raise (Fail
                                "parallel_add_sub_op1: can't decode")))

  fun parallel_add_sub_op2 w =
        case word_eq w (n2w_itself (ZERO,(ITSELF (fromString "3"))))
         of true => Parallel_add_16
          | false =>
               (case
                  word_eq w (n2w_itself (ONE,(ITSELF (fromString "3"))))
                of true => Parallel_add_sub_exchange
                 | false =>
                      (case
                         word_eq w
                           (n2w_itself (TWO,(ITSELF (fromString "3"))))
                       of true => Parallel_sub_add_exchange
                        | false =>
                             (case
                                word_eq w
                                  (n2w_itself
                                     ((fromString "3"),
                                      (ITSELF (fromString "3"))))
                              of true => Parallel_sub_16
                               | false =>
                                    (case
                                       word_eq w
                                         (n2w_itself
                                            ((fromString "4"),
                                             (ITSELF (fromString "3"))))
                                     of true => Parallel_add_8
                                      | false =>
                                           (case
                                              word_eq w
                                                (n2w_itself
                                                   ((fromString "7"),
                                                    (ITSELF
                                                      (fromString
                                                      "3"))))
                                            of true => Parallel_sub_8
                                             | false =>
                                                  raise (Fail
                                                     "parallel_add_sub_op2: can't decode"))))))

  fun parallel_add_sub_thumb_op2 w =
        case word_eq w (n2w_itself (ONE,(ITSELF (fromString "3"))))
         of true => Parallel_add_16
          | false =>
               (case
                  word_eq w (n2w_itself (TWO,(ITSELF (fromString "3"))))
                of true => Parallel_add_sub_exchange
                 | false =>
                      (case
                         word_eq w
                           (n2w_itself
                              ((fromString "6"),
                               (ITSELF (fromString "3"))))
                       of true => Parallel_sub_add_exchange
                        | false =>
                             (case
                                word_eq w
                                  (n2w_itself
                                     ((fromString "5"),
                                      (ITSELF (fromString "3"))))
                              of true => Parallel_sub_16
                               | false =>
                                    (case
                                       word_eq w
                                         (n2w_itself
                                            (ZERO,
                                             (ITSELF (fromString "3"))))
                                     of true => Parallel_add_8
                                      | false =>
                                           (case
                                              word_eq w
                                                (n2w_itself
                                                   ((fromString "4"),
                                                    (ITSELF
                                                      (fromString
                                                      "3"))))
                                            of true => Parallel_sub_8
                                             | false =>
                                                  raise (Fail
                                                     "parallel_add_sub_thumb_op2: can't decode"))))))

  fun parallel_add_sub_decode (a,b) =
        (parallel_add_sub_op1 a,parallel_add_sub_op2 b)

  fun parallel_add_sub_thumb_decode (a,b) =
        (parallel_add_sub_op1
           (word_add a (n2w_itself (ONE,(ITSELF TWO)))),
         parallel_add_sub_thumb_op2 b)

  fun InITBlock IT =
        not
          (word_eq (word_bits (fromString "3") ZERO IT)
             (n2w_itself (ZERO,(ITSELF (fromString "8")))))

  fun LastInITBlock IT =
        word_eq (word_bits (fromString "3") ZERO IT)
          (n2w_itself ((fromString "8"),(ITSELF (fromString "8"))))

  fun arm_decode v4 ireg =
        let fun b n = word_index ireg n
            fun i2 n = word_extract_itself (ITSELF TWO) (+ n ONE) n ireg
            fun i3 n =
                word_extract_itself (ITSELF (fromString "3")) (+ n TWO)
                  n ireg
            fun i4 n =
                word_extract_itself (ITSELF (fromString "4"))
                  (+ n (fromString "3")) n ireg
            fun i5 n =
                word_extract_itself (ITSELF (fromString "5"))
                  (+ n (fromString "4")) n ireg
            fun i8 n =
                word_extract_itself (ITSELF (fromString "8"))
                  (+ n (fromString "7")) n ireg
            fun i12 n =
                word_extract_itself (ITSELF (fromString "12"))
                  (+ n (fromString "11")) n ireg
            fun i16 n =
                word_extract_itself (ITSELF (fromString "16"))
                  (+ n (fromString "15")) n ireg
            fun i24 n =
                word_extract_itself (ITSELF (fromString "24"))
                  (fromString "23") ZERO ireg
            val cond = i4 (fromString "28")
            val r = i4
        in
           (cond,
            if
              word_eq cond
                (n2w_itself
                   ((fromString "15"),(ITSELF (fromString "4"))))
            then
              (if v4 then
                 Unpredictable
               else
                 case
                   (b (fromString "27"),
                    (b (fromString "26"),
                     (b (fromString "25"),
                      (b (fromString "24"),
                       (b (fromString "23"),
                        (b (fromString "22"),
                         (b (fromString "21"),
                          (b (fromString "20"),
                           (b (fromString "7"),
                            (b (fromString "6"),
                             (b (fromString "5"),
                              b (fromString "4"))))))))))))
                  of (true,
                      (true,
                       (true,
                        (true,
                         (v8,
                          (v10,
                           (v12,(v14,(v16,(v18,(v20,v21))))))))))) =>
                        Undefined
                   | (true,
                      (true,
                       (true,
                        (false,
                         (v22,
                          (v24,
                           (v26,(v28,(v30,(v32,(v34,true))))))))))) =>
                        Coprocessor(Coprocessor_Transfer(i3
                                                           (fromString
                                                           "21"),
                                                         b
                                                           (fromString
                                                           "20"),
                                                         r
                                                           (fromString
                                                           "16"),
                                                         r
                                                           (fromString
                                                           "12"),
                                                         i4
                                                           (fromString
                                                           "8"),
                                                         i3
                                                           (fromString
                                                           "5"),r ZERO))
                   | (true,
                      (true,
                       (true,
                        (false,
                         (v22,
                          (v24,
                           (v26,(v28,(v30,(v32,(v34,false))))))))))) =>
                        Coprocessor(Coprocessor_Data_Processing(i4
                                                                  (fromString
                                                                  "20"),
                                                                r
                                                                  (fromString
                                                                  "16"),
                                                                r
                                                                  (fromString
                                                                  "12"),
                                                                i4
                                                                  (fromString
                                                                  "8"),
                                                                i3
                                                                  (fromString
                                                                  "5"),
                                                                r ZERO))
                   | (true,
                      (true,
                       (false,
                        (true,
                         (v38,
                          (v40,
                           (v42,(true,(v46,(v48,(v50,v51))))))))))) =>
                        Coprocessor(Coprocessor_Load(true,
                                                     b
                                                       (fromString
                                                       "23"),
                                                     b
                                                       (fromString
                                                       "22"),
                                                     b
                                                       (fromString
                                                       "21"),
                                                     r
                                                       (fromString
                                                       "16"),
                                                     r
                                                       (fromString
                                                       "12"),
                                                     i4
                                                       (fromString "8"),
                                                     i8 ZERO))
                   | (true,
                      (true,
                       (false,
                        (true,
                         (v38,
                          (v40,
                           (v42,(false,(v52,(v54,(v56,v57))))))))))) =>
                        Coprocessor(Coprocessor_Store(true,
                                                      b
                                                        (fromString
                                                        "23"),
                                                      b
                                                        (fromString
                                                        "22"),
                                                      b
                                                        (fromString
                                                        "21"),
                                                      r
                                                        (fromString
                                                        "16"),
                                                      r
                                                        (fromString
                                                        "12"),
                                                      i4
                                                        (fromString
                                                        "8"),i8 ZERO))
                   | (true,
                      (true,
                       (false,
                        (false,
                         (true,
                          (v60,
                           (v62,(true,(v66,(v68,(v70,v71))))))))))) =>
                        Coprocessor(Coprocessor_Load(false,
                                                     b
                                                       (fromString
                                                       "23"),
                                                     b
                                                       (fromString
                                                       "22"),
                                                     b
                                                       (fromString
                                                       "21"),
                                                     r
                                                       (fromString
                                                       "16"),
                                                     r
                                                       (fromString
                                                       "12"),
                                                     i4
                                                       (fromString "8"),
                                                     i8 ZERO))
                   | (true,
                      (true,
                       (false,
                        (false,
                         (true,
                          (v60,
                           (v62,(false,(v72,(v74,(v76,v77))))))))))) =>
                        Coprocessor(Coprocessor_Store(false,
                                                      b
                                                        (fromString
                                                        "23"),
                                                      b
                                                        (fromString
                                                        "22"),
                                                      b
                                                        (fromString
                                                        "21"),
                                                      r
                                                        (fromString
                                                        "16"),
                                                      r
                                                        (fromString
                                                        "12"),
                                                      i4
                                                        (fromString
                                                        "8"),i8 ZERO))
                   | (true,
                      (true,
                       (false,
                        (false,
                         (false,
                          (true,
                           (true,(true,(v84,(v86,(v88,v89))))))))))) =>
                        Coprocessor(Coprocessor_Load(false,
                                                     b
                                                       (fromString
                                                       "23"),
                                                     b
                                                       (fromString
                                                       "22"),
                                                     b
                                                       (fromString
                                                       "21"),
                                                     r
                                                       (fromString
                                                       "16"),
                                                     r
                                                       (fromString
                                                       "12"),
                                                     i4
                                                       (fromString "8"),
                                                     i8 ZERO))
                   | (true,
                      (true,
                       (false,
                        (false,
                         (false,
                          (true,
                           (true,(false,(v90,(v92,(v94,v95))))))))))) =>
                        Coprocessor(Coprocessor_Store(false,
                                                      b
                                                        (fromString
                                                        "23"),
                                                      b
                                                        (fromString
                                                        "22"),
                                                      b
                                                        (fromString
                                                        "21"),
                                                      r
                                                        (fromString
                                                        "16"),
                                                      r
                                                        (fromString
                                                        "12"),
                                                      i4
                                                        (fromString
                                                        "8"),i8 ZERO))
                   | (true,
                      (true,
                       (false,
                        (false,
                         (false,
                          (true,
                           (false,
                            (true,(v98,(v100,(v102,v103))))))))))) =>
                        Coprocessor(Coprocessor_Transfer_Two(true,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             i4
                                                               (fromString
                                                               "8"),
                                                             i4
                                                               (fromString
                                                               "4"),
                                                             r ZERO))
                   | (true,
                      (true,
                       (false,
                        (false,
                         (false,
                          (true,
                           (false,
                            (false,(v104,(v106,(v108,v109))))))))))) =>
                        Coprocessor(Coprocessor_Transfer_Two(false,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             i4
                                                               (fromString
                                                               "8"),
                                                             i4
                                                               (fromString
                                                               "4"),
                                                             r ZERO))
                   | (true,
                      (true,
                       (false,
                        (false,
                         (false,
                          (false,
                           (v110,
                            (true,(v114,(v116,(v118,v119))))))))))) =>
                        Coprocessor(Coprocessor_Load(false,
                                                     b
                                                       (fromString
                                                       "23"),
                                                     b
                                                       (fromString
                                                       "22"),
                                                     b
                                                       (fromString
                                                       "21"),
                                                     r
                                                       (fromString
                                                       "16"),
                                                     r
                                                       (fromString
                                                       "12"),
                                                     i4
                                                       (fromString "8"),
                                                     i8 ZERO))
                   | (true,
                      (true,
                       (false,
                        (false,
                         (false,
                          (false,
                           (v110,
                            (false,(v120,(v122,(v124,v125))))))))))) =>
                        Coprocessor(Coprocessor_Store(false,
                                                      b
                                                        (fromString
                                                        "23"),
                                                      b
                                                        (fromString
                                                        "22"),
                                                      b
                                                        (fromString
                                                        "21"),
                                                      r
                                                        (fromString
                                                        "16"),
                                                      r
                                                        (fromString
                                                        "12"),
                                                      i4
                                                        (fromString
                                                        "8"),i8 ZERO))
                   | (true,
                      (false,
                       (true,
                        (b24',
                         (v130,
                          (v132,
                           (v134,
                            (v136,(v138,(v140,(v142,v143))))))))))) =>
                        Branch(Branch_Link_Exchange_Immediate(b24',
                                                              false,
                                                              i24 ZERO))
                   | (true,
                      (false,
                       (false,
                        (b24,
                         (b23''',
                          (true,
                           (b21,
                            (true,(v154,(v156,(v158,v159))))))))))) =>
                        Undefined
                   | (true,
                      (false,
                       (false,
                        (b24,
                         (b23''',
                          (true,
                           (b21,
                            (false,(v160,(v162,(v164,v165))))))))))) =>
                        LoadStore(Store_Return_State(b24,b23''',b21,
                                                     i5 ZERO))
                   | (true,
                      (false,
                       (false,
                        (b24,
                         (b23''',
                          (false,
                           (b21',
                            (true,(v170,(v172,(v174,v175))))))))))) =>
                        LoadStore(Return_From_Exception(b24,b23''',b21',
                                                        r
                                                          (fromString
                                                          "16")))
                   | (true,
                      (false,
                       (false,
                        (b24,
                         (b23''',
                          (false,
                           (b21',
                            (false,(v176,(v178,(v180,v181))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (true,
                        (true,
                         (b23'',
                          (b22,
                           (true,
                            (v194,(v196,(v198,(v200,v201))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (true,
                        (true,
                         (b23'',
                          (b22,
                           (false,
                            (true,(v204,(v206,(v208,v209))))))))))) =>
                        Miscellaneous(Preload_Data(b23'',not b22,
                                                   r (fromString "16"),
                                                   Mode2_register(i5
                                                                    (fromString
                                                                    "7"),
                                                                  i2
                                                                    (fromString
                                                                    "5"),
                                                                  r
                                                                    ZERO)))
                   | (false,
                      (true,
                       (true,
                        (true,
                         (b23'',
                          (b22,
                           (false,
                            (false,(v210,(v212,(v214,v215))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (true,
                        (false,
                         (b23',
                          (true,
                           (true,
                            (v222,(v224,(v226,(v228,v229))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (true,
                        (false,
                         (b23',
                          (true,
                           (false,
                            (true,(v232,(v234,(v236,v237))))))))))) =>
                        Miscellaneous(Preload_Instruction(b23',
                                                          r
                                                            (fromString
                                                            "16"),
                                                          Mode2_register(i5
                                                                           (fromString
                                                                           "7"),
                                                                         i2
                                                                           (fromString
                                                                           "5"),
                                                                         r
                                                                           ZERO)))
                   | (false,
                      (true,
                       (true,
                        (false,
                         (b23',
                          (true,
                           (false,
                            (false,(v238,(v240,(v242,v243))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (true,
                        (false,
                         (b23',
                          (false,
                           (v244,
                            (v246,(v248,(v250,(v252,v253))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (false,
                        (true,
                         (true,
                          (v258,
                           (true,
                            (v262,(v264,(v266,(v268,v269))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (false,
                        (true,
                         (true,
                          (v258,
                           (false,
                            (true,(v272,(v274,(v276,v277))))))))))) =>
                        if
                          not v258 andalso
                          word_eq (r (fromString "12"))
                            (n2w_itself
                               ((fromString "15"),
                                (ITSELF (fromString "4"))))
                        then
                          Undefined
                        else
                          Miscellaneous(Preload_Data(true,not v258,
                                                     r
                                                       (fromString
                                                       "16"),
                                                     Mode2_immediate(i12
                                                                       ZERO)))
                   | (false,
                      (true,
                       (false,
                        (true,
                         (true,
                          (v258,
                           (false,
                            (false,(v278,(v280,(v282,v283))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (true,
                           (true,
                            (true,(true,(v292,(v294,v295))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (true,
                           (true,
                            (true,(false,(true,(true,true))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (true,
                           (true,
                            (true,(false,(true,(true,false))))))))))) =>
                        Miscellaneous(Instruction_Synchronization_Barrier(i4
                                                                            ZERO))
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (true,
                           (true,
                            (true,(false,(true,(false,true))))))))))) =>
                        Miscellaneous(Data_Memory_Barrier(i4 ZERO))
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (true,
                           (true,
                            (true,
                             (false,(true,(false,false))))))))))) =>
                        Miscellaneous(Data_Synchronization_Barrier(i4
                                                                     ZERO))
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (true,
                           (true,
                            (true,(false,(false,(true,v301))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (true,
                           (true,
                            (true,
                             (false,(false,(false,true))))))))))) =>
                        Miscellaneous(Clear_Exclusive)
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (true,
                           (true,
                            (true,
                             (false,(false,(false,false))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (true,
                           (true,
                            (false,(v302,(v304,(v306,v307))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (true,
                           (false,
                            (true,(v310,(v312,(v314,v315))))))))))) =>
                        Miscellaneous(Preload_Data(false,false,
                                                   r (fromString "16"),
                                                   Mode2_immediate(i12
                                                                     ZERO)))
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (true,
                           (false,
                            (false,(v316,(v318,(v320,v321))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (false,
                           (true,
                            (v324,(v326,(v328,(v330,v331))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (false,
                           (false,
                            (true,(v334,(v336,(v338,v339))))))))))) =>
                        if
                          word_eq (r (fromString "12"))
                            (n2w_itself
                               ((fromString "15"),
                                (ITSELF (fromString "4"))))
                        then
                          Undefined
                        else
                          Miscellaneous(Preload_Data(false,true,
                                                     r
                                                       (fromString
                                                       "16"),
                                                     Mode2_immediate(i12
                                                                       ZERO)))
                   | (false,
                      (true,
                       (false,
                        (true,
                         (false,
                          (false,
                           (false,
                            (false,(v340,(v342,(v344,v345))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (false,
                        (false,
                         (b23,
                          (true,
                           (true,
                            (v352,(v354,(v356,(v358,v359))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (false,
                        (false,
                         (b23,
                          (true,
                           (false,
                            (true,(v362,(v364,(v366,v367))))))))))) =>
                        Miscellaneous(Preload_Instruction(b23,
                                                          r
                                                            (fromString
                                                            "16"),
                                                          Mode2_immediate(i12
                                                                            ZERO)))
                   | (false,
                      (true,
                       (false,
                        (false,
                         (b23,
                          (true,
                           (false,
                            (false,(v368,(v370,(v372,v373))))))))))) =>
                        Undefined
                   | (false,
                      (true,
                       (false,
                        (false,
                         (b23,
                          (false,
                           (v374,
                            (v376,(v378,(v380,(v382,v383))))))))))) =>
                        Undefined
                   | (false,
                      (false,
                       (true,
                        (v386,
                         (v388,
                          (v390,
                           (v392,
                            (v394,(v396,(v398,(v400,v401))))))))))) =>
                        Undefined
                   | (false,
                      (false,
                       (false,
                        (true,
                         (true,
                          (v406,
                           (v408,
                            (v410,(v412,(v414,(v416,v417))))))))))) =>
                        Undefined
                   | (false,
                      (false,
                       (false,
                        (true,
                         (false,
                          (true,
                           (v420,
                            (v422,(v424,(v426,(v428,v429))))))))))) =>
                        Undefined
                   | (false,
                      (false,
                       (false,
                        (true,
                         (false,
                          (false,
                           (true,
                            (v432,(v434,(v436,(v438,v439))))))))))) =>
                        Undefined
                   | (false,
                      (false,
                       (false,
                        (true,
                         (false,
                          (false,
                           (false,
                            (true,(v442,(v444,(v446,v447))))))))))) =>
                        Undefined
                   | (false,
                      (false,
                       (false,
                        (true,
                         (false,
                          (false,
                           (false,(false,(b7,(b6,(true,b4))))))))))) =>
                        Undefined
                   | (false,
                      (false,
                       (false,
                        (true,
                         (false,
                          (false,
                           (false,(false,(b7,(b6,(false,b4))))))))))) =>
                        if b (fromString "16") then
                          (if
                             not b7 andalso (not b6 andalso not b4)
                           then
                             StatusAccess(Set_Endianness(b
                                                           (fromString
                                                           "9")))
                           else Undefined)
                        else
                          let val m = b (fromString "17")
                              val mode = i5 ZERO
                          in
                             if
                               not m andalso
                               not
                                 (word_eq mode
                                    (n2w_itself
                                       (ZERO,
                                        (ITSELF (fromString "5")))))
                             then
                            Unpredictable
                          else
                            StatusAccess(Change_Processor_State(i2
                                                                  (fromString
                                                                  "18"),
                                                                b
                                                                  (fromString
                                                                  "8"),
                                                                b
                                                                  (fromString
                                                                  "7"),
                                                                b
                                                                  (fromString
                                                                  "6"),
                                                                if
                                                                  m
                                                                then
                                                                  SOME(mode)
                                                                else
                                                                  optionML.NONE))
                          end
                   | (false,
                      (false,
                       (false,
                        (false,
                         (v454,
                          (v456,
                           (v458,
                            (v460,(v462,(v464,(v466,v467))))))))))) =>
                        Undefined)
            else
              case
                (b (fromString "27"),
                 (b (fromString "26"),
                  (b (fromString "25"),
                   (b (fromString "24"),
                    (b (fromString "23"),
                     (b (fromString "22"),
                      (b (fromString "21"),
                       (b (fromString "20"),
                        (b (fromString "7"),
                         (b (fromString "6"),
                          (b (fromString "5"),
                           b (fromString "4"))))))))))))
               of (true,
                   (true,
                    (true,
                     (true,
                      (v18,
                       (v22,(v26,(v30,(v34,(v38,(v42,v43))))))))))) =>
                     Miscellaneous(Supervisor_Call(i24 ZERO))
                | (true,
                   (true,
                    (true,
                     (false,
                      (v46,
                       (v50,(v54,(b20',(v62,(v66,(v70,true))))))))))) =>
                     Coprocessor(Coprocessor_Transfer(i3
                                                        (fromString
                                                        "21"),b20',
                                                      r
                                                        (fromString
                                                        "16"),
                                                      r
                                                        (fromString
                                                        "12"),
                                                      i4
                                                        (fromString
                                                        "8"),
                                                      i3
                                                        (fromString
                                                        "5"),r ZERO))
                | (true,
                   (true,
                    (true,
                     (false,
                      (v46,
                       (v50,
                        (v54,(b20',(v62,(v66,(v70,false))))))))))) =>
                     Coprocessor(Coprocessor_Data_Processing(i4
                                                               (fromString
                                                               "20"),
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             i4
                                                               (fromString
                                                               "8"),
                                                             i3
                                                               (fromString
                                                               "5"),
                                                             r ZERO))
                | (true,
                   (true,
                    (false,
                     (true,
                      (v78,
                       (v82,
                        (v86,(true,(v94,(v98,(v102,v103))))))))))) =>
                     Coprocessor(Coprocessor_Load(true,v78,v82,v86,
                                                  r (fromString "16"),
                                                  r (fromString "12"),
                                                  i4 (fromString "8"),
                                                  i8 ZERO))
                | (true,
                   (true,
                    (false,
                     (true,
                      (v78,
                       (v82,
                        (v86,(false,(v106,(v110,(v114,v115))))))))))) =>
                     Coprocessor(Coprocessor_Store(true,v78,v82,v86,
                                                   r (fromString "16"),
                                                   r (fromString "12"),
                                                   i4 (fromString "8"),
                                                   i8 ZERO))
                | (true,
                   (true,
                    (false,
                     (false,
                      (true,
                       (v122,
                        (v126,(true,(v134,(v138,(v142,v143))))))))))) =>
                     Coprocessor(Coprocessor_Load(false,true,v122,v126,
                                                  r (fromString "16"),
                                                  r (fromString "12"),
                                                  i4 (fromString "8"),
                                                  i8 ZERO))
                | (true,
                   (true,
                    (false,
                     (false,
                      (true,
                       (v122,
                        (v126,
                         (false,(v146,(v150,(v154,v155))))))))))) =>
                     Coprocessor(Coprocessor_Store(false,true,v122,v126,
                                                   r (fromString "16"),
                                                   r (fromString "12"),
                                                   i4 (fromString "8"),
                                                   i8 ZERO))
                | (true,
                   (true,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,(true,(v170,(v174,(v178,v179))))))))))) =>
                     Coprocessor(Coprocessor_Load(false,false,true,true,
                                                  r (fromString "16"),
                                                  r (fromString "12"),
                                                  i4 (fromString "8"),
                                                  i8 ZERO))
                | (true,
                   (true,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (false,(v182,(v186,(v190,v191))))))))))) =>
                     Coprocessor(Coprocessor_Store(false,false,true,
                                                   true,
                                                   r (fromString "16"),
                                                   r (fromString "12"),
                                                   i4 (fromString "8"),
                                                   i8 ZERO))
                | (true,
                   (true,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (true,(v198,(v202,(v206,v207))))))))))) =>
                     Coprocessor(Coprocessor_Transfer_Two(true,
                                                          r
                                                            (fromString
                                                            "16"),
                                                          r
                                                            (fromString
                                                            "12"),
                                                          i4
                                                            (fromString
                                                            "8"),
                                                          i4
                                                            (fromString
                                                            "4"),
                                                          r ZERO))
                | (true,
                   (true,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (false,(v210,(v214,(v218,v219))))))))))) =>
                     Coprocessor(Coprocessor_Transfer_Two(false,
                                                          r
                                                            (fromString
                                                            "16"),
                                                          r
                                                            (fromString
                                                            "12"),
                                                          i4
                                                            (fromString
                                                            "8"),
                                                          i4
                                                            (fromString
                                                            "4"),
                                                          r ZERO))
                | (true,
                   (true,
                    (false,
                     (false,
                      (false,
                       (false,
                        (v222,(true,(v230,(v234,(v238,v239))))))))))) =>
                     Coprocessor(Coprocessor_Load(false,false,false,
                                                  v222,
                                                  r (fromString "16"),
                                                  r (fromString "12"),
                                                  i4 (fromString "8"),
                                                  i8 ZERO))
                | (true,
                   (true,
                    (false,
                     (false,
                      (false,
                       (false,
                        (v222,
                         (false,(v242,(v246,(v250,v251))))))))))) =>
                     Coprocessor(Coprocessor_Store(false,false,false,
                                                   v222,
                                                   r (fromString "16"),
                                                   r (fromString "12"),
                                                   i4 (fromString "8"),
                                                   i8 ZERO))
                | (true,
                   (false,
                    (true,
                     (true,
                      (v262,
                       (v266,
                        (v270,(v274,(v278,(v282,(v286,v287))))))))))) =>
                     Branch(Branch_Link_Exchange_Immediate(true,true,
                                                           i24 ZERO))
                | (true,
                   (false,
                    (true,
                     (false,
                      (v290,
                       (v294,
                        (v298,(v302,(v306,(v310,(v314,v315))))))))))) =>
                     Branch(Branch_Target(i24 ZERO))
                | (true,
                   (false,
                    (false,
                     (b24',
                      (b23',
                       (b22'',
                        (b21',(true,(v338,(v342,(v346,v347))))))))))) =>
                     LoadStore(Load_Multiple(b24',b23',b22'',b21',
                                             r (fromString "16"),
                                             i16 ZERO))
                | (true,
                   (false,
                    (false,
                     (b24',
                      (b23',
                       (b22'',
                        (b21',
                         (false,(v350,(v354,(v358,v359))))))))))) =>
                     LoadStore(Store_Multiple(b24',b23',b22'',b21',
                                              r (fromString "16"),
                                              i16 ZERO))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (true,(true,(v390,(true,(true,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (true,
                         (true,(v390,(true,(true,false))))))))))) =>
                     LoadStore(Load(true,true,true,true,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (true,
                         (true,(v390,(true,(false,true))))))))))) =>
                     DataProcessing(Bit_Field_Extract(true,
                                                      i5
                                                        (fromString
                                                        "16"),
                                                      r
                                                        (fromString
                                                        "12"),
                                                      i5
                                                        (fromString
                                                        "7"),r ZERO))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (true,
                         (true,(v390,(true,(false,false))))))))))) =>
                     LoadStore(Load(true,true,true,true,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (true,
                         (true,(v390,(false,(v402,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (true,
                         (true,(v390,(false,(v402,false))))))))))) =>
                     LoadStore(Load(true,true,true,true,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(v406,(true,(true,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(v406,(true,(true,false))))))))))) =>
                     LoadStore(Store(true,true,true,true,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(v406,(true,(false,true))))))))))) =>
                     DataProcessing(Bit_Field_Extract(true,
                                                      i5
                                                        (fromString
                                                        "16"),
                                                      r
                                                        (fromString
                                                        "12"),
                                                      i5
                                                        (fromString
                                                        "7"),r ZERO))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(v406,(true,(false,false))))))))))) =>
                     LoadStore(Store(true,true,true,true,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(v406,(false,(v418,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(v406,(false,(v418,false))))))))))) =>
                     LoadStore(Store(true,true,true,true,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(v426,(true,(v434,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(v426,(true,(v434,false))))))))))) =>
                     LoadStore(Load(true,true,true,false,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(v426,(false,(true,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(v426,(false,(true,false))))))))))) =>
                     LoadStore(Load(true,true,true,false,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(v426,(false,(false,true))))))))))) =>
                     DataProcessing(Bit_Field_Clear_Insert(i5
                                                             (fromString
                                                             "16"),
                                                           r
                                                             (fromString
                                                             "12"),
                                                           i5
                                                             (fromString
                                                             "7"),
                                                           r ZERO))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(v426,(false,(false,false))))))))))) =>
                     LoadStore(Load(true,true,true,false,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(v442,(true,(v450,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(v442,(true,(v450,false))))))))))) =>
                     LoadStore(Store(true,true,true,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(v442,(false,(true,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(v442,(false,(true,false))))))))))) =>
                     LoadStore(Store(true,true,true,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(v442,(false,(false,true))))))))))) =>
                     DataProcessing(Bit_Field_Clear_Insert(i5
                                                             (fromString
                                                             "16"),
                                                           r
                                                             (fromString
                                                             "12"),
                                                           i5
                                                             (fromString
                                                             "7"),
                                                           r ZERO))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(v442,(false,(false,false))))))))))) =>
                     LoadStore(Store(true,true,true,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (true,(true,(v466,(true,(true,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (true,
                         (true,(v466,(true,(true,false))))))))))) =>
                     LoadStore(Load(true,true,false,true,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (true,
                         (true,(v466,(true,(false,true))))))))))) =>
                     DataProcessing(Bit_Field_Extract(false,
                                                      i5
                                                        (fromString
                                                        "16"),
                                                      r
                                                        (fromString
                                                        "12"),
                                                      i5
                                                        (fromString
                                                        "7"),r ZERO))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (true,
                         (true,(v466,(true,(false,false))))))))))) =>
                     LoadStore(Load(true,true,false,true,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (true,
                         (true,(v466,(false,(v478,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (true,
                         (true,(v466,(false,(v478,false))))))))))) =>
                     LoadStore(Load(true,true,false,true,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(v482,(true,(true,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(v482,(true,(true,false))))))))))) =>
                     LoadStore(Store(true,true,false,true,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(v482,(true,(false,true))))))))))) =>
                     DataProcessing(Bit_Field_Extract(false,
                                                      i5
                                                        (fromString
                                                        "16"),
                                                      r
                                                        (fromString
                                                        "12"),
                                                      i5
                                                        (fromString
                                                        "7"),r ZERO))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(v482,(true,(false,false))))))))))) =>
                     LoadStore(Store(true,true,false,true,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(v482,(false,(v494,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(v482,(false,(v494,false))))))))))) =>
                     LoadStore(Store(true,true,false,true,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (false,
                         (true,(v502,(v506,(v510,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (false,
                         (true,(v502,(v506,(v510,false))))))))))) =>
                     LoadStore(Load(true,true,false,false,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(true,(v518,(v522,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(true,(v518,(v522,false))))))))))) =>
                     LoadStore(Store(true,true,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(false,(true,(v530,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(false,(true,(v530,false))))))))))) =>
                     LoadStore(Store(true,true,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(false,(false,(true,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(false,(false,(true,false))))))))))) =>
                     LoadStore(Store(true,true,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(false,(false,(false,true))))))))))) =>
                     DataProcessing(Unsigned_Sum_Absolute_Differences(r
                                                                        (fromString
                                                                        "16"),
                                                                      r
                                                                        (fromString
                                                                        "12"),
                                                                      r
                                                                        (fromString
                                                                        "8"),
                                                                      r
                                                                        ZERO))
                | (false,
                   (true,
                    (true,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(false,(false,(false,false))))))))))) =>
                     LoadStore(Store(true,true,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (true,(true,(v550,(v554,(v558,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (true,
                         (true,(v550,(v554,(v558,false))))))))))) =>
                     LoadStore(Load(true,false,true,true,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(v562,(v566,(v570,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(v562,(v566,(v570,false))))))))))) =>
                     LoadStore(Store(true,false,true,true,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(true,(true,(b5''',true))))))))))) =>
                     DataProcessing(Signed_Most_Significant_Multiply_Subtract(r
                                                                                (fromString
                                                                                "16"),
                                                                              r
                                                                                (fromString
                                                                                "12"),
                                                                              r
                                                                                (fromString
                                                                                "8"),
                                                                              b5''',
                                                                              r
                                                                                ZERO))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(true,(true,(b5''',false))))))))))) =>
                     LoadStore(Load(true,false,true,false,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(true,(false,(v590,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(true,(false,(v590,false))))))))))) =>
                     LoadStore(Load(true,false,true,false,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(false,(true,(v598,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(false,(true,(v598,false))))))))))) =>
                     LoadStore(Load(true,false,true,false,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(false,(false,(b5'',true))))))))))) =>
                     DataProcessing(Signed_Most_Significant_Multiply(r
                                                                       (fromString
                                                                       "16"),
                                                                     r
                                                                       (fromString
                                                                       "12"),
                                                                     r
                                                                       (fromString
                                                                       "8"),
                                                                     b5'',
                                                                     r
                                                                       ZERO))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(false,(false,(b5'',false))))))))))) =>
                     LoadStore(Load(true,false,true,false,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(true,(v610,(v614,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(true,(v610,(v614,false))))))))))) =>
                     LoadStore(Store(true,false,true,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(false,(b6',(b5',true))))))))))) =>
                     DataProcessing(Signed_Multiply_Long_Dual(r
                                                                (fromString
                                                                "16"),
                                                              r
                                                                (fromString
                                                                "12"),
                                                              r
                                                                (fromString
                                                                "8"),
                                                              b6',b5',
                                                              r ZERO))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(false,(b6',(b5',false))))))))))) =>
                     LoadStore(Store(true,false,true,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (false,
                        (true,(true,(v634,(v638,(v642,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (false,
                        (true,
                         (true,(v634,(v638,(v642,false))))))))))) =>
                     LoadStore(Load(true,false,false,true,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(v646,(v650,(v654,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(v646,(v650,(v654,false))))))))))) =>
                     LoadStore(Store(true,false,false,true,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (false,
                        (false,
                         (true,(v662,(v666,(v670,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (false,
                        (false,
                         (true,(v662,(v666,(v670,false))))))))))) =>
                     LoadStore(Load(true,false,false,false,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(true,(v678,(v682,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(true,(v678,(v682,false))))))))))) =>
                     LoadStore(Store(true,false,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (false,
                        (false,(false,(false,(b6,(b5,true))))))))))) =>
                     DataProcessing(Signed_Multiply_Dual(r
                                                           (fromString
                                                           "16"),
                                                         r
                                                           (fromString
                                                           "12"),
                                                         r
                                                           (fromString
                                                           "8"),b6,b5,
                                                         r ZERO))
                | (false,
                   (true,
                    (true,
                     (true,
                      (false,
                       (false,
                        (false,(false,(false,(b6,(b5,false))))))))))) =>
                     LoadStore(Store(true,false,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,(true,(true,(true,(true,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(true,(true,(true,false))))))))))) =>
                     LoadStore(Load(false,true,true,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(true,(true,(false,true))))))))))) =>
                     DataProcessing(Saturate(true,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),true,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(true,(true,(false,false))))))))))) =>
                     LoadStore(Load(false,true,true,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(true,(false,(true,true))))))))))) =>
                     DataProcessing(Byte_Reverse_Signed_Halfword(r
                                                                   (fromString
                                                                   "12"),
                                                                 r
                                                                   ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(true,(false,(true,false))))))))))) =>
                     LoadStore(Load(false,true,true,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(true,(false,(false,true))))))))))) =>
                     DataProcessing(Saturate(true,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),false,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(true,(false,(false,false))))))))))) =>
                     LoadStore(Load(false,true,true,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(false,(true,(true,true))))))))))) =>
                     DataProcessing(Extend_Halfword(true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    i2
                                                      (fromString "10"),
                                                    r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(false,(true,(true,false))))))))))) =>
                     LoadStore(Load(false,true,true,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(false,(true,(false,true))))))))))) =>
                     DataProcessing(Saturate(true,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),true,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(false,(true,(false,false))))))))))) =>
                     LoadStore(Load(false,true,true,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(false,(false,(true,true))))))))))) =>
                     DataProcessing(Reverse_Bits(r (fromString "12"),
                                                 r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(false,(false,(true,false))))))))))) =>
                     LoadStore(Load(false,true,true,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(false,(false,(false,true))))))))))) =>
                     DataProcessing(Saturate(true,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),false,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (true,(false,(false,(false,false))))))))))) =>
                     LoadStore(Load(false,true,true,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (false,(true,(v742,(true,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (false,(true,(v742,(true,false))))))))))) =>
                     LoadStore(Store(false,true,true,true,true,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (false,(true,(v742,(false,true))))))))))) =>
                     DataProcessing(Saturate(true,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),v742,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (false,(true,(v742,(false,false))))))))))) =>
                     LoadStore(Store(false,true,true,true,true,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (false,(false,(true,(true,true))))))))))) =>
                     DataProcessing(Extend_Byte(true,
                                                r (fromString "16"),
                                                r (fromString "12"),
                                                i2 (fromString "10"),
                                                r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (false,(false,(true,(true,false))))))))))) =>
                     LoadStore(Store(false,true,true,true,true,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (false,(false,(true,(false,true))))))))))) =>
                     DataProcessing(Saturate(true,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),true,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (false,(false,(true,(false,false))))))))))) =>
                     LoadStore(Store(false,true,true,true,true,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (false,(false,(false,(true,true))))))))))) =>
                     DataProcessing(Saturate_16(true,
                                                i4 (fromString "16"),
                                                r (fromString "12"),
                                                r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (false,(false,(false,(true,false))))))))))) =>
                     LoadStore(Store(false,true,true,true,true,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (false,(false,(false,(false,true))))))))))) =>
                     DataProcessing(Saturate(true,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),false,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (true,
                         (false,(false,(false,(false,false))))))))))) =>
                     LoadStore(Store(false,true,true,true,true,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (false,
                         (true,(v766,(v770,(v774,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (false,
                         (true,(v766,(v770,(v774,false))))))))))) =>
                     LoadStore(Load(false,true,true,false,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (false,
                         (false,(true,(v782,(v786,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (false,
                         (false,(true,(v782,(v786,false))))))))))) =>
                     LoadStore(Store(false,true,true,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (false,
                         (false,(false,(true,(true,true))))))))))) =>
                     DataProcessing(Extend_Byte_16(true,
                                                   r (fromString "16"),
                                                   r (fromString "12"),
                                                   i2 (fromString "10"),
                                                   r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (false,
                         (false,(false,(true,(true,false))))))))))) =>
                     LoadStore(Store(false,true,true,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (false,
                         (false,(false,(true,(false,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (false,
                         (false,(false,(true,(false,false))))))))))) =>
                     LoadStore(Store(false,true,true,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (false,
                         (false,(false,(false,(v798,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (true,
                        (false,
                         (false,(false,(false,(v798,false))))))))))) =>
                     LoadStore(Store(false,true,true,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,(true,(true,(true,(true,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(true,(true,(true,false))))))))))) =>
                     LoadStore(Load(false,true,false,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(true,(true,(false,true))))))))))) =>
                     DataProcessing(Saturate(false,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),true,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(true,(true,(false,false))))))))))) =>
                     LoadStore(Load(false,true,false,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(true,(false,(true,true))))))))))) =>
                     DataProcessing(Byte_Reverse_Packed_Halfword(r
                                                                   (fromString
                                                                   "12"),
                                                                 r
                                                                   ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(true,(false,(true,false))))))))))) =>
                     LoadStore(Load(false,true,false,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(true,(false,(false,true))))))))))) =>
                     DataProcessing(Saturate(false,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),false,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(true,(false,(false,false))))))))))) =>
                     LoadStore(Load(false,true,false,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(false,(true,(true,true))))))))))) =>
                     DataProcessing(Extend_Halfword(false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    i2
                                                      (fromString "10"),
                                                    r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(false,(true,(true,false))))))))))) =>
                     LoadStore(Load(false,true,false,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(false,(true,(false,true))))))))))) =>
                     DataProcessing(Saturate(false,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),true,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(false,(true,(false,false))))))))))) =>
                     LoadStore(Load(false,true,false,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(false,(false,(true,true))))))))))) =>
                     DataProcessing(Byte_Reverse_Word(r
                                                        (fromString
                                                        "12"),r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(false,(false,(true,false))))))))))) =>
                     LoadStore(Load(false,true,false,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(false,(false,(false,true))))))))))) =>
                     DataProcessing(Saturate(false,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),false,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (true,(false,(false,(false,false))))))))))) =>
                     LoadStore(Load(false,true,false,true,true,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (false,(true,(v842,(true,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (false,(true,(v842,(true,false))))))))))) =>
                     LoadStore(Store(false,true,false,true,true,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (false,(true,(v842,(false,true))))))))))) =>
                     DataProcessing(Saturate(false,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),v842,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (false,(true,(v842,(false,false))))))))))) =>
                     LoadStore(Store(false,true,false,true,true,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (false,(false,(true,(true,true))))))))))) =>
                     DataProcessing(Extend_Byte(false,
                                                r (fromString "16"),
                                                r (fromString "12"),
                                                i2 (fromString "10"),
                                                r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (false,(false,(true,(true,false))))))))))) =>
                     LoadStore(Store(false,true,false,true,true,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (false,(false,(true,(false,true))))))))))) =>
                     DataProcessing(Saturate(false,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),true,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (false,(false,(true,(false,false))))))))))) =>
                     LoadStore(Store(false,true,false,true,true,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (false,(false,(false,(true,true))))))))))) =>
                     DataProcessing(Saturate_16(false,
                                                i4 (fromString "16"),
                                                r (fromString "12"),
                                                r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (false,(false,(false,(true,false))))))))))) =>
                     LoadStore(Store(false,true,false,true,true,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (false,(false,(false,(false,true))))))))))) =>
                     DataProcessing(Saturate(false,i5 (fromString "16"),
                                             r (fromString "12"),
                                             i5 (fromString "7"),false,
                                             r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (false,(false,(false,(false,false))))))))))) =>
                     LoadStore(Store(false,true,false,true,true,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (true,(v866,(v870,(v874,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (true,(v866,(v870,(v874,false))))))))))) =>
                     LoadStore(Load(false,true,false,false,false,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(true,(true,(true,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(true,(true,(true,false))))))))))) =>
                     LoadStore(Store(false,true,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(true,(true,(false,true))))))))))) =>
                     DataProcessing(Pack_Halfword(r (fromString "16"),
                                                  r (fromString "12"),
                                                  i5 (fromString "7"),
                                                  true,r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(true,(true,(false,false))))))))))) =>
                     LoadStore(Store(false,true,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(true,(false,(true,true))))))))))) =>
                     DataProcessing(Select_Bytes(r (fromString "16"),
                                                 r (fromString "12"),
                                                 r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(true,(false,(true,false))))))))))) =>
                     LoadStore(Store(false,true,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(true,(false,(false,true))))))))))) =>
                     DataProcessing(Pack_Halfword(r (fromString "16"),
                                                  r (fromString "12"),
                                                  i5 (fromString "7"),
                                                  false,r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(true,(false,(false,false))))))))))) =>
                     LoadStore(Store(false,true,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(false,(true,(true,true))))))))))) =>
                     DataProcessing(Extend_Byte_16(false,
                                                   r (fromString "16"),
                                                   r (fromString "12"),
                                                   i2 (fromString "10"),
                                                   r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(false,(true,(true,false))))))))))) =>
                     LoadStore(Store(false,true,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(false,(true,(false,true))))))))))) =>
                     DataProcessing(Pack_Halfword(r (fromString "16"),
                                                  r (fromString "12"),
                                                  i5 (fromString "7"),
                                                  true,r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(false,(true,(false,false))))))))))) =>
                     LoadStore(Store(false,true,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(false,(false,(true,true))))))))))) =>
                     Undefined
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(false,(false,(true,false))))))))))) =>
                     LoadStore(Store(false,true,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(false,(false,(false,true))))))))))) =>
                     DataProcessing(Pack_Halfword(r (fromString "16"),
                                                  r (fromString "12"),
                                                  i5 (fromString "7"),
                                                  false,r ZERO))
                | (false,
                   (true,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(false,(false,(false,false))))))))))) =>
                     LoadStore(Store(false,true,false,false,false,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (false,
                       (v906,
                        (v910,(true,(v918,(v922,(v926,true))))))))))) =>
                     let val op1 = i2 (fromString "20")
                         val op2 = i3 (fromString "5")
                     in
                        if
                          not
                            (word_eq op1
                               (n2w_itself (ZERO,(ITSELF TWO)))) andalso
                          (word_lo op2
                             (n2w_itself
                                ((fromString "5"),
                                 (ITSELF (fromString "3")))) orelse
                           word_eq op2
                             (n2w_itself
                                ((fromString "7"),
                                 (ITSELF (fromString "3")))))
                        then
                       DataProcessing(Parallel_Add_Subtract(v906,
                                                            parallel_add_sub_decode
                                                              (op1,op2),
                                                            r
                                                              (fromString
                                                              "16"),
                                                            r
                                                              (fromString
                                                              "12"),
                                                            r ZERO))
                     else Undefined
                     end
                | (false,
                   (true,
                    (true,
                     (false,
                      (false,
                       (v906,
                        (v910,
                         (true,(v918,(v922,(v926,false))))))))))) =>
                     LoadStore(Load(false,false,v906,v910,v910,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_register(i5 (fromString "7"),
                                                   i2 (fromString "5"),
                                                   r ZERO)))
                | (false,
                   (true,
                    (true,
                     (false,
                      (false,
                       (v906,
                        (v910,
                         (false,(v930,(v934,(v938,true))))))))))) =>
                     let val op1 = i2 (fromString "20")
                         val op2 = i3 (fromString "5")
                     in
                        if
                          not
                            (word_eq op1
                               (n2w_itself (ZERO,(ITSELF TWO)))) andalso
                          (word_lo op2
                             (n2w_itself
                                ((fromString "5"),
                                 (ITSELF (fromString "3")))) orelse
                           word_eq op2
                             (n2w_itself
                                ((fromString "7"),
                                 (ITSELF (fromString "3")))))
                        then
                       DataProcessing(Parallel_Add_Subtract(v906,
                                                            parallel_add_sub_decode
                                                              (op1,op2),
                                                            r
                                                              (fromString
                                                              "16"),
                                                            r
                                                              (fromString
                                                              "12"),
                                                            r ZERO))
                     else Undefined
                     end
                | (false,
                   (true,
                    (true,
                     (false,
                      (false,
                       (v906,
                        (v910,
                         (false,(v930,(v934,(v938,false))))))))))) =>
                     LoadStore(Store(false,false,v906,v910,v910,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_register(i5 (fromString "7"),
                                                    i2 (fromString "5"),
                                                    r ZERO)))
                | (false,
                   (true,
                    (false,
                     (b24,
                      (b23,
                       (b22',
                        (b21,(true,(v962,(v966,(v970,v971))))))))))) =>
                     LoadStore(Load(b24,b23,b22',b21,
                                    not b24 andalso b21,
                                    r (fromString "16"),
                                    r (fromString "12"),
                                    Mode2_immediate(i12 ZERO)))
                | (false,
                   (true,
                    (false,
                     (b24,
                      (b23,
                       (b22',
                        (b21,(false,(v974,(v978,(v982,v983))))))))))) =>
                     LoadStore(Store(b24,b23,b22',b21,
                                     not b24 andalso b21,
                                     r (fromString "16"),
                                     r (fromString "12"),
                                     Mode2_immediate(i12 ZERO)))
                | (false,
                   (false,
                    (true,
                     (true,
                      (true,
                       (true,
                        (true,
                         (b20,(v1010,(v1014,(v1018,v1019))))))))))) =>
                     DataProcessing(Data_Processing(n2w_itself
                                                      ((fromString
                                                       "15"),
                                                       (ITSELF
                                                         (fromString
                                                         "4"))),b20,
                                                    n2w_itself
                                                      ((fromString
                                                       "15"),
                                                       (ITSELF
                                                         (fromString
                                                         "4"))),
                                                    r (fromString "12"),
                                                    Mode1_immediate(i12
                                                                      ZERO)))
                | (false,
                   (false,
                    (true,
                     (true,
                      (true,
                       (true,
                        (false,
                         (v1022,(v1026,(v1030,(v1034,v1035))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    v1022,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_immediate(i12
                                                                      ZERO)))
                | (false,
                   (false,
                    (true,
                     (true,
                      (true,
                       (false,
                        (v1038,
                         (v1042,(v1046,(v1050,(v1054,v1055))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    v1042,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_immediate(i12
                                                                      ZERO)))
                | (false,
                   (false,
                    (true,
                     (true,
                      (false,
                       (b22,
                        (true,
                         (true,(v1070,(v1074,(v1078,v1079))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_immediate(i12
                                                                      ZERO)))
                | (false,
                   (false,
                    (true,
                     (true,
                      (false,
                       (b22,
                        (true,
                         (false,(v1082,(v1086,(v1090,v1091))))))))))) =>
                     if
                       not b22 andalso
                       word_eq (r (fromString "16"))
                         (n2w_itself (ZERO,(ITSELF (fromString "4"))))
                     then
                       Miscellaneous(Hint(hint_decode (i8 ZERO)))
                     else
                       StatusAccess(Immediate_to_Status(b22,
                                                        i4
                                                          (fromString
                                                          "16"),
                                                        i12 ZERO))
                | (false,
                   (false,
                    (true,
                     (true,
                      (false,
                       (b22,
                        (false,
                         (true,(v1098,(v1102,(v1106,v1107))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_immediate(i12
                                                                      ZERO)))
                | (false,
                   (false,
                    (true,
                     (true,
                      (false,
                       (b22,
                        (false,
                         (false,(v1110,(v1114,(v1118,v1119))))))))))) =>
                     DataProcessing(Move_Halfword(b22,
                                                  r (fromString "12"),
                                                  word_concat_itself
                                                    (ITSELF
                                                      (fromString "16"))
                                                    (i4
                                                       (fromString
                                                       "16"))
                                                    (i12 ZERO)))
                | (false,
                   (false,
                    (true,
                     (false,
                      (true,
                       (true,
                        (v1130,
                         (v1134,(v1138,(v1142,(v1146,v1147))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    v1134,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_immediate(i12
                                                                      ZERO)))
                | (false,
                   (false,
                    (true,
                     (false,
                      (true,
                       (false,
                        (true,
                         (v1154,(v1158,(v1162,(v1166,v1167))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    v1154,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_immediate(i12
                                                                      ZERO)))
                | (false,
                   (false,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (true,(v1174,(v1178,(v1182,v1183))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_immediate(i12
                                                                      ZERO)))
                | (false,
                   (false,
                    (true,
                     (false,
                      (true,
                       (false,
                        (false,
                         (false,(v1186,(v1190,(v1194,v1195))))))))))) =>
                     let val rn = r (fromString "16")
                     in
                        if
                          word_eq rn
                            (n2w_itself
                               ((fromString "15"),
                                (ITSELF (fromString "4"))))
                        then
                       DataProcessing(Add_Sub(true,
                                              n2w_itself
                                                ((fromString "15"),
                                                 (ITSELF
                                                   (fromString "4"))),
                                              r (fromString "12"),
                                              i12 ZERO))
                     else
                       DataProcessing(Data_Processing(n2w_itself
                                                        ((fromString
                                                         "4"),
                                                         (ITSELF
                                                           (fromString
                                                           "4"))),false,
                                                      rn,
                                                      r
                                                        (fromString
                                                        "12"),
                                                      Mode1_immediate(i12
                                                                        ZERO)))
                     end
                | (false,
                   (false,
                    (true,
                     (false,
                      (false,
                       (true,
                        (true,
                         (v1206,(v1210,(v1214,(v1218,v1219))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    v1206,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_immediate(i12
                                                                      ZERO)))
                | (false,
                   (false,
                    (true,
                     (false,
                      (false,
                       (true,
                        (false,
                         (true,(v1226,(v1230,(v1234,v1235))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_immediate(i12
                                                                      ZERO)))
                | (false,
                   (false,
                    (true,
                     (false,
                      (false,
                       (true,
                        (false,
                         (false,(v1238,(v1242,(v1246,v1247))))))))))) =>
                     let val rn = r (fromString "16")
                     in
                        if
                          word_eq rn
                            (n2w_itself
                               ((fromString "15"),
                                (ITSELF (fromString "4"))))
                        then
                       DataProcessing(Add_Sub(false,
                                              n2w_itself
                                                ((fromString "15"),
                                                 (ITSELF
                                                   (fromString "4"))),
                                              r (fromString "12"),
                                              i12 ZERO))
                     else
                       DataProcessing(Data_Processing(n2w_itself
                                                        (TWO,
                                                         (ITSELF
                                                           (fromString
                                                           "4"))),false,
                                                      rn,
                                                      r
                                                        (fromString
                                                        "12"),
                                                      Mode1_immediate(i12
                                                                        ZERO)))
                     end
                | (false,
                   (false,
                    (true,
                     (false,
                      (false,
                       (false,
                        (v1250,
                         (v1254,(v1258,(v1262,(v1266,v1267))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    v1254,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_immediate(i12
                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (true,(true,(true,(v1298,true))))))))))) =>
                     LoadStore(Load_Halfword(true,true,true,true,v1298,
                                             false,r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (true,(true,(true,(v1298,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (true,(true,(false,(true,true))))))))))) =>
                     LoadStore(Load_Halfword(true,true,true,false,true,
                                             false,r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (true,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (true,(true,(false,(false,true))))))))))) =>
                     LoadStore(Load_Exclusive_Halfword(r
                                                         (fromString
                                                         "16"),
                                                       r
                                                         (fromString
                                                         "12")))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (true,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (true,(false,(v1306,(v1310,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (true,(false,(v1306,(v1310,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(true,(true,(true,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Store_Dual(true,true,true,
                                             r (fromString "16"),rt,
                                             word_add rt
                                               (n2w_itself
                                                  (ONE,
                                                   (ITSELF
                                                     (fromString
                                                     "4")))),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(true,(true,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(true,(true,(false,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Load_Dual(true,true,true,
                                            r (fromString "16"),rt,
                                            word_add rt
                                              (n2w_itself
                                                 (ONE,
                                                  (ITSELF
                                                    (fromString "4")))),
                                            Mode3_immediate(word_concat_itself
                                                              (ITSELF
                                                                (fromString
                                                                "12"))
                                                              (i4
                                                                 (fromString
                                                                 "8"))
                                                              (i4
                                                                 ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(true,(true,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(true,(false,(true,true))))))))))) =>
                     LoadStore(Store_Halfword(true,true,true,false,
                                              r (fromString "16"),
                                              r (fromString "12"),
                                              Mode3_immediate(word_concat_itself
                                                                (ITSELF
                                                                  (fromString
                                                                  "12"))
                                                                (i4
                                                                   (fromString
                                                                   "8"))
                                                                (i4
                                                                   ZERO))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(true,(false,(false,true))))))))))) =>
                     LoadStore(Store_Exclusive_Halfword(r
                                                          (fromString
                                                          "16"),
                                                        r
                                                          (fromString
                                                          "12"),r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(false,(v1330,(v1334,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (true,
                         (false,(false,(v1330,(v1334,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(true,(true,(v1350,true))))))))))) =>
                     LoadStore(Load_Halfword(true,true,false,true,v1350,
                                             false,r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(true,(true,(v1350,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(true,(false,(true,true))))))))))) =>
                     LoadStore(Load_Halfword(true,true,false,false,true,
                                             false,r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(true,(false,(false,true))))))))))) =>
                     LoadStore(Load_Exclusive_Byte(r (fromString "16"),
                                                   r (fromString "12")))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(false,(v1358,(v1362,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (true,(false,(v1358,(v1362,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(true,(true,(true,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Store_Dual(true,true,false,
                                             r (fromString "16"),rt,
                                             word_add rt
                                               (n2w_itself
                                                  (ONE,
                                                   (ITSELF
                                                     (fromString
                                                     "4")))),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(true,(true,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(true,(true,(false,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Load_Dual(true,true,false,
                                            r (fromString "16"),rt,
                                            word_add rt
                                              (n2w_itself
                                                 (ONE,
                                                  (ITSELF
                                                    (fromString "4")))),
                                            Mode3_immediate(word_concat_itself
                                                              (ITSELF
                                                                (fromString
                                                                "12"))
                                                              (i4
                                                                 (fromString
                                                                 "8"))
                                                              (i4
                                                                 ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(true,(true,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(true,(false,(true,true))))))))))) =>
                     LoadStore(Store_Halfword(true,true,false,false,
                                              r (fromString "16"),
                                              r (fromString "12"),
                                              Mode3_immediate(word_concat_itself
                                                                (ITSELF
                                                                  (fromString
                                                                  "12"))
                                                                (i4
                                                                   (fromString
                                                                   "8"))
                                                                (i4
                                                                   ZERO))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(true,(false,(false,true))))))))))) =>
                     LoadStore(Store_Exclusive_Byte(r (fromString "16"),
                                                    r (fromString "12"),
                                                    r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(false,(v1382,(v1386,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (true,
                        (false,
                         (false,(false,(v1382,(v1386,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (true,(true,(true,(v1406,true))))))))))) =>
                     LoadStore(Load_Halfword(true,true,true,true,v1406,
                                             false,r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (true,(true,(true,(v1406,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (true,(true,(false,(true,true))))))))))) =>
                     LoadStore(Load_Halfword(true,true,true,false,true,
                                             false,r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (true,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (true,(true,(false,(false,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Load_Exclusive_Doubleword(r
                                                              (fromString
                                                              "16"),rt,
                                                            word_add rt
                                                              (n2w_itself
                                                                 (ONE,
                                                                  (ITSELF
                                                                    (fromString
                                                                    "4"))))))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (true,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (true,(false,(v1414,(v1418,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (true,(false,(v1414,(v1418,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(true,(true,(true,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Store_Dual(true,true,true,
                                             r (fromString "16"),rt,
                                             word_add rt
                                               (n2w_itself
                                                  (ONE,
                                                   (ITSELF
                                                     (fromString
                                                     "4")))),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(true,(true,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(true,(true,(false,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Load_Dual(true,true,true,
                                            r (fromString "16"),rt,
                                            word_add rt
                                              (n2w_itself
                                                 (ONE,
                                                  (ITSELF
                                                    (fromString "4")))),
                                            Mode3_register(n2w_itself
                                                             (ZERO,
                                                              (ITSELF
                                                                TWO)),
                                                           r ZERO)))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(true,(true,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(true,(false,(true,true))))))))))) =>
                     LoadStore(Store_Halfword(true,true,true,false,
                                              r (fromString "16"),
                                              r (fromString "12"),
                                              Mode3_register(n2w_itself
                                                               (ZERO,
                                                                (ITSELF
                                                                  TWO)),
                                                             r ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(true,(false,(false,true))))))))))) =>
                     let val rt = r ZERO
                     in
                        LoadStore(Store_Exclusive_Doubleword(r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),rt,
                                                             word_add rt
                                                               (n2w_itself
                                                                  (ONE,
                                                                   (ITSELF
                                                                     (fromString
                                                                     "4"))))))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(false,(v1438,(v1442,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (true,
                         (false,(false,(v1438,(v1442,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (true,(true,(true,(v1458,true))))))))))) =>
                     LoadStore(Load_Halfword(true,true,false,true,v1458,
                                             false,r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (true,(true,(true,(v1458,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (true,(true,(false,(true,true))))))))))) =>
                     LoadStore(Load_Halfword(true,true,false,false,true,
                                             false,r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (true,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (true,(true,(false,(false,true))))))))))) =>
                     LoadStore(Load_Exclusive(r (fromString "16"),
                                              r (fromString "12"),
                                              n2w_itself
                                                (ZERO,
                                                 (ITSELF
                                                   (fromString "8")))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (true,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (true,(false,(v1466,(v1470,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (true,(false,(v1466,(v1470,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(true,(true,(true,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Store_Dual(true,true,false,
                                             r (fromString "16"),rt,
                                             word_add rt
                                               (n2w_itself
                                                  (ONE,
                                                   (ITSELF
                                                     (fromString
                                                     "4")))),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(true,(true,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(true,(true,(false,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Load_Dual(true,true,false,
                                            r (fromString "16"),rt,
                                            word_add rt
                                              (n2w_itself
                                                 (ONE,
                                                  (ITSELF
                                                    (fromString "4")))),
                                            Mode3_register(n2w_itself
                                                             (ZERO,
                                                              (ITSELF
                                                                TWO)),
                                                           r ZERO)))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(true,(true,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(true,(false,(true,true))))))))))) =>
                     LoadStore(Store_Halfword(true,true,false,false,
                                              r (fromString "16"),
                                              r (fromString "12"),
                                              Mode3_register(n2w_itself
                                                               (ZERO,
                                                                (ITSELF
                                                                  TWO)),
                                                             r ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(true,(false,(false,true))))))))))) =>
                     LoadStore(Store_Exclusive(r (fromString "16"),
                                               r (fromString "12"),
                                               r ZERO,
                                               n2w_itself
                                                 (ZERO,
                                                  (ITSELF
                                                    (fromString "8")))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(false,(v1490,(v1494,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (true,
                       (false,
                        (false,
                         (false,(false,(v1490,(v1494,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (true,(true,(true,(v1518,true))))))))))) =>
                     LoadStore(Load_Halfword(true,false,true,true,v1518,
                                             false,r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (true,(true,(true,(v1518,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (true,(true,(false,(true,true))))))))))) =>
                     LoadStore(Load_Halfword(true,false,true,false,true,
                                             false,r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (true,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (true,(true,(false,(false,true))))))))))) =>
                     Undefined
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (true,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (true,(false,(v1526,(v1530,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (true,(false,(v1526,(v1530,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(true,(true,(true,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Store_Dual(true,false,true,
                                             r (fromString "16"),rt,
                                             word_add rt
                                               (n2w_itself
                                                  (ONE,
                                                   (ITSELF
                                                     (fromString
                                                     "4")))),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(true,(true,(true,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             true,true,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(true,(true,(false,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Load_Dual(true,false,true,
                                            r (fromString "16"),rt,
                                            word_add rt
                                              (n2w_itself
                                                 (ONE,
                                                  (ITSELF
                                                    (fromString "4")))),
                                            Mode3_immediate(word_concat_itself
                                                              (ITSELF
                                                                (fromString
                                                                "12"))
                                                              (i4
                                                                 (fromString
                                                                 "8"))
                                                              (i4
                                                                 ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(true,(true,(false,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             true,false,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(true,(false,(true,true))))))))))) =>
                     LoadStore(Store_Halfword(true,false,true,false,
                                              r (fromString "16"),
                                              r (fromString "12"),
                                              Mode3_immediate(word_concat_itself
                                                                (ITSELF
                                                                  (fromString
                                                                  "12"))
                                                                (i4
                                                                   (fromString
                                                                   "8"))
                                                                (i4
                                                                   ZERO))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             false,true,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(true,(false,(false,true))))))))))) =>
                     Undefined
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             false,
                                                             false,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(false,(true,(true,true))))))))))) =>
                     Miscellaneous(Secure_Monitor_Call(i4 ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(false,(true,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(false,(true,(false,true))))))))))) =>
                     DataProcessing(Saturating_Add_Subtract(i2
                                                              (fromString
                                                              "21"),
                                                            r
                                                              (fromString
                                                              "16"),
                                                            r
                                                              (fromString
                                                              "12"),
                                                            r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(false,(true,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(false,(false,(true,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(false,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(false,(false,(false,true))))))))))) =>
                     DataProcessing(Count_Leading_Zeroes(r
                                                           (fromString
                                                           "12"),
                                                         r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (true,
                         (false,(false,(false,(false,false))))))))))) =>
                     StatusAccess(Register_to_Status(true,
                                                     i4
                                                       (fromString
                                                       "16"),r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(true,(true,(v1574,true))))))))))) =>
                     LoadStore(Load_Halfword(true,false,false,true,
                                             v1574,false,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(true,(true,(v1574,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(true,(false,(true,true))))))))))) =>
                     LoadStore(Load_Halfword(true,false,false,false,
                                             true,false,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(true,(false,(false,true))))))))))) =>
                     Undefined
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(false,(v1582,(v1586,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (true,(false,(v1582,(v1586,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(true,(true,(true,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Store_Dual(true,false,false,
                                             r (fromString "16"),rt,
                                             word_add rt
                                               (n2w_itself
                                                  (ONE,
                                                   (ITSELF
                                                     (fromString
                                                     "4")))),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(true,(true,(true,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             true,true,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(true,(true,(false,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Load_Dual(true,false,false,
                                            r (fromString "16"),rt,
                                            word_add rt
                                              (n2w_itself
                                                 (ONE,
                                                  (ITSELF
                                                    (fromString "4")))),
                                            Mode3_immediate(word_concat_itself
                                                              (ITSELF
                                                                (fromString
                                                                "12"))
                                                              (i4
                                                                 (fromString
                                                                 "8"))
                                                              (i4
                                                                 ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(true,(true,(false,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             true,false,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(true,(false,(true,true))))))))))) =>
                     LoadStore(Store_Halfword(true,false,false,false,
                                              r (fromString "16"),
                                              r (fromString "12"),
                                              Mode3_immediate(word_concat_itself
                                                                (ITSELF
                                                                  (fromString
                                                                  "12"))
                                                                (i4
                                                                   (fromString
                                                                   "8"))
                                                                (i4
                                                                   ZERO))))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             false,true,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(true,(false,(false,true))))))))))) =>
                     Miscellaneous(Swap(true,r (fromString "16"),
                                        r (fromString "12"),r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             false,
                                                             false,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(false,(true,(true,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(false,(true,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(false,(true,(false,true))))))))))) =>
                     DataProcessing(Saturating_Add_Subtract(i2
                                                              (fromString
                                                              "21"),
                                                            r
                                                              (fromString
                                                              "16"),
                                                            r
                                                              (fromString
                                                              "12"),
                                                            r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(false,(true,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(false,(false,(true,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(false,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(false,(false,(false,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (true,
                        (false,
                         (false,(false,(false,(false,false))))))))))) =>
                     StatusAccess(Status_to_Register(true,
                                                     r
                                                       (fromString
                                                       "12")))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (true,(true,(true,(v1634,true))))))))))) =>
                     LoadStore(Load_Halfword(true,false,true,true,v1634,
                                             false,r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (true,(true,(true,(v1634,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (true,(true,(false,(true,true))))))))))) =>
                     LoadStore(Load_Halfword(true,false,true,false,true,
                                             false,r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (true,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (true,(true,(false,(false,true))))))))))) =>
                     Undefined
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (true,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (true,(false,(v1642,(v1646,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (true,(false,(v1642,(v1646,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(true,(true,(true,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Store_Dual(true,false,true,
                                             r (fromString "16"),rt,
                                             word_add rt
                                               (n2w_itself
                                                  (ONE,
                                                   (ITSELF
                                                     (fromString
                                                     "4")))),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(true,(true,(true,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             true,true,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(true,(true,(false,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Load_Dual(true,false,true,
                                            r (fromString "16"),rt,
                                            word_add rt
                                              (n2w_itself
                                                 (ONE,
                                                  (ITSELF
                                                    (fromString "4")))),
                                            Mode3_register(n2w_itself
                                                             (ZERO,
                                                              (ITSELF
                                                                TWO)),
                                                           r ZERO)))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(true,(true,(false,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             true,false,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(true,(false,(true,true))))))))))) =>
                     LoadStore(Store_Halfword(true,false,true,false,
                                              r (fromString "16"),
                                              r (fromString "12"),
                                              Mode3_register(n2w_itself
                                                               (ZERO,
                                                                (ITSELF
                                                                  TWO)),
                                                             r ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             false,true,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(true,(false,(false,true))))))))))) =>
                     Undefined
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             false,
                                                             false,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(false,(true,(true,true))))))))))) =>
                     if
                       word_eq cond
                         (n2w_itself
                            ((fromString "14"),
                             (ITSELF (fromString "4"))))
                     then
                       Miscellaneous(Breakpoint(word_concat_itself
                                                  (ITSELF
                                                    (fromString "16"))
                                                  (i12 (fromString "8"))
                                                  (i4 ZERO)))
                     else Unpredictable
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(false,(true,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(false,(true,(false,true))))))))))) =>
                     DataProcessing(Saturating_Add_Subtract(i2
                                                              (fromString
                                                              "21"),
                                                            r
                                                              (fromString
                                                              "16"),
                                                            r
                                                              (fromString
                                                              "12"),
                                                            r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(false,(true,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(false,(false,(true,true))))))))))) =>
                     Branch(Branch_Link_Exchange_Register(r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(false,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(false,(false,(false,true))))))))))) =>
                     Branch(Branch_Exchange(r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (true,
                         (false,(false,(false,(false,false))))))))))) =>
                     StatusAccess(Register_to_Status(false,
                                                     i4
                                                       (fromString
                                                       "16"),r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (true,(true,(true,(v1690,true))))))))))) =>
                     LoadStore(Load_Halfword(true,false,false,true,
                                             v1690,false,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (true,(true,(true,(v1690,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (true,(true,(false,(true,true))))))))))) =>
                     LoadStore(Load_Halfword(true,false,false,false,
                                             true,false,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (true,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (true,(true,(false,(false,true))))))))))) =>
                     Undefined
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (true,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (true,(false,(v1698,(v1702,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (true,(false,(v1698,(v1702,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(true,(true,(true,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Store_Dual(true,false,false,
                                             r (fromString "16"),rt,
                                             word_add rt
                                               (n2w_itself
                                                  (ONE,
                                                   (ITSELF
                                                     (fromString
                                                     "4")))),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(true,(true,(true,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             true,true,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(true,(true,(false,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Load_Dual(true,false,false,
                                            r (fromString "16"),rt,
                                            word_add rt
                                              (n2w_itself
                                                 (ONE,
                                                  (ITSELF
                                                    (fromString "4")))),
                                            Mode3_register(n2w_itself
                                                             (ZERO,
                                                              (ITSELF
                                                                TWO)),
                                                           r ZERO)))
                     end
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(true,(true,(false,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             true,false,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(true,(false,(true,true))))))))))) =>
                     LoadStore(Store_Halfword(true,false,false,false,
                                              r (fromString "16"),
                                              r (fromString "12"),
                                              Mode3_register(n2w_itself
                                                               (ZERO,
                                                                (ITSELF
                                                                  TWO)),
                                                             r ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             false,true,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(true,(false,(false,true))))))))))) =>
                     Miscellaneous(Swap(false,r (fromString "16"),
                                        r (fromString "12"),r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Signed_Halfword_Multiply(i2
                                                               (fromString
                                                               "21"),
                                                             false,
                                                             false,
                                                             r
                                                               (fromString
                                                               "16"),
                                                             r
                                                               (fromString
                                                               "12"),
                                                             r
                                                               (fromString
                                                               "8"),
                                                             r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(false,(true,(true,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(false,(true,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(false,(true,(false,true))))))))))) =>
                     DataProcessing(Saturating_Add_Subtract(i2
                                                              (fromString
                                                              "21"),
                                                            r
                                                              (fromString
                                                              "16"),
                                                            r
                                                              (fromString
                                                              "12"),
                                                            r ZERO))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(false,(true,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(false,(false,(true,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(false,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(false,(false,(false,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (true,
                      (false,
                       (false,
                        (false,
                         (false,(false,(false,(false,false))))))))))) =>
                     StatusAccess(Status_to_Register(false,
                                                     r
                                                       (fromString
                                                       "12")))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (true,(true,(true,(v1758,true))))))))))) =>
                     LoadStore(Load_Halfword(false,true,v1742,true,
                                             v1758,v1742,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (true,(true,(true,(v1758,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (true,(true,(false,(true,true))))))))))) =>
                     LoadStore(Load_Halfword(false,true,v1742,false,
                                             true,v1742,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (true,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (true,(true,(false,(false,true))))))))))) =>
                     DataProcessing(Multiply_Long(true,v1742,true,
                                                  r (fromString "16"),
                                                  r (fromString "12"),
                                                  r (fromString "8"),
                                                  r ZERO))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (true,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (true,(false,(v1766,(v1770,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (true,(false,(v1766,(v1770,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (false,(true,(true,(true,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Store_Dual(false,true,v1742,
                                             r (fromString "16"),rt,
                                             word_add rt
                                               (n2w_itself
                                                  (ONE,
                                                   (ITSELF
                                                     (fromString
                                                     "4")))),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (false,(true,(true,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (false,(true,(true,(false,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Load_Dual(false,true,v1742,
                                            r (fromString "16"),rt,
                                            word_add rt
                                              (n2w_itself
                                                 (ONE,
                                                  (ITSELF
                                                    (fromString "4")))),
                                            Mode3_immediate(word_concat_itself
                                                              (ITSELF
                                                                (fromString
                                                                "12"))
                                                              (i4
                                                                 (fromString
                                                                 "8"))
                                                              (i4
                                                                 ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (false,(true,(true,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (false,(true,(false,(true,true))))))))))) =>
                     LoadStore(Store_Halfword(false,true,v1742,v1742,
                                              r (fromString "16"),
                                              r (fromString "12"),
                                              Mode3_immediate(word_concat_itself
                                                                (ITSELF
                                                                  (fromString
                                                                  "12"))
                                                                (i4
                                                                   (fromString
                                                                   "8"))
                                                                (i4
                                                                   ZERO))))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (false,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (false,(true,(false,(false,true))))))))))) =>
                     DataProcessing(Multiply_Long(true,v1742,false,
                                                  r (fromString "16"),
                                                  r (fromString "12"),
                                                  r (fromString "8"),
                                                  r ZERO))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (false,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (false,(false,(v1790,(v1794,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (true,
                        (v1742,
                         (false,(false,(v1790,(v1794,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (true,(true,(true,(v1814,true))))))))))) =>
                     LoadStore(Load_Halfword(false,true,v1798,true,
                                             v1814,v1798,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (true,(true,(true,(v1814,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (true,(true,(false,(true,true))))))))))) =>
                     LoadStore(Load_Halfword(false,true,v1798,false,
                                             true,v1798,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (true,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (true,(true,(false,(false,true))))))))))) =>
                     DataProcessing(Multiply_Long(false,v1798,true,
                                                  r (fromString "16"),
                                                  r (fromString "12"),
                                                  r (fromString "8"),
                                                  r ZERO))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (true,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (true,(false,(v1822,(v1826,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (true,(false,(v1822,(v1826,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (false,(true,(true,(true,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Store_Dual(false,true,v1798,
                                             r (fromString "16"),rt,
                                             word_add rt
                                               (n2w_itself
                                                  (ONE,
                                                   (ITSELF
                                                     (fromString
                                                     "4")))),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                     end
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (false,(true,(true,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (false,(true,(true,(false,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Load_Dual(false,true,v1798,
                                            r (fromString "16"),rt,
                                            word_add rt
                                              (n2w_itself
                                                 (ONE,
                                                  (ITSELF
                                                    (fromString "4")))),
                                            Mode3_register(n2w_itself
                                                             (ZERO,
                                                              (ITSELF
                                                                TWO)),
                                                           r ZERO)))
                     end
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (false,(true,(true,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (false,(true,(false,(true,true))))))))))) =>
                     LoadStore(Store_Halfword(false,true,v1798,v1798,
                                              r (fromString "16"),
                                              r (fromString "12"),
                                              Mode3_register(n2w_itself
                                                               (ZERO,
                                                                (ITSELF
                                                                  TWO)),
                                                             r ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (false,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (false,(true,(false,(false,true))))))))))) =>
                     DataProcessing(Multiply_Long(false,v1798,false,
                                                  r (fromString "16"),
                                                  r (fromString "12"),
                                                  r (fromString "8"),
                                                  r ZERO))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (false,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (false,(false,(v1846,(v1850,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (true,
                       (false,
                        (v1798,
                         (false,(false,(v1846,(v1850,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (true,(true,(true,(v1874,true))))))))))) =>
                     LoadStore(Load_Halfword(false,false,true,true,
                                             v1874,true,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (true,(true,(true,(v1874,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (true,(true,(false,(true,true))))))))))) =>
                     LoadStore(Load_Halfword(false,false,true,false,
                                             true,true,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (true,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (true,(true,(false,(false,true))))))))))) =>
                     Undefined
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (true,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (true,(false,(v1882,(v1886,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (true,(false,(v1882,(v1886,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (false,(true,(true,(true,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Store_Dual(false,false,true,
                                             r (fromString "16"),rt,
                                             word_add rt
                                               (n2w_itself
                                                  (ONE,
                                                   (ITSELF
                                                     (fromString
                                                     "4")))),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (false,(true,(true,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (false,(true,(true,(false,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Load_Dual(false,false,true,
                                            r (fromString "16"),rt,
                                            word_add rt
                                              (n2w_itself
                                                 (ONE,
                                                  (ITSELF
                                                    (fromString "4")))),
                                            Mode3_immediate(word_concat_itself
                                                              (ITSELF
                                                                (fromString
                                                                "12"))
                                                              (i4
                                                                 (fromString
                                                                 "8"))
                                                              (i4
                                                                 ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (false,(true,(true,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (false,(true,(false,(true,true))))))))))) =>
                     LoadStore(Store_Halfword(false,false,true,true,
                                              r (fromString "16"),
                                              r (fromString "12"),
                                              Mode3_immediate(word_concat_itself
                                                                (ITSELF
                                                                  (fromString
                                                                  "12"))
                                                                (i4
                                                                   (fromString
                                                                   "8"))
                                                                (i4
                                                                   ZERO))))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (false,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (false,(true,(false,(false,true))))))))))) =>
                     DataProcessing(Multiply_Subtract(r
                                                        (fromString
                                                        "16"),
                                                      r
                                                        (fromString
                                                        "12"),
                                                      r
                                                        (fromString
                                                        "8"),r ZERO))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (false,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (false,(false,(v1906,(v1910,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (true,
                         (false,(false,(v1906,(v1910,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (true,(true,(true,(v1926,true))))))))))) =>
                     LoadStore(Load_Halfword(false,false,false,true,
                                             v1926,false,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (true,(true,(true,(v1926,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (true,(true,(false,(true,true))))))))))) =>
                     LoadStore(Load_Halfword(false,false,false,false,
                                             true,false,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (true,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (true,(true,(false,(false,true))))))))))) =>
                     Undefined
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (true,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (true,(false,(v1934,(v1938,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (true,(false,(v1934,(v1938,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (false,(true,(true,(true,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Store_Dual(false,false,false,
                                             r (fromString "16"),rt,
                                             word_add rt
                                               (n2w_itself
                                                  (ONE,
                                                   (ITSELF
                                                     (fromString
                                                     "4")))),
                                             Mode3_immediate(word_concat_itself
                                                               (ITSELF
                                                                 (fromString
                                                                 "12"))
                                                               (i4
                                                                  (fromString
                                                                  "8"))
                                                               (i4
                                                                  ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (false,(true,(true,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (false,(true,(true,(false,true))))))))))) =>
                     let val rt = r (fromString "12")
                     in
                        LoadStore(Load_Dual(false,false,false,
                                            r (fromString "16"),rt,
                                            word_add rt
                                              (n2w_itself
                                                 (ONE,
                                                  (ITSELF
                                                    (fromString "4")))),
                                            Mode3_immediate(word_concat_itself
                                                              (ITSELF
                                                                (fromString
                                                                "12"))
                                                              (i4
                                                                 (fromString
                                                                 "8"))
                                                              (i4
                                                                 ZERO))))
                     end
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (false,(true,(true,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (false,(true,(false,(true,true))))))))))) =>
                     LoadStore(Store_Halfword(false,false,false,false,
                                              r (fromString "16"),
                                              r (fromString "12"),
                                              Mode3_immediate(word_concat_itself
                                                                (ITSELF
                                                                  (fromString
                                                                  "12"))
                                                                (i4
                                                                   (fromString
                                                                   "8"))
                                                                (i4
                                                                   ZERO))))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (false,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (false,(true,(false,(false,true))))))))))) =>
                     DataProcessing(Multiply_Accumulate_Accumulate(r
                                                                     (fromString
                                                                     "16"),
                                                                   r
                                                                     (fromString
                                                                     "12"),
                                                                   r
                                                                     (fromString
                                                                     "8"),
                                                                   r
                                                                     ZERO))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (false,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (false,(false,(v1958,(v1962,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register_shifted_register(r
                                                                                      (fromString
                                                                                      "8"),
                                                                                    i2
                                                                                      (fromString
                                                                                      "5"),
                                                                                    r
                                                                                      ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (true,
                        (false,
                         (false,(false,(v1958,(v1962,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    false,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (false,
                        (v1966,
                         (true,(true,(true,(v1982,true))))))))))) =>
                     LoadStore(Load_Halfword(false,false,v1966,true,
                                             v1982,v1966,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (false,
                        (v1966,
                         (true,(true,(true,(v1982,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (false,
                        (v1966,
                         (true,(true,(false,(true,true))))))))))) =>
                     LoadStore(Load_Halfword(false,false,v1966,false,
                                             true,v1966,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             Mode3_register(n2w_itself
                                                              (ZERO,
                                                               (ITSELF
                                                                 TWO)),
                                                            r ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (false,
                        (v1966,
                         (true,(true,(false,(true,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (false,
                        (v1966,
                         (true,(true,(false,(false,true))))))))))) =>
                     DataProcessing(Multiply(v1966,true,
                                             r (fromString "16"),
                                             r (fromString "12"),
                                             r (fromString "8"),r ZERO))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (false,
                        (v1966,
                         (true,(true,(false,(false,false))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (fromString "21"),
                                                    true,
                                                    r (fromString "16"),
                                                    r (fromString "12"),
                                                    Mode1_register(i5
                                                                     (fromString
                                                                     "7"),
                                                                   i2
                                                                     (fromString
                                                                     "5"),
                                                                   r
                                                                     ZERO)))
                | (false,
                   (false,
                    (false,
                     (false,
                      (false,
                       (false,
                        (v1966,
                         (true,(false,(v1990,(v1994,true))))))))))) =>
                     DataProcessing(Data_Processing(i4
                                                      (f