(**************************************************************************)
(*                            arm-run & arm-tracer                        *)
(*                                                                        *)
(*   Pankaj More, IIT Kanpur & INRIA Paris-Rocquencourt                   *)
(*   Francesco Zappa Nardelli, INRIA Paris-Rocquencourt                   *)
(*                                                                        *)
(*  The arm-run and arm-tracer tools are copyright 2012, 2013 Institut    *)
(*  National de Recherche en Informatique et en Automatique (INRIA).      *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(*  *******************************************************************   *)
(*                                                                        *)
(*  *******************************************************************   *)
(*                                                                        *)
(*                               arm-run                                  *)
(*                                                                        *)
(*  The arm-run tool is copyright 2010 - 2013 Anthony Fox, Magnus Myreen  *)
(*  and Mike Gordon, Computer Laboratory, University of Cambridge.        *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER  *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*                                                                        *)
(**************************************************************************)

signature armML =
sig
  type num = numML.num
  type int = intML.int
  type 'a ptree = 'a patriciaML.ptree
  type 'a set = 'a setML.set
  type 'a itself = 'a fcpML.itself
  type 'a bit0 = 'a fcpML.bit0
  type 'a bit1 = 'a fcpML.bit1
  type 'a word = 'a wordsML.word
  type ('a,'b) cart = ('a,'b) fcpML.cart
  type ('a,'b) sum = ('a,'b) sumML.sum
  type word2 = wordsML.word2
  type word3 = wordsML.word3
  type word4 = wordsML.word4
  type word5 = wordsML.word5
  type word6 = wordsML.word6
  type word8 = wordsML.word8
  type word12 = wordsML.word12
  type word16 = wordsML.word16
  type word24 = wordsML.word24
  type word32 = wordsML.word32
  type word64 = wordsML.word64
  datatype ARMextensions
       = Extension_ThumbEE
       | Extension_VFP
       | Extension_AdvanvedSIMD
       | Extension_Security
       | Extension_Jazelle
       | Extension_Multiprocessing
  type ARMextensions_set = ARMextensions set
  datatype iiid = iiid of num
  val iiid_proc : iiid -> num
  val iiid_proc_fupd : (num -> num) -> iiid -> iiid
  datatype RName
       = RName_0usr
       | RName_1usr
       | RName_2usr
       | RName_3usr
       | RName_4usr
       | RName_5usr
       | RName_6usr
       | RName_7usr
       | RName_8usr
       | RName_8fiq
       | RName_9usr
       | RName_9fiq
       | RName_10usr
       | RName_10fiq
       | RName_11usr
       | RName_11fiq
       | RName_12usr
       | RName_12fiq
       | RName_SPusr
       | RName_SPfiq
       | RName_SPirq
       | RName_SPsvc
       | RName_SPabt
       | RName_SPund
       | RName_SPmon
       | RName_LRusr
       | RName_LRfiq
       | RName_LRirq
       | RName_LRsvc
       | RName_LRabt
       | RName_LRund
       | RName_LRmon
       | RName_PC
  datatype PSRName
       = CPSR
       | SPSR_fiq
       | SPSR_irq
       | SPSR_svc
       | SPSR_mon
       | SPSR_abt
       | SPSR_und
  datatype
  ARMpsr = ARMpsr of bool * bool * bool * bool * bool * word8 * bool *
                     word4 * word4 * bool * bool * bool * bool * bool *
                     word5
  val ARMpsr_N : ARMpsr -> bool
  val ARMpsr_Z : ARMpsr -> bool
  val ARMpsr_C : ARMpsr -> bool
  val ARMpsr_V : ARMpsr -> bool
  val ARMpsr_Q : ARMpsr -> bool
  val ARMpsr_IT : ARMpsr -> word8
  val ARMpsr_J : ARMpsr -> bool
  val ARMpsr_Reserved : ARMpsr -> word4
  val ARMpsr_GE : ARMpsr -> word4
  val ARMpsr_E : ARMpsr -> bool
  val ARMpsr_A : ARMpsr -> bool
  val ARMpsr_I : ARMpsr -> bool
  val ARMpsr_F : ARMpsr -> bool
  val ARMpsr_T : ARMpsr -> bool
  val ARMpsr_M : ARMpsr -> word5
  val ARMpsr_N_fupd : (bool -> bool) -> ARMpsr -> ARMpsr
  val ARMpsr_Z_fupd : (bool -> bool) -> ARMpsr -> ARMpsr
  val ARMpsr_C_fupd : (bool -> bool) -> ARMpsr -> ARMpsr
  val ARMpsr_V_fupd : (bool -> bool) -> ARMpsr -> ARMpsr
  val ARMpsr_Q_fupd : (bool -> bool) -> ARMpsr -> ARMpsr
  val ARMpsr_IT_fupd : (word8 -> word8) -> ARMpsr -> ARMpsr
  val ARMpsr_J_fupd : (bool -> bool) -> ARMpsr -> ARMpsr
  val ARMpsr_Reserved_fupd : (word4 -> word4) -> ARMpsr -> ARMpsr
  val ARMpsr_GE_fupd : (word4 -> word4) -> ARMpsr -> ARMpsr
  val ARMpsr_E_fupd : (bool -> bool) -> ARMpsr -> ARMpsr
  val ARMpsr_A_fupd : (bool -> bool) -> ARMpsr -> ARMpsr
  val ARMpsr_I_fupd : (bool -> bool) -> ARMpsr -> ARMpsr
  val ARMpsr_F_fupd : (bool -> bool) -> ARMpsr -> ARMpsr
  val ARMpsr_T_fupd : (bool -> bool) -> ARMpsr -> ARMpsr
  val ARMpsr_M_fupd : (word5 -> word5) -> ARMpsr -> ARMpsr
  datatype CP14reg = CP14reg of word32
  val CP14reg_TEEHBR : CP14reg -> word32
  val CP14reg_TEEHBR_fupd : (word32 -> word32) -> CP14reg -> CP14reg
  datatype
  CP15sctlr = CP15sctlr of bool * bool * bool * bool * bool * bool *
                           bool * bool * bool * bool * bool * bool *
                           bool * bool * bool * bool * bool * bool *
                           bool * bool
  val CP15sctlr_IE : CP15sctlr -> bool
  val CP15sctlr_TE : CP15sctlr -> bool
  val CP15sctlr_AFE : CP15sctlr -> bool
  val CP15sctlr_TRE : CP15sctlr -> bool
  val CP15sctlr_NMFI : CP15sctlr -> bool
  val CP15sctlr_EE : CP15sctlr -> bool
  val CP15sctlr_VE : CP15sctlr -> bool
  val CP15sctlr_U : CP15sctlr -> bool
  val CP15sctlr_FI : CP15sctlr -> bool
  val CP15sctlr_DZ : CP15sctlr -> bool
  val CP15sctlr_HA : CP15sctlr -> bool
  val CP15sctlr_RR : CP15sctlr -> bool
  val CP15sctlr_V : CP15sctlr -> bool
  val CP15sctlr_I : CP15sctlr -> bool
  val CP15sctlr_Z : CP15sctlr -> bool
  val CP15sctlr_SW : CP15sctlr -> bool
  val CP15sctlr_B : CP15sctlr -> bool
  val CP15sctlr_C : CP15sctlr -> bool
  val CP15sctlr_A : CP15sctlr -> bool
  val CP15sctlr_M : CP15sctlr -> bool
  val CP15sctlr_IE_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_TE_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_AFE_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_TRE_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_NMFI_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_EE_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_VE_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_U_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_FI_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_DZ_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_HA_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_RR_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_V_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_I_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_Z_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_SW_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_B_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_C_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_A_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  val CP15sctlr_M_fupd : (bool -> bool) -> CP15sctlr -> CP15sctlr
  datatype
  CP15scr = CP15scr of bool * bool * bool * bool * bool * bool * bool
  val CP15scr_nET : CP15scr -> bool
  val CP15scr_AW : CP15scr -> bool
  val CP15scr_FW : CP15scr -> bool
  val CP15scr_EA : CP15scr -> bool
  val CP15scr_FIQ : CP15scr -> bool
  val CP15scr_IRQ : CP15scr -> bool
  val CP15scr_NS : CP15scr -> bool
  val CP15scr_nET_fupd : (bool -> bool) -> CP15scr -> CP15scr
  val CP15scr_AW_fupd : (bool -> bool) -> CP15scr -> CP15scr
  val CP15scr_FW_fupd : (bool -> bool) -> CP15scr -> CP15scr
  val CP15scr_EA_fupd : (bool -> bool) -> CP15scr -> CP15scr
  val CP15scr_FIQ_fupd : (bool -> bool) -> CP15scr -> CP15scr
  val CP15scr_IRQ_fupd : (bool -> bool) -> CP15scr -> CP15scr
  val CP15scr_NS_fupd : (bool -> bool) -> CP15scr -> CP15scr
  datatype
  CP15nsacr = CP15nsacr of bool * bool * bool * unit bit1 bit1 bit0 word
  val CP15nsacr_RFR : CP15nsacr -> bool
  val CP15nsacr_NSASEDIS : CP15nsacr -> bool
  val CP15nsacr_NSD32DIS : CP15nsacr -> bool
  val CP15nsacr_cp : CP15nsacr -> unit bit1 bit1 bit0 word
  val CP15nsacr_RFR_fupd : (bool -> bool) -> CP15nsacr -> CP15nsacr
  val CP15nsacr_NSASEDIS_fupd : (bool -> bool) -> CP15nsacr -> CP15nsacr
  val CP15nsacr_NSD32DIS_fupd : (bool -> bool) -> CP15nsacr -> CP15nsacr
  val CP15nsacr_cp_fupd
     : (unit bit1 bit1 bit0 word -> unit bit1 bit1 bit0 word) ->
       CP15nsacr -> CP15nsacr
  datatype
  CP15reg = CP15reg of CP15sctlr * CP15scr * CP15nsacr * word32 * word32
  val CP15reg_SCTLR : CP15reg -> CP15sctlr
  val CP15reg_SCR : CP15reg -> CP15scr
  val CP15reg_NSACR : CP15reg -> CP15nsacr
  val CP15reg_VBAR : CP15reg -> word32
  val CP15reg_MVBAR : CP15reg -> word32
  val CP15reg_SCTLR_fupd
     : (CP15sctlr -> CP15sctlr) -> CP15reg -> CP15reg
  val CP15reg_SCR_fupd : (CP15scr -> CP15scr) -> CP15reg -> CP15reg
  val CP15reg_NSACR_fupd
     : (CP15nsacr -> CP15nsacr) -> CP15reg -> CP15reg
  val CP15reg_VBAR_fupd : (word32 -> word32) -> CP15reg -> CP15reg
  val CP15reg_MVBAR_fupd : (word32 -> word32) -> CP15reg -> CP15reg
  datatype coproc_state = coproc_state of CP14reg * CP15reg
  val coproc_state_cp14 : coproc_state -> CP14reg
  val coproc_state_cp15 : coproc_state -> CP15reg
  val coproc_state_cp14_fupd
     : (CP14reg -> CP14reg) -> coproc_state -> coproc_state
  val coproc_state_cp15_fupd
     : (CP15reg -> CP15reg) -> coproc_state -> coproc_state
  datatype access
       = MEM_READ of word32 * (word8 list) * num | MEM_WRITE of word32 * (word8 list) * num
       | REG_READ of RName | REG_WRITE of RName
       | PSR_READ of PSRName | PSR_WRITE of PSRName
  datatype ir_access
       = IR_REG_READ of RName | IR_REG_WRITE of RName
       | LOCAL_READ of word32 | LOCAL_WRITE of word32
       | GLOBAL_READ of Int.int | GLOBAL_WRITE of Int.int
  datatype ARMarch
       = ARMv4
       | ARMv4T
       | ARMv5T
       | ARMv5TE
       | ARMv6
       | ARMv6K
       | ARMv6T2
       | ARMv7_A
       | ARMv7_R
  datatype ARMinfo = ARMinfo of ARMarch * (ARMextensions_set) * bool
  val ARMinfo_arch : ARMinfo -> ARMarch
  val ARMinfo_extensions : ARMinfo -> ARMextensions_set
  val ARMinfo_unaligned_support : ARMinfo -> bool
  val ARMinfo_arch_fupd : (ARMarch -> ARMarch) -> ARMinfo -> ARMinfo
  val ARMinfo_extensions_fupd
     : (ARMextensions_set -> ARMextensions_set) -> ARMinfo -> ARMinfo
  val ARMinfo_unaligned_support_fupd
     : (bool -> bool) -> ARMinfo -> ARMinfo
  datatype SRType
       = SRType_LSL | SRType_LSR | SRType_ASR | SRType_ROR | SRType_RRX
  datatype InstrSet
       = InstrSet_ARM
       | InstrSet_Thumb
       | InstrSet_Jazelle
       | InstrSet_ThumbEE
  datatype Encoding
       = Encoding_ARM
       | Encoding_Thumb
       | Encoding_Thumb2
       | Encoding_ThumbEE
  datatype MemType
       = MemType_Normal | MemType_Device | MemType_StronglyOrdered
  datatype
  MemoryAttributes = MemoryAttributes of MemType * word2 * word2 *
                                         bool * bool
  val MemoryAttributes_type : MemoryAttributes -> MemType
  val MemoryAttributes_innerattrs : MemoryAttributes -> word2
  val MemoryAttributes_outerattrs : MemoryAttributes -> word2
  val MemoryAttributes_shareable : MemoryAttributes -> bool
  val MemoryAttributes_outershareable : MemoryAttributes -> bool
  val MemoryAttributes_type_fupd
     : (MemType -> MemType) -> MemoryAttributes -> MemoryAttributes
  val MemoryAttributes_innerattrs_fupd
     : (word2 -> word2) -> MemoryAttributes -> MemoryAttributes
  val MemoryAttributes_outerattrs_fupd
     : (word2 -> word2) -> MemoryAttributes -> MemoryAttributes
  val MemoryAttributes_shareable_fupd
     : (bool -> bool) -> MemoryAttributes -> MemoryAttributes
  val MemoryAttributes_outershareable_fupd
     : (bool -> bool) -> MemoryAttributes -> MemoryAttributes
  datatype
  AddressDescriptor = AddressDescriptor of MemoryAttributes * word32
  val AddressDescriptor_memattrs : AddressDescriptor -> MemoryAttributes
  val AddressDescriptor_paddress : AddressDescriptor -> word32
  val AddressDescriptor_memattrs_fupd
     : (MemoryAttributes -> MemoryAttributes) ->
       AddressDescriptor -> AddressDescriptor
  val AddressDescriptor_paddress_fupd
     : (word32 -> word32) -> AddressDescriptor -> AddressDescriptor
  datatype MBReqDomain
       = MBReqDomain_FullSystem
       | MBReqDomain_OuterShareable
       | MBReqDomain_InnerShareable
       | MBReqDomain_Nonshareable
  datatype MBReqTypes = MBReqTypes_All | MBReqTypes_Writes
  datatype addressing_mode1
       = Mode1_immediate of word12
       | Mode1_register of word5 * word2 * word4
       | Mode1_register_shifted_register of word4 * word2 * word4
  datatype addressing_mode2
       = Mode2_immediate of word12
       | Mode2_register of word5 * word2 * word4
  datatype addressing_mode3
       = Mode3_immediate of word12 | Mode3_register of word2 * word4
  datatype hint
       = Hint_nop
       | Hint_yield
       | Hint_wait_for_event
       | Hint_wait_for_interrupt
       | Hint_send_event
       | Hint_debug of word4
  datatype parallel_add_sub_op1
       = Parallel_normal | Parallel_saturating | Parallel_halving
  datatype parallel_add_sub_op2
       = Parallel_add_16
       | Parallel_add_sub_exchange
       | Parallel_sub_add_exchange
       | Parallel_sub_16
       | Parallel_add_8
       | Parallel_sub_8
  datatype branch_instruction
       = Branch_Target of word24
       | Branch_Exchange of word4
       | Branch_Link_Exchange_Immediate of bool * bool * word24
       | Branch_Link_Exchange_Register of word4
       | Compare_Branch of bool * word6 * word3
       | Table_Branch_Byte of word4 * bool * word4
       | Check_Array of word4 * word4
       | Handler_Branch_Link of bool * word8
       | Handler_Branch_Link_Parameter of word5 * word5
       | Handler_Branch_Parameter of word3 * word5
  datatype data_processing_instruction
       = Data_Processing of word4 * bool * word4 * word4 *
                            addressing_mode1
       | Add_Sub of bool * word4 * word4 * word12
       | Move_Halfword of bool * word4 * word16
       | Multiply of bool * bool * word4 * word4 * word4 * word4
       | Multiply_Subtract of word4 * word4 * word4 * word4
       | Signed_Halfword_Multiply of word2 * bool * bool * word4 *
                                     word4 * word4 * word4
       | Signed_Multiply_Dual of word4 * word4 * word4 * bool * bool *
                                 word4
       | Signed_Multiply_Long_Dual of word4 * word4 * word4 * bool *
                                      bool * word4
       | Signed_Most_Significant_Multiply of word4 * word4 * word4 *
                                             bool * word4
       | Signed_Most_Significant_Multiply_Subtract of word4 * word4 *
                                                      word4 * bool *
                                                      word4
       | Multiply_Long of bool * bool * bool * word4 * word4 * word4 *
                          word4
       | Multiply_Accumulate_Accumulate of word4 * word4 * word4 * word4
       | Saturate of bool * word5 * word4 * word5 * bool * word4
       | Saturate_16 of bool * word4 * word4 * word4
       | Saturating_Add_Subtract of word2 * word4 * word4 * word4
       | Pack_Halfword of word4 * word4 * word5 * bool * word4
       | Extend_Byte of bool * word4 * word4 * word2 * word4
       | Extend_Byte_16 of bool * word4 * word4 * word2 * word4
       | Extend_Halfword of bool * word4 * word4 * word2 * word4
       | Bit_Field_Clear_Insert of word5 * word4 * word5 * word4
       | Count_Leading_Zeroes of word4 * word4
       | Reverse_Bits of word4 * word4
       | Byte_Reverse_Word of word4 * word4
       | Byte_Reverse_Packed_Halfword of word4 * word4
       | Byte_Reverse_Signed_Halfword of word4 * word4
       | Bit_Field_Extract of bool * word5 * word4 * word5 * word4
       | Select_Bytes of word4 * word4 * word4
       | Unsigned_Sum_Absolute_Differences of word4 * word4 * word4 *
                                              word4
       | Parallel_Add_Subtract of bool *
                                  (parallel_add_sub_op1 *
                                   parallel_add_sub_op2) * word4 *
                                  word4 * word4
       | Divide of bool * word4 * word4 * word4
  datatype status_access_instruction
       = Status_to_Register of bool * word4
       | Register_to_Status of bool * word4 * word4
       | Immediate_to_Status of bool * word4 * word12
       | Change_Processor_State of word2 * bool * bool * bool *
                                   word5 option
       | Set_Endianness of bool
  datatype load_store_instruction
       = Load of bool * bool * bool * bool * bool * word4 * word4 *
                 addressing_mode2
       | Store of bool * bool * bool * bool * bool * word4 * word4 *
                  addressing_mode2
       | Load_Halfword of bool * bool * bool * bool * bool * bool *
                          word4 * word4 * addressing_mode3
       | Store_Halfword of bool * bool * bool * bool * word4 * word4 *
                           addressing_mode3
       | Load_Dual of bool * bool * bool * word4 * word4 * word4 *
                      addressing_mode3
       | Store_Dual of bool * bool * bool * word4 * word4 * word4 *
                       addressing_mode3
       | Load_Multiple of bool * bool * bool * bool * word4 * word16
       | Store_Multiple of bool * bool * bool * bool * word4 * word16
       | Load_Exclusive of word4 * word4 * word8
       | Store_Exclusive of word4 * word4 * word4 * word8
       | Load_Exclusive_Doubleword of word4 * word4 * word4
       | Store_Exclusive_Doubleword of word4 * word4 * word4 * word4
       | Load_Exclusive_Halfword of word4 * word4
       | Store_Exclusive_Halfword of word4 * word4 * word4
       | Load_Exclusive_Byte of word4 * word4
       | Store_Exclusive_Byte of word4 * word4 * word4
       | Store_Return_State of bool * bool * bool * word5
       | Return_From_Exception of bool * bool * bool * word4
  datatype miscellaneous_instruction
       = Hint of hint
       | Breakpoint of word16
       | Data_Memory_Barrier of word4
       | Data_Synchronization_Barrier of word4
       | Instruction_Synchronization_Barrier of word4
       | Swap of bool * word4 * word4 * word4
       | Preload_Data of bool * bool * word4 * addressing_mode2
       | Preload_Instruction of bool * word4 * addressing_mode2
       | Supervisor_Call of word24
       | Secure_Monitor_Call of word4
       | Enterx_Leavex of bool
       | Clear_Exclusive
       | If_Then of word4 * word4
  datatype coprocessor_instruction
       = Coprocessor_Load of bool * bool * bool * bool * word4 * word4 *
                             word4 * word8
       | Coprocessor_Store of bool * bool * bool * bool * word4 *
                              word4 * word4 * word8
       | Coprocessor_Data_Processing of word4 * word4 * word4 * word4 *
                                        word3 * word4
       | Coprocessor_Transfer of word3 * bool * word4 * word4 * word4 *
                                 word3 * word4
       | Coprocessor_Transfer_Two of bool * word4 * word4 * word4 *
                                     word4 * word4
  datatype ARMinstruction
       = Unpredictable
       | Undefined
       | Branch of branch_instruction
       | DataProcessing of data_processing_instruction
       | StatusAccess of status_access_instruction
       | LoadStore of load_store_instruction
       | Miscellaneous of miscellaneous_instruction
       | Coprocessor of coprocessor_instruction
  type CPinstruction = word4 * (word4 * coprocessor_instruction)
  type exclusive_triple = word32 * (iiid * num)
  type exclusive_state = (num -> word32 set) * (word32 * num) set
  type 'a ExclusiveM = exclusive_state -> ('a * exclusive_state)
  type 'a CoprocessorM = coproc_state -> ('a * coproc_state)
  datatype
  ExclusiveMonitors = ExclusiveMonitors of (exclusive_state) *
                                           (exclusive_triple ->
                                            unit ExclusiveM) *
                                           (exclusive_triple ->
                                            unit ExclusiveM) *
                                           (exclusive_triple ->
                                            bool ExclusiveM) *
                                           (exclusive_triple ->
                                            bool ExclusiveM) *
                                           (exclusive_triple ->
                                            unit ExclusiveM) *
                                           (num -> unit ExclusiveM)
  val ExclusiveMonitors_state : ExclusiveMonitors -> exclusive_state
  val ExclusiveMonitors_MarkExclusiveGlobal
     : ExclusiveMonitors -> exclusive_triple -> unit ExclusiveM
  val ExclusiveMonitors_MarkExclusiveLocal
     : ExclusiveMonitors -> exclusive_triple -> unit ExclusiveM
  val ExclusiveMonitors_IsExclusiveGlobal
     : ExclusiveMonitors -> exclusive_triple -> bool ExclusiveM
  val ExclusiveMonitors_IsExclusiveLocal
     : ExclusiveMonitors -> exclusive_triple -> bool ExclusiveM
  val ExclusiveMonitors_ClearExclusiveByAddress
     : ExclusiveMonitors -> exclusive_triple -> unit ExclusiveM
  val ExclusiveMonitors_ClearExclusiveLocal
     : ExclusiveMonitors -> num -> unit ExclusiveM
  val ExclusiveMonitors_state_fupd
     : (exclusive_state -> exclusive_state) ->
       ExclusiveMonitors -> ExclusiveMonitors
  val ExclusiveMonitors_MarkExclusiveGlobal_fupd
     : ((exclusive_triple -> unit ExclusiveM) ->
        exclusive_triple -> unit ExclusiveM) ->
       ExclusiveMonitors -> ExclusiveMonitors
  val ExclusiveMonitors_MarkExclusiveLocal_fupd
     : ((exclusive_triple -> unit ExclusiveM) ->
        exclusive_triple -> unit ExclusiveM) ->
       ExclusiveMonitors -> ExclusiveMonitors
  val ExclusiveMonitors_IsExclusiveGlobal_fupd
     : ((exclusive_triple -> bool ExclusiveM) ->
        exclusive_triple -> bool ExclusiveM) ->
       ExclusiveMonitors -> ExclusiveMonitors
  val ExclusiveMonitors_IsExclusiveLocal_fupd
     : ((exclusive_triple -> bool ExclusiveM) ->
        exclusive_triple -> bool ExclusiveM) ->
       ExclusiveMonitors -> ExclusiveMonitors
  val ExclusiveMonitors_ClearExclusiveByAddress_fupd
     : ((exclusive_triple -> unit ExclusiveM) ->
        exclusive_triple -> unit ExclusiveM) ->
       ExclusiveMonitors -> ExclusiveMonitors
  val ExclusiveMonitors_ClearExclusiveLocal_fupd
     : ((num -> unit ExclusiveM) -> num -> unit ExclusiveM) ->
       ExclusiveMonitors -> ExclusiveMonitors
  datatype
  Coprocessors = Coprocessors of coproc_state *
                                 (CPinstruction -> bool CoprocessorM) *
                                 (CPinstruction -> unit CoprocessorM) *
                                 (CPinstruction -> num CoprocessorM) *
                                 (CPinstruction ->
                                  word32 list -> unit CoprocessorM) *
                                 (CPinstruction ->
                                  word32 list CoprocessorM) *
                                 (CPinstruction ->
                                  word32 -> unit CoprocessorM) *
                                 (CPinstruction ->
                                  word32 CoprocessorM) *
                                 (CPinstruction ->
                                  word32 * word32 ->
                                  unit CoprocessorM) *
                                 (CPinstruction ->
                                  (word32 * word32) CoprocessorM)
  val Coprocessors_state : Coprocessors -> coproc_state
  val Coprocessors_accept
     : Coprocessors -> CPinstruction -> bool CoprocessorM
  val Coprocessors_internal_op
     : Coprocessors -> CPinstruction -> unit CoprocessorM
  val Coprocessors_load_count
     : Coprocessors -> CPinstruction -> num CoprocessorM
  val Coprocessors_load
     : Coprocessors -> CPinstruction -> word32 list -> unit CoprocessorM
  val Coprocessors_store
     : Coprocessors -> CPinstruction -> word32 list CoprocessorM
  val Coprocessors_send_one
     : Coprocessors -> CPinstruction -> word32 -> unit CoprocessorM
  val Coprocessors_get_one
     : Coprocessors -> CPinstruction -> word32 CoprocessorM
  val Coprocessors_send_two
     : Coprocessors ->
       CPinstruction -> word32 * word32 -> unit CoprocessorM
  val Coprocessors_get_two
     : Coprocessors -> CPinstruction -> (word32 * word32) CoprocessorM
  val Coprocessors_state_fupd
     : (coproc_state -> coproc_state) -> Coprocessors -> Coprocessors
  val Coprocessors_accept_fupd
     : ((CPinstruction -> bool CoprocessorM) ->
        CPinstruction -> bool CoprocessorM) ->
       Coprocessors -> Coprocessors
  val Coprocessors_internal_op_fupd
     : ((CPinstruction -> unit CoprocessorM) ->
        CPinstruction -> unit CoprocessorM) ->
       Coprocessors -> Coprocessors
  val Coprocessors_load_count_fupd
     : ((CPinstruction -> num CoprocessorM) ->
        CPinstruction -> num CoprocessorM) ->
       Coprocessors -> Coprocessors
  val Coprocessors_load_fupd
     : ((CPinstruction -> word32 list -> unit CoprocessorM) ->
        CPinstruction -> word32 list -> unit CoprocessorM) ->
       Coprocessors -> Coprocessors
  val Coprocessors_store_fupd
     : ((CPinstruction -> word32 list CoprocessorM) ->
        CPinstruction -> word32 list CoprocessorM) ->
       Coprocessors -> Coprocessors
  val Coprocessors_send_one_fupd
     : ((CPinstruction -> word32 -> unit CoprocessorM) ->
        CPinstruction -> word32 -> unit CoprocessorM) ->
       Coprocessors -> Coprocessors
  val Coprocessors_get_one_fupd
     : ((CPinstruction -> word32 CoprocessorM) ->
        CPinstruction -> word32 CoprocessorM) ->
       Coprocessors -> Coprocessors
  val Coprocessors_send_two_fupd
     : ((CPinstruction -> word32 * word32 -> unit CoprocessorM) ->
        CPinstruction -> word32 * word32 -> unit CoprocessorM) ->
       Coprocessors -> Coprocessors
  val Coprocessors_get_two_fupd
     : ((CPinstruction -> (word32 * word32) CoprocessorM) ->
        CPinstruction -> (word32 * word32) CoprocessorM) ->
       Coprocessors -> Coprocessors
  datatype
  arm_state = arm_state of (num * RName -> word32) *
                           (num * PSRName -> ARMpsr) * (num -> bool) *
                           (num -> bool) * (word32 -> word8) *
                           access list * ARMinfo * Coprocessors *
                           ExclusiveMonitors
  val arm_state_registers : arm_state -> num * RName -> word32
  val arm_state_psrs : arm_state -> num * PSRName -> ARMpsr
  val arm_state_event_register : arm_state -> num -> bool
  val arm_state_interrupt_wait : arm_state -> num -> bool
  val arm_state_memory : arm_state -> word32 -> word8
  val arm_state_accesses : arm_state -> access list
  val arm_state_information : arm_state -> ARMinfo
  val arm_state_coprocessors : arm_state -> Coprocessors
  val arm_state_monitors : arm_state -> ExclusiveMonitors
  val arm_state_registers_fupd
     : ((num * RName -> word32) -> num * RName -> word32) ->
       arm_state -> arm_state
  val arm_state_psrs_fupd
     : ((num * PSRName -> ARMpsr) -> num * PSRName -> ARMpsr) ->
       arm_state -> arm_state
  val arm_state_event_register_fupd
     : ((num -> bool) -> num -> bool) -> arm_state -> arm_state
  val arm_state_interrupt_wait_fupd
     : ((num -> bool) -> num -> bool) -> arm_state -> arm_state
  val arm_state_memory_fupd
     : ((word32 -> word8) -> word32 -> word8) -> arm_state -> arm_state
  val arm_state_accesses_fupd
     : (access list -> access list) -> arm_state -> arm_state
  val arm_state_information_fupd
     : (ARMinfo -> ARMinfo) -> arm_state -> arm_state
  val arm_state_coprocessors_fupd
     : (Coprocessors -> Coprocessors) -> arm_state -> arm_state
  val arm_state_monitors_fupd
     : (ExclusiveMonitors -> ExclusiveMonitors) ->
       arm_state -> arm_state
  datatype ('a,'b)error_option = ValueState of 'a * 'b | Error of string
  type 'a M = arm_state -> ('a, arm_state) error_option
  val i2w : int -> word8
  val i2bits_itself : int * (num * 'a itself) -> 'a word
  val signed_sat_itself : int * (num * 'a itself) -> 'a word
  val unsigned_sat_itself : int * (num * 'a itself) -> 'a word
  val signed_sat_q_itself : int * (num * 'a itself) -> 'a word * bool
  val unsigned_sat_q_itself : int * (num * 'a itself) -> 'a word * bool
  val data_processing_thumb2_unpredictable
     : data_processing_instruction -> bool
  val ==> : bool -> bool -> bool
  val align : 'a word * num -> 'a word
  val aligned : 'a word * num -> bool
  val count_leading_zeroes : 'a word -> num
  val lowest_set_bit : 'a word -> num
  val SUM : num -> (num -> num) -> num
  val bit_count_upto : num -> 'a word -> num
  val bit_count : 'a word -> num
  val zero_extend32 : word8 list -> word32
  val sign_extend32 : word8 list -> word32
  val word16 : word8 list -> word16
  val word32 : word8 list -> word32
  val word64 : word8 list -> word64
  val bytes : word32 * num -> word8 list
  val LSL_C : 'a word * num -> 'a word * bool
  val LSR_C : 'a word * num -> 'a word * bool
  val ASR_C : 'a word * num -> 'a word * bool
  val ROR_C : 'a word * num -> 'a word * bool
  val RRX_C : 'a word * bool -> 'a word * bool
  val LSL : 'a word * num -> 'a word
  val LSR : 'a word * num -> 'a word
  val ASR : 'a word * num -> 'a word
  val ROR : 'a word * num -> 'a word
  val RRX : 'a word * bool -> 'a word
  val ITAdvance : word8 -> word8
  val decode_psr : word32 -> ARMpsr
  val encode_psr : ARMpsr -> word32
  val version_number : ARMarch -> num
  val is_mode1_immediate : addressing_mode1 -> bool
  val is_mode2_immediate : addressing_mode2 -> bool
  val is_mode3_immediate : addressing_mode3 -> bool
  val constE : 'a -> 'a ExclusiveM
  val seqE : 'a ExclusiveM -> ('a -> 'b ExclusiveM) -> 'b ExclusiveM
  val constC : 'a -> 'a CoprocessorM
  val seqC
     : 'a CoprocessorM -> ('a -> 'b CoprocessorM) -> 'b CoprocessorM
  val constT : 'a -> 'a M
  val errorT : string -> 'a M
  val seqT : 'a M -> ('a -> 'b M) -> 'b M
  val parT : 'a M -> 'b M -> ('a * 'b) M
  val lockT : 'a M -> 'a M
  val condT : bool -> unit M -> unit M
  val forT : num -> num -> (num -> 'a M) -> 'a list M
  val readT : (arm_state -> 'a) -> 'a M
  val writeT : (arm_state -> arm_state) -> unit M
  val read_info : iiid -> ARMinfo M
  val read_arch : iiid -> ARMarch M
  val read_extensions : iiid -> ARMextensions_set M
  val read__reg : iiid -> RName -> word32 M
  val write__reg : iiid -> RName -> word32 -> unit M
  val read__psr : iiid -> PSRName -> ARMpsr M
  val write__psr : iiid -> PSRName -> ARMpsr -> unit M
  val read_scr : iiid -> CP15scr M
  val write_scr : iiid -> CP15scr -> unit M
  val read_nsacr : iiid -> CP15nsacr M
  val read_teehbr : iiid -> word32 M
  val read_sctlr : iiid -> CP15sctlr M
  val read_cpsr : iiid -> ARMpsr M
  val write_cpsr : iiid -> ARMpsr -> unit M
  val read_isetstate : iiid -> word2 M
  val write_isetstate : iiid -> word2 -> unit M
  val have_security_ext : iiid -> bool M
  val have_jazelle : iiid -> bool M
  val have_thumbEE : iiid -> bool M
  val bad_mode : iiid -> word5 -> bool M
  val read_spsr : iiid -> ARMpsr M
  val write_spsr : iiid -> ARMpsr -> unit M
  val current_mode_is_priviledged : iiid -> bool M
  val current_mode_is_user_or_system : iiid -> bool M
  val is_secure : iiid -> bool M
  val read_vbar : 'a -> word32 M
  val read_mvbar : iiid -> word32 M
  val current_instr_set : iiid -> InstrSet M
  val select_instr_set : iiid -> InstrSet -> unit M
  val RBankSelect
     : iiid ->
       word5 *
       (RName * (RName * (RName * (RName * (RName * (RName * RName))))))
       -> RName M
  val RfiqBankSelect : iiid -> word5 * (RName * RName) -> RName M
  val LookUpRName : iiid -> word4 * word5 -> RName M
  val read_reg_mode : iiid -> word4 * word5 -> word32 M
  val write_reg_mode : iiid -> word4 * word5 -> word32 -> unit M
  val read_pc : iiid -> word32 M
  val pc_store_value : iiid -> word32 M
  val read_reg : iiid -> word4 -> word32 M
  val read_r0 : iiid -> word32 M
  val restore_return_address_to_pc : iiid -> unit M
  val write_reg : iiid -> word4 -> word32 -> unit M
  val write_0_r0 : iiid -> unit M
  datatype LockType
        = Lock
        | Unlock
  val handle_locks : iiid -> LockType -> unit M
  val branch_to
: iiid -> word32 -> unit M
  val increment_pc : iiid -> Encoding -> unit M
  val big_endian : iiid -> bool M
  val translate_address : word32 * (bool * bool) -> AddressDescriptor M
  val read_monitor : iiid -> ExclusiveMonitors M
  val write_monitor : iiid -> ExclusiveMonitors -> unit M
(*  val read_mem1 : iiid -> word32 -> word8 M *)
(*  val write_mem1 : iiid -> word32 -> word8 -> unit M *)
  val read_mem : iiid -> AddressDescriptor * num -> word8 list M
  val write_mem
     : iiid -> AddressDescriptor * num -> word8 list -> unit M
  val read_memA_with_priv
     : iiid -> word32 * (num * bool) -> word8 list M
  val write_memA_with_priv
     : iiid -> word32 * (num * bool) -> word8 list -> unit M
  val read_memU_with_priv
     : iiid -> word32 * (num * bool) -> word8 list M
  val write_memU_with_priv
     : iiid -> word32 * (num * bool) -> word8 list -> unit M
  val read_memA : iiid -> word32 * num -> word8 list M
  val write_memA : iiid -> word32 * num -> word8 list -> unit M
  val read_memA_unpriv : iiid -> word32 * num -> word8 list M
  val write_memA_unpriv : iiid -> word32 * num -> word8 list -> unit M
  val read_memU : iiid -> word32 * num -> word8 list M
  val write_memU : iiid -> word32 * num -> word8 list -> unit M
  val read_memU_unpriv : iiid -> word32 * num -> word8 list M
  val write_memU_unpriv : iiid -> word32 * num -> word8 list -> unit M
  val data_memory_barrier : iiid -> MBReqDomain * MBReqTypes -> unit M
  val data_synchronization_barrier
     : iiid -> MBReqDomain * MBReqTypes -> unit M
  val instruction_synchronization_barrier : iiid -> unit M
  val hint_preload_data_for_write : iiid -> word32 -> unit M
  val hint_preload_data : iiid -> word32 -> unit M
  val hint_preload_instr : iiid -> word32 -> unit M
  val hint_yield : iiid -> unit M
  val hint_debug : iiid -> word4 -> unit M
  val clear_event_register : iiid -> unit M
  val event_registered : iiid -> bool M
  val send_event : iiid -> unit M
  val wait_for_event : iiid -> unit M
  val wait_for_interrupt : iiid -> unit M
  val clear_wait_for_interrupt : iiid -> unit M
  val waiting_for_interrupt : iiid -> bool M
  val set_exclusive_monitors : iiid -> word32 * num -> unit M
  val exclusive_monitors_pass : iiid -> word32 * num -> bool M
  val clear_exclusive_local : iiid -> unit M
  val read_coprocessors : iiid -> Coprocessors M
  val write_coprocessors : iiid -> Coprocessors -> unit M
  val coproc_accepted : iiid -> CPinstruction -> bool M
  val coproc_internal_operation : iiid -> CPinstruction -> unit M
  val coproc_send_loaded_words
     : iiid -> (num -> word32 M) * CPinstruction -> unit M
  val coproc_get_words_to_store : iiid -> CPinstruction -> word32 list M
  val coproc_send_one_word : iiid -> word32 * CPinstruction -> unit M
  val coproc_get_one_word : iiid -> CPinstruction -> word32 M
  val coproc_send_two_words
     : iiid -> (word32 * word32) * CPinstruction -> unit M
  val coproc_get_two_words
     : iiid -> CPinstruction -> (word32 * word32) M
  val unaligned_support : iiid -> bool M
  val arch_version : iiid -> num M
  val read_reg_literal : iiid -> word4 -> word32 M
  val read_flags : iiid -> (bool * (bool * (bool * bool))) M
  val write_flags : iiid -> bool * (bool * (bool * bool)) -> unit M
  val read_cflag : iiid -> bool M
  val set_q : iiid -> unit M
  val read_ge : iiid -> word4 M
  val write_ge : iiid -> word4 -> unit M
  val write_e : iiid -> bool -> unit M
  val IT_advance : iiid -> unit M
  val cpsr_write_by_instr : iiid -> word32 * (word4 * bool) -> unit M
  val spsr_write_by_instr : iiid -> word32 * word4 -> unit M
  val branch_write_pc : iiid -> word32 -> unit M
  val bx_write_pc : iiid -> word32 -> unit M
  val load_write_pc : iiid -> word32 -> unit M
  val alu_write_pc : iiid -> word32 -> unit M
  val decode_imm_shift : word2 * word5 -> SRType * num
  val decode_reg_shift : word2 -> SRType
  val shift_c : 'a word * (SRType * (num * bool)) -> ('a word * bool) M
  val shift : 'a word * (SRType * (num * bool)) -> 'a word M
  val arm_expand_imm_c : word12 * bool -> (word32 * bool) M
  val thumb_expand_imm_c : word12 * bool -> (word32 * bool) M
  val arm_expand_imm : iiid -> word12 -> word32 M
  val address_mode1
     : iiid -> bool -> addressing_mode1 -> (word32 * bool) M
  val address_mode2
     : iiid ->
       bool -> bool -> word32 -> addressing_mode2 -> (word32 * word32) M
  val address_mode3
     : iiid ->
       bool -> bool -> word32 -> addressing_mode3 -> (word32 * word32) M
  val address_mode5
     : bool -> bool -> word32 -> word8 -> (word32 * word32) M
  val signed_parallel_add_sub_16
     : parallel_add_sub_op2 -> word32 -> word32 -> int * int
  val signed_normal_add_sub_16
     : parallel_add_sub_op2 -> word32 -> word32 -> word32 * word4 option
  val signed_saturating_add_sub_16
     : parallel_add_sub_op2 -> word32 -> word32 -> word32 * word4 option
  val signed_halving_add_sub_16
     : parallel_add_sub_op2 -> word32 -> word32 -> word32 * word4 option
  val signed_parallel_add_sub_8
     : parallel_add_sub_op2 -> word32 -> word32 -> int list
  val signed_normal_add_sub_8
     : parallel_add_sub_op2 -> word32 -> word32 -> word32 * word4 option
  val signed_saturating_add_sub_8
     : parallel_add_sub_op2 -> word32 -> word32 -> word32 * word4 option
  val signed_halving_add_sub_8
     : parallel_add_sub_op2 -> word32 -> word32 -> word32 * word4 option
  val unsigned_parallel_add_sub_16
     : parallel_add_sub_op2 -> word32 -> word32 -> int * int
  val unsigned_normal_add_sub_16
     : parallel_add_sub_op2 -> word32 -> word32 -> word32 * word4 option
  val unsigned_saturating_add_sub_16
     : parallel_add_sub_op2 -> word32 -> word32 -> word32 * word4 option
  val unsigned_halving_add_sub_16
     : parallel_add_sub_op2 -> word32 -> word32 -> word32 * word4 option
  val unsigned_parallel_add_sub_8
     : parallel_add_sub_op2 -> word32 -> word32 -> int list
  val unsigned_normal_add_sub_8
     : parallel_add_sub_op2 -> word32 -> word32 -> word32 * word4 option
  val unsigned_saturating_add_sub_8
     : parallel_add_sub_op2 -> word32 -> word32 -> word32 * word4 option
  val unsigned_halving_add_sub_8
     : parallel_add_sub_op2 -> word32 -> word32 -> word32 * word4 option
  val parallel_add_sub
     : bool ->
       parallel_add_sub_op1 * parallel_add_sub_op2 ->
       word32 -> word32 -> word32 * word4 option
  val barrier_option : word4 -> MBReqDomain * MBReqTypes
  val exc_vector_base : iiid -> word32 M
  val take_undef_instr_exception : iiid -> unit M
  val take_svc_exception : iiid -> unit M
  val take_smc_exception : iiid -> unit M
  val take_prefetch_abort_exception : iiid -> unit M
  val integer_zero_divide_trapping_enabled : iiid -> bool M
  val null_check_if_thumbEE : iiid -> word4 -> unit M -> unit M
  val branch_target_instr
     : iiid -> Encoding -> branch_instruction -> unit M
  val branch_exchange_instr : iiid -> branch_instruction -> unit M
  val branch_link_exchange_imm_instr
     : iiid -> Encoding -> branch_instruction -> unit M
  val branch_link_exchange_reg_instr
     : iiid -> branch_instruction -> unit M
  val compare_branch_instr : iiid -> branch_instruction -> unit M
  val table_branch_byte_instr : iiid -> branch_instruction -> unit M
  val check_array_instr : iiid -> branch_instruction -> unit M
  val handler_branch_link_instr : iiid -> branch_instruction -> unit M
  val handler_branch_link_parameter_instr
     : iiid -> branch_instruction -> unit M
  val handler_branch_parameter_instr
     : iiid -> branch_instruction -> unit M
  val enterx_leavex_instr : iiid -> bool -> unit M
  val if_then_instr : iiid -> miscellaneous_instruction -> unit M
  val count_leading_zeroes_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val move_halfword_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val add_sub_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val data_processing_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val multiply_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val multiply_long_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val multiply_accumulate_accumulate_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val multiply_subtract_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val saturating_add_subtract_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val signed_16_multiply_32_accumulate_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val signed_16_multiply_32_result_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val signed_16x32_multiply_32_accumulate_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val signed_16x32_multiply_32_result_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val signed_16_multiply_64_accumulate_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val signed_multiply_dual_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val signed_multiply_long_dual_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val signed_most_significant_multiply_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val signed_most_significant_multiply_subtract_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val parallel_add_subtract_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val divide_instr : iiid -> data_processing_instruction -> unit M
  val pack_halfword_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val saturate_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val extend_byte_16_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val select_bytes_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val saturate_16_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val extend_byte_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val byte_reverse_word_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val extend_halfword_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val byte_reverse_packed_halfword_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val reverse_bits_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val byte_reverse_signed_halfword_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val unsigned_sum_absolute_differences_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val bit_field_extract_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val bit_field_clear_insert_instr
     : iiid -> Encoding -> data_processing_instruction -> unit M
  val preload_data_instr
     : iiid -> Encoding -> miscellaneous_instruction -> unit M
  val preload_instruction_instr
     : iiid -> Encoding -> miscellaneous_instruction -> unit M
  val load_instr : iiid -> Encoding -> load_store_instruction -> unit M
  val store_instr : iiid -> Encoding -> load_store_instruction -> unit M
  val load_halfword_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val store_halfword_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val load_multiple_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val store_multiple_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val load_dual_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val store_dual_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val load_exclusive_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val store_exclusive_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val load_exclusive_doubleword_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val store_exclusive_doubleword_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val load_exclusive_byte_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val store_exclusive_byte_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val load_exclusive_halfword_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val store_exclusive_halfword_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val clear_exclusive_instr : iiid -> Encoding -> unit M
  val swap_instr : iiid -> miscellaneous_instruction -> unit M
  val store_return_state_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val return_from_exception_instr
     : iiid -> Encoding -> load_store_instruction -> unit M
  val status_to_register_instr
     : iiid -> Encoding -> status_access_instruction -> unit M
  val immediate_to_status_instr
     : iiid -> status_access_instruction -> unit M
  val register_to_status_instr
     : iiid -> Encoding -> status_access_instruction -> unit M
  val change_processor_state_instr
     : iiid -> Encoding -> status_access_instruction -> unit M
  val set_endianness_instr
     : iiid -> Encoding -> status_access_instruction -> unit M
  val secure_monitor_call_instr : iiid -> unit M
  val breakpoint_instr : iiid -> unit M
  val data_memory_barrier_instr
     : iiid -> Encoding -> miscellaneous_instruction -> unit M
  val data_synchronization_barrier_instr
     : iiid -> Encoding -> miscellaneous_instruction -> unit M
  val instruction_synchronization_barrier_instr
     : iiid -> Encoding -> miscellaneous_instruction -> unit M
  val coprocessor_data_processing_instr
     : iiid -> Encoding -> word4 -> coprocessor_instruction -> unit M
  val coprocessor_load_instr
     : iiid -> Encoding -> word4 -> coprocessor_instruction -> unit M
  val coprocessor_store_instr
     : iiid -> Encoding -> word4 -> coprocessor_instruction -> unit M
  val coprocessor_register_to_arm_instr
     : iiid -> Encoding -> word4 -> coprocessor_instruction -> unit M
  val arm_register_to_coprocessor_instr
     : iiid -> Encoding -> word4 -> coprocessor_instruction -> unit M
  val coprocessor_register_to_arm_two_instr
     : iiid -> Encoding -> word4 -> coprocessor_instruction -> unit M
  val arm_register_to_coprocessor_two_instr
     : iiid -> Encoding -> word4 -> coprocessor_instruction -> unit M
  val no_operation_instr : iiid -> Encoding -> unit M
  val yield_instr : iiid -> Encoding -> unit M
  val wait_for_event_instr : iiid -> Encoding -> unit M
  val send_event_instr : iiid -> Encoding -> unit M
  val wait_for_interrupt_instr : iiid -> Encoding -> unit M
  val debug_instr : iiid -> Encoding -> word4 -> unit M
  val condition_passed : iiid -> word4 -> bool M
  val branch_instruction
     : iiid -> Encoding * branch_instruction -> unit M
  val data_processing_instruction
     : iiid -> Encoding * data_processing_instruction -> unit M
  val status_access_instruction
     : iiid -> Encoding * status_access_instruction -> unit M
  val load_store_instruction
     : iiid -> Encoding * load_store_instruction -> unit M
  val miscellaneous_instruction
     : iiid -> Encoding * miscellaneous_instruction -> unit M
  val coprocessor_instruction
     : iiid -> Encoding * (word4 * coprocessor_instruction) -> unit M
  val arm_instr : iiid -> Encoding * (word4 * ARMinstruction) -> unit M
  val hint_decode : word8 -> hint
  val parallel_add_sub_op1 : word2 -> parallel_add_sub_op1
  val parallel_add_sub_op2 : word3 -> parallel_add_sub_op2
  val parallel_add_sub_thumb_op2 : word3 -> parallel_add_sub_op2
  val parallel_add_sub_decode
     : word2 * word3 -> parallel_add_sub_op1 * parallel_add_sub_op2
  val parallel_add_sub_thumb_decode
     : word2 * word3 -> parallel_add_sub_op1 * parallel_add_sub_op2
  val InITBlock : word8 -> bool
  val LastInITBlock : word8 -> bool
  val arm_decode : bool -> word32 -> word4 * ARMinstruction
  val thumb_decode
     : ARMarch -> word8 -> word16 -> word4 * ARMinstruction
  val thumbee_decode
     : ARMarch -> word8 -> word16 -> Encoding * (word4 * ARMinstruction)
  val thumb2_decode_aux1 : word8 -> word16 * word16 -> ARMinstruction
  val thumb2_decode_aux2 : word16 * word16 -> ARMinstruction
  val thumb2_decode_aux3 : word16 * word16 -> ARMinstruction
  val thumb2_decode_aux4 : word16 * word16 -> ARMinstruction
  val thumb2_decode_aux5 : word16 * word16 -> ARMinstruction
  val thumb2_decode_aux6 : word8 -> word16 * word16 -> ARMinstruction
  val thumb2_decode_aux7 : word8 -> word16 * word16 -> ARMinstruction
  val thumb2_decode_aux8 : word16 * word16 -> ARMinstruction
  val thumb2_decode_aux9 : word16 * word16 -> ARMinstruction
  val thumb2_decode
     : ARMarch -> word8 -> word16 * word16 -> word4 * ARMinstruction
  val proc : num -> ('a -> 'b) -> num * 'a -> 'b
  val ptree_read_word : word8 ptree -> word32 -> word32 M
  val ptree_read_halfword : word8 ptree -> word32 -> word16 M
  val fetch_arm
     : iiid ->
       (word32 -> word32 M) ->
       (string * (Encoding * (word4 * ARMinstruction))) M
  val fetch_thumb
     : iiid ->
       bool ->
       (word32 -> word16 M) ->
       (string * (Encoding * (word4 * ARMinstruction))) M
  val attempt
     : 'a ->
       (arm_state -> ('b, 'c) error_option) ->
       ('b -> 'c -> ('a * string, arm_state) error_option) ->
       ('a * string) M
  val actual_instr_set : iiid -> InstrSet M
  val fetch_instruction
     : iiid ->
       (word32 -> word32 M) ->
       (word32 -> word16 M) ->
       (string * (Encoding * (word4 * ARMinstruction))) M
  val compare_ir_access : ir_access -> ir_access -> bool
end
